/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebugGlobalVariable;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMToDebugValueNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@GeneratedBy(value=LLVMToDebugValueNode.class)
public final class LLVMToDebugValueNodeGen
extends LLVMToDebugValueNode {
    @CompilerDirectives.CompilationFinal
    private int state_;

    private LLVMToDebugValueNodeGen() {
    }

    @Override
    public LLVMDebugValue executeWithTarget(Object arg0Value) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.fromBoolean(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return this.fromByte(arg0Value_);
        }
        if ((state & 4) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return this.fromShort(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.fromInt(arg0Value_);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.fromLong(arg0Value_);
        }
        if ((state & 0x20) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state & 0x3800000) >>> 23, arg0Value)) {
            LLVMIVarBit arg0Value_ = LLVMTypesGen.asImplicitLLVMIVarBit((state & 0x3800000) >>> 23, arg0Value);
            return this.fromIVarBit(arg0Value_);
        }
        if ((state & 0x40) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
            LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
            return this.fromNativePointer(arg0Value_);
        }
        if ((state & 0x80) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
            LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
            return this.fromManagedPointer(arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof LLVMFunctionDescriptor) {
            LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor)arg0Value;
            return this.fromFunctionHandle(arg0Value_);
        }
        if ((state & 0x200) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return this.fromFloat(arg0Value_);
        }
        if ((state & 0x400) != 0 && arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            return this.fromDouble(arg0Value_);
        }
        if ((state & 0x800) != 0 && arg0Value instanceof LLVM80BitFloat) {
            LLVM80BitFloat arg0Value_ = (LLVM80BitFloat)arg0Value;
            return this.from80BitFloat(arg0Value_);
        }
        if ((state & 0x1000) != 0 && arg0Value instanceof LLVMI1Vector) {
            LLVMI1Vector arg0Value_ = (LLVMI1Vector)arg0Value;
            return this.fromI1Vector(arg0Value_);
        }
        if ((state & 0x2000) != 0 && arg0Value instanceof LLVMI8Vector) {
            LLVMI8Vector arg0Value_ = (LLVMI8Vector)arg0Value;
            return this.fromI8Vector(arg0Value_);
        }
        if ((state & 0x4000) != 0 && arg0Value instanceof LLVMI16Vector) {
            LLVMI16Vector arg0Value_ = (LLVMI16Vector)arg0Value;
            return this.fromI16Vector(arg0Value_);
        }
        if ((state & 0x8000) != 0 && arg0Value instanceof LLVMI32Vector) {
            LLVMI32Vector arg0Value_ = (LLVMI32Vector)arg0Value;
            return this.fromI32Vector(arg0Value_);
        }
        if ((state & 0x10000) != 0 && arg0Value instanceof LLVMI64Vector) {
            LLVMI64Vector arg0Value_ = (LLVMI64Vector)arg0Value;
            return this.fromI64Vector(arg0Value_);
        }
        if ((state & 0x20000) != 0 && arg0Value instanceof LLVMFloatVector) {
            LLVMFloatVector arg0Value_ = (LLVMFloatVector)arg0Value;
            return this.fromFloatVector(arg0Value_);
        }
        if ((state & 0x40000) != 0 && arg0Value instanceof LLVMDoubleVector) {
            LLVMDoubleVector arg0Value_ = (LLVMDoubleVector)arg0Value;
            return this.fromDoubleVector(arg0Value_);
        }
        if ((state & 0x80000) != 0 && arg0Value instanceof LLVMPointerVector) {
            LLVMPointerVector arg0Value_ = (LLVMPointerVector)arg0Value;
            return this.fromAddressVector(arg0Value_);
        }
        if ((state & 0x100000) != 0 && arg0Value instanceof LLVMGlobalContainer) {
            LLVMGlobalContainer arg0Value_ = (LLVMGlobalContainer)arg0Value;
            return this.fromGlobalContainer(arg0Value_);
        }
        if ((state & 0x200000) != 0 && arg0Value instanceof LLVMDebugGlobalVariable) {
            LLVMDebugGlobalVariable arg0Value_ = (LLVMDebugGlobalVariable)arg0Value;
            return this.fromGlobal(arg0Value_);
        }
        if ((state & 0x400000) != 0 && LLVMToDebugValueNodeGen.fallbackGuard_(state, arg0Value)) {
            return this.fromGenericObject(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private LLVMDebugValue executeAndSpecialize(Object arg0Value) {
        int state = this.state_;
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            this.state_ = state |= 1;
            return this.fromBoolean(arg0Value_);
        }
        if (arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            this.state_ = state |= 2;
            return this.fromByte(arg0Value_);
        }
        if (arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            this.state_ = state |= 4;
            return this.fromShort(arg0Value_);
        }
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            this.state_ = state |= 8;
            return this.fromInt(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            this.state_ = state |= 0x10;
            return this.fromLong(arg0Value_);
        }
        int lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(arg0Value);
        if (lLVMIVarBitCast0 != 0) {
            LLVMIVarBit arg0Value_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, arg0Value);
            state |= lLVMIVarBitCast0 << 23;
            this.state_ = state |= 0x20;
            return this.fromIVarBit(arg0Value_);
        }
        if (LLVMTypes.isNativePointer(arg0Value)) {
            LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
            this.state_ = state |= 0x40;
            return this.fromNativePointer(arg0Value_);
        }
        if (LLVMTypes.isManagedPointer(arg0Value)) {
            LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
            this.state_ = state |= 0x80;
            return this.fromManagedPointer(arg0Value_);
        }
        if (arg0Value instanceof LLVMFunctionDescriptor) {
            LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor)arg0Value;
            this.state_ = state |= 0x100;
            return this.fromFunctionHandle(arg0Value_);
        }
        if (arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            this.state_ = state |= 0x200;
            return this.fromFloat(arg0Value_);
        }
        if (arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            this.state_ = state |= 0x400;
            return this.fromDouble(arg0Value_);
        }
        if (arg0Value instanceof LLVM80BitFloat) {
            LLVM80BitFloat arg0Value_ = (LLVM80BitFloat)arg0Value;
            this.state_ = state |= 0x800;
            return this.from80BitFloat(arg0Value_);
        }
        if (arg0Value instanceof LLVMI1Vector) {
            LLVMI1Vector arg0Value_ = (LLVMI1Vector)arg0Value;
            this.state_ = state |= 0x1000;
            return this.fromI1Vector(arg0Value_);
        }
        if (arg0Value instanceof LLVMI8Vector) {
            LLVMI8Vector arg0Value_ = (LLVMI8Vector)arg0Value;
            this.state_ = state |= 0x2000;
            return this.fromI8Vector(arg0Value_);
        }
        if (arg0Value instanceof LLVMI16Vector) {
            LLVMI16Vector arg0Value_ = (LLVMI16Vector)arg0Value;
            this.state_ = state |= 0x4000;
            return this.fromI16Vector(arg0Value_);
        }
        if (arg0Value instanceof LLVMI32Vector) {
            LLVMI32Vector arg0Value_ = (LLVMI32Vector)arg0Value;
            this.state_ = state |= 0x8000;
            return this.fromI32Vector(arg0Value_);
        }
        if (arg0Value instanceof LLVMI64Vector) {
            LLVMI64Vector arg0Value_ = (LLVMI64Vector)arg0Value;
            this.state_ = state |= 0x10000;
            return this.fromI64Vector(arg0Value_);
        }
        if (arg0Value instanceof LLVMFloatVector) {
            LLVMFloatVector arg0Value_ = (LLVMFloatVector)arg0Value;
            this.state_ = state |= 0x20000;
            return this.fromFloatVector(arg0Value_);
        }
        if (arg0Value instanceof LLVMDoubleVector) {
            LLVMDoubleVector arg0Value_ = (LLVMDoubleVector)arg0Value;
            this.state_ = state |= 0x40000;
            return this.fromDoubleVector(arg0Value_);
        }
        if (arg0Value instanceof LLVMPointerVector) {
            LLVMPointerVector arg0Value_ = (LLVMPointerVector)arg0Value;
            this.state_ = state |= 0x80000;
            return this.fromAddressVector(arg0Value_);
        }
        if (arg0Value instanceof LLVMGlobalContainer) {
            LLVMGlobalContainer arg0Value_ = (LLVMGlobalContainer)arg0Value;
            this.state_ = state |= 0x100000;
            return this.fromGlobalContainer(arg0Value_);
        }
        if (arg0Value instanceof LLVMDebugGlobalVariable) {
            LLVMDebugGlobalVariable arg0Value_ = (LLVMDebugGlobalVariable)arg0Value;
            this.state_ = state |= 0x200000;
            return this.fromGlobal(arg0Value_);
        }
        this.state_ = state |= 0x400000;
        return this.fromGenericObject(arg0Value);
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x7FFFFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x7FFFFF & (state & 0x7FFFFF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    private static boolean fallbackGuard_(int state, Object arg0Value) {
        if ((state & 1) == 0 && arg0Value instanceof Boolean) {
            return false;
        }
        if ((state & 2) == 0 && arg0Value instanceof Byte) {
            return false;
        }
        if ((state & 4) == 0 && arg0Value instanceof Short) {
            return false;
        }
        if ((state & 8) == 0 && arg0Value instanceof Integer) {
            return false;
        }
        if ((state & 0x10) == 0 && arg0Value instanceof Long) {
            return false;
        }
        if (LLVMTypesGen.isImplicitLLVMIVarBit(arg0Value)) {
            return false;
        }
        if ((state & 0x40) == 0 && LLVMTypes.isNativePointer(arg0Value)) {
            return false;
        }
        if ((state & 0x80) == 0 && LLVMTypes.isManagedPointer(arg0Value)) {
            return false;
        }
        if ((state & 0x100) == 0 && arg0Value instanceof LLVMFunctionDescriptor) {
            return false;
        }
        if ((state & 0x200) == 0 && arg0Value instanceof Float) {
            return false;
        }
        if ((state & 0x400) == 0 && arg0Value instanceof Double) {
            return false;
        }
        if ((state & 0x800) == 0 && arg0Value instanceof LLVM80BitFloat) {
            return false;
        }
        if ((state & 0x1000) == 0 && arg0Value instanceof LLVMI1Vector) {
            return false;
        }
        if ((state & 0x2000) == 0 && arg0Value instanceof LLVMI8Vector) {
            return false;
        }
        if ((state & 0x4000) == 0 && arg0Value instanceof LLVMI16Vector) {
            return false;
        }
        if ((state & 0x8000) == 0 && arg0Value instanceof LLVMI32Vector) {
            return false;
        }
        if ((state & 0x10000) == 0 && arg0Value instanceof LLVMI64Vector) {
            return false;
        }
        if ((state & 0x20000) == 0 && arg0Value instanceof LLVMFloatVector) {
            return false;
        }
        if ((state & 0x40000) == 0 && arg0Value instanceof LLVMDoubleVector) {
            return false;
        }
        if ((state & 0x80000) == 0 && arg0Value instanceof LLVMPointerVector) {
            return false;
        }
        if ((state & 0x100000) == 0 && arg0Value instanceof LLVMGlobalContainer) {
            return false;
        }
        return (state & 0x200000) != 0 || !(arg0Value instanceof LLVMDebugGlobalVariable);
    }

    public static LLVMToDebugValueNode create() {
        return new LLVMToDebugValueNodeGen();
    }
}

