/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import java.util.function.IntPredicate;

public abstract class LLVMX86_VectorMathNode {

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMX86_VectorCmpNode
    extends LLVMBuiltin {
        private static double mask = Double.longBitsToDouble(-1L);
        protected static int cmpCnt = Comparator.values().length;

        protected static Comparator getComparator(int predicate) {
            return Comparator.values()[predicate];
        }

        @Specialization(guards={"v1.getLength() == 2", "v2.getLength() == 2", "predicate == cachedPredicate"}, limit="cmpCnt")
        protected LLVMDoubleVector doCmp(LLVMDoubleVector v1, LLVMDoubleVector v2, int predicate, @Cached(value="predicate") int cachedPredicate, @Cached(value="getComparator(predicate)") Comparator comparator) {
            double v11 = v1.getValue(0);
            double v21 = v2.getValue(0);
            boolean compareResult = comparator.pred.test(Double.compare(v11, v21));
            compareResult = comparator.ordered ? !Double.isNaN(v11) && !Double.isNaN(v21) && compareResult : Double.isNaN(v11) || Double.isNaN(v21) || compareResult;
            return LLVMDoubleVector.create(new double[]{compareResult ? mask : 0.0, v1.getValue(1)});
        }

        @Specialization(guards={"v1.getLength() == 2", "v2.getLength() == 2", "predicate == cachedPredicate"}, limit="cmpCnt")
        protected LLVMDoubleVector doCmp(LLVMDoubleVector v1, LLVMDoubleVector v2, byte predicate, @Cached(value="predicate") byte cachedPredicate, @Cached(value="getComparator(predicate)") Comparator comparator) {
            double v11 = v1.getValue(0);
            double v21 = v2.getValue(0);
            boolean compareResult = comparator.pred.test(Double.compare(v11, v21));
            compareResult = comparator.ordered ? !Double.isNaN(v11) && !Double.isNaN(v21) && compareResult : Double.isNaN(v11) || Double.isNaN(v21) || compareResult;
            return LLVMDoubleVector.create(new double[]{compareResult ? mask : 0.0, v1.getValue(1)});
        }

        protected static enum Comparator {
            _CMP_EQ_OQ(0, cmp -> cmp == 0, true, false),
            _CMP_LT_OS(1, cmp -> cmp < 0, true, true),
            _CMP_LE_OS(2, cmp -> cmp <= 0, true, true),
            _CMP_UNORD_Q(3, cmp -> true, false, false),
            _CMP_NEQ_UQ(4, cmp -> cmp != 0, false, false),
            _CMP_NLT_US(5, cmp -> cmp >= 0, false, true),
            _CMP_NLE_US(6, cmp -> cmp > 0, false, true),
            _CMP_ORD_Q(7, cmp -> true, true, false),
            _CMP_EQ_UQ(8, cmp -> cmp == 0, false, false),
            _CMP_NGE_US(9, cmp -> cmp < 0, false, true),
            _CMP_NGT_US(10, cmp -> cmp <= 0, false, true),
            _CMP_FALSE_OQ(11, cmp -> false, true, false),
            _CMP_NEQ_OQ(12, cmp -> cmp != 0, true, false),
            _CMP_GE_OS(13, cmp -> cmp >= 0, true, true),
            _CMP_GT_OS(14, cmp -> cmp > 0, true, true),
            _CMP_TRUE_UQ(15, cmp -> true, false, false),
            _CMP_EQ_OS(16, cmp -> cmp == 0, true, true),
            _CMP_LT_OQ(17, cmp -> cmp < 0, true, false),
            _CMP_LE_OQ(18, cmp -> cmp <= 0, true, false),
            _CMP_UNORD_S(19, cmp -> true, false, true),
            _CMP_NEQ_US(20, cmp -> cmp != 0, false, true),
            _CMP_NLT_UQ(21, cmp -> cmp >= 0, false, false),
            _CMP_NLE_UQ(22, cmp -> cmp > 0, false, false),
            _CMP_ORD_S(23, cmp -> true, true, true),
            _CMP_EQ_US(24, cmp -> cmp == 0, false, true),
            _CMP_NGE_UQ(25, cmp -> cmp < 0, false, false),
            _CMP_NGT_UQ(26, cmp -> cmp <= 0, false, false),
            _CMP_FALSE_OS(27, cmp -> false, true, true),
            _CMP_NEQ_OS(28, cmp -> cmp != 0, true, true),
            _CMP_GE_OQ(29, cmp -> cmp >= 0, true, false),
            _CMP_GT_OQ(30, cmp -> cmp > 0, true, false),
            _CMP_TRUE_US(31, cmp -> true, false, true);

            IntPredicate pred;
            boolean ordered;
            boolean signaling;

            private Comparator(int i, IntPredicate pred, boolean ordered, boolean signaling) {
                this.pred = pred;
                this.ordered = ordered;
                this.signaling = signaling;
            }
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMX86_VectorPackNode
    extends LLVMBuiltin {
        short saturatedPack(int value) {
            if (value > Short.MAX_VALUE) {
                return Short.MAX_VALUE;
            }
            if (value < Short.MIN_VALUE) {
                return Short.MIN_VALUE;
            }
            return (short)value;
        }

        @Specialization(guards={"v1.getLength() == 4", "v2.getLength() == 4"})
        protected LLVMI16Vector doPacksswd(LLVMI32Vector v1, LLVMI32Vector v2) {
            return LLVMI16Vector.create(new short[]{this.saturatedPack(v1.getValue(0)), this.saturatedPack(v1.getValue(1)), this.saturatedPack(v1.getValue(2)), this.saturatedPack(v1.getValue(3)), this.saturatedPack(v2.getValue(0)), this.saturatedPack(v2.getValue(1)), this.saturatedPack(v2.getValue(2)), this.saturatedPack(v2.getValue(3))});
        }

        byte saturatedPack(short value) {
            if (value > 127) {
                return 127;
            }
            if (value < -128) {
                return -128;
            }
            return (byte)value;
        }

        @Specialization(guards={"v1.getLength() == 8", "v2.getLength() == 8"})
        protected LLVMI8Vector doPacksswb(LLVMI16Vector v1, LLVMI16Vector v2) {
            return LLVMI8Vector.create(new byte[]{this.saturatedPack(v1.getValue(0)), this.saturatedPack(v1.getValue(1)), this.saturatedPack(v1.getValue(2)), this.saturatedPack(v1.getValue(3)), this.saturatedPack(v1.getValue(4)), this.saturatedPack(v1.getValue(5)), this.saturatedPack(v1.getValue(6)), this.saturatedPack(v1.getValue(7)), this.saturatedPack(v2.getValue(0)), this.saturatedPack(v2.getValue(1)), this.saturatedPack(v2.getValue(2)), this.saturatedPack(v2.getValue(3)), this.saturatedPack(v2.getValue(4)), this.saturatedPack(v2.getValue(5)), this.saturatedPack(v2.getValue(6)), this.saturatedPack(v2.getValue(7))});
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMX86_VectorMinNode
    extends LLVMBuiltin {
        @Specialization(guards={"v1.getLength() == 2", "v2.getLength() == 2"})
        protected LLVMDoubleVector doM128(LLVMDoubleVector v1, LLVMDoubleVector v2) {
            return LLVMDoubleVector.create(new double[]{Math.min(v1.getValue(0), v2.getValue(0)), Math.min(v1.getValue(1), v2.getValue(1))});
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMX86_VectorMaxNode
    extends LLVMBuiltin {
        @Specialization(guards={"v1.getLength() == 2", "v2.getLength() == 2"})
        protected LLVMDoubleVector doM128(LLVMDoubleVector v1, LLVMDoubleVector v2) {
            return LLVMDoubleVector.create(new double[]{Math.max(v1.getValue(0), v2.getValue(0)), Math.max(v1.getValue(1), v2.getValue(1))});
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMX86_VectorSquareRootNode
    extends LLVMBuiltin {
        @Specialization(guards={"vector.getLength() == 2"})
        protected LLVMDoubleVector doM128(LLVMDoubleVector vector) {
            return LLVMDoubleVector.create(new double[]{Math.sqrt(vector.getValue(0)), Math.sqrt(vector.getValue(1))});
        }
    }
}

