/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMFence;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMFence.class)
public final class LLVMFenceNodeGen
extends LLVMFence {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private LLVMMemory memory_;

    private LLVMFenceNodeGen() {
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state = this.state_;
        if (state != 0) {
            this.doOp(this.memory_);
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndSpecialize() {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            this.memory_ = LLVMNode.getLLVMMemory();
            this.state_ = state |= 1;
            lock.unlock();
            hasLock = false;
            this.doOp(this.memory_);
            return;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMFence create() {
        return new LLVMFenceNodeGen();
    }
}

