/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.NativeMemSetNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NativeMemSetNode.class)
public final class NativeMemSetNodeGen
extends NativeMemSetNode {
    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);
    private static final LibraryFactory<NativeTypeLibrary> NATIVE_TYPE_LIBRARY_ = LibraryFactory.resolve(NativeTypeLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private LLVMMemory memset0_memory_;
    @Node.Child
    private MemsetManagedI80Data memsetManagedI80_cache;
    @Node.Child
    private MemsetManagedI160Data memsetManagedI160_cache;
    @Node.Child
    private MemsetManagedI320Data memsetManagedI320_cache;
    @Node.Child
    private MemsetManagedI640Data memsetManagedI640_cache;
    @Node.Child
    private Memset1Data memset1_cache;
    @Node.Child
    private LLVMToNativeNode memset2_globalAccess_;
    @CompilerDirectives.CompilationFinal
    private LLVMMemory memset2_memory_;

    private NativeMemSetNodeGen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public void executeWithTarget(Object arg0Value, byte arg1Value, long arg2Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                this.memset(arg0Value_, arg1Value, arg2Value, this.memset0_memory_);
                return;
            }
            if ((state & 0x7FE) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                Node prev_;
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if ((state & 2) != 0) {
                    MemsetManagedI80Data s2_ = this.memsetManagedI80_cache;
                    while (s2_ != null) {
                        if (s2_.nativeTypes_.accepts(arg0Value_.getObject()) && s2_.nativeWrite_.accepts(arg0Value_.getObject()) && s2_.nativeWrite_.isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, s2_.nativeTypes_) == 1L) {
                            this.memsetManagedI8(arg0Value_, arg1Value, arg2Value, s2_.nativeTypes_, s2_.nativeWrite_);
                            return;
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 4) != 0) {
                    prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        if (((LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(arg0Value_.getObject())).isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject())) == 1L) {
                            this.memsetManagedI8(arg0Value_, arg1Value, arg2Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject()), (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(arg0Value_.getObject()));
                            return;
                        }
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                if ((state & 8) != 0) {
                    MemsetManagedI160Data s4_ = this.memsetManagedI160_cache;
                    while (s4_ != null) {
                        if (s4_.nativeTypes_.accepts(arg0Value_.getObject()) && s4_.nativeWrite_.accepts(arg0Value_.getObject()) && s4_.nativeWrite_.isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, s4_.nativeTypes_) == 2L) {
                            this.memsetManagedI16(arg0Value_, arg1Value, arg2Value, s4_.nativeTypes_, s4_.nativeWrite_);
                            return;
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state & 0x10) != 0) {
                    prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        if (((LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(arg0Value_.getObject())).isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject())) == 2L) {
                            this.memsetManagedI16(arg0Value_, arg1Value, arg2Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject()), (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(arg0Value_.getObject()));
                            return;
                        }
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                if ((state & 0x20) != 0) {
                    MemsetManagedI320Data s6_ = this.memsetManagedI320_cache;
                    while (s6_ != null) {
                        if (s6_.nativeTypes_.accepts(arg0Value_.getObject()) && s6_.nativeWrite_.accepts(arg0Value_.getObject()) && s6_.nativeWrite_.isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, s6_.nativeTypes_) == 4L) {
                            this.memsetManagedI32(arg0Value_, arg1Value, arg2Value, s6_.nativeTypes_, s6_.nativeWrite_);
                            return;
                        }
                        s6_ = s6_.next_;
                    }
                }
                if ((state & 0x40) != 0) {
                    prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        if (((LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(arg0Value_.getObject())).isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject())) == 4L) {
                            this.memsetManagedI32(arg0Value_, arg1Value, arg2Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject()), (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(arg0Value_.getObject()));
                            return;
                        }
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                if ((state & 0x80) != 0) {
                    MemsetManagedI640Data s8_ = this.memsetManagedI640_cache;
                    while (s8_ != null) {
                        if (s8_.nativeTypes_.accepts(arg0Value_.getObject()) && s8_.nativeWrite_.accepts(arg0Value_.getObject()) && s8_.nativeWrite_.isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, s8_.nativeTypes_) == 8L) {
                            this.memsetManagedI64(arg0Value_, arg1Value, arg2Value, s8_.nativeTypes_, s8_.nativeWrite_);
                            return;
                        }
                        s8_ = s8_.next_;
                    }
                }
                if ((state & 0x100) != 0) {
                    prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        if (((LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(arg0Value_.getObject())).isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject())) == 8L) {
                            this.memsetManagedI64(arg0Value_, arg1Value, arg2Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject()), (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(arg0Value_.getObject()));
                            return;
                        }
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                if ((state & 0x200) != 0) {
                    Memset1Data s10_ = this.memset1_cache;
                    while (s10_ != null) {
                        if (s10_.nativeWrite_.accepts(arg0Value_.getObject()) && !s10_.nativeWrite_.isWritable(arg0Value_.getObject())) {
                            this.memset(arg0Value_, arg1Value, arg2Value, s10_.globalAccess_, s10_.nativeWrite_, s10_.memory_);
                            return;
                        }
                        s10_ = s10_.next_;
                    }
                }
                if ((state & 0x400) != 0) {
                    prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        if (!((LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(arg0Value_.getObject())).isWritable(arg0Value_.getObject())) {
                            this.memset(arg0Value_, arg1Value, arg2Value, this.memset2_globalAccess_, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(arg0Value_.getObject()), this.memset2_memory_);
                            return;
                        }
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndSpecialize(Object arg0Value, byte arg1Value, long arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                this.memset0_memory_ = LLVMNode.getLLVMMemory();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                this.memset(arg0Value_, arg1Value, arg2Value, this.memset0_memory_);
                return;
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                NativeTypeLibrary nativeTypes__;
                LLVMManagedWriteLibrary nativeWrite__;
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if ((exclude & 1) == 0) {
                    int count2_ = 0;
                    MemsetManagedI80Data s2_ = this.memsetManagedI80_cache;
                    if ((state & 2) != 0) {
                        while (!(s2_ == null || s2_.nativeTypes_.accepts(arg0Value_.getObject()) && s2_.nativeWrite_.accepts(arg0Value_.getObject()) && s2_.nativeWrite_.isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, s2_.nativeTypes_) == 1L)) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && (nativeWrite__ = (LLVMManagedWriteLibrary)super.insert((Node)((LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.create(arg0Value_.getObject())))).isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, nativeTypes__ = (NativeTypeLibrary)super.insert((Node)((NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.create(arg0Value_.getObject())))) == 1L && count2_ < 3) {
                        s2_ = (MemsetManagedI80Data)super.insert((Node)new MemsetManagedI80Data(this.memsetManagedI80_cache));
                        s2_.nativeTypes_ = s2_.insertAccessor(nativeTypes__);
                        s2_.nativeWrite_ = s2_.insertAccessor(nativeWrite__);
                        this.memsetManagedI80_cache = s2_;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.memsetManagedI8(arg0Value_, arg1Value, arg2Value, s2_.nativeTypes_, s2_.nativeWrite_);
                        return;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    NativeTypeLibrary memsetManagedI81_nativeTypes__;
                    LLVMManagedWriteLibrary memsetManagedI81_nativeWrite__ = (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(arg0Value_.getObject());
                    if (memsetManagedI81_nativeWrite__.isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, memsetManagedI81_nativeTypes__ = (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject())) == 1L) {
                        this.exclude_ = exclude |= 1;
                        this.memsetManagedI80_cache = null;
                        state &= 0xFFFFFFFD;
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        this.memsetManagedI8(arg0Value_, arg1Value, arg2Value, memsetManagedI81_nativeTypes__, memsetManagedI81_nativeWrite__);
                        return;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
                if ((exclude & 2) == 0) {
                    int count4_ = 0;
                    MemsetManagedI160Data s4_ = this.memsetManagedI160_cache;
                    if ((state & 8) != 0) {
                        while (!(s4_ == null || s4_.nativeTypes_.accepts(arg0Value_.getObject()) && s4_.nativeWrite_.accepts(arg0Value_.getObject()) && s4_.nativeWrite_.isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, s4_.nativeTypes_) == 2L)) {
                            s4_ = s4_.next_;
                            ++count4_;
                        }
                    }
                    if (s4_ == null && (nativeWrite__ = (LLVMManagedWriteLibrary)super.insert((Node)((LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.create(arg0Value_.getObject())))).isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, nativeTypes__ = (NativeTypeLibrary)super.insert((Node)((NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.create(arg0Value_.getObject())))) == 2L && count4_ < 3) {
                        s4_ = (MemsetManagedI160Data)super.insert((Node)new MemsetManagedI160Data(this.memsetManagedI160_cache));
                        s4_.nativeTypes_ = s4_.insertAccessor(nativeTypes__);
                        s4_.nativeWrite_ = s4_.insertAccessor(nativeWrite__);
                        this.memsetManagedI160_cache = s4_;
                        this.state_ = state |= 8;
                    }
                    if (s4_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.memsetManagedI16(arg0Value_, arg1Value, arg2Value, s4_.nativeTypes_, s4_.nativeWrite_);
                        return;
                    }
                }
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    NativeTypeLibrary memsetManagedI161_nativeTypes__;
                    LLVMManagedWriteLibrary memsetManagedI161_nativeWrite__ = (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(arg0Value_.getObject());
                    if (memsetManagedI161_nativeWrite__.isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, memsetManagedI161_nativeTypes__ = (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject())) == 2L) {
                        this.exclude_ = exclude |= 2;
                        this.memsetManagedI160_cache = null;
                        state &= 0xFFFFFFF7;
                        this.state_ = state |= 0x10;
                        lock.unlock();
                        hasLock = false;
                        this.memsetManagedI16(arg0Value_, arg1Value, arg2Value, memsetManagedI161_nativeTypes__, memsetManagedI161_nativeWrite__);
                        return;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
                if ((exclude & 4) == 0) {
                    int count6_ = 0;
                    MemsetManagedI320Data s6_ = this.memsetManagedI320_cache;
                    if ((state & 0x20) != 0) {
                        while (!(s6_ == null || s6_.nativeTypes_.accepts(arg0Value_.getObject()) && s6_.nativeWrite_.accepts(arg0Value_.getObject()) && s6_.nativeWrite_.isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, s6_.nativeTypes_) == 4L)) {
                            s6_ = s6_.next_;
                            ++count6_;
                        }
                    }
                    if (s6_ == null && (nativeWrite__ = (LLVMManagedWriteLibrary)super.insert((Node)((LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.create(arg0Value_.getObject())))).isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, nativeTypes__ = (NativeTypeLibrary)super.insert((Node)((NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.create(arg0Value_.getObject())))) == 4L && count6_ < 3) {
                        s6_ = (MemsetManagedI320Data)super.insert((Node)new MemsetManagedI320Data(this.memsetManagedI320_cache));
                        s6_.nativeTypes_ = s6_.insertAccessor(nativeTypes__);
                        s6_.nativeWrite_ = s6_.insertAccessor(nativeWrite__);
                        this.memsetManagedI320_cache = s6_;
                        this.state_ = state |= 0x20;
                    }
                    if (s6_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.memsetManagedI32(arg0Value_, arg1Value, arg2Value, s6_.nativeTypes_, s6_.nativeWrite_);
                        return;
                    }
                }
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    NativeTypeLibrary memsetManagedI321_nativeTypes__;
                    LLVMManagedWriteLibrary memsetManagedI321_nativeWrite__ = (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(arg0Value_.getObject());
                    if (memsetManagedI321_nativeWrite__.isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, memsetManagedI321_nativeTypes__ = (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject())) == 4L) {
                        this.exclude_ = exclude |= 4;
                        this.memsetManagedI320_cache = null;
                        state &= 0xFFFFFFDF;
                        this.state_ = state |= 0x40;
                        lock.unlock();
                        hasLock = false;
                        this.memsetManagedI32(arg0Value_, arg1Value, arg2Value, memsetManagedI321_nativeTypes__, memsetManagedI321_nativeWrite__);
                        return;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
                if ((exclude & 8) == 0) {
                    int count8_ = 0;
                    MemsetManagedI640Data s8_ = this.memsetManagedI640_cache;
                    if ((state & 0x80) != 0) {
                        while (!(s8_ == null || s8_.nativeTypes_.accepts(arg0Value_.getObject()) && s8_.nativeWrite_.accepts(arg0Value_.getObject()) && s8_.nativeWrite_.isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, s8_.nativeTypes_) == 8L)) {
                            s8_ = s8_.next_;
                            ++count8_;
                        }
                    }
                    if (s8_ == null && (nativeWrite__ = (LLVMManagedWriteLibrary)super.insert((Node)((LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.create(arg0Value_.getObject())))).isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, nativeTypes__ = (NativeTypeLibrary)super.insert((Node)((NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.create(arg0Value_.getObject())))) == 8L && count8_ < 3) {
                        s8_ = (MemsetManagedI640Data)super.insert((Node)new MemsetManagedI640Data(this.memsetManagedI640_cache));
                        s8_.nativeTypes_ = s8_.insertAccessor(nativeTypes__);
                        s8_.nativeWrite_ = s8_.insertAccessor(nativeWrite__);
                        this.memsetManagedI640_cache = s8_;
                        this.state_ = state |= 0x80;
                    }
                    if (s8_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.memsetManagedI64(arg0Value_, arg1Value, arg2Value, s8_.nativeTypes_, s8_.nativeWrite_);
                        return;
                    }
                }
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    NativeTypeLibrary memsetManagedI641_nativeTypes__;
                    LLVMManagedWriteLibrary memsetManagedI641_nativeWrite__ = (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(arg0Value_.getObject());
                    if (memsetManagedI641_nativeWrite__.isWritable(arg0Value_.getObject()) && this.getAccessLength(arg0Value_, arg2Value, memsetManagedI641_nativeTypes__ = (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value_.getObject())) == 8L) {
                        this.exclude_ = exclude |= 8;
                        this.memsetManagedI640_cache = null;
                        state &= 0xFFFFFF7F;
                        this.state_ = state |= 0x100;
                        lock.unlock();
                        hasLock = false;
                        this.memsetManagedI64(arg0Value_, arg1Value, arg2Value, memsetManagedI641_nativeTypes__, memsetManagedI641_nativeWrite__);
                        return;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
                if ((exclude & 0x10) == 0) {
                    int count10_ = 0;
                    Memset1Data s10_ = this.memset1_cache;
                    if ((state & 0x200) != 0) {
                        while (s10_ != null && (!s10_.nativeWrite_.accepts(arg0Value_.getObject()) || s10_.nativeWrite_.isWritable(arg0Value_.getObject()))) {
                            s10_ = s10_.next_;
                            ++count10_;
                        }
                    }
                    if (s10_ == null && !(nativeWrite__ = (LLVMManagedWriteLibrary)super.insert((Node)((LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.create(arg0Value_.getObject())))).isWritable(arg0Value_.getObject()) && count10_ < 3) {
                        s10_ = (Memset1Data)super.insert((Node)new Memset1Data(this.memset1_cache));
                        s10_.globalAccess_ = s10_.insertAccessor(LLVMToNativeNode.createToNativeWithTarget());
                        s10_.nativeWrite_ = s10_.insertAccessor(nativeWrite__);
                        s10_.memory_ = LLVMNode.getLLVMMemory();
                        this.memset1_cache = s10_;
                        this.state_ = state |= 0x200;
                    }
                    if (s10_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.memset(arg0Value_, arg1Value, arg2Value, s10_.globalAccess_, s10_.nativeWrite_, s10_.memory_);
                        return;
                    }
                }
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    LLVMManagedWriteLibrary memset2_nativeWrite__ = (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(arg0Value_.getObject());
                    if (!memset2_nativeWrite__.isWritable(arg0Value_.getObject())) {
                        this.memset2_globalAccess_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                        this.memset2_memory_ = LLVMNode.getLLVMMemory();
                        this.exclude_ = exclude |= 0x10;
                        this.memset1_cache = null;
                        state &= 0xFFFFFDFF;
                        this.state_ = state |= 0x400;
                        lock.unlock();
                        hasLock = false;
                        this.memset(arg0Value_, arg1Value, arg2Value, this.memset2_globalAccess_, memset2_nativeWrite__, this.memset2_memory_);
                        return;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            MemsetManagedI80Data s2_ = this.memsetManagedI80_cache;
            MemsetManagedI160Data s4_ = this.memsetManagedI160_cache;
            MemsetManagedI320Data s6_ = this.memsetManagedI320_cache;
            MemsetManagedI640Data s8_ = this.memsetManagedI640_cache;
            Memset1Data s10_ = this.memset1_cache;
            if (!(s2_ != null && s2_.next_ != null || s4_ != null && s4_.next_ != null || s6_ != null && s6_.next_ != null || s8_ != null && s8_.next_ != null || s10_ != null && s10_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static NativeMemSetNode create() {
        return new NativeMemSetNodeGen();
    }

    @GeneratedBy(value=NativeMemSetNode.class)
    private static final class Memset1Data
    extends Node {
        @Node.Child
        Memset1Data next_;
        @Node.Child
        LLVMToNativeNode globalAccess_;
        @Node.Child
        LLVMManagedWriteLibrary nativeWrite_;
        @CompilerDirectives.CompilationFinal
        LLVMMemory memory_;

        Memset1Data(Memset1Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=NativeMemSetNode.class)
    private static final class MemsetManagedI640Data
    extends Node {
        @Node.Child
        MemsetManagedI640Data next_;
        @Node.Child
        NativeTypeLibrary nativeTypes_;
        @Node.Child
        LLVMManagedWriteLibrary nativeWrite_;

        MemsetManagedI640Data(MemsetManagedI640Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=NativeMemSetNode.class)
    private static final class MemsetManagedI320Data
    extends Node {
        @Node.Child
        MemsetManagedI320Data next_;
        @Node.Child
        NativeTypeLibrary nativeTypes_;
        @Node.Child
        LLVMManagedWriteLibrary nativeWrite_;

        MemsetManagedI320Data(MemsetManagedI320Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=NativeMemSetNode.class)
    private static final class MemsetManagedI160Data
    extends Node {
        @Node.Child
        MemsetManagedI160Data next_;
        @Node.Child
        NativeTypeLibrary nativeTypes_;
        @Node.Child
        LLVMManagedWriteLibrary nativeWrite_;

        MemsetManagedI160Data(MemsetManagedI160Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=NativeMemSetNode.class)
    private static final class MemsetManagedI80Data
    extends Node {
        @Node.Child
        MemsetManagedI80Data next_;
        @Node.Child
        NativeTypeLibrary nativeTypes_;
        @Node.Child
        LLVMManagedWriteLibrary nativeWrite_;

        MemsetManagedI80Data(MemsetManagedI80Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

