/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMNativeMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public class LLVMDerefHandleGetReceiverNode
extends LLVMNode {
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> context;

    protected LLVMContext getContext() {
        if (this.context == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.context = this.lookupContextReference(LLVMLanguage.class);
        }
        return (LLVMContext)this.context.get();
    }

    public LLVMManagedPointer execute(LLVMNativePointer addr) {
        return this.execute(addr.asNative());
    }

    public LLVMManagedPointer execute(long addr) {
        long mask = LLVMNativeMemory.getDerefHandleObjectMask();
        LLVMNativePointer objectBaseAddr = LLVMNativePointer.create(addr & (mask ^ 0xFFFFFFFFFFFFFFFFL));
        Object receiver = this.getContext().getManagedObjectForHandle(objectBaseAddr);
        LLVMManagedPointer pointerToForeign = LLVMManagedPointer.create(receiver);
        return pointerToForeign.increment(addr & mask);
    }

    public static LLVMDerefHandleGetReceiverNode create() {
        return new LLVMDerefHandleGetReceiverNode();
    }
}

