/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDirectLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMDirectLoadNode.class)
public final class LLVMDirectLoadNodeFactory {
    private static final LibraryFactory<LLVMManagedReadLibrary> L_L_V_M_MANAGED_READ_LIBRARY_ = LibraryFactory.resolve(LLVMManagedReadLibrary.class);

    @GeneratedBy(value=LLVMDirectLoadNode.LLVMStructDirectLoadNode.class)
    public static final class LLVMStructDirectLoadNodeGen
    extends LLVMDirectLoadNode.LLVMStructDirectLoadNode {
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMStructDirectLoadNodeGen(LLVMExpressionNode address) {
            this.address_ = address;
        }

        @Override
        public Object executeWithTarget(Object addressValue) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isPointer(addressValue)) {
                LLVMPointer addressValue_ = LLVMTypes.asPointer(addressValue);
                return this.doPointer(addressValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isPointer(addressValue_)) {
                LLVMPointer addressValue__ = LLVMTypes.asPointer(addressValue_);
                return this.doPointer(addressValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        private LLVMPointer executeAndSpecialize(Object addressValue) {
            int state = this.state_;
            if (LLVMTypes.isPointer(addressValue)) {
                LLVMPointer addressValue_ = LLVMTypes.asPointer(addressValue);
                this.state_ = state |= 1;
                return this.doPointer(addressValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMDirectLoadNode.LLVMStructDirectLoadNode create(LLVMExpressionNode address) {
            return new LLVMStructDirectLoadNodeGen(address);
        }
    }

    @GeneratedBy(value=LLVMDirectLoadNode.LLVMPointerDirectLoadNode.class)
    public static final class LLVMPointerDirectLoadNodeGen
    extends LLVMDirectLoadNode.LLVMPointerDirectLoadNode {
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private LLVMManagedReadLibrary derefHandle_nativeRead_;
        @Node.Child
        private IndirectedForeign0Data indirectedForeign0_cache;

        private LLVMPointerDirectLoadNodeGen(LLVMExpressionNode address) {
            this.address_ = address;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doNativePointer((LLVMNativePointer)addressValue_);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doDerefHandle((LLVMNativePointer)addressValue_, this.derefHandle_nativeRead_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    IndirectedForeign0Data s3_ = this.indirectedForeign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doIndirectedForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.indirectedForeign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object indirectedForeign1Boundary(int state, LLVMManagedPointer addressValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMPointer lLVMPointer = this.doIndirectedForeign(addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return lLVMPointer;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doNativePointer((LLVMNativePointer)addressValue__);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doDerefHandle((LLVMNativePointer)addressValue__, this.derefHandle_nativeRead_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    IndirectedForeign0Data s3_ = this.indirectedForeign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doIndirectedForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.indirectedForeign1Boundary0(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object indirectedForeign1Boundary0(int state, LLVMManagedPointer addressValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMPointer lLVMPointer = this.doIndirectedForeign(addressValue__, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return lLVMPointer;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMPointer executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMNativePointer lLVMNativePointer = this.doNativePointer((LLVMNativePointer)addressValue_);
                        return lLVMNativePointer;
                    }
                    if (this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.derefHandle_nativeRead_ = (LLVMManagedReadLibrary)super.insert((Node)((LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMPointer lLVMPointer = this.doDerefHandle((LLVMNativePointer)addressValue_, this.derefHandle_nativeRead_);
                        return lLVMPointer;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        IndirectedForeign0Data s3_ = this.indirectedForeign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (IndirectedForeign0Data)super.insert((Node)new IndirectedForeign0Data(this.indirectedForeign0_cache));
                            s3_.nativeRead_ = s3_.insertAccessor((LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.indirectedForeign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMPointer lLVMPointer = this.doIndirectedForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMPointer;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        this.exclude_ = exclude |= 1;
                        this.indirectedForeign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMPointer lLVMPointer = this.doIndirectedForeign((LLVMManagedPointer)addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                        return lLVMPointer;
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            IndirectedForeign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.indirectedForeign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDirectLoadNode.LLVMPointerDirectLoadNode create(LLVMExpressionNode address) {
            return new LLVMPointerDirectLoadNodeGen(address);
        }

        @GeneratedBy(value=LLVMDirectLoadNode.LLVMPointerDirectLoadNode.class)
        private static final class IndirectedForeign0Data
        extends Node {
            @Node.Child
            IndirectedForeign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            IndirectedForeign0Data(IndirectedForeign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMDirectLoadNode.LLVM80BitFloatDirectLoadNode.class)
    public static final class LLVM80BitFloatDirectLoadNodeGen
    extends LLVMDirectLoadNode.LLVM80BitFloatDirectLoadNode {
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private LLVMDirectLoadNode.LLVM80BitFloatDirectLoadNode do80BitFloatDerefHandle_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVM80BitFloatDirectLoadNodeGen(LLVMExpressionNode address) {
            this.address_ = address;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.do80BitFloatNative((LLVMNativePointer)addressValue_);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.do80BitFloatDerefHandle((LLVMNativePointer)addressValue_, this.do80BitFloatDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVM80BitFloat lLVM80BitFloat = this.doForeign(addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return lLVM80BitFloat;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected LLVM80BitFloat executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVM80BitFloat foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVM80BitFloat lLVM80BitFloat = this.doForeign(addressValue, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                return lLVM80BitFloat;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.do80BitFloatNative((LLVMNativePointer)addressValue__);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.do80BitFloatDerefHandle((LLVMNativePointer)addressValue__, this.do80BitFloatDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVM80BitFloat lLVM80BitFloat = this.doForeign(addressValue__, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return lLVM80BitFloat;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVM80BitFloat executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVM80BitFloat lLVM80BitFloat = this.do80BitFloatNative((LLVMNativePointer)addressValue_);
                        return lLVM80BitFloat;
                    }
                    if (this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.do80BitFloatDerefHandle_load_ = (LLVMDirectLoadNode.LLVM80BitFloatDirectLoadNode)super.insert((Node)LLVMDirectLoadNode.LLVM80BitFloatDirectLoadNode.create());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVM80BitFloat lLVM80BitFloat = this.do80BitFloatDerefHandle((LLVMNativePointer)addressValue_, this.do80BitFloatDerefHandle_load_);
                        return lLVM80BitFloat;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = s3_.insertAccessor((LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVM80BitFloat lLVM80BitFloat = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVM80BitFloat;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVM80BitFloat lLVM80BitFloat = this.doForeign((LLVMManagedPointer)addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                        return lLVM80BitFloat;
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDirectLoadNode.LLVM80BitFloatDirectLoadNode create(LLVMExpressionNode address) {
            return new LLVM80BitFloatDirectLoadNodeGen(address);
        }

        @GeneratedBy(value=LLVMDirectLoadNode.LLVM80BitFloatDirectLoadNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMDirectLoadNode.LLVMIVarBitDirectLoadNode.class)
    public static final class LLVMIVarBitDirectLoadNodeGen
    extends LLVMDirectLoadNode.LLVMIVarBitDirectLoadNode {
        private final int bitWidth;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private LLVMDirectLoadNode.LLVMIVarBitDirectLoadNode iVarBitDerefHandle_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVMIVarBitDirectLoadNodeGen(LLVMExpressionNode address, int bitWidth) {
            this.bitWidth = bitWidth;
            this.address_ = address;
        }

        @Override
        public int getBitWidth() {
            return this.bitWidth;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doIVarBitNative((LLVMNativePointer)addressValue_);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doIVarBitDerefHandle((LLVMNativePointer)addressValue_, this.iVarBitDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMIVarBit lLVMIVarBit = this.doForeign(addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return lLVMIVarBit;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected LLVMIVarBit executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMIVarBit foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMIVarBit lLVMIVarBit = this.doForeign(addressValue, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                return lLVMIVarBit;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doIVarBitNative((LLVMNativePointer)addressValue__);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doIVarBitDerefHandle((LLVMNativePointer)addressValue__, this.iVarBitDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMIVarBit lLVMIVarBit = this.doForeign(addressValue__, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return lLVMIVarBit;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMIVarBit executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMIVarBit lLVMIVarBit = this.doIVarBitNative((LLVMNativePointer)addressValue_);
                        return lLVMIVarBit;
                    }
                    if (this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.iVarBitDerefHandle_load_ = (LLVMDirectLoadNode.LLVMIVarBitDirectLoadNode)super.insert((Node)this.createRecursive());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMIVarBit lLVMIVarBit = this.doIVarBitDerefHandle((LLVMNativePointer)addressValue_, this.iVarBitDerefHandle_load_);
                        return lLVMIVarBit;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = s3_.insertAccessor((LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMIVarBit lLVMIVarBit = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMIVarBit;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMIVarBit lLVMIVarBit = this.doForeign((LLVMManagedPointer)addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                        return lLVMIVarBit;
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDirectLoadNode.LLVMIVarBitDirectLoadNode create(LLVMExpressionNode address, int bitWidth) {
            return new LLVMIVarBitDirectLoadNodeGen(address, bitWidth);
        }

        @GeneratedBy(value=LLVMDirectLoadNode.LLVMIVarBitDirectLoadNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

