/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.DoubleValueProfile;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMAbstractLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMDoubleLoadNode
extends LLVMAbstractLoadNode {
    private final DoubleValueProfile profile = DoubleValueProfile.createRawIdentityProfile();

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected double doDoubleNative(LLVMNativePointer addr) {
        return this.profile.profile(this.getLLVMMemoryCached().getDouble(addr));
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected double doDoubleDerefHandle(LLVMNativePointer addr, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return this.doDoubleManaged(this.getDerefHandleGetReceiverNode().execute(addr), nativeRead);
    }

    @Specialization(limit="3")
    protected double doDoubleManaged(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readDouble(addr.getObject(), addr.getOffset());
    }
}

