/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI1LoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMI1LoadNode.class)
public final class LLVMI1LoadNodeGen
extends LLVMI1LoadNode {
    private static final LibraryFactory<LLVMManagedReadLibrary> L_L_V_M_MANAGED_READ_LIBRARY_ = LibraryFactory.resolve(LLVMManagedReadLibrary.class);
    @Node.Child
    private LLVMExpressionNode address_;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private LLVMManagedReadLibrary i1DerefHandle_nativeRead_;
    @Node.Child
    private I1Managed0Data i1Managed0_cache;

    private LLVMI1LoadNodeGen(LLVMExpressionNode address) {
        this.address_ = address;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public Object executeWithTarget(Object addressValue) {
        LLVMPointer addressValue_;
        int state = this.state_;
        if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
            addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                return this.doI1Native((LLVMNativePointer)addressValue_);
            }
            if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                return this.doI1DerefHandle((LLVMNativePointer)addressValue_, this.i1DerefHandle_nativeRead_);
            }
        }
        if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
            addressValue_ = LLVMTypes.asManagedPointer(addressValue);
            if ((state & 4) != 0) {
                I1Managed0Data s3_ = this.i1Managed0_cache;
                while (s3_ != null) {
                    if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                        return this.doI1Managed((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                    }
                    s3_ = s3_.next_;
                }
            }
            if ((state & 8) != 0) {
                return this.i1Managed1Boundary(state, (LLVMManagedPointer)addressValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(addressValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object i1Managed1Boundary(int state, LLVMManagedPointer addressValue_) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            Boolean bl = this.doI1Managed(addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
            return bl;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public Object executeGeneric(VirtualFrame frameValue) {
        LLVMPointer addressValue__;
        int state = this.state_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
            addressValue__ = LLVMTypes.asNativePointer(addressValue_);
            if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                return this.doI1Native((LLVMNativePointer)addressValue__);
            }
            if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                return this.doI1DerefHandle((LLVMNativePointer)addressValue__, this.i1DerefHandle_nativeRead_);
            }
        }
        if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
            addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
            if ((state & 4) != 0) {
                I1Managed0Data s3_ = this.i1Managed0_cache;
                while (s3_ != null) {
                    if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                        return this.doI1Managed((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                    }
                    s3_ = s3_.next_;
                }
            }
            if ((state & 8) != 0) {
                return this.i1Managed1Boundary0(state, (LLVMManagedPointer)addressValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(addressValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object i1Managed1Boundary0(int state, LLVMManagedPointer addressValue__) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            Boolean bl = this.doI1Managed(addressValue__, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
            return bl;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public boolean executeI1(VirtualFrame frameValue) {
        LLVMPointer addressValue__;
        int state = this.state_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
            addressValue__ = LLVMTypes.asNativePointer(addressValue_);
            if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                return this.doI1Native((LLVMNativePointer)addressValue__);
            }
            if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                return this.doI1DerefHandle((LLVMNativePointer)addressValue__, this.i1DerefHandle_nativeRead_);
            }
        }
        if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
            addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
            if ((state & 4) != 0) {
                I1Managed0Data s3_ = this.i1Managed0_cache;
                while (s3_ != null) {
                    if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                        return this.doI1Managed((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                    }
                    s3_ = s3_.next_;
                }
            }
            if ((state & 8) != 0) {
                return this.i1Managed1Boundary1(state, (LLVMManagedPointer)addressValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(addressValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean i1Managed1Boundary1(int state, LLVMManagedPointer addressValue__) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            boolean bl = this.doI1Managed(addressValue__, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
            return bl;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object addressValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            LLVMPointer addressValue_;
            if (LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doI1Native((LLVMNativePointer)addressValue_);
                    return bl;
                }
                if (this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    this.i1DerefHandle_nativeRead_ = (LLVMManagedReadLibrary)super.insert((Node)((LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doI1DerefHandle((LLVMNativePointer)addressValue_, this.i1DerefHandle_nativeRead_);
                    return bl;
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if (exclude == 0) {
                    int count3_ = 0;
                    I1Managed0Data s3_ = this.i1Managed0_cache;
                    if ((state & 4) != 0) {
                        while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            s3_ = s3_.next_;
                            ++count3_;
                        }
                    }
                    if (s3_ == null && count3_ < 3) {
                        s3_ = (I1Managed0Data)super.insert((Node)new I1Managed0Data(this.i1Managed0_cache));
                        s3_.nativeRead_ = s3_.insertAccessor((LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                        this.i1Managed0_cache = s3_;
                        this.state_ = state |= 4;
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.doI1Managed((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        return bl;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    this.exclude_ = exclude |= 1;
                    this.i1Managed0_cache = null;
                    state &= 0xFFFFFFFB;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doI1Managed((LLVMManagedPointer)addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                    return bl;
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        I1Managed0Data s3_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s3_ = this.i1Managed0_cache) == null || s3_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMI1LoadNode create(LLVMExpressionNode address) {
        return new LLVMI1LoadNodeGen(address);
    }

    @GeneratedBy(value=LLVMI1LoadNode.class)
    private static final class I1Managed0Data
    extends Node {
        @Node.Child
        I1Managed0Data next_;
        @Node.Child
        LLVMManagedReadLibrary nativeRead_;

        I1Managed0Data(I1Managed0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

