/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.rmw;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="pointerNode"), @NodeChild(type=LLVMExpressionNode.class, value="valueNode")})
public abstract class LLVMI32RMWNode
extends LLVMExpressionNode {
    protected static LLVMI32LoadNode createRead() {
        return LLVMI32LoadNodeGen.create(null);
    }

    protected static LLVMI32StoreNode createWrite() {
        return LLVMI32StoreNodeGen.create(null, null);
    }

    public static abstract class LLVMI32RMWXorNode
    extends LLVMI32RMWNode {
        @Specialization
        protected int doOp(LLVMNativePointer address, int value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndOpI32(address, value, (a, b) -> a ^ b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected int doOp(LLVMManagedPointer address, int value, @Cached(value="createRead()") LLVMI32LoadNode read, @Cached(value="createWrite()") LLVMI32StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                int result = (Integer)read.executeWithTarget(address);
                write.executeWithTarget(address, result ^ value);
                return result;
            }
        }
    }

    public static abstract class LLVMI32RMWOrNode
    extends LLVMI32RMWNode {
        @Specialization
        protected int doOp(LLVMNativePointer address, int value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndOpI32(address, value, (a, b) -> a | b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected int doOp(LLVMManagedPointer address, int value, @Cached(value="createRead()") LLVMI32LoadNode read, @Cached(value="createWrite()") LLVMI32StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                int result = (Integer)read.executeWithTarget(address);
                write.executeWithTarget(address, result | value);
                return result;
            }
        }
    }

    public static abstract class LLVMI32RMWNandNode
    extends LLVMI32RMWNode {
        @Specialization
        protected int doOp(LLVMNativePointer address, int value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndOpI32(address, value, (a, b) -> ~(a & b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected int doOp(LLVMManagedPointer address, int value, @Cached(value="createRead()") LLVMI32LoadNode read, @Cached(value="createWrite()") LLVMI32StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                int result = (Integer)read.executeWithTarget(address);
                write.executeWithTarget(address, ~(result & value));
                return result;
            }
        }
    }

    public static abstract class LLVMI32RMWAndNode
    extends LLVMI32RMWNode {
        @Specialization
        protected int doOp(LLVMNativePointer address, int value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndOpI32(address, value, (a, b) -> a & b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected int doOp(LLVMManagedPointer address, int value, @Cached(value="createRead()") LLVMI32LoadNode read, @Cached(value="createWrite()") LLVMI32StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                int result = (Integer)read.executeWithTarget(address);
                write.executeWithTarget(address, result & value);
                return result;
            }
        }
    }

    public static abstract class LLVMI32RMWSubNode
    extends LLVMI32RMWNode {
        @Specialization
        protected int doOp(LLVMNativePointer address, int value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndSubI32(address, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected int doOp(LLVMManagedPointer address, int value, @Cached(value="createRead()") LLVMI32LoadNode read, @Cached(value="createWrite()") LLVMI32StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                int result = (Integer)read.executeWithTarget(address);
                write.executeWithTarget(address, result - value);
                return result;
            }
        }
    }

    public static abstract class LLVMI32RMWAddNode
    extends LLVMI32RMWNode {
        @Specialization
        protected int doOp(LLVMNativePointer address, int value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndAddI32(address, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected int doOp(LLVMManagedPointer address, int value, @Cached(value="createRead()") LLVMI32LoadNode read, @Cached(value="createWrite()") LLVMI32StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                int result = (Integer)read.executeWithTarget(address);
                write.executeWithTarget(address, result + value);
                return result;
            }
        }
    }

    public static abstract class LLVMI32RMWXchgNode
    extends LLVMI32RMWNode {
        @Specialization
        protected int doOp(LLVMNativePointer address, int value, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return memory.getAndSetI32(address, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected int doOp(LLVMManagedPointer address, int value, @Cached(value="createRead()") LLVMI32LoadNode read, @Cached(value="createWrite()") LLVMI32StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                int result = (Integer)read.executeWithTarget(address);
                write.executeWithTarget(address, value);
                return result;
            }
        }
    }
}

