/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMDoubleStoreNode.class)
public final class LLVMDoubleStoreNodeGen
extends LLVMDoubleStoreNode {
    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);
    @Node.Child
    private LLVMExpressionNode address_;
    @Node.Child
    private LLVMExpressionNode value_;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private LLVMManagedWriteLibrary opDerefHandle_nativeWrite_;
    @Node.Child
    private OpManaged0Data opManaged0_cache;

    private LLVMDoubleStoreNodeGen(LLVMExpressionNode address, LLVMExpressionNode value) {
        this.address_ = address;
        this.value_ = value;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public void executeWithTarget(Object addressValue, Object valueValue) {
        int state = this.state_;
        if (state != 0 && valueValue instanceof Double) {
            LLVMPointer addressValue_;
            double valueValue_ = (Double)valueValue;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    this.doOp((LLVMNativePointer)addressValue_, valueValue_);
                    return;
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    this.doOpDerefHandle((LLVMNativePointer)addressValue_, valueValue_, this.opDerefHandle_nativeWrite_);
                    return;
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    OpManaged0Data s3_ = this.opManaged0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeWrite_.accepts(addressValue_.getObject())) {
                            this.doOpManaged((LLVMManagedPointer)addressValue_, valueValue_, s3_.nativeWrite_);
                            return;
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    this.opManaged1Boundary(state, (LLVMManagedPointer)addressValue_, valueValue_);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue, valueValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void opManaged1Boundary(int state, LLVMManagedPointer addressValue_, double valueValue_) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            this.doOpManaged(addressValue_, valueValue_, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
            return;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public void execute(VirtualFrame frameValue) {
        LLVMPointer addressValue__;
        double valueValue_;
        int state = this.state_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        try {
            valueValue_ = this.value_.executeDouble(frameValue);
        }
        catch (UnexpectedResultException ex) {
            this.executeAndSpecialize(addressValue_, ex.getResult());
            return;
        }
        if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
            addressValue__ = LLVMTypes.asNativePointer(addressValue_);
            if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                this.doOp((LLVMNativePointer)addressValue__, valueValue_);
                return;
            }
            if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                this.doOpDerefHandle((LLVMNativePointer)addressValue__, valueValue_, this.opDerefHandle_nativeWrite_);
                return;
            }
        }
        if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
            addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
            if ((state & 4) != 0) {
                OpManaged0Data s3_ = this.opManaged0_cache;
                while (s3_ != null) {
                    if (s3_.nativeWrite_.accepts(addressValue__.getObject())) {
                        this.doOpManaged((LLVMManagedPointer)addressValue__, valueValue_, s3_.nativeWrite_);
                        return;
                    }
                    s3_ = s3_.next_;
                }
            }
            if ((state & 8) != 0) {
                this.opManaged1Boundary0(state, (LLVMManagedPointer)addressValue__, valueValue_);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue_, valueValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void opManaged1Boundary0(int state, LLVMManagedPointer addressValue__, double valueValue_) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            this.doOpManaged(addressValue__, valueValue_, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
            return;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndSpecialize(Object addressValue, Object valueValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (valueValue instanceof Double) {
                LLVMPointer addressValue_;
                double valueValue_ = (Double)valueValue;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        this.doOp((LLVMNativePointer)addressValue_, valueValue_);
                        return;
                    }
                    if (this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.opDerefHandle_nativeWrite_ = (LLVMManagedWriteLibrary)super.insert((Node)((LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3)));
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        this.doOpDerefHandle((LLVMNativePointer)addressValue_, valueValue_, this.opDerefHandle_nativeWrite_);
                        return;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        OpManaged0Data s3_ = this.opManaged0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeWrite_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (OpManaged0Data)super.insert((Node)new OpManaged0Data(this.opManaged0_cache));
                            s3_.nativeWrite_ = s3_.insertAccessor((LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject()));
                            this.opManaged0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            this.doOpManaged((LLVMManagedPointer)addressValue_, valueValue_, s3_.nativeWrite_);
                            return;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        this.exclude_ = exclude |= 1;
                        this.opManaged0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        this.doOpManaged((LLVMManagedPointer)addressValue_, valueValue_, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                        return;
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_, this.value_}, new Object[]{addressValue, valueValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        OpManaged0Data s3_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s3_ = this.opManaged0_cache) == null || s3_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMDoubleStoreNode create(LLVMExpressionNode address, LLVMExpressionNode value) {
        return new LLVMDoubleStoreNodeGen(address, value);
    }

    @GeneratedBy(value=LLVMDoubleStoreNode.class)
    private static final class OpManaged0Data
    extends Node {
        @Node.Child
        OpManaged0Data next_;
        @Node.Child
        LLVMManagedWriteLibrary nativeWrite_;

        OpManaged0Data(OpManaged0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

