/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStoreNodeCommon;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMI16StoreNode
extends LLVMStoreNodeCommon {
    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected void doOp(LLVMNativePointer addr, short value) {
        this.getLLVMMemoryCached().putI16(addr, value);
    }

    @Specialization(limit="3")
    protected void doOpManaged(LLVMManagedPointer address, short value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writeI16(address.getObject(), address.getOffset(), value);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected void doOpDerefHandle(LLVMNativePointer addr, short value, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        this.doOpManaged(this.getDerefHandleGetReceiverNode().execute(addr), value, nativeWrite);
    }
}

