/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMArithmeticNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

@NodeChildren(value={@NodeChild(value="leftNode"), @NodeChild(value="rightNode")})
public abstract class LLVMVectorArithmeticNode
extends LLVMExpressionNode {
    private final int vectorLength;
    @Node.Child
    private LLVMArithmeticNode arithmeticNode;

    public LLVMVectorArithmeticNode(int vectorLength, LLVMArithmeticNode arithmeticNode) {
        this.vectorLength = vectorLength;
        this.arithmeticNode = arithmeticNode;
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI1Vector doI1(LLVMI1Vector left, LLVMI1Vector right) {
        assert (left.getLength() == this.vectorLength && right.getLength() == this.vectorLength);
        boolean[] result = new boolean[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = LLVMTypesGen.asBoolean(this.arithmeticNode.executeWithTarget(left.getValue(i), right.getValue(i)));
        }
        return LLVMI1Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI8Vector doI8(LLVMI8Vector left, LLVMI8Vector right) {
        assert (left.getLength() == this.vectorLength && right.getLength() == this.vectorLength);
        byte[] result = new byte[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = LLVMTypesGen.asByte(this.arithmeticNode.executeWithTarget(left.getValue(i), right.getValue(i)));
        }
        return LLVMI8Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI16Vector doI16(LLVMI16Vector left, LLVMI16Vector right) {
        assert (left.getLength() == this.vectorLength && right.getLength() == this.vectorLength);
        short[] result = new short[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = LLVMTypesGen.asShort(this.arithmeticNode.executeWithTarget(left.getValue(i), right.getValue(i)));
        }
        return LLVMI16Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI32Vector doI32(LLVMI32Vector left, LLVMI32Vector right) {
        assert (left.getLength() == this.vectorLength && right.getLength() == this.vectorLength);
        int[] result = new int[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = LLVMTypesGen.asInteger(this.arithmeticNode.executeWithTarget(left.getValue(i), right.getValue(i)));
        }
        return LLVMI32Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMI64Vector doI64(LLVMI64Vector left, LLVMI64Vector right) {
        assert (left.getLength() == this.vectorLength && right.getLength() == this.vectorLength);
        long[] result = new long[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = LLVMTypesGen.asLong(this.arithmeticNode.executeWithTarget(left.getValue(i), right.getValue(i)));
        }
        return LLVMI64Vector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMFloatVector doFloat(LLVMFloatVector left, LLVMFloatVector right) {
        assert (left.getLength() == this.vectorLength && right.getLength() == this.vectorLength);
        float[] result = new float[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = LLVMTypesGen.asFloat(this.arithmeticNode.executeWithTarget(Float.valueOf(left.getValue(i)), Float.valueOf(right.getValue(i))));
        }
        return LLVMFloatVector.create(result);
    }

    @ExplodeLoop
    @Specialization
    protected LLVMDoubleVector doDouble(LLVMDoubleVector left, LLVMDoubleVector right) {
        assert (left.getLength() == this.vectorLength && right.getLength() == this.vectorLength);
        double[] result = new double[this.vectorLength];
        for (int i = 0; i < this.vectorLength; ++i) {
            result[i] = LLVMTypesGen.asDouble(this.arithmeticNode.executeWithTarget(left.getValue(i), right.getValue(i)));
        }
        return LLVMDoubleVector.create(result);
    }
}

