/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValueNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;

public abstract class ToComparableValue
extends LLVMNode {
    public abstract long executeWithTarget(Object var1);

    @Specialization(guards={"lib.isPointer(obj)"}, limit="3", rewriteOn={UnsupportedMessageException.class})
    protected long doPointer(Object obj, @CachedLibrary(value="obj") LLVMNativeLibrary lib) throws UnsupportedMessageException {
        return lib.asPointer(obj);
    }

    @Specialization(guards={"lib.isPointer(obj)"}, limit="3")
    protected long doPointerException(Object obj, @CachedLibrary(value="obj") LLVMNativeLibrary lib, @Cached(value="createUseOffset()") ManagedToComparableValue toComparable) {
        try {
            return lib.asPointer(obj);
        }
        catch (UnsupportedMessageException ex) {
            return this.doManaged(obj, lib, toComparable);
        }
    }

    @Specialization(guards={"!lib.isPointer(obj)"}, limit="3")
    protected long doManaged(Object obj, @CachedLibrary(value="obj") LLVMNativeLibrary lib, @Cached(value="createUseOffset()") ManagedToComparableValue toComparable) {
        return toComparable.executeWithTarget(obj);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static long getHashCode(Object obj) {
        return (long)obj.hashCode() << 8;
    }

    @ImportStatic(value={ForeignToLLVM.ForeignToLLVMType.class})
    public static abstract class ManagedToComparableValue
    extends LLVMNode {
        private final boolean includeOffset;

        public ManagedToComparableValue(boolean includeOffset) {
            this.includeOffset = includeOffset;
        }

        abstract long executeWithTarget(Object var1);

        @Specialization
        protected long doManaged(LLVMManagedPointer address) {
            long result = ToComparableValue.getHashCode(address.getObject());
            if (this.includeOffset) {
                result += address.getOffset();
            }
            return result;
        }

        public static ManagedToComparableValue createIgnoreOffset() {
            return ToComparableValueNodeGen.ManagedToComparableValueNodeGen.create(false);
        }

        public static ManagedToComparableValue createUseOffset() {
            return ToComparableValueNodeGen.ManagedToComparableValueNodeGen.create(true);
        }

        protected ForeignToLLVM createForeignToI64() {
            return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.I64);
        }
    }
}

