/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMExtractElementNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@GeneratedBy(value=LLVMExtractElementNode.class)
public final class LLVMExtractElementNodeFactory {

    @GeneratedBy(value=LLVMExtractElementNode.LLVMDoubleExtractElementNode.class)
    public static final class LLVMDoubleExtractElementNodeGen
    extends LLVMExtractElementNode.LLVMDoubleExtractElementNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMDoubleExtractElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int child1Value_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                return this.doDouble(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            int child1Value_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                return this.doDouble(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private double executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value_ = (LLVMDoubleVector)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_ = state |= 1;
                    return this.doDouble(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMExtractElementNode.LLVMDoubleExtractElementNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMDoubleExtractElementNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMExtractElementNode.LLVMFloatExtractElementNode.class)
    public static final class LLVMFloatExtractElementNodeGen
    extends LLVMExtractElementNode.LLVMFloatExtractElementNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMFloatExtractElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int child1Value_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(child0Value_, ex.getResult()));
            }
            if (state != 0 && child0Value_ instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value__ = (LLVMFloatVector)child0Value_;
                return Float.valueOf(this.doFloat(child0Value__, child1Value_));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(child0Value_, child1Value_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) {
            int child1Value_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value__ = (LLVMFloatVector)child0Value_;
                return this.doFloat(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private float executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof LLVMFloatVector) {
                LLVMFloatVector child0Value_ = (LLVMFloatVector)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_ = state |= 1;
                    return this.doFloat(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMExtractElementNode.LLVMFloatExtractElementNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMFloatExtractElementNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMExtractElementNode.LLVMI64ExtractElementNode.class)
    public static final class LLVMI64ExtractElementNodeGen
    extends LLVMExtractElementNode.LLVMI64ExtractElementNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI64ExtractElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int child1Value_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if ((state & 1) != 0 && child0Value_ instanceof LLVMI64Vector) {
                LLVMI64Vector child0Value__ = (LLVMI64Vector)child0Value_;
                return this.doI64(child0Value__, child1Value_);
            }
            if ((state & 2) != 0 && child0Value_ instanceof LLVMPointerVector) {
                LLVMPointerVector child0Value__ = (LLVMPointerVector)child0Value_;
                return this.doPointer(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int child1Value_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_, ex.getResult()));
            }
            if ((state & 1) != 0 && child0Value_ instanceof LLVMI64Vector) {
                LLVMI64Vector child0Value__ = (LLVMI64Vector)child0Value_;
                return this.doI64(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_, child1Value_));
        }

        private Object executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child1Value instanceof Integer) {
                int child1Value_ = (Integer)child1Value;
                if (child0Value instanceof LLVMI64Vector) {
                    LLVMI64Vector child0Value_ = (LLVMI64Vector)child0Value;
                    this.state_ = state |= 1;
                    return this.doI64(child0Value_, child1Value_);
                }
                if (child0Value instanceof LLVMPointerVector) {
                    LLVMPointerVector child0Value_ = (LLVMPointerVector)child0Value;
                    this.state_ = state |= 2;
                    return this.doPointer(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMExtractElementNode.LLVMI64ExtractElementNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMI64ExtractElementNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMExtractElementNode.LLVMI32ExtractElementNode.class)
    public static final class LLVMI32ExtractElementNodeGen
    extends LLVMExtractElementNode.LLVMI32ExtractElementNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI32ExtractElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int child1Value_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value__ = (LLVMI32Vector)child0Value_;
                return this.doI32(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int child1Value_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value__ = (LLVMI32Vector)child0Value_;
                return this.doI32(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private int executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof LLVMI32Vector) {
                LLVMI32Vector child0Value_ = (LLVMI32Vector)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_ = state |= 1;
                    return this.doI32(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMExtractElementNode.LLVMI32ExtractElementNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMI32ExtractElementNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMExtractElementNode.LLVMI16ExtractElementNode.class)
    public static final class LLVMI16ExtractElementNodeGen
    extends LLVMExtractElementNode.LLVMI16ExtractElementNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI16ExtractElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int child1Value_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value__ = (LLVMI16Vector)child0Value_;
                return this.doI16(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            int child1Value_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value__ = (LLVMI16Vector)child0Value_;
                return this.doI16(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private short executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof LLVMI16Vector) {
                LLVMI16Vector child0Value_ = (LLVMI16Vector)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_ = state |= 1;
                    return this.doI16(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMExtractElementNode.LLVMI16ExtractElementNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMI16ExtractElementNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMExtractElementNode.LLVMI8ExtractElementNode.class)
    public static final class LLVMI8ExtractElementNodeGen
    extends LLVMExtractElementNode.LLVMI8ExtractElementNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI8ExtractElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int child1Value_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value__ = (LLVMI8Vector)child0Value_;
                return this.doI8(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            int child1Value_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value__ = (LLVMI8Vector)child0Value_;
                return this.doI8(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private byte executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof LLVMI8Vector) {
                LLVMI8Vector child0Value_ = (LLVMI8Vector)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_ = state |= 1;
                    return this.doI8(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMExtractElementNode.LLVMI8ExtractElementNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMI8ExtractElementNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMExtractElementNode.LLVMI1ExtractElementNode.class)
    public static final class LLVMI1ExtractElementNodeGen
    extends LLVMExtractElementNode.LLVMI1ExtractElementNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI1ExtractElementNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int child1Value_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value__ = (LLVMI1Vector)child0Value_;
                return this.doI1(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        @Override
        public boolean executeI1(VirtualFrame frameValue) {
            int child1Value_;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            try {
                child1Value_ = this.child1_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, ex.getResult());
            }
            if (state != 0 && child0Value_ instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value__ = (LLVMI1Vector)child0Value_;
                return this.doI1(child0Value__, child1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private boolean executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof LLVMI1Vector) {
                LLVMI1Vector child0Value_ = (LLVMI1Vector)child0Value;
                if (child1Value instanceof Integer) {
                    int child1Value_ = (Integer)child1Value;
                    this.state_ = state |= 1;
                    return this.doI1(child0Value_, child1Value_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMExtractElementNode.LLVMI1ExtractElementNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMI1ExtractElementNodeGen(child0, child1);
        }
    }
}

