/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.options;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOptionOptionDescriptors;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;

public final class SulongEngineOption {
    public static final String OPTION_ARRAY_SEPARATOR = ":";
    @Option(name="llvm.stackSize", category=OptionCategory.USER, stability=OptionStability.STABLE, help="The stack size, please end the input with one of: k, m, g, or t. (Note: the stack size will be in bytes if no appropriate suffix is give.)")
    public static final OptionKey<String> STACK_SIZE = new OptionKey((Object)"81920k");
    public static final String LIBRARY_PATH_NAME = "llvm.libraryPath";
    @Option(name="llvm.libraryPath", category=OptionCategory.USER, stability=OptionStability.STABLE, help="A list of paths where Sulong will search for relative libraries. Paths are delimited by : .")
    public static final OptionKey<String> LIBRARY_PATH = new OptionKey((Object)"");
    @Option(name="llvm.sourcePath", category=OptionCategory.USER, help="This option is deprecated. Use --inspect.SourcePath instead.", deprecated=true)
    public static final OptionKey<String> SOURCE_PATH = new OptionKey((Object)"");
    @Option(name="llvm.loadC++Libraries", category=OptionCategory.EXPERT, help="Specifies whether the standard C++ libraries (libc++ and libc++abi) should be loaded. Enabled by default.")
    public static final OptionKey<Boolean> LOAD_CXX_LIBRARIES = new OptionKey((Object)true);
    @Option(name="llvm.enableExternalNativeAccess", category=OptionCategory.USER, help="Enable Sulongs native interface.")
    public static final OptionKey<Boolean> ENABLE_NFI = new OptionKey((Object)true);
    @Option(name="llvm.debugSysCalls", category=OptionCategory.INTERNAL, help="Turns syscall debugging on/off. Can be 'stdout' or 'stderr'.")
    public static final OptionKey<String> DEBUG_SYSCALLS = new OptionKey((Object)String.valueOf(false));
    @Option(name="llvm.printNativeCallStats", category=OptionCategory.INTERNAL, help="Outputs stats about native call site frequencies. Can be 'stdout' or 'stderr'.")
    public static final OptionKey<String> NATIVE_CALL_STATS = new OptionKey((Object)String.valueOf(false));
    @Option(name="llvm.printLifetimeAnalysisStats", category=OptionCategory.INTERNAL, help="Prints the results of the lifetime analysis. Can be 'stdout' or 'stderr'.")
    public static final OptionKey<String> PRINT_LIFE_TIME_ANALYSIS_STATS = new OptionKey((Object)String.valueOf(false));
    @Option(name="llvm.debugLoader", category=OptionCategory.EXPERT, help="Turns dynamic loader debugging on/off. Can be 'stdout' or 'stderr'.")
    public static final OptionKey<String> LD_DEBUG = new OptionKey((Object)String.valueOf(false));
    @Option(name="llvm.parseOnly", category=OptionCategory.EXPERT, help="Only parses a bc file; execution is not possible.")
    public static final OptionKey<Boolean> PARSE_ONLY = new OptionKey((Object)false);
    @Option(name="llvm.enableLVI", category=OptionCategory.EXPERT, help="Enable source-level inspection of local variables.")
    public static final OptionKey<Boolean> ENABLE_LVI = new OptionKey((Object)false);
    public static final String LAZY_PARSING_NAME = "llvm.lazyParsing";
    @Option(name="llvm.lazyParsing", category=OptionCategory.EXPERT, help="Enable lazy parsing of LLVM bitcode files.")
    public static final OptionKey<Boolean> LAZY_PARSING = new OptionKey((Object)true);
    @Option(name="llvm.llDebug", category=OptionCategory.EXPERT, help="Enable IR-level debugging of LLVM bitcode files.")
    public static final OptionKey<Boolean> LL_DEBUG = new OptionKey((Object)false);
    @Option(name="llvm.llDebug.sources", category=OptionCategory.EXPERT, help="Provide the locations of *.ll files for debugging. The expected format is <bc-path>=<ll-path>{:<bc-path>=<ll-path>}.")
    public static final OptionKey<String> LL_DEBUG_SOURCES = new OptionKey((Object)"");
    @Option(name="llvm.printStackTraceOnAbort", category=OptionCategory.INTERNAL, help="Prints a C stack trace when abort() is called.")
    public static final OptionKey<Boolean> STACKTRACE_ON_ABORT = new OptionKey((Object)false);
    @Option(name="llvm.printToolchainPath", category=OptionCategory.INTERNAL, help="Enables the intrinisc for printing the toolchain path.")
    public static final OptionKey<Boolean> PRINT_TOOLCHAIN_PATH = new OptionKey((Object)false);
    @Option(name="llvm.traceIR", category=OptionCategory.EXPERT, help="Prints a trace of the executed bitcode. Requires '--llvm.llDebug=true'. Set value to 'stdout', 'stderr' or 'file://<path to writable file>' to enable.")
    public static final OptionKey<String> TRACE_IR = new OptionKey((Object)"");
    public static final String LIBRARIES_NAME = "llvm.libraries";
    @Option(name="llvm.libraries", category=OptionCategory.USER, stability=OptionStability.STABLE, help="List of libraries (precompiled libraries *.dylib/*.so as well as bitcode libraries *.bc). Files with a relative path will be looked up relative to llvm.libraryPath. Libraries are delimited by : .")
    public static final OptionKey<String> LIBRARIES = new OptionKey((Object)"");

    public static List<OptionDescriptor> describeOptions() {
        ArrayList<OptionDescriptor> options = new ArrayList<OptionDescriptor>();
        Iterator iterator = SulongEngineOption.createDescriptors().iterator();
        while (iterator.hasNext()) {
            options.add((OptionDescriptor)iterator.next());
        }
        return options;
    }

    public static OptionDescriptors createDescriptors() {
        return new SulongEngineOptionOptionDescriptors();
    }

    public static PrintStream getStream(String name) {
        if ("stderr".equals(name)) {
            return System.err;
        }
        return System.out;
    }

    public static boolean isTrue(String option) {
        return "true".equalsIgnoreCase(option) || "stdout".equalsIgnoreCase(option) || "stderr".equalsIgnoreCase(option);
    }

    public static List<String> getPolyglotOptionSearchPaths(TruffleLanguage.Env env) {
        String libraryPathOption = (String)env.getOptions().get(LIBRARY_PATH);
        String[] libraryPath = "".equals(libraryPathOption) ? new String[]{} : libraryPathOption.split(OPTION_ARRAY_SEPARATOR);
        return Arrays.asList(libraryPath);
    }

    public static List<String> getPolyglotOptionExternalLibraries(TruffleLanguage.Env env) {
        CompilerAsserts.neverPartOfCompilation();
        String librariesOption = (String)env.getOptions().get(LIBRARIES);
        String[] userLibraries = "".equals(librariesOption) ? new String[]{} : librariesOption.split(OPTION_ARRAY_SEPARATOR);
        return Arrays.asList(userLibraries);
    }
}

