/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class StructureType
extends AggregateType {
    private final String name;
    private final boolean isPacked;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Type[] types;
    private int size = -1;

    public StructureType(String name, boolean isPacked, Type[] types) {
        this.name = name;
        this.isPacked = isPacked;
        this.types = types;
    }

    public StructureType(boolean isPacked, Type[] types) {
        this("<anon>", isPacked, types);
    }

    public Type[] getElementTypes() {
        return this.types;
    }

    public boolean isPacked() {
        return this.isPacked;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getBitSize() {
        if (this.isPacked) {
            return Arrays.stream(this.types).mapToInt(Type::getBitSize).sum();
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException("TargetDataLayout is necessary to compute Padding information!");
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int getNumberOfElements() {
        return this.types.length;
    }

    @Override
    public Type getElementType(long index) {
        assert (index == (long)((int)index));
        return this.types[(int)index];
    }

    @Override
    public int getAlignment(DataLayout targetDataLayout) {
        return this.isPacked ? 1 : this.getLargestAlignment(targetDataLayout);
    }

    @Override
    public int getSize(DataLayout targetDataLayout) {
        if (this.size != -1) {
            return this.size;
        }
        int sumByte = 0;
        for (Type elementType : this.types) {
            if (!this.isPacked) {
                sumByte += Type.getPadding(sumByte, elementType, targetDataLayout);
            }
            sumByte += elementType.getSize(targetDataLayout);
        }
        int padding = 0;
        if (!this.isPacked && sumByte != 0) {
            padding = Type.getPadding(sumByte, this.getAlignment(targetDataLayout));
        }
        this.size = sumByte + padding;
        return this.size;
    }

    @Override
    public long getOffsetOf(long index, DataLayout targetDataLayout) {
        int offset = 0;
        int i = 0;
        while ((long)i < index) {
            Type elementType = this.types[i];
            if (!this.isPacked) {
                offset += Type.getPadding(offset, elementType, targetDataLayout);
            }
            offset += elementType.getSize(targetDataLayout);
            ++i;
        }
        if (!this.isPacked && this.getSize(targetDataLayout) > offset) {
            assert (index == (long)((int)index));
            offset += Type.getPadding(offset, this.types[(int)index], targetDataLayout);
        }
        return offset;
    }

    private int getLargestAlignment(DataLayout targetDataLayout) {
        int largestAlignment = 0;
        for (Type elementType : this.types) {
            largestAlignment = Math.max(largestAlignment, elementType.getAlignment(targetDataLayout));
        }
        return largestAlignment;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if ("<anon>".equals(this.name)) {
            return Arrays.stream(this.types).map(String::valueOf).collect(Collectors.joining(", ", "%{", "}"));
        }
        return this.name;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isPacked ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.hashCode(this.types);
        return result;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureType other = (StructureType)obj;
        if (this.isPacked != other.isPacked) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return Arrays.equals(this.types, other.types);
    }
}

