/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import org.openide.awt.AquaVectorCloseButton;
import org.openide.awt.Windows8VectorCloseButton;
import org.openide.util.ImageUtilities;

public final class CloseButtonFactory {
    private static Icon closeTabImage;
    private static Icon closeTabPressedImage;
    private static Icon closeTabMouseOverImage;
    private static Icon bigCloseTabImage;
    private static Icon bigCloseTabPressedImage;
    private static Icon bigCloseTabMouseOverImage;

    private CloseButtonFactory() {
    }

    public static JButton createCloseButton() {
        JButton jButton = new JButton();
        int n = 16;
        jButton.setPreferredSize(new Dimension(n, n));
        jButton.setContentAreaFilled(false);
        jButton.setFocusable(false);
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setBorderPainted(false);
        jButton.setRolloverEnabled(true);
        jButton.setIcon(CloseButtonFactory.getCloseTabImage());
        jButton.setRolloverIcon(CloseButtonFactory.getCloseTabRolloverImage());
        jButton.setPressedIcon(CloseButtonFactory.getCloseTabPressedImage());
        return jButton;
    }

    public static JButton createBigCloseButton() {
        JButton jButton = new JButton();
        int n = 19;
        jButton.setPreferredSize(new Dimension(n, n));
        jButton.setContentAreaFilled(false);
        jButton.setFocusable(false);
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setBorderPainted(false);
        jButton.setRolloverEnabled(true);
        jButton.setIcon(CloseButtonFactory.getBigCloseTabImage());
        jButton.setRolloverIcon(CloseButtonFactory.getBigCloseTabRolloverImage());
        jButton.setPressedIcon(CloseButtonFactory.getBigCloseTabPressedImage());
        return jButton;
    }

    private static boolean isWindowsVistaLaF() {
        return CloseButtonFactory.isWindowsLaF() && (CloseButtonFactory.isWindowsVista() || CloseButtonFactory.isWindows7()) && CloseButtonFactory.isWindowsXPLaF();
    }

    private static boolean isWindows8LaF() {
        return CloseButtonFactory.isWindowsLaF() && CloseButtonFactory.isWindows8() && CloseButtonFactory.isWindowsXPLaF();
    }

    private static boolean isWindows10LaF() {
        return CloseButtonFactory.isWindowsLaF() && CloseButtonFactory.isWindows10() && CloseButtonFactory.isWindowsXPLaF();
    }

    private static boolean isWindowsVista() {
        String string = System.getProperty("os.name");
        return string.indexOf("Vista") >= 0 || string.equals("Windows NT (unknown)") && "6.0".equals(System.getProperty("os.version"));
    }

    private static boolean isWindows10() {
        String string = System.getProperty("os.name");
        return string.indexOf("Windows 10") >= 0 || string.equals("Windows NT (unknown)") && "10.0".equals(System.getProperty("os.version"));
    }

    private static boolean isWindows8() {
        String string = System.getProperty("os.name");
        return string.indexOf("Windows 8") >= 0 || string.equals("Windows NT (unknown)") && "6.2".equals(System.getProperty("os.version"));
    }

    private static boolean isWindows7() {
        String string = System.getProperty("os.name");
        return string.indexOf("Windows 7") >= 0 || string.equals("Windows NT (unknown)") && "6.1".equals(System.getProperty("os.version"));
    }

    private static boolean isWindowsXPLaF() {
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return CloseButtonFactory.isWindowsLaF() && bl != null && bl != false;
    }

    private static boolean isWindowsLaF() {
        String string = UIManager.getLookAndFeel().getID();
        return string.endsWith("Windows");
    }

    private static boolean isAquaLaF() {
        return "Aqua".equals(UIManager.getLookAndFeel().getID());
    }

    private static boolean isGTKLaF() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    private static Icon getCloseTabImage() {
        String string;
        if (null == closeTabImage && null != (string = UIManager.getString("nb.close.tab.icon.enabled.name"))) {
            closeTabImage = ImageUtilities.loadImageIcon((String)string, (boolean)true);
        }
        if (null == closeTabImage) {
            closeTabImage = CloseButtonFactory.isWindows8LaF() || CloseButtonFactory.isWindows10LaF() ? Windows8VectorCloseButton.DEFAULT : (CloseButtonFactory.isWindowsVistaLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/vista_close_enabled.png", (boolean)true) : (CloseButtonFactory.isWindowsXPLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/xp_close_enabled.png", (boolean)true) : (CloseButtonFactory.isWindowsLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/win_close_enabled.png", (boolean)true) : (CloseButtonFactory.isAquaLaF() ? AquaVectorCloseButton.DEFAULT : (CloseButtonFactory.isGTKLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/gtk_close_enabled.png", (boolean)true) : ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/metal_close_enabled.png", (boolean)true))))));
        }
        return closeTabImage;
    }

    private static Icon getCloseTabPressedImage() {
        String string;
        if (null == closeTabPressedImage && null != (string = UIManager.getString("nb.close.tab.icon.pressed.name"))) {
            closeTabPressedImage = ImageUtilities.loadImageIcon((String)string, (boolean)true);
        }
        if (null == closeTabPressedImage) {
            closeTabPressedImage = CloseButtonFactory.isWindows8LaF() || CloseButtonFactory.isWindows10LaF() ? Windows8VectorCloseButton.PRESSED : (CloseButtonFactory.isWindowsVistaLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/vista_close_pressed.png", (boolean)true) : (CloseButtonFactory.isWindowsXPLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/xp_close_pressed.png", (boolean)true) : (CloseButtonFactory.isWindowsLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/win_close_pressed.png", (boolean)true) : (CloseButtonFactory.isAquaLaF() ? AquaVectorCloseButton.PRESSED : (CloseButtonFactory.isGTKLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/gtk_close_pressed.png", (boolean)true) : ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/metal_close_pressed.png", (boolean)true))))));
        }
        return closeTabPressedImage;
    }

    private static Icon getCloseTabRolloverImage() {
        String string;
        if (null == closeTabMouseOverImage && null != (string = UIManager.getString("nb.close.tab.icon.rollover.name"))) {
            closeTabMouseOverImage = ImageUtilities.loadImageIcon((String)string, (boolean)true);
        }
        if (null == closeTabMouseOverImage) {
            closeTabMouseOverImage = CloseButtonFactory.isWindows8LaF() || CloseButtonFactory.isWindows10LaF() ? Windows8VectorCloseButton.PRESSED : (CloseButtonFactory.isWindowsVistaLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/vista_close_rollover.png", (boolean)true) : (CloseButtonFactory.isWindowsXPLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/xp_close_rollover.png", (boolean)true) : (CloseButtonFactory.isWindowsLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/win_close_rollover.png", (boolean)true) : (CloseButtonFactory.isAquaLaF() ? AquaVectorCloseButton.ROLLOVER : (CloseButtonFactory.isGTKLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/gtk_close_rollover.png", (boolean)true) : ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/metal_close_rollover.png", (boolean)true))))));
        }
        return closeTabMouseOverImage;
    }

    private static Icon getBigCloseTabImage() {
        String string;
        if (null == bigCloseTabImage && null != (string = UIManager.getString("nb.bigclose.tab.icon.enabled.name"))) {
            bigCloseTabImage = ImageUtilities.loadImageIcon((String)string, (boolean)true);
        }
        if (null == bigCloseTabImage) {
            bigCloseTabImage = CloseButtonFactory.isWindows8LaF() || CloseButtonFactory.isWindows10LaF() ? Windows8VectorCloseButton.DEFAULT : (CloseButtonFactory.isWindowsVistaLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/vista_bigclose_enabled.png", (boolean)true) : (CloseButtonFactory.isWindowsXPLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/xp_bigclose_enabled.png", (boolean)true) : (CloseButtonFactory.isWindowsLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/win_bigclose_enabled.png", (boolean)true) : (CloseButtonFactory.isAquaLaF() ? AquaVectorCloseButton.DEFAULT : (CloseButtonFactory.isGTKLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/gtk_bigclose_enabled.png", (boolean)true) : ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/metal_bigclose_enabled.png", (boolean)true))))));
        }
        return bigCloseTabImage;
    }

    private static Icon getBigCloseTabPressedImage() {
        String string;
        if (null == bigCloseTabPressedImage && null != (string = UIManager.getString("nb.bigclose.tab.icon.pressed.name"))) {
            bigCloseTabPressedImage = ImageUtilities.loadImageIcon((String)string, (boolean)true);
        }
        if (null == bigCloseTabPressedImage) {
            bigCloseTabPressedImage = CloseButtonFactory.isWindows8LaF() || CloseButtonFactory.isWindows10LaF() ? Windows8VectorCloseButton.PRESSED : (CloseButtonFactory.isWindowsVistaLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/vista_bigclose_pressed.png", (boolean)true) : (CloseButtonFactory.isWindowsXPLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/xp_bigclose_pressed.png", (boolean)true) : (CloseButtonFactory.isWindowsLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/win_bigclose_pressed.png", (boolean)true) : (CloseButtonFactory.isAquaLaF() ? AquaVectorCloseButton.PRESSED : (CloseButtonFactory.isGTKLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/gtk_bigclose_pressed.png", (boolean)true) : ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/metal_bigclose_pressed.png", (boolean)true))))));
        }
        return bigCloseTabPressedImage;
    }

    private static Icon getBigCloseTabRolloverImage() {
        String string;
        if (null == bigCloseTabMouseOverImage && null != (string = UIManager.getString("nb.bigclose.tab.icon.rollover.name"))) {
            bigCloseTabMouseOverImage = ImageUtilities.loadImageIcon((String)string, (boolean)true);
        }
        if (null == bigCloseTabMouseOverImage) {
            bigCloseTabMouseOverImage = CloseButtonFactory.isWindows8LaF() || CloseButtonFactory.isWindows10LaF() ? Windows8VectorCloseButton.PRESSED : (CloseButtonFactory.isWindowsVistaLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/vista_bigclose_rollover.png", (boolean)true) : (CloseButtonFactory.isWindowsXPLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/xp_bigclose_rollover.png", (boolean)true) : (CloseButtonFactory.isWindowsLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/win_bigclose_rollover.png", (boolean)true) : (CloseButtonFactory.isAquaLaF() ? AquaVectorCloseButton.ROLLOVER : (CloseButtonFactory.isGTKLaF() ? ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/gtk_bigclose_rollover.png", (boolean)true) : ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/metal_bigclose_rollover.png", (boolean)true))))));
        }
        return bigCloseTabMouseOverImage;
    }
}

