/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.remote;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.persist.AbstractCatalogStorage;
import org.graalvm.component.installer.persist.ComponentPackageLoader;

public class RemotePropertiesStorage
extends AbstractCatalogStorage {
    protected static final String PROPERTY_HASH = "hash";
    private static final String FORMAT_FLAVOUR = "Component.{0}";
    private static final String FORMAT_SINGLE_VERSION = "Component.{0}_{1}.";
    private final Properties catalogProperties;
    private final String flavourPrefix;
    private final String singleVersionPrefix;
    private final Version graalVersion;
    private Map<String, Properties> filteredComponents;

    public RemotePropertiesStorage(Feedback fb, ComponentRegistry localReg, Properties catalogProperties, String graalSelector, Version gVersion, URL baseURL) {
        super(localReg, fb, baseURL);
        this.catalogProperties = catalogProperties;
        this.flavourPrefix = MessageFormat.format(FORMAT_FLAVOUR, graalSelector);
        this.graalVersion = gVersion != null ? gVersion : localReg.getGraalVersion();
        this.singleVersionPrefix = MessageFormat.format(FORMAT_SINGLE_VERSION, this.graalVersion.originalString(), graalSelector);
    }

    Properties filterPropertiesForVersions(String id) {
        this.splitPropertiesToComponents();
        return this.filteredComponents.get(id);
    }

    private void splitPropertiesToComponents() {
        if (this.filteredComponents != null) {
            return;
        }
        this.filteredComponents = new HashMap<String, Properties>();
        HashSet<String> knownPrefixes = new HashSet<String>();
        HashSet<String> acceptedPrefixes = new HashSet<String>();
        for (String s : this.catalogProperties.stringPropertyNames()) {
            int dashPos;
            String pn;
            int l;
            int slashPos = s.indexOf(47);
            int secondSlashPos = s.indexOf(47, slashPos + 1);
            if (slashPos != -1 && secondSlashPos != -1) {
                if (!s.startsWith(this.flavourPrefix)) continue;
                l = secondSlashPos + 1;
                pn = s.substring(slashPos + 1);
                String pref = s.substring(0, secondSlashPos);
                if (knownPrefixes.add(pref)) {
                    try {
                        Version vn = Version.fromString(s.substring(slashPos + 1, secondSlashPos));
                        if (this.acceptsVersion(vn)) {
                            acceptedPrefixes.add(pref);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        this.feedback.verboseOutput("REMOTE_BadComponentVersion", pn);
                    }
                }
                if (!acceptedPrefixes.contains(pref)) {
                    continue;
                }
            } else {
                if (!s.startsWith(this.singleVersionPrefix)) continue;
                l = this.singleVersionPrefix.length();
                pn = this.graalVersion.toString() + "/" + s.substring(l);
            }
            if ((dashPos = s.indexOf("-", l)) == -1) {
                dashPos = s.length();
            }
            String cid = s.substring(l, dashPos);
            String patchedCid = cid.replace("_", "-");
            String patchedPn = pn.replace(cid, patchedCid);
            this.filteredComponents.computeIfAbsent(patchedCid, unused -> new Properties()).setProperty(patchedPn, this.catalogProperties.getProperty(s));
        }
    }

    boolean acceptsVersion(Version vers) {
        return this.graalVersion.installVersion().compareTo(vers.installVersion()) <= 0;
    }

    @Override
    public Set<String> listComponentIDs() throws IOException {
        HashSet<String> ret = new HashSet<String>();
        this.splitPropertiesToComponents();
        ret.addAll(this.filteredComponents.keySet());
        return ret;
    }

    @Override
    public Set<ComponentInfo> loadComponentMetadata(String id) throws IOException {
        Properties compProps = this.filterPropertiesForVersions(id);
        if (compProps == null) {
            return null;
        }
        HashMap<String, ComponentInfo> infos = new HashMap<String, ComponentInfo>();
        HashSet<String> processedPrefixes = new HashSet<String>();
        for (String s : compProps.stringPropertyNames()) {
            Version v;
            int slashPos;
            String vS = s.substring(0, slashPos = s.indexOf(47));
            if (!processedPrefixes.add(vS)) continue;
            try {
                v = Version.fromString(vS);
            }
            catch (IllegalArgumentException ex) {
                this.feedback.verboseOutput("REMOTE_BadComponentVersion", s);
                continue;
            }
            ComponentInfo ci = this.createVersionedComponent(compProps, id, v);
            if (ci == null) continue;
            infos.put(vS, ci);
        }
        return new HashSet<ComponentInfo>(infos.values());
    }

    private ComponentInfo createVersionedComponent(Properties filtered, String id, Version v) throws IOException {
        String versoPrefix = v.originalString() + "/";
        String s = filtered.getProperty(versoPrefix + id.toLowerCase());
        if (s == null) {
            return null;
        }
        URL downloadURL = new URL(this.baseURL, s);
        String prefix = versoPrefix + id.toLowerCase() + "-";
        String hashS = filtered.getProperty(versoPrefix + PROPERTY_HASH);
        byte[] hash = hashS == null ? null : this.toHashBytes(id, hashS);
        ComponentPackageLoader ldr = new ComponentPackageLoader(new PrefixedPropertyReader(prefix, filtered), this.feedback);
        ComponentInfo info = ldr.createComponentInfo();
        info.setRemoteURL(downloadURL);
        info.setShaDigest(hash);
        info.setOrigin(this.baseURL.toString());
        return info;
    }

    static class PrefixedPropertyReader
    implements Function<String, String> {
        private final String compPrefix;
        private final Properties props;

        PrefixedPropertyReader(String compPrefix, Properties props) {
            this.compPrefix = compPrefix;
            this.props = props;
        }

        @Override
        public String apply(String t) {
            return this.props.getProperty(this.compPrefix + t);
        }
    }
}

