/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.DataViewPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.GetViewValueNode;
import com.oracle.truffle.js.nodes.access.SetViewValueNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSDataView;

public final class DataViewPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<DataViewPrototype> {
    protected DataViewPrototypeBuiltins() {
        super("DataView.prototype", DataViewPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, DataViewPrototype builtinEnum) {
        switch (builtinEnum) {
            case getBigInt64: 
            case getBigUint64: 
            case getFloat32: 
            case getFloat64: 
            case getInt16: 
            case getInt32: 
            case getInt8: 
            case getUint16: 
            case getUint32: 
            case getUint8: {
                return DataViewPrototypeBuiltinsFactory.DataViewGetNodeGen.create(context, builtin, DataViewPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case setBigInt64: 
            case setBigUint64: 
            case setFloat32: 
            case setFloat64: 
            case setInt16: 
            case setInt32: 
            case setInt8: 
            case setUint16: 
            case setUint32: 
            case setUint8: {
                return DataViewPrototypeBuiltinsFactory.DataViewSetNodeGen.create(context, builtin, DataViewPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
        }
        return null;
    }

    @ImportStatic(value={JSDataView.class})
    public static abstract class DataViewSetNode
    extends JSBuiltinNode {
        @Node.Child
        private SetViewValueNode setViewValueNode;

        public DataViewSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.setViewValueNode = SetViewValueNode.create(context, builtin.getName().substring(3), null, null, null, null);
        }

        @Specialization(guards={"isJSDataView(dataView)"})
        protected Object doDataView(DynamicObject dataView, Object byteOffset, Object value, Object littleEndian) {
            return this.setViewValueNode.execute(dataView, byteOffset, littleEndian, value);
        }

        @Specialization(guards={"!isJSDataView(thisObj)"})
        protected DynamicObject doIncompatibleReceiver(Object thisObj, Object byteOffset, Object value, Object littleEndian) {
            throw Errors.createTypeErrorNotADataView();
        }
    }

    @ImportStatic(value={JSDataView.class})
    public static abstract class DataViewGetNode
    extends JSBuiltinNode {
        @Node.Child
        private GetViewValueNode getViewValueNode;

        public DataViewGetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getViewValueNode = GetViewValueNode.create(context, builtin.getName().substring(3), null, null, null);
        }

        @Specialization(guards={"isJSDataView(dataView)"})
        protected Object doDataView(DynamicObject dataView, Object byteOffset, Object littleEndian) {
            return this.getViewValueNode.execute(dataView, byteOffset, littleEndian);
        }

        @Specialization(guards={"!isJSDataView(thisObj)"})
        protected DynamicObject doIncompatibleReceiver(Object thisObj, Object byteOffset, Object littleEndian) {
            throw Errors.createTypeErrorNotADataView();
        }
    }

    public static enum DataViewPrototype implements BuiltinEnum<DataViewPrototype>
    {
        getBigInt64(1),
        getBigUint64(1),
        getFloat32(1),
        getFloat64(1),
        getInt8(1),
        getInt16(1),
        getInt32(1),
        getUint8(1),
        getUint16(1),
        getUint32(1),
        setBigInt64(2),
        setBigUint64(2),
        setFloat32(2),
        setFloat64(2),
        setInt8(2),
        setInt16(2),
        setInt32(2),
        setUint8(2),
        setUint16(2),
        setUint32(2);

        private final int length;

        private DataViewPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

