/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.ReflectBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.IsExtensibleNode;
import com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import com.oracle.truffle.js.nodes.access.ToPropertyDescriptorNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectArrayNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectArrayNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespace;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.truffleinterop.JSInteropUtil;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import com.oracle.truffle.js.runtime.util.JSReflectUtils;
import java.util.List;

public class ReflectBuiltins
extends JSBuiltinsContainer.SwitchEnum<Reflect> {
    protected ReflectBuiltins() {
        super("Reflect", Reflect.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, Reflect builtinEnum) {
        assert (context.getEcmaScriptVersion() >= 6);
        switch (builtinEnum) {
            case apply: {
                return ReflectBuiltinsFactory.ReflectApplyNodeGen.create(context, builtin, ReflectBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case construct: {
                return ReflectBuiltinsFactory.ReflectConstructNodeGen.create(context, builtin, ReflectBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case defineProperty: {
                return ReflectBuiltinsFactory.ReflectDefinePropertyNodeGen.create(context, builtin, ReflectBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case deleteProperty: {
                return ReflectBuiltinsFactory.ReflectDeletePropertyNodeGen.create(context, builtin, ReflectBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case get: {
                return ReflectBuiltinsFactory.ReflectGetNodeGen.create(context, builtin, ReflectBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case getOwnPropertyDescriptor: {
                return ReflectBuiltinsFactory.ReflectGetOwnPropertyDescriptorNodeGen.create(context, builtin, ReflectBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case getPrototypeOf: {
                return ReflectBuiltinsFactory.ReflectGetPrototypeOfNodeGen.create(context, builtin, ReflectBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case has: {
                return ReflectBuiltinsFactory.ReflectHasNodeGen.create(context, builtin, ReflectBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case isExtensible: {
                return ReflectBuiltinsFactory.ReflectIsExtensibleNodeGen.create(context, builtin, ReflectBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case ownKeys: {
                return ReflectBuiltinsFactory.ReflectOwnKeysNodeGen.create(context, builtin, ReflectBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case preventExtensions: {
                return ReflectBuiltinsFactory.ReflectPreventExtensionsNodeGen.create(context, builtin, ReflectBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case set: {
                return ReflectBuiltinsFactory.ReflectSetNodeGen.create(context, builtin, ReflectBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case setPrototypeOf: {
                return ReflectBuiltinsFactory.ReflectSetPrototypeOfNodeGen.create(context, builtin, ReflectBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class ReflectSetPrototypeOfNode
    extends ReflectOperation {
        public ReflectSetPrototypeOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean reflectSetPrototypeOf(Object target, Object proto) {
            this.ensureObject(target);
            if (!JSObject.isJSObject(proto) && proto != Null.instance || proto == Undefined.instance) {
                throw Errors.createTypeErrorInvalidPrototype(proto);
            }
            return JSObject.setPrototype((DynamicObject)target, (DynamicObject)proto);
        }
    }

    public static abstract class ReflectSetNode
    extends ReflectOperation {
        public ReflectSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected static boolean isProxy(Object[] args) {
            return args.length > 0 && JSProxy.isProxy(args[0]);
        }

        protected static boolean isModuleNamespace(Object[] args) {
            return args.length > 0 && JSModuleNamespace.isJSModuleNamespace(args[0]);
        }

        @Specialization(guards={"isProxy(args)"})
        protected boolean reflectSetProxy(Object[] args, @Cached(value="create()") JSToPropertyKeyNode toPropertyKeyNode, @Cached(value="create()") JSToBooleanNode toBooleanNode) {
            Object proxy = args[0];
            Object propertyKey = JSRuntime.getArgOrUndefined(args, 1);
            Object value = JSRuntime.getArgOrUndefined(args, 2);
            Object receiver = JSRuntime.getArg(args, 3, proxy);
            Object key = toPropertyKeyNode.execute(propertyKey);
            DynamicObject proxyObj = (DynamicObject)proxy;
            DynamicObject handler = JSProxy.getHandler(proxyObj);
            TruffleObject pxTarget = JSProxy.getTarget(proxyObj);
            TruffleObject trap = JSProxy.getTrapFromObject(handler, "set");
            while (trap == Undefined.instance) {
                if (JSProxy.isProxy(pxTarget)) {
                    proxyObj = (DynamicObject)pxTarget;
                    handler = JSProxy.getHandler(proxyObj);
                    pxTarget = JSProxy.getTarget(proxyObj);
                    trap = JSProxy.getTrapFromObject(handler, "set");
                    continue;
                }
                if (JSModuleNamespace.isJSModuleNamespace(pxTarget)) {
                    return false;
                }
                if (JSObject.isJSObject(pxTarget)) {
                    return JSReflectUtils.performOrdinarySet((DynamicObject)pxTarget, key, value, receiver);
                }
                JSInteropUtil.writeMember(pxTarget, key, value);
                return true;
            }
            Object[] trapArgs = new Object[]{pxTarget, key, value, receiver};
            boolean booleanTrapResult = toBooleanNode.executeBoolean(JSRuntime.call(trap, handler, trapArgs));
            if (!booleanTrapResult) {
                return false;
            }
            return JSProxy.checkProxySetTrapInvariants(proxyObj, key, value);
        }

        @Specialization(guards={"isModuleNamespace(args)"})
        protected boolean reflectSetModuleNamespace(Object[] args, @Cached(value="create()") JSToPropertyKeyNode toPropertyKeyNode) {
            Object propertyKey = JSRuntime.getArgOrUndefined(args, 1);
            toPropertyKeyNode.execute(propertyKey);
            return false;
        }

        @Specialization(guards={"!isProxy(args)", "!isModuleNamespace(args)"})
        protected boolean reflectSet(Object[] args, @Cached(value="create()") JSToPropertyKeyNode toPropertyKeyNode) {
            Object target = JSRuntime.getArgOrUndefined(args, 0);
            Object propertyKey = JSRuntime.getArgOrUndefined(args, 1);
            Object value = JSRuntime.getArgOrUndefined(args, 2);
            this.ensureObject(target);
            Object key = toPropertyKeyNode.execute(propertyKey);
            Object receiver = JSRuntime.getArg(args, 3, target);
            return JSReflectUtils.performOrdinarySet((DynamicObject)target, key, value, receiver);
        }
    }

    public static abstract class ReflectPreventExtensionsNode
    extends ReflectOperation {
        public ReflectPreventExtensionsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean reflectPreventExtensions(Object target) {
            this.ensureObject(target);
            return JSObject.preventExtensions((DynamicObject)target);
        }
    }

    public static abstract class ReflectOwnKeysNode
    extends ReflectOperation {
        public ReflectOwnKeysNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected DynamicObject reflectOwnKeys(Object target) {
            this.ensureObject(target);
            List<Object> list = JSObject.ownPropertyKeys((DynamicObject)target);
            return JSArray.createLazyArray(this.getContext(), list);
        }
    }

    public static abstract class ReflectIsExtensibleNode
    extends ReflectOperation {
        public ReflectIsExtensibleNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean reflectIsExtensible(Object target, @Cached IsExtensibleNode isExtensibleNode) {
            this.ensureObject(target);
            return isExtensibleNode.executeBoolean((DynamicObject)target);
        }
    }

    public static abstract class ReflectHasNode
    extends ReflectOperation {
        public ReflectHasNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean reflectHas(Object target, Object propertyKey, @Cached(value="create()") JSToPropertyKeyNode toPropertyKeyNode) {
            this.ensureObject(target);
            Object key = toPropertyKeyNode.execute(propertyKey);
            return JSObject.hasProperty((DynamicObject)target, key);
        }
    }

    public static abstract class ReflectGetPrototypeOfNode
    extends ReflectOperation {
        public ReflectGetPrototypeOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object reflectGetPrototypeOf(Object target) {
            this.ensureObject(target);
            return JSObject.getPrototype((DynamicObject)target);
        }
    }

    public static abstract class ReflectGetOwnPropertyDescriptorNode
    extends ReflectOperation {
        public ReflectGetOwnPropertyDescriptorNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected DynamicObject reflectGetOwnPropertyDescriptor(Object target, Object key, @Cached(value="create()") JSToPropertyKeyNode toPropertyKeyNode, @Cached(value="create()") JSGetOwnPropertyNode getOwnPropertyNode) {
            this.ensureObject(target);
            Object propertyKey = toPropertyKeyNode.execute(key);
            PropertyDescriptor desc = getOwnPropertyNode.execute((DynamicObject)target, propertyKey);
            return JSRuntime.fromPropertyDescriptor(desc, this.getContext());
        }
    }

    public static abstract class ReflectGetNode
    extends ReflectOperation {
        public ReflectGetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"!targetIsObject(args)"})
        protected Object doNonObject(Object[] args) {
            throw Errors.createTypeErrorCalledOnNonObject();
        }

        @Specialization(guards={"targetIsObject(args)"})
        protected Object doObject(Object[] args, @Cached(value="create()") JSToPropertyKeyNode toPropertyKeyNode, @Cached(value="create()") JSClassProfile classProfile) {
            Object target = args[0];
            Object propertyKey = JSRuntime.getArgOrUndefined(args, 1);
            Object receiver = JSRuntime.getArg(args, 2, target);
            Object key = toPropertyKeyNode.execute(propertyKey);
            DynamicObject store = (DynamicObject)target;
            return JSRuntime.nullToUndefined(classProfile.getJSClass(store).getHelper(store, receiver, key));
        }

        protected static boolean targetIsObject(Object[] args) {
            return args.length != 0 && JSRuntime.isObject(args[0]);
        }
    }

    public static abstract class ReflectDeletePropertyNode
    extends ReflectOperation {
        public ReflectDeletePropertyNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean reflectDeleteProperty(Object target, Object propertyKey, @Cached(value="create()") JSToPropertyKeyNode toPropertyKeyNode) {
            this.ensureObject(target);
            Object key = toPropertyKeyNode.execute(propertyKey);
            return JSObject.delete((DynamicObject)target, key);
        }
    }

    public static abstract class ReflectDefinePropertyNode
    extends ReflectOperation {
        public ReflectDefinePropertyNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean reflectDefineProperty(Object target, Object propertyKey, Object attributes, @Cached(value="create()") JSToPropertyKeyNode toPropertyKeyNode, @Cached(value="create(getContext())") ToPropertyDescriptorNode toPropertyDescriptorNode) {
            this.ensureObject(target);
            Object key = toPropertyKeyNode.execute(propertyKey);
            PropertyDescriptor descriptor = (PropertyDescriptor)toPropertyDescriptorNode.execute(attributes);
            return JSObject.defineOwnProperty((DynamicObject)target, key, descriptor);
        }
    }

    public static abstract class ReflectConstructNode
    extends ReflectOperation {
        @Node.Child
        private JSFunctionCallNode constructCall = JSFunctionCallNode.createNewTarget();
        @Node.Child
        private JSToObjectArrayNode toObjectArray;

        public ReflectConstructNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.toObjectArray = JSToObjectArrayNodeGen.create(context);
        }

        @Specialization
        protected Object reflectConstruct(Object[] args) {
            Object target = JSRuntime.getArgOrUndefined(args, 0);
            Object argumentsList = JSRuntime.getArgOrUndefined(args, 1);
            this.ensureConstructor(target);
            Object newTarget = JSRuntime.getArg(args, 2, target);
            this.ensureConstructor(newTarget);
            if (!JSRuntime.isObject(argumentsList)) {
                throw Errors.createTypeError("Reflect.construct: Arguments list has wrong type");
            }
            Object[] applyUserArgs = this.toObjectArray.executeObjectArray(argumentsList);
            Object[] passedOnArguments = JSArguments.createWithNewTarget(JSFunction.CONSTRUCT, target, newTarget, applyUserArgs);
            return this.constructCall.executeCall(passedOnArguments);
        }

        private void ensureConstructor(Object obj) {
            this.ensureObject(obj);
            DynamicObject constrObj = (DynamicObject)obj;
            if (!JSRuntime.isConstructor(constrObj)) {
                throw Errors.createTypeErrorNotAConstructor(constrObj);
            }
        }
    }

    public static abstract class ReflectApplyNode
    extends JSBuiltinNode {
        @Node.Child
        private JSFunctionCallNode call = JSFunctionCallNode.createCall();
        @Node.Child
        private JSToObjectArrayNode toObjectArray = JSToObjectArrayNodeGen.create(this.getContext());

        public ReflectApplyNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSFunction(target)"})
        protected final Object applyFunction(DynamicObject target, Object thisArgument, Object argumentsList) {
            return this.apply(target, thisArgument, argumentsList);
        }

        @Specialization(guards={"isCallable.executeBoolean(target)"}, replaces={"applyFunction"}, limit="1")
        protected final Object applyCallable(Object target, Object thisArgument, Object argumentsList, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable) {
            return this.apply(target, thisArgument, argumentsList);
        }

        private Object apply(Object target, Object thisArgument, Object argumentsList) {
            Object[] applyUserArgs = this.toObjectArray.executeObjectArray(argumentsList);
            assert (applyUserArgs.length <= JSTruffleOptions.MaxApplyArgumentLength);
            Object[] passedOnArguments = JSArguments.create(thisArgument, target, applyUserArgs);
            return this.call.executeCall(passedOnArguments);
        }

        @Specialization(guards={"!isCallable.executeBoolean(target)"}, limit="1")
        protected static Object error(Object target, Object thisArgument, Object argumentsList, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable) {
            throw Errors.createTypeErrorCallableExpected();
        }
    }

    public static abstract class ReflectOperation
    extends JSBuiltinNode {
        private final BranchProfile errorBranch = BranchProfile.create();

        public ReflectOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected void ensureObject(Object target) {
            if (!JSRuntime.isObject(target)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorCalledOnNonObject();
            }
        }
    }

    public static enum Reflect implements BuiltinEnum<Reflect>
    {
        apply(3),
        construct(2),
        defineProperty(3),
        deleteProperty(2),
        get(2),
        getOwnPropertyDescriptor(2),
        getPrototypeOf(1),
        has(2),
        isExtensible(1),
        ownKeys(1),
        preventExtensions(1),
        set(3),
        setPrototypeOf(2);

        private final int length;

        private Reflect(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

