/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes;

import com.oracle.truffle.api.dsl.ImplicitCast;
import com.oracle.truffle.api.dsl.TypeCast;
import com.oracle.truffle.api.dsl.TypeCheck;
import com.oracle.truffle.api.dsl.TypeSystem;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.JSLazyStringFlattened;
import com.oracle.truffle.js.runtime.objects.JSLazyStringRaw;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.PropertyReference;

@TypeSystem(value={boolean.class, int.class, double.class, long.class, LargeInteger.class, BigInt.class, String.class, DynamicObject.class, TruffleObject.class, char.class, byte.class, float.class, Object[].class})
public class JSTypes {
    protected JSTypes() {
    }

    @ImplicitCast
    public static double intToDouble(int value) {
        return value;
    }

    @ImplicitCast
    public static double largeIntegerToDouble(LargeInteger value) {
        return value.doubleValue();
    }

    @ImplicitCast
    public static double longToDouble(long value) {
        return value;
    }

    @TypeCast(value=double.class)
    public static double asDouble(Object value) {
        return (Double)value;
    }

    @TypeCheck(value=CharSequence.class)
    public static boolean isCharSequence(Object value) {
        return JSRuntime.isString(value);
    }

    @TypeCheck(value=DynamicObject.class)
    public static boolean isDynamicObject(Object value) {
        return JSObject.isDynamicObject(value);
    }

    @TypeCheck(value=JSLazyStringFlattened.class)
    public static boolean isLazyStringFlattened(Object object) {
        return object instanceof JSLazyString && ((JSLazyString)object).isFlat();
    }

    @TypeCast(value=JSLazyStringFlattened.class)
    public static JSLazyStringFlattened asLazyStringFlattened(Object object) {
        return (JSLazyString)object;
    }

    @TypeCheck(value=JSLazyStringRaw.class)
    public static boolean isLazyStringRaw(Object object) {
        return object instanceof JSLazyString && !((JSLazyString)object).isFlat();
    }

    @TypeCast(value=JSLazyStringRaw.class)
    public static JSLazyStringRaw asLazyStringRaw(Object object) {
        return (JSLazyString)object;
    }

    @ImplicitCast
    public static String convertLazyStringFlattened(JSLazyStringFlattened value) {
        return value.getFlattenedString();
    }

    @ImplicitCast
    public static String convertLazyStringRaw(JSLazyStringRaw value) {
        return value.toString();
    }

    @ImplicitCast
    public static String castString(PropertyReference value) {
        return value.toString();
    }

    @ImplicitCast
    public static CharSequence castCharSequence(String value) {
        return value;
    }

    @ImplicitCast
    public static CharSequence castCharSequence(JSLazyString value) {
        return value;
    }

    @ImplicitCast
    public static CharSequence castCharSequence(PropertyReference value) {
        return value;
    }
}

