/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CopyDataPropertiesNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=CopyDataPropertiesNode.class)
public final class CopyDataPropertiesNodeGen
extends CopyDataPropertiesNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private JSToObjectNode toObject;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile isJSObject;

    private CopyDataPropertiesNodeGen(JSContext context, JavaScriptNode targetNode, JavaScriptNode sourceNode, JavaScriptNode excludedNode) {
        super(context, targetNode, sourceNode, excludedNode);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object targetNodeValue_ = this.targetNode.execute(frameValue);
        Object sourceNodeValue_ = this.sourceNode.execute(frameValue);
        if (state != 0 && JSTypes.isDynamicObject(targetNodeValue_)) {
            DynamicObject targetNodeValue__ = (DynamicObject)targetNodeValue_;
            if ((state & 1) != 0 && JSGuards.isNullOrUndefined(sourceNodeValue_)) {
                return CopyDataPropertiesNode.doNullOrUndefined(targetNodeValue__, sourceNodeValue_);
            }
            if ((state & 6) != 0 && JSTypes.isDynamicObject(sourceNodeValue_)) {
                DynamicObject sourceNodeValue__ = (DynamicObject)sourceNodeValue_;
                if ((state & 2) != 0 && JSGuards.isJSObject(sourceNodeValue__)) {
                    assert (this.excludedNode == null);
                    return CopyDataPropertiesNode.doObject(targetNodeValue__, sourceNodeValue__);
                }
                if ((state & 4) != 0 && JSGuards.isJSObject(sourceNodeValue__)) {
                    assert (this.excludedNode != null);
                    return this.doObjectWithExcluded(frameValue, targetNodeValue__, sourceNodeValue__);
                }
            }
            if ((state & 0x18) != 0) {
                if ((state & 8) != 0 && !JSGuards.isJSType(sourceNodeValue_)) {
                    assert (this.excludedNode == null);
                    return this.doOther(targetNodeValue__, sourceNodeValue_, this.toObject, this.isJSObject);
                }
                if ((state & 0x10) != 0 && !JSGuards.isJSType(sourceNodeValue_)) {
                    assert (this.excludedNode != null);
                    return this.doOtherWithExcluded(frameValue, targetNodeValue__, sourceNodeValue_, this.toObject, this.isJSObject);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, targetNodeValue_, sourceNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object targetNodeValue, Object sourceNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (JSTypes.isDynamicObject(targetNodeValue)) {
                Object object;
                DynamicObject targetNodeValue_ = (DynamicObject)targetNodeValue;
                if (JSGuards.isNullOrUndefined(sourceNodeValue)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = CopyDataPropertiesNode.doNullOrUndefined(targetNodeValue_, sourceNodeValue);
                    return dynamicObject;
                }
                if (JSTypes.isDynamicObject(sourceNodeValue)) {
                    DynamicObject sourceNodeValue_ = (DynamicObject)sourceNodeValue;
                    if (JSGuards.isJSObject(sourceNodeValue_) && this.excludedNode == null) {
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = CopyDataPropertiesNode.doObject(targetNodeValue_, sourceNodeValue_);
                        return dynamicObject;
                    }
                    if (JSGuards.isJSObject(sourceNodeValue_) && this.excludedNode != null) {
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.doObjectWithExcluded(frameValue, targetNodeValue_, sourceNodeValue_);
                        return dynamicObject;
                    }
                }
                if (!JSGuards.isJSType(sourceNodeValue) && this.excludedNode == null) {
                    if (this.toObject == null) {
                        this.toObject = (JSToObjectNode)super.insert((Node)JSToObjectNode.createToObjectNoCheck(this.context));
                    }
                    if (this.isJSObject == null) {
                        this.isJSObject = ConditionProfile.createBinaryProfile();
                    }
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    object = this.doOther(targetNodeValue_, sourceNodeValue, this.toObject, this.isJSObject);
                    return object;
                }
                if (!JSGuards.isJSType(sourceNodeValue) && this.excludedNode != null) {
                    if (this.toObject == null) {
                        this.toObject = (JSToObjectNode)super.insert((Node)JSToObjectNode.createToObjectNoCheck(this.context));
                    }
                    if (this.isJSObject == null) {
                        this.isJSObject = ConditionProfile.createBinaryProfile();
                    }
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    object = this.doOtherWithExcluded(frameValue, targetNodeValue_, sourceNodeValue, this.toObject, this.isJSObject);
                    return object;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.targetNode, this.sourceNode}, new Object[]{targetNodeValue, sourceNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Cloneable>> cached;
        Object[] data = new Object[6];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doNullOrUndefined";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doObject";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doObjectWithExcluded";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doOther";
        if ((state & 8) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Cloneable>>();
            cached.add(Arrays.asList(new Cloneable[]{this.toObject, this.isJSObject}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doOtherWithExcluded";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Cloneable[]{this.toObject, this.isJSObject}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static CopyDataPropertiesNode create(JSContext context, JavaScriptNode targetNode, JavaScriptNode sourceNode, JavaScriptNode excludedNode) {
        return new CopyDataPropertiesNodeGen(context, targetNode, sourceNode, excludedNode);
    }
}

