/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.RepeatableNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNodeGen;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.util.JSClassProfile;

public abstract class GetPrototypeNode
extends JavaScriptBaseNode {
    static final int MAX_SHAPE_COUNT = 2;

    GetPrototypeNode() {
    }

    protected abstract DynamicObject executeDynamicObject(DynamicObject var1);

    public abstract DynamicObject executeJSObject(Object var1);

    public static GetPrototypeNode create() {
        return GetPrototypeNodeGen.create();
    }

    public static JavaScriptNode create(JavaScriptNode object) {
        assert (object instanceof RepeatableNode);
        class GetPrototypeOfNode
        extends JavaScriptNode
        implements RepeatableNode {
            @Node.Child
            private JavaScriptNode objectNode;
            @Node.Child
            private GetPrototypeNode getPrototypeNode;
            final /* synthetic */ JavaScriptNode val$object;

            GetPrototypeOfNode(JavaScriptNode javaScriptNode) {
                this.val$object = javaScriptNode;
                this.objectNode = this.val$object;
                this.getPrototypeNode = GetPrototypeNode.create();
            }

            public DynamicObject execute(VirtualFrame frame) {
                return this.getPrototypeNode.executeJSObject(this.objectNode.execute(frame));
            }

            @Override
            protected JavaScriptNode copyUninitialized() {
                return new GetPrototypeOfNode(this.val$object);
            }
        }
        return new GetPrototypeOfNode(object);
    }

    static Property getPrototypeProperty(Shape shape) {
        if (JSShape.getJSClass(shape) == JSProxy.INSTANCE) {
            return null;
        }
        return JSShape.getPrototypeProperty(shape);
    }

    @Specialization(guards={"obj.getShape() == shape", "prototypeProperty != null"}, limit="MAX_SHAPE_COUNT")
    public DynamicObject doCachedShape(DynamicObject obj, @Cached(value="obj.getShape()") Shape shape, @Cached(value="getPrototypeProperty(shape)") Property prototypeProperty) {
        assert (!JSGuards.isJSProxy(obj));
        return (DynamicObject)prototypeProperty.get(obj, shape);
    }

    @Specialization(guards={"!isJSProxy(obj)"}, replaces={"doCachedShape"})
    public DynamicObject doGeneric(DynamicObject obj) {
        Location location = JSShape.getPrototypeProperty(obj.getShape()).getLocation();
        if (CompilerDirectives.isPartialEvaluationConstant((Object)location)) {
            return (DynamicObject)location.get(obj, false);
        }
        return GetPrototypeNode.getLocationValue(obj, location);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=false)
    private static DynamicObject getLocationValue(DynamicObject obj, Location location) {
        return (DynamicObject)location.get(obj, false);
    }

    @Specialization(guards={"isJSProxy(obj)"})
    public DynamicObject doProxy(DynamicObject obj, @Cached(value="create()") JSClassProfile jsclassProfile) {
        return JSObject.getPrototype(obj, jsclassProfile);
    }

    @Specialization(guards={"!isDynamicObject(obj)"})
    public DynamicObject doNotObject(Object obj) {
        return Null.instance;
    }
}

