/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.IntToLongTypeSystem;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.HasPropertyCacheNode;
import com.oracle.truffle.js.nodes.access.JSHasPropertyNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsObject;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.truffleinterop.JSInteropUtil;
import com.oracle.truffle.js.runtime.util.JSClassProfile;

@TypeSystemReference(value=IntToLongTypeSystem.class)
@ImportStatic(value={JSRuntime.class, JSInteropUtil.class})
@ReportPolymorphism
public abstract class JSHasPropertyNode
extends JavaScriptBaseNode {
    private final boolean hasOwnProperty;
    private final JSClassProfile classProfile = JSClassProfile.create();
    private final ConditionProfile hasElementProfile = ConditionProfile.createBinaryProfile();
    static final int MAX_ARRAY_TYPES = 3;

    protected JSHasPropertyNode(boolean hasOwnProperty) {
        this.hasOwnProperty = hasOwnProperty;
    }

    public static JSHasPropertyNode create() {
        return JSHasPropertyNodeGen.create(false);
    }

    public static JSHasPropertyNode create(boolean hasOwnProperty) {
        return JSHasPropertyNodeGen.create(hasOwnProperty);
    }

    public abstract boolean executeBoolean(Object var1, Object var2);

    public abstract boolean executeBoolean(Object var1, long var2);

    @Specialization(guards={"isJSFastArray(object)", "isArrayIndex(index)", "cachedArrayType.isInstance(getArrayType(object))"}, limit="MAX_ARRAY_TYPES")
    public boolean arrayLongCached(DynamicObject object, long index, @Cached(value="getArrayType(object)") ScriptArray cachedArrayType) {
        return this.checkInteger(object, index, cachedArrayType.cast(JSHasPropertyNode.getArrayType(object)));
    }

    @Specialization(guards={"isJSFastArray(object)", "isArrayIndex(index)"}, replaces={"arrayLongCached"})
    public boolean arrayLong(DynamicObject object, long index) {
        return this.checkInteger(object, index, JSHasPropertyNode.getArrayType(object));
    }

    private boolean checkInteger(DynamicObject object, long index, ScriptArray arrayType) {
        if (this.hasElementProfile.profile(arrayType.hasElement(object, index, JSArray.isJSFastArray(object)))) {
            return true;
        }
        return this.objectLong(object, index);
    }

    @Specialization(guards={"cachedObjectType != null", "cachedObjectType.isInstance(object)", "cachedName.equals(propertyName)"}, limit="1")
    public boolean objectStringCached(DynamicObject object, String propertyName, @Cached(value="getCacheableObjectType(object)") JSClass cachedObjectType, @Cached(value="propertyName") String cachedName, @Cached(value="getCachedPropertyGetter(object,propertyName)") HasPropertyCacheNode hasPropertyNode) {
        return hasPropertyNode.hasProperty(object);
    }

    @Specialization(guards={"isJSArray(object)", "!isArrayIndex(cachedName)", "cachedName.equals(propertyName)"}, limit="1")
    public boolean arrayStringCached(DynamicObject object, String propertyName, @Cached(value="propertyName") String cachedName, @Cached(value="getCachedPropertyGetter(object,propertyName)") HasPropertyCacheNode hasPropertyNode) {
        return hasPropertyNode.hasProperty(object);
    }

    @Specialization(guards={"isJSType(object)"}, replaces={"objectStringCached", "arrayStringCached"})
    public boolean objectOrArrayString(DynamicObject object, String propertyName) {
        return this.hasPropertyGeneric(object, propertyName);
    }

    @Specialization(guards={"isJSType(object)"})
    public boolean objectSymbol(DynamicObject object, Symbol propertyName) {
        return this.hasPropertyGeneric(object, propertyName);
    }

    @Specialization(guards={"isJSType(object)", "!isJSFastArray(object)"})
    public boolean objectLong(DynamicObject object, long propertyIdx) {
        if (this.hasOwnProperty) {
            return JSObject.hasOwnProperty(object, propertyIdx, this.classProfile);
        }
        return JSObject.hasProperty(object, propertyIdx, this.classProfile);
    }

    private boolean hasPropertyGeneric(DynamicObject object, Object propertyKey) {
        assert (JSRuntime.isPropertyKey(propertyKey));
        if (this.hasOwnProperty) {
            return JSObject.hasOwnProperty(object, propertyKey, this.classProfile);
        }
        return JSObject.hasProperty(object, propertyKey, this.classProfile);
    }

    @Specialization(guards={"isForeignObject(object)"})
    public boolean foreignObject(TruffleObject object, Object propertyName, @CachedLibrary(limit="3") InteropLibrary interop, @Cached(value="create()") JSToStringNode toStringNode, @Cached(value="create()") ForeignObjectPrototypeNode foreignObjectPrototypeNode, @Cached(value="create()") JSHasPropertyNode hasInPrototype, @CachedLanguage TruffleLanguage.LanguageReference<JavaScriptLanguage> languageRef) {
        if (propertyName instanceof Symbol) {
            return false;
        }
        if (propertyName instanceof Number) {
            long index = JSRuntime.longValue((Number)propertyName);
            return index >= 0L && index < JSInteropUtil.getArraySize(object, interop, this);
        }
        if (interop.isMemberExisting((Object)object, toStringNode.executeString(propertyName))) {
            return true;
        }
        if (((JavaScriptLanguage)languageRef.get()).getJSContext().getContextOptions().hasForeignObjectPrototype()) {
            DynamicObject prototype = foreignObjectPrototypeNode.executeDynamicObject(object);
            return hasInPrototype.executeBoolean((Object)prototype, propertyName);
        }
        return false;
    }

    @Specialization(guards={"isJSType(object)"})
    public boolean objectObject(DynamicObject object, Object propertyName, @Cached(value="create()") JSToPropertyKeyNode toPropertyKeyNode) {
        Object propertyKey = toPropertyKeyNode.execute(propertyName);
        return this.hasPropertyGeneric(object, propertyKey);
    }

    protected static boolean isCacheableObjectType(DynamicObject obj) {
        return JSObject.isJSObject(obj) && !JSRuntime.isNullOrUndefined(obj) && !JSString.isJSString(obj) && !JSArray.isJSArray(obj) && !JSArgumentsObject.isJSArgumentsObject(obj) && !JSArrayBufferView.isJSArrayBufferView(obj);
    }

    protected static JSClass getCacheableObjectType(DynamicObject obj) {
        if (JSHasPropertyNode.isCacheableObjectType(obj)) {
            return JSObject.getJSClass(obj);
        }
        return null;
    }

    protected static ScriptArray getArrayType(DynamicObject object) {
        return JSAbstractArray.arrayGetArrayType(object);
    }

    protected HasPropertyCacheNode getCachedPropertyGetter(DynamicObject object, Object key) {
        return HasPropertyCacheNode.create(key, JSObject.getJSContext(object), this.hasOwnProperty);
    }
}

