/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.binary.InstanceofNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=InstanceofNode.class)
public final class InstanceofNodeGen
extends InstanceofNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private GenericData generic_cache;

    private InstanceofNodeGen(JSContext context, JavaScriptNode left, JavaScriptNode right) {
        super(context, left, right);
    }

    @Override
    public boolean executeBoolean(Object leftNodeValue, Object rightNodeValue) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && JSTypes.isDynamicObject(rightNodeValue)) {
                DynamicObject rightNodeValue_ = (DynamicObject)rightNodeValue;
                GenericData s1_ = this.generic_cache;
                if (s1_ != null) {
                    return this.doGeneric(leftNodeValue, rightNodeValue_, s1_.isObjectNode_, s1_.getMethodHasInstanceNode_, s1_.toBooleanNode_, s1_.callHasInstanceNode_, s1_.hasInstanceProfile_, s1_.errorBranch_, s1_.proxyBranch_);
                }
            }
            if ((state & 0xE) != 0) {
                if ((state & 2) != 0 && !this.isJavaObject(leftNodeValue) && this.isJavaInteropClass(rightNodeValue)) {
                    return this.instanceofJavaClass(leftNodeValue, rightNodeValue);
                }
                if ((state & 4) != 0 && this.isJavaObject(leftNodeValue) && this.isJavaInteropClass(rightNodeValue)) {
                    return this.instanceofJavaClassUnwrap(leftNodeValue, rightNodeValue);
                }
                if ((state & 8) != 0 && !JSGuards.isDynamicObject(rightNodeValue)) {
                    return this.doRHSNotAnObject(leftNodeValue, rightNodeValue);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if (state != 0) {
            if ((state & 1) != 0 && JSTypes.isDynamicObject(rightNodeValue_)) {
                DynamicObject rightNodeValue__ = (DynamicObject)rightNodeValue_;
                GenericData s1_ = this.generic_cache;
                if (s1_ != null) {
                    return this.doGeneric(leftNodeValue_, rightNodeValue__, s1_.isObjectNode_, s1_.getMethodHasInstanceNode_, s1_.toBooleanNode_, s1_.callHasInstanceNode_, s1_.hasInstanceProfile_, s1_.errorBranch_, s1_.proxyBranch_);
                }
            }
            if ((state & 0xE) != 0) {
                if ((state & 2) != 0 && !this.isJavaObject(leftNodeValue_) && this.isJavaInteropClass(rightNodeValue_)) {
                    return this.instanceofJavaClass(leftNodeValue_, rightNodeValue_);
                }
                if ((state & 4) != 0 && this.isJavaObject(leftNodeValue_) && this.isJavaInteropClass(rightNodeValue_)) {
                    return this.instanceofJavaClassUnwrap(leftNodeValue_, rightNodeValue_);
                }
                if ((state & 8) != 0 && !JSGuards.isDynamicObject(rightNodeValue_)) {
                    return this.doRHSNotAnObject(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state = this.state_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if (state != 0) {
            if ((state & 1) != 0 && JSTypes.isDynamicObject(rightNodeValue_)) {
                DynamicObject rightNodeValue__ = (DynamicObject)rightNodeValue_;
                GenericData s1_ = this.generic_cache;
                if (s1_ != null) {
                    return this.doGeneric(leftNodeValue_, rightNodeValue__, s1_.isObjectNode_, s1_.getMethodHasInstanceNode_, s1_.toBooleanNode_, s1_.callHasInstanceNode_, s1_.hasInstanceProfile_, s1_.errorBranch_, s1_.proxyBranch_);
                }
            }
            if ((state & 0xE) != 0) {
                if ((state & 2) != 0 && !this.isJavaObject(leftNodeValue_) && this.isJavaInteropClass(rightNodeValue_)) {
                    return this.instanceofJavaClass(leftNodeValue_, rightNodeValue_);
                }
                if ((state & 4) != 0 && this.isJavaObject(leftNodeValue_) && this.isJavaInteropClass(rightNodeValue_)) {
                    return this.instanceofJavaClassUnwrap(leftNodeValue_, rightNodeValue_);
                }
                if ((state & 8) != 0 && !JSGuards.isDynamicObject(rightNodeValue_)) {
                    return this.doRHSNotAnObject(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeBoolean(frameValue);
    }

    private boolean executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (JSTypes.isDynamicObject(rightNodeValue)) {
                DynamicObject rightNodeValue_ = (DynamicObject)rightNodeValue;
                GenericData s1_ = (GenericData)super.insert((Node)new GenericData());
                s1_.isObjectNode_ = s1_.insertAccessor(IsJSObjectNode.create());
                s1_.getMethodHasInstanceNode_ = s1_.insertAccessor(this.createGetMethodHasInstance());
                s1_.toBooleanNode_ = s1_.insertAccessor(JSToBooleanNode.create());
                s1_.callHasInstanceNode_ = s1_.insertAccessor(JSFunctionCallNode.createCall());
                s1_.hasInstanceProfile_ = ConditionProfile.createBinaryProfile();
                s1_.errorBranch_ = BranchProfile.create();
                s1_.proxyBranch_ = BranchProfile.create();
                this.generic_cache = s1_;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doGeneric(leftNodeValue, rightNodeValue_, s1_.isObjectNode_, s1_.getMethodHasInstanceNode_, s1_.toBooleanNode_, s1_.callHasInstanceNode_, s1_.hasInstanceProfile_, s1_.errorBranch_, s1_.proxyBranch_);
                return bl;
            }
            if (!this.isJavaObject(leftNodeValue) && this.isJavaInteropClass(rightNodeValue)) {
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                boolean bl = this.instanceofJavaClass(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (this.isJavaObject(leftNodeValue) && this.isJavaInteropClass(rightNodeValue)) {
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                boolean bl = this.instanceofJavaClassUnwrap(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (!JSGuards.isDynamicObject(rightNodeValue)) {
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doRHSNotAnObject(leftNodeValue, rightNodeValue);
                return bl;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode, this.rightNode}, new Object[]{leftNodeValue, rightNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[5];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doGeneric";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
            GenericData s1_ = this.generic_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s1_.isObjectNode_, s1_.getMethodHasInstanceNode_, s1_.toBooleanNode_, s1_.callHasInstanceNode_, s1_.hasInstanceProfile_, s1_.errorBranch_, s1_.proxyBranch_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "instanceofJavaClass";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "instanceofJavaClassUnwrap";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doRHSNotAnObject";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static InstanceofNode create(JSContext context, JavaScriptNode left, JavaScriptNode right) {
        return new InstanceofNodeGen(context, left, right);
    }

    @GeneratedBy(value=InstanceofNode.IsBoundFunctionCacheNode.class)
    public static final class IsBoundFunctionCacheNodeGen
    extends InstanceofNode.IsBoundFunctionCacheNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private DynamicObject cachedInstance_cachedFunction_;
        @CompilerDirectives.CompilationFinal
        private boolean cachedInstance_cachedIsBound_;
        @CompilerDirectives.CompilationFinal
        private CachedShapeData cachedShape_cache;

        private IsBoundFunctionCacheNodeGen(boolean multiContext) {
            super(multiContext);
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public boolean executeBoolean(DynamicObject arg0Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    assert (!this.multiContext);
                    if (arg0Value == this.cachedInstance_cachedFunction_) {
                        return InstanceofNode.IsBoundFunctionCacheNode.doCachedInstance(arg0Value, this.cachedInstance_cachedFunction_, this.cachedInstance_cachedIsBound_);
                    }
                }
                if ((state & 2) != 0) {
                    CachedShapeData s2_ = this.cachedShape_cache;
                    while (s2_ != null) {
                        if (s2_.cachedShape_.check(arg0Value)) {
                            return InstanceofNode.IsBoundFunctionCacheNode.doCachedShape(arg0Value, s2_.cachedShape_, s2_.cachedIsBound_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 4) != 0) {
                    return InstanceofNode.IsBoundFunctionCacheNode.isBoundFunction(arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(DynamicObject arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if ((exclude & 1) == 0) {
                    boolean CachedInstance_duplicateFound_ = false;
                    if ((state & 1) != 0) {
                        assert (!this.multiContext);
                        if (arg0Value == this.cachedInstance_cachedFunction_) {
                            CachedInstance_duplicateFound_ = true;
                        }
                    }
                    if (!CachedInstance_duplicateFound_ && !this.multiContext && (state & 1) == 0) {
                        this.cachedInstance_cachedFunction_ = arg0Value;
                        this.cachedInstance_cachedIsBound_ = InstanceofNode.IsBoundFunctionCacheNode.isBoundFunction(arg0Value);
                        this.state_ = state |= 1;
                        CachedInstance_duplicateFound_ = true;
                    }
                    if (CachedInstance_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl = InstanceofNode.IsBoundFunctionCacheNode.doCachedInstance(arg0Value, this.cachedInstance_cachedFunction_, this.cachedInstance_cachedIsBound_);
                        return bl;
                    }
                }
                if ((exclude & 2) == 0) {
                    Shape cachedShape__;
                    int count2_ = 0;
                    CachedShapeData s2_ = this.cachedShape_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null && !s2_.cachedShape_.check(arg0Value)) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && (cachedShape__ = arg0Value.getShape()).check(arg0Value) && count2_ < 3) {
                        s2_ = new CachedShapeData(this.cachedShape_cache);
                        s2_.cachedShape_ = cachedShape__;
                        s2_.cachedIsBound_ = InstanceofNode.IsBoundFunctionCacheNode.isBoundFunction(arg0Value);
                        this.cachedShape_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl = InstanceofNode.IsBoundFunctionCacheNode.doCachedShape(arg0Value, s2_.cachedShape_, s2_.cachedIsBound_);
                        return bl;
                    }
                }
                this.exclude_ = exclude |= 3;
                this.cachedShape_cache = null;
                state &= 0xFFFFFFFC;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                boolean bl = InstanceofNode.IsBoundFunctionCacheNode.isBoundFunction(arg0Value);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            CachedShapeData s2_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s2_ = this.cachedShape_cache) == null || s2_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "doCachedInstance";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                cached.add(Arrays.asList(this.cachedInstance_cachedFunction_, this.cachedInstance_cachedIsBound_));
                s[2] = cached;
            } else {
                s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doCachedShape";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                CachedShapeData s2_ = this.cachedShape_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(s2_.cachedShape_, s2_.cachedIsBound_));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "isBoundFunction";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static InstanceofNode.IsBoundFunctionCacheNode create(boolean multiContext) {
            return new IsBoundFunctionCacheNodeGen(multiContext);
        }

        @GeneratedBy(value=InstanceofNode.IsBoundFunctionCacheNode.class)
        private static final class CachedShapeData {
            @CompilerDirectives.CompilationFinal
            CachedShapeData next_;
            @CompilerDirectives.CompilationFinal
            Shape cachedShape_;
            @CompilerDirectives.CompilationFinal
            boolean cachedIsBound_;

            CachedShapeData(CachedShapeData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=InstanceofNode.OrdinaryHasInstanceNode.class)
    public static final class OrdinaryHasInstanceNodeGen
    extends InstanceofNode.OrdinaryHasInstanceNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private InstanceofNode isBound_instanceofNode_;
        @Node.Child
        private JSObjectData jSObject_cache;
        @Node.Child
        private JSObjectProxyData jSObjectProxy_cache;

        private OrdinaryHasInstanceNodeGen(JSContext context) {
            super(context);
        }

        @Override
        public boolean executeBoolean(Object arg0Value, Object arg1Value) {
            int state = this.state_;
            if ((state & 0xF) != 0) {
                if ((state & 1) != 0 && !JSGuards.isCallable(arg1Value)) {
                    return this.doNotCallable(arg0Value, arg1Value);
                }
                if ((state & 0xE) != 0 && JSTypes.isDynamicObject(arg1Value)) {
                    DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                    if ((state & 2) != 0 && JSGuards.isJSFunction(arg1Value_) && this.isBoundFunction(arg1Value_)) {
                        return this.doIsBound(arg0Value, arg1Value_, this.isBound_instanceofNode_);
                    }
                    if ((state & 4) != 0 && !JSGuards.isJSObject(arg0Value) && JSGuards.isJSFunction(arg1Value_) && !this.isBoundFunction(arg1Value_)) {
                        return this.doNotAnObject(arg0Value, arg1Value_);
                    }
                    if ((state & 8) != 0 && !JSGuards.isJSObject(arg0Value) && JSGuards.isJSProxy(arg1Value_) && JSGuards.isCallableProxy(arg1Value_)) {
                        return this.doNotAnObjectProxy(arg0Value, arg1Value_);
                    }
                }
            }
            if ((state & 0x30) != 0 && JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if (JSTypes.isDynamicObject(arg1Value)) {
                    JSObjectProxyData s6_;
                    JSObjectData s5_;
                    DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                    if ((state & 0x10) != 0 && (s5_ = this.jSObject_cache) != null && this.isObjectLocal(arg0Value_) && JSGuards.isJSFunction(arg1Value_) && !this.isBoundFunction(arg1Value_)) {
                        return this.doJSObject(arg0Value_, arg1Value_, s5_.getPrototype1Node_, s5_.getPrototype2Node_, s5_.getPrototype3Node_, s5_.firstTrue_, s5_.firstFalse_, s5_.need2Hops_, s5_.need3Hops_, s5_.errorBranch_, s5_.invalidPrototypeBranch_);
                    }
                    if ((state & 0x20) != 0 && (s6_ = this.jSObjectProxy_cache) != null && this.isObjectLocal(arg0Value_) && JSGuards.isJSProxy(arg1Value_) && JSGuards.isCallableProxy(arg1Value_)) {
                        return this.doJSObjectProxy(arg0Value_, arg1Value_, s6_.getPrototype1Node_, s6_.getPrototype2Node_, s6_.getPrototype3Node_, s6_.firstTrue_, s6_.firstFalse_, s6_.need2Hops_, s6_.need3Hops_, s6_.errorBranch_, s6_.invalidPrototypeBranch_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(Object arg0Value, Object arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (!JSGuards.isCallable(arg1Value)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doNotCallable(arg0Value, arg1Value);
                    return bl;
                }
                if (JSTypes.isDynamicObject(arg1Value)) {
                    DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                    if (JSGuards.isJSFunction(arg1Value_) && this.isBoundFunction(arg1Value_)) {
                        this.isBound_instanceofNode_ = (InstanceofNode)super.insert((Node)InstanceofNode.create(this.context));
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.doIsBound(arg0Value, arg1Value_, this.isBound_instanceofNode_);
                        return bl;
                    }
                    if (!JSGuards.isJSObject(arg0Value) && JSGuards.isJSFunction(arg1Value_) && !this.isBoundFunction(arg1Value_)) {
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.doNotAnObject(arg0Value, arg1Value_);
                        return bl;
                    }
                    if (!JSGuards.isJSObject(arg0Value) && JSGuards.isJSProxy(arg1Value_) && JSGuards.isCallableProxy(arg1Value_)) {
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.doNotAnObjectProxy(arg0Value, arg1Value_);
                        return bl;
                    }
                }
                if (JSTypes.isDynamicObject(arg0Value)) {
                    DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                    if (JSTypes.isDynamicObject(arg1Value)) {
                        DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                        if (this.isObjectLocal(arg0Value_) && JSGuards.isJSFunction(arg1Value_) && !this.isBoundFunction(arg1Value_)) {
                            JSObjectData s5_ = (JSObjectData)super.insert((Node)new JSObjectData());
                            s5_.getPrototype1Node_ = s5_.insertAccessor(GetPrototypeNode.create());
                            s5_.getPrototype2Node_ = s5_.insertAccessor(GetPrototypeNode.create());
                            s5_.getPrototype3Node_ = s5_.insertAccessor(GetPrototypeNode.create());
                            s5_.firstTrue_ = BranchProfile.create();
                            s5_.firstFalse_ = BranchProfile.create();
                            s5_.need2Hops_ = BranchProfile.create();
                            s5_.need3Hops_ = BranchProfile.create();
                            s5_.errorBranch_ = BranchProfile.create();
                            s5_.invalidPrototypeBranch_ = BranchProfile.create();
                            this.jSObject_cache = s5_;
                            this.state_ = state |= 0x10;
                            lock.unlock();
                            hasLock = false;
                            boolean bl = this.doJSObject(arg0Value_, arg1Value_, s5_.getPrototype1Node_, s5_.getPrototype2Node_, s5_.getPrototype3Node_, s5_.firstTrue_, s5_.firstFalse_, s5_.need2Hops_, s5_.need3Hops_, s5_.errorBranch_, s5_.invalidPrototypeBranch_);
                            return bl;
                        }
                        if (this.isObjectLocal(arg0Value_) && JSGuards.isJSProxy(arg1Value_) && JSGuards.isCallableProxy(arg1Value_)) {
                            JSObjectProxyData s6_ = (JSObjectProxyData)super.insert((Node)new JSObjectProxyData());
                            s6_.getPrototype1Node_ = s6_.insertAccessor(GetPrototypeNode.create());
                            s6_.getPrototype2Node_ = s6_.insertAccessor(GetPrototypeNode.create());
                            s6_.getPrototype3Node_ = s6_.insertAccessor(GetPrototypeNode.create());
                            s6_.firstTrue_ = BranchProfile.create();
                            s6_.firstFalse_ = BranchProfile.create();
                            s6_.need2Hops_ = BranchProfile.create();
                            s6_.need3Hops_ = BranchProfile.create();
                            s6_.errorBranch_ = BranchProfile.create();
                            s6_.invalidPrototypeBranch_ = BranchProfile.create();
                            this.jSObjectProxy_cache = s6_;
                            this.state_ = state |= 0x20;
                            lock.unlock();
                            hasLock = false;
                            boolean bl = this.doJSObjectProxy(arg0Value_, arg1Value_, s6_.getPrototype1Node_, s6_.getPrototype2Node_, s6_.getPrototype3Node_, s6_.firstTrue_, s6_.firstFalse_, s6_.need2Hops_, s6_.need3Hops_, s6_.errorBranch_, s6_.invalidPrototypeBranch_);
                            return bl;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[7];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doNotCallable";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "doIsBound";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                cached.add(Arrays.asList(this.isBound_instanceofNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "doNotAnObject";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "doNotAnObjectProxy";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "doJSObject";
            if ((state & 0x10) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                JSObjectData s5_ = this.jSObject_cache;
                if (s5_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s5_.getPrototype1Node_, s5_.getPrototype2Node_, s5_.getPrototype3Node_, s5_.firstTrue_, s5_.firstFalse_, s5_.need2Hops_, s5_.need3Hops_, s5_.errorBranch_, s5_.invalidPrototypeBranch_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[5] = s;
            s = new Object[3];
            s[0] = "doJSObjectProxy";
            if ((state & 0x20) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                JSObjectProxyData s6_ = this.jSObjectProxy_cache;
                if (s6_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s6_.getPrototype1Node_, s6_.getPrototype2Node_, s6_.getPrototype3Node_, s6_.firstTrue_, s6_.firstFalse_, s6_.need2Hops_, s6_.need3Hops_, s6_.errorBranch_, s6_.invalidPrototypeBranch_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[6] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static InstanceofNode.OrdinaryHasInstanceNode create(JSContext context) {
            return new OrdinaryHasInstanceNodeGen(context);
        }

        @GeneratedBy(value=InstanceofNode.OrdinaryHasInstanceNode.class)
        private static final class JSObjectProxyData
        extends Node {
            @Node.Child
            GetPrototypeNode getPrototype1Node_;
            @Node.Child
            GetPrototypeNode getPrototype2Node_;
            @Node.Child
            GetPrototypeNode getPrototype3Node_;
            @CompilerDirectives.CompilationFinal
            BranchProfile firstTrue_;
            @CompilerDirectives.CompilationFinal
            BranchProfile firstFalse_;
            @CompilerDirectives.CompilationFinal
            BranchProfile need2Hops_;
            @CompilerDirectives.CompilationFinal
            BranchProfile need3Hops_;
            @CompilerDirectives.CompilationFinal
            BranchProfile errorBranch_;
            @CompilerDirectives.CompilationFinal
            BranchProfile invalidPrototypeBranch_;

            JSObjectProxyData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=InstanceofNode.OrdinaryHasInstanceNode.class)
        private static final class JSObjectData
        extends Node {
            @Node.Child
            GetPrototypeNode getPrototype1Node_;
            @Node.Child
            GetPrototypeNode getPrototype2Node_;
            @Node.Child
            GetPrototypeNode getPrototype3Node_;
            @CompilerDirectives.CompilationFinal
            BranchProfile firstTrue_;
            @CompilerDirectives.CompilationFinal
            BranchProfile firstFalse_;
            @CompilerDirectives.CompilationFinal
            BranchProfile need2Hops_;
            @CompilerDirectives.CompilationFinal
            BranchProfile need3Hops_;
            @CompilerDirectives.CompilationFinal
            BranchProfile errorBranch_;
            @CompilerDirectives.CompilationFinal
            BranchProfile invalidPrototypeBranch_;

            JSObjectData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=InstanceofNode.class)
    private static final class GenericData
    extends Node {
        @Node.Child
        IsJSObjectNode isObjectNode_;
        @Node.Child
        GetMethodNode getMethodHasInstanceNode_;
        @Node.Child
        JSToBooleanNode toBooleanNode_;
        @Node.Child
        JSFunctionCallNode callHasInstanceNode_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile hasInstanceProfile_;
        @CompilerDirectives.CompilationFinal
        BranchProfile errorBranch_;
        @CompilerDirectives.CompilationFinal
        BranchProfile proxyBranch_;

        GenericData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

