/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSAddNode;
import com.oracle.truffle.js.nodes.binary.JSConcatStringsNode;
import com.oracle.truffle.js.nodes.cast.JSDoubleToStringNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.LargeInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSAddNode.class)
public final class JSAddNodeGen
extends JSAddNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private long state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private JSConcatStringsNode concatStringsNode;
    @Node.Child
    private JSDoubleToStringNode doubleToStringNode;
    @Node.Child
    private PrimitiveConversionData primitiveConversion_cache;

    private JSAddNodeGen(boolean truncate, JavaScriptNode left, JavaScriptNode right) {
        super(truncate, left, right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Object leftNodeValue, Object rightNodeValue) {
        int rightNodeValue_;
        int leftNodeValue_;
        long state = this.state_;
        if ((state & 0xFL) != 0L && leftNodeValue instanceof Integer) {
            leftNodeValue_ = (Integer)leftNodeValue;
            if ((state & 7L) != 0L && rightNodeValue instanceof Integer) {
                rightNodeValue_ = (Integer)rightNodeValue;
                if ((state & 1L) != 0L) {
                    assert (this.truncate);
                    return JSAddNode.doIntTruncate(leftNodeValue_, rightNodeValue_);
                }
                if ((state & 2L) != 0L) {
                    assert (!this.truncate);
                    try {
                        return JSAddNode.doInt(leftNodeValue_, rightNodeValue_);
                    }
                    catch (ArithmeticException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 2;
                            this.state_ &= 0xFFFFFFFFFFFFFFFDL;
                        }
                        finally {
                            lock.unlock();
                        }
                        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                    }
                }
                if ((state & 4L) != 0L) {
                    assert (!this.truncate);
                    try {
                        return JSAddNode.doIntOverflow(leftNodeValue_, rightNodeValue_);
                    }
                    catch (ArithmeticException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 4;
                            this.state_ &= 0xFFFFFFFFFFFFFFFBL;
                        }
                        finally {
                            lock.unlock();
                        }
                        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if ((state & 8L) != 0L && rightNodeValue instanceof LargeInteger) {
                LargeInteger rightNodeValue_2 = (LargeInteger)rightNodeValue;
                assert (this.truncate);
                return JSAddNode.doIntLargeIntegerTruncate(leftNodeValue_, rightNodeValue_2);
            }
        }
        if ((state & 0x30L) != 0L && leftNodeValue instanceof LargeInteger) {
            LargeInteger leftNodeValue_2 = (LargeInteger)leftNodeValue;
            if ((state & 0x10L) != 0L && rightNodeValue instanceof Integer) {
                rightNodeValue_ = (Integer)rightNodeValue;
                assert (this.truncate);
                return JSAddNode.doLargeIntegerIntTruncate(leftNodeValue_2, rightNodeValue_);
            }
            if ((state & 0x20L) != 0L && rightNodeValue instanceof LargeInteger) {
                LargeInteger rightNodeValue_3 = (LargeInteger)rightNodeValue;
                assert (this.truncate);
                return JSAddNode.doLargeIntegerTruncate(leftNodeValue_2, rightNodeValue_3);
            }
        }
        if ((state & 0x40L) != 0L && leftNodeValue instanceof Integer) {
            leftNodeValue_ = (Integer)leftNodeValue;
            if (rightNodeValue instanceof LargeInteger) {
                LargeInteger rightNodeValue_4 = (LargeInteger)rightNodeValue;
                assert (!this.truncate);
                try {
                    return JSAddNode.doIntLargeInteger(leftNodeValue_, rightNodeValue_4);
                }
                catch (ArithmeticException ex) {
                    Lock lock = this.getLock();
                    lock.lock();
                    try {
                        this.exclude_ |= 0x40;
                        this.state_ &= 0xFFFFFFFFFFFFFFBFL;
                    }
                    finally {
                        lock.unlock();
                    }
                    return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_4);
                }
            }
        }
        if ((state & 0x180L) != 0L && leftNodeValue instanceof LargeInteger) {
            LargeInteger leftNodeValue_3 = (LargeInteger)leftNodeValue;
            if ((state & 0x80L) != 0L && rightNodeValue instanceof Integer) {
                rightNodeValue_ = (Integer)rightNodeValue;
                assert (!this.truncate);
                try {
                    return JSAddNode.doLargeIntegerInt(leftNodeValue_3, rightNodeValue_);
                }
                catch (ArithmeticException ex) {
                    Lock lock = this.getLock();
                    lock.lock();
                    try {
                        this.exclude_ |= 0x80;
                        this.state_ &= 0xFFFFFFFFFFFFFF7FL;
                    }
                    finally {
                        lock.unlock();
                    }
                    return this.executeAndSpecialize(leftNodeValue_3, rightNodeValue_);
                }
            }
            if ((state & 0x100L) != 0L && rightNodeValue instanceof LargeInteger) {
                LargeInteger rightNodeValue_5 = (LargeInteger)rightNodeValue;
                assert (!this.truncate);
                try {
                    return JSAddNode.doLargeInteger(leftNodeValue_3, rightNodeValue_5);
                }
                catch (ArithmeticException ex) {
                    Lock lock = this.getLock();
                    lock.lock();
                    try {
                        this.exclude_ |= 0x100;
                        this.state_ &= 0xFFFFFFFFFFFFFEFFL;
                    }
                    finally {
                        lock.unlock();
                    }
                    return this.executeAndSpecialize(leftNodeValue_3, rightNodeValue_5);
                }
            }
        }
        if ((state & 0x200L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue)) {
            double leftNodeValue_4 = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue);
            if (JSTypesGen.isImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue)) {
                double rightNodeValue_6 = JSTypesGen.asImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue);
                return JSAddNode.doDouble(leftNodeValue_4, rightNodeValue_6);
            }
        }
        if ((state & 0x400L) != 0L && leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_5 = (BigInt)leftNodeValue;
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_7 = (BigInt)rightNodeValue;
                return this.doBigInt(leftNodeValue_5, rightNodeValue_7);
            }
        }
        if ((state & 0x1800L) != 0L && JSTypesGen.isImplicitCharSequence((int)((state & 0x1E000000L) >>> 25), leftNodeValue)) {
            CharSequence leftNodeValue_6 = JSTypesGen.asImplicitCharSequence((int)((state & 0x1E000000L) >>> 25), leftNodeValue);
            if ((state & 0x800L) != 0L && JSTypesGen.isImplicitCharSequence((int)((state & 0x1E0000000L) >>> 29), rightNodeValue)) {
                CharSequence rightNodeValue_8 = JSTypesGen.asImplicitCharSequence((int)((state & 0x1E0000000L) >>> 29), rightNodeValue);
                return this.doString(leftNodeValue_6, rightNodeValue_8, this.concatStringsNode);
            }
            if ((state & 0x1000L) != 0L && rightNodeValue instanceof Integer) {
                rightNodeValue_ = (Integer)rightNodeValue;
                return this.doStringInt(leftNodeValue_6, rightNodeValue_);
            }
        }
        if ((state & 0x2000L) != 0L && leftNodeValue instanceof Integer) {
            int leftNodeValue_7 = (Integer)leftNodeValue;
            if (JSTypesGen.isImplicitCharSequence((int)((state & 0x1E0000000L) >>> 29), rightNodeValue)) {
                CharSequence rightNodeValue_9 = JSTypesGen.asImplicitCharSequence((int)((state & 0x1E0000000L) >>> 29), rightNodeValue);
                return this.doIntString(leftNodeValue_7, rightNodeValue_9);
            }
        }
        if ((state & 0x4000L) != 0L && JSTypesGen.isImplicitCharSequence((int)((state & 0x1E000000L) >>> 25), leftNodeValue)) {
            CharSequence leftNodeValue_8 = JSTypesGen.asImplicitCharSequence((int)((state & 0x1E000000L) >>> 25), leftNodeValue);
            if (JSGuards.isNumber(rightNodeValue)) {
                return this.doStringNumber(leftNodeValue_8, rightNodeValue, this.concatStringsNode, this.doubleToStringNode);
            }
        }
        if ((state & 0x18000L) != 0L) {
            PrimitiveConversionData s17_;
            if ((state & 0x8000L) != 0L && JSTypesGen.isImplicitCharSequence((int)((state & 0x1E0000000L) >>> 29), rightNodeValue)) {
                CharSequence rightNodeValue_10 = JSTypesGen.asImplicitCharSequence((int)((state & 0x1E0000000L) >>> 29), rightNodeValue);
                if (JSGuards.isNumber(leftNodeValue)) {
                    return this.doNumberString(leftNodeValue, rightNodeValue_10, this.concatStringsNode, this.doubleToStringNode);
                }
            }
            if ((state & 0x10000L) != 0L && (s17_ = this.primitiveConversion_cache) != null) {
                return this.doPrimitiveConversion(leftNodeValue, rightNodeValue, s17_.toPrimitiveA_, s17_.toPrimitiveB_, s17_.toNumericA_, s17_.toNumericB_, s17_.toStringA_, s17_.toStringB_, s17_.profileA_, s17_.profileB_, s17_.add_, s17_.mixedNumericTypes_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        long state = this.state_;
        if ((state & 0x1FFF8L) == 0L && (state & 0x1FFFFL) != 0L) {
            return this.execute_int_int0(frameValue, state);
        }
        if ((state & 0x1FDFFL) == 0L && (state & 0x1FFFFL) != 0L) {
            return this.execute_double_double1(frameValue, state);
        }
        if ((state & 0x1DFB7L) == 0L && (state & 0x1FFFFL) != 0L) {
            return this.execute_int2(frameValue, state);
        }
        if ((state & 0x1EF6FL) == 0L && (state & 0x1FFFFL) != 0L) {
            return this.execute_int3(frameValue, state);
        }
        return this.execute_generic4(frameValue, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute_int_int0(VirtualFrame frameValue, long state) {
        int rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        if ((state & 1L) != 0L) {
            assert (this.truncate);
            return JSAddNode.doIntTruncate(leftNodeValue_, rightNodeValue_);
        }
        if ((state & 2L) != 0L) {
            assert (!this.truncate);
            try {
                return JSAddNode.doInt(leftNodeValue_, rightNodeValue_);
            }
            catch (ArithmeticException ex) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    this.exclude_ |= 2;
                    this.state_ &= 0xFFFFFFFFFFFFFFFDL;
                }
                finally {
                    lock.unlock();
                }
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 4L) != 0L) {
            assert (!this.truncate);
            try {
                return JSAddNode.doIntOverflow(leftNodeValue_, rightNodeValue_);
            }
            catch (ArithmeticException ex) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    this.exclude_ |= 4;
                    this.state_ &= 0xFFFFFFFFFFFFFFFBL;
                }
                finally {
                    lock.unlock();
                }
                return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_double_double1(VirtualFrame frameValue, long state) {
        double rightNodeValue_;
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x1C0000L) == 0L && (state & 0x1FFFFL) != 0L) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x1A0000L) == 0L && (state & 0x1FFFFL) != 0L) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x160000L) == 0L && (state & 0x1FFFFL) != 0L) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x1C00000L) == 0L && (state & 0x1FFFFL) != 0L) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1A00000L) == 0L && (state & 0x1FFFFL) != 0L) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x1600000L) == 0L && (state & 0x1FFFFL) != 0L) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize((state & 0x1C0000L) == 0L && (state & 0x1FFFFL) != 0L ? (Number)leftNodeValue_long : (Number)((state & 0x1A0000L) == 0L && (state & 0x1FFFFL) != 0L ? (Number)leftNodeValue_int : (Number)leftNodeValue_), ex.getResult());
        }
        assert ((state & 0x200L) != 0L);
        return JSAddNode.doDouble(leftNodeValue_, rightNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute_int2(VirtualFrame frameValue, long state) {
        Object rightNodeValue__;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 0x48L) != 0L && rightNodeValue_ instanceof LargeInteger) {
            rightNodeValue__ = (LargeInteger)rightNodeValue_;
            if ((state & 8L) != 0L) {
                assert (this.truncate);
                return JSAddNode.doIntLargeIntegerTruncate(leftNodeValue_, (LargeInteger)rightNodeValue__);
            }
            if ((state & 0x40L) != 0L) {
                assert (!this.truncate);
                try {
                    return JSAddNode.doIntLargeInteger(leftNodeValue_, (LargeInteger)rightNodeValue__);
                }
                catch (ArithmeticException ex) {
                    Lock lock = this.getLock();
                    lock.lock();
                    try {
                        this.exclude_ |= 0x40;
                        this.state_ &= 0xFFFFFFFFFFFFFFBFL;
                    }
                    finally {
                        lock.unlock();
                    }
                    return this.executeAndSpecialize(leftNodeValue_, rightNodeValue__);
                }
            }
        }
        if ((state & 0x2000L) != 0L && JSTypesGen.isImplicitCharSequence((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_)) {
            rightNodeValue__ = JSTypesGen.asImplicitCharSequence((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_);
            return this.doIntString(leftNodeValue_, (CharSequence)rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute_int3(VirtualFrame frameValue, long state) {
        Object leftNodeValue__;
        int rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        if ((state & 0x90L) != 0L && leftNodeValue_ instanceof LargeInteger) {
            leftNodeValue__ = (LargeInteger)leftNodeValue_;
            if ((state & 0x10L) != 0L) {
                assert (this.truncate);
                return JSAddNode.doLargeIntegerIntTruncate((LargeInteger)leftNodeValue__, rightNodeValue_);
            }
            if ((state & 0x80L) != 0L) {
                assert (!this.truncate);
                try {
                    return JSAddNode.doLargeIntegerInt((LargeInteger)leftNodeValue__, rightNodeValue_);
                }
                catch (ArithmeticException ex) {
                    Lock lock = this.getLock();
                    lock.lock();
                    try {
                        this.exclude_ |= 0x80;
                        this.state_ &= 0xFFFFFFFFFFFFFF7FL;
                    }
                    finally {
                        lock.unlock();
                    }
                    return this.executeAndSpecialize(leftNodeValue__, rightNodeValue_);
                }
            }
        }
        if ((state & 0x1000L) != 0L && JSTypesGen.isImplicitCharSequence((int)((state & 0x1E000000L) >>> 25), leftNodeValue_)) {
            leftNodeValue__ = JSTypesGen.asImplicitCharSequence((int)((state & 0x1E000000L) >>> 25), leftNodeValue_);
            return this.doStringInt((CharSequence)leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute_generic4(VirtualFrame frameValue, long state) {
        int rightNodeValue__;
        int leftNodeValue__;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 0xFL) != 0L && leftNodeValue_ instanceof Integer) {
            leftNodeValue__ = (Integer)leftNodeValue_;
            if ((state & 7L) != 0L && rightNodeValue_ instanceof Integer) {
                rightNodeValue__ = (Integer)rightNodeValue_;
                if ((state & 1L) != 0L) {
                    assert (this.truncate);
                    return JSAddNode.doIntTruncate(leftNodeValue__, rightNodeValue__);
                }
                if ((state & 2L) != 0L) {
                    assert (!this.truncate);
                    try {
                        return JSAddNode.doInt(leftNodeValue__, rightNodeValue__);
                    }
                    catch (ArithmeticException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 2;
                            this.state_ &= 0xFFFFFFFFFFFFFFFDL;
                        }
                        finally {
                            lock.unlock();
                        }
                        return this.executeAndSpecialize(leftNodeValue__, rightNodeValue__);
                    }
                }
                if ((state & 4L) != 0L) {
                    assert (!this.truncate);
                    try {
                        return JSAddNode.doIntOverflow(leftNodeValue__, rightNodeValue__);
                    }
                    catch (ArithmeticException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 4;
                            this.state_ &= 0xFFFFFFFFFFFFFFFBL;
                        }
                        finally {
                            lock.unlock();
                        }
                        return this.executeAndSpecialize(leftNodeValue__, rightNodeValue__);
                    }
                }
            }
            if ((state & 8L) != 0L && rightNodeValue_ instanceof LargeInteger) {
                LargeInteger rightNodeValue__2 = (LargeInteger)rightNodeValue_;
                assert (this.truncate);
                return JSAddNode.doIntLargeIntegerTruncate(leftNodeValue__, rightNodeValue__2);
            }
        }
        if ((state & 0x30L) != 0L && leftNodeValue_ instanceof LargeInteger) {
            LargeInteger leftNodeValue__2 = (LargeInteger)leftNodeValue_;
            if ((state & 0x10L) != 0L && rightNodeValue_ instanceof Integer) {
                rightNodeValue__ = (Integer)rightNodeValue_;
                assert (this.truncate);
                return JSAddNode.doLargeIntegerIntTruncate(leftNodeValue__2, rightNodeValue__);
            }
            if ((state & 0x20L) != 0L && rightNodeValue_ instanceof LargeInteger) {
                LargeInteger rightNodeValue__3 = (LargeInteger)rightNodeValue_;
                assert (this.truncate);
                return JSAddNode.doLargeIntegerTruncate(leftNodeValue__2, rightNodeValue__3);
            }
        }
        if ((state & 0x40L) != 0L && leftNodeValue_ instanceof Integer) {
            leftNodeValue__ = (Integer)leftNodeValue_;
            if (rightNodeValue_ instanceof LargeInteger) {
                LargeInteger rightNodeValue__4 = (LargeInteger)rightNodeValue_;
                assert (!this.truncate);
                try {
                    return JSAddNode.doIntLargeInteger(leftNodeValue__, rightNodeValue__4);
                }
                catch (ArithmeticException ex) {
                    Lock lock = this.getLock();
                    lock.lock();
                    try {
                        this.exclude_ |= 0x40;
                        this.state_ &= 0xFFFFFFFFFFFFFFBFL;
                    }
                    finally {
                        lock.unlock();
                    }
                    return this.executeAndSpecialize(leftNodeValue__, rightNodeValue__4);
                }
            }
        }
        if ((state & 0x180L) != 0L && leftNodeValue_ instanceof LargeInteger) {
            LargeInteger leftNodeValue__3 = (LargeInteger)leftNodeValue_;
            if ((state & 0x80L) != 0L && rightNodeValue_ instanceof Integer) {
                rightNodeValue__ = (Integer)rightNodeValue_;
                assert (!this.truncate);
                try {
                    return JSAddNode.doLargeIntegerInt(leftNodeValue__3, rightNodeValue__);
                }
                catch (ArithmeticException ex) {
                    Lock lock = this.getLock();
                    lock.lock();
                    try {
                        this.exclude_ |= 0x80;
                        this.state_ &= 0xFFFFFFFFFFFFFF7FL;
                    }
                    finally {
                        lock.unlock();
                    }
                    return this.executeAndSpecialize(leftNodeValue__3, rightNodeValue__);
                }
            }
            if ((state & 0x100L) != 0L && rightNodeValue_ instanceof LargeInteger) {
                LargeInteger rightNodeValue__5 = (LargeInteger)rightNodeValue_;
                assert (!this.truncate);
                try {
                    return JSAddNode.doLargeInteger(leftNodeValue__3, rightNodeValue__5);
                }
                catch (ArithmeticException ex) {
                    Lock lock = this.getLock();
                    lock.lock();
                    try {
                        this.exclude_ |= 0x100;
                        this.state_ &= 0xFFFFFFFFFFFFFEFFL;
                    }
                    finally {
                        lock.unlock();
                    }
                    return this.executeAndSpecialize(leftNodeValue__3, rightNodeValue__5);
                }
            }
        }
        if ((state & 0x200L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue_)) {
            double leftNodeValue__4 = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue_);
            if (JSTypesGen.isImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue_)) {
                double rightNodeValue__6 = JSTypesGen.asImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue_);
                return JSAddNode.doDouble(leftNodeValue__4, rightNodeValue__6);
            }
        }
        if ((state & 0x400L) != 0L && leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__5 = (BigInt)leftNodeValue_;
            if (rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__7 = (BigInt)rightNodeValue_;
                return this.doBigInt(leftNodeValue__5, rightNodeValue__7);
            }
        }
        if ((state & 0x1800L) != 0L && JSTypesGen.isImplicitCharSequence((int)((state & 0x1E000000L) >>> 25), leftNodeValue_)) {
            CharSequence leftNodeValue__6 = JSTypesGen.asImplicitCharSequence((int)((state & 0x1E000000L) >>> 25), leftNodeValue_);
            if ((state & 0x800L) != 0L && JSTypesGen.isImplicitCharSequence((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_)) {
                CharSequence rightNodeValue__8 = JSTypesGen.asImplicitCharSequence((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_);
                return this.doString(leftNodeValue__6, rightNodeValue__8, this.concatStringsNode);
            }
            if ((state & 0x1000L) != 0L && rightNodeValue_ instanceof Integer) {
                rightNodeValue__ = (Integer)rightNodeValue_;
                return this.doStringInt(leftNodeValue__6, rightNodeValue__);
            }
        }
        if ((state & 0x2000L) != 0L && leftNodeValue_ instanceof Integer) {
            int leftNodeValue__7 = (Integer)leftNodeValue_;
            if (JSTypesGen.isImplicitCharSequence((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_)) {
                CharSequence rightNodeValue__9 = JSTypesGen.asImplicitCharSequence((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_);
                return this.doIntString(leftNodeValue__7, rightNodeValue__9);
            }
        }
        if ((state & 0x4000L) != 0L && JSTypesGen.isImplicitCharSequence((int)((state & 0x1E000000L) >>> 25), leftNodeValue_)) {
            CharSequence leftNodeValue__8 = JSTypesGen.asImplicitCharSequence((int)((state & 0x1E000000L) >>> 25), leftNodeValue_);
            if (JSGuards.isNumber(rightNodeValue_)) {
                return this.doStringNumber(leftNodeValue__8, rightNodeValue_, this.concatStringsNode, this.doubleToStringNode);
            }
        }
        if ((state & 0x18000L) != 0L) {
            PrimitiveConversionData s17_;
            if ((state & 0x8000L) != 0L && JSTypesGen.isImplicitCharSequence((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_)) {
                CharSequence rightNodeValue__10 = JSTypesGen.asImplicitCharSequence((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_);
                if (JSGuards.isNumber(leftNodeValue_)) {
                    return this.doNumberString(leftNodeValue_, rightNodeValue__10, this.concatStringsNode, this.doubleToStringNode);
                }
            }
            if ((state & 0x10000L) != 0L && (s17_ = this.primitiveConversion_cache) != null) {
                return this.doPrimitiveConversion(leftNodeValue_, rightNodeValue_, s17_.toPrimitiveA_, s17_.toPrimitiveB_, s17_.toNumericA_, s17_.toNumericB_, s17_.toStringA_, s17_.toStringB_, s17_.profileA_, s17_.profileB_, s17_.add_, s17_.mixedNumericTypes_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        double rightNodeValue_;
        double leftNodeValue_;
        long state = this.state_;
        if ((state & 0x10004L) != 0L) {
            return JSTypesGen.expectDouble(this.execute(frameValue));
        }
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x1C0000L) == 0L && (state & 0x1FFFFL) != 0L) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x1A0000L) == 0L && (state & 0x1FFFFL) != 0L) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x160000L) == 0L && (state & 0x1FFFFL) != 0L) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E0000L) >>> 17), leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return JSTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x1C00000L) == 0L && (state & 0x1FFFFL) != 0L) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1A00000L) == 0L && (state & 0x1FFFFL) != 0L) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x1600000L) == 0L && (state & 0x1FFFFL) != 0L) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E00000L) >>> 21), rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectDouble(this.executeAndSpecialize((state & 0x1C0000L) == 0L && (state & 0x1FFFFL) != 0L ? (Number)leftNodeValue_long : (Number)((state & 0x1A0000L) == 0L && (state & 0x1FFFFL) != 0L ? (Number)leftNodeValue_int : (Number)leftNodeValue_), ex.getResult()));
        }
        if ((state & 0x200L) != 0L) {
            return JSAddNode.doDouble(leftNodeValue_, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(this.executeAndSpecialize((state & 0x1C0000L) == 0L && (state & 0x1FFFFL) != 0L ? (Number)leftNodeValue_long : (Number)((state & 0x1A0000L) == 0L && (state & 0x1FFFFL) != 0L ? (Number)leftNodeValue_int : (Number)leftNodeValue_), (state & 0x1C00000L) == 0L && (state & 0x1FFFFL) != 0L ? (Number)rightNodeValue_long : (Number)((state & 0x1A00000L) == 0L && (state & 0x1FFFFL) != 0L ? (Number)rightNodeValue_int : (Number)rightNodeValue_)));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        long state = this.state_;
        if ((state & 0x10004L) != 0L) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        if ((state & 0x38L) == 0L && (state & 0x3BL) != 0L) {
            return this.executeInt_int_int5(frameValue, state);
        }
        if ((state & 0x33L) == 0L && (state & 0x3BL) != 0L) {
            return this.executeInt_int6(frameValue, state);
        }
        if ((state & 0x2BL) == 0L && (state & 0x3BL) != 0L) {
            return this.executeInt_int7(frameValue, state);
        }
        return this.executeInt_generic8(frameValue, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeInt_int_int5(VirtualFrame frameValue, long state) throws UnexpectedResultException {
        int rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        if ((state & 1L) != 0L) {
            assert (this.truncate);
            return JSAddNode.doIntTruncate(leftNodeValue_, rightNodeValue_);
        }
        if ((state & 2L) != 0L) {
            assert (!this.truncate);
            try {
                return JSAddNode.doInt(leftNodeValue_, rightNodeValue_);
            }
            catch (ArithmeticException ex) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    this.exclude_ |= 2;
                    this.state_ &= 0xFFFFFFFFFFFFFFFDL;
                }
                finally {
                    lock.unlock();
                }
                return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    private int executeInt_int6(VirtualFrame frameValue, long state) throws UnexpectedResultException {
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        assert ((state & 8L) != 0L);
        if (rightNodeValue_ instanceof LargeInteger) {
            LargeInteger rightNodeValue__ = (LargeInteger)rightNodeValue_;
            assert (this.truncate);
            return JSAddNode.doIntLargeIntegerTruncate(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    private int executeInt_int7(VirtualFrame frameValue, long state) throws UnexpectedResultException {
        int rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        assert ((state & 0x10L) != 0L);
        if (leftNodeValue_ instanceof LargeInteger) {
            LargeInteger leftNodeValue__ = (LargeInteger)leftNodeValue_;
            assert (this.truncate);
            return JSAddNode.doLargeIntegerIntTruncate(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeInt_generic8(VirtualFrame frameValue, long state) throws UnexpectedResultException {
        int rightNodeValue__;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 0xBL) != 0L && leftNodeValue_ instanceof Integer) {
            int leftNodeValue__ = (Integer)leftNodeValue_;
            if ((state & 3L) != 0L && rightNodeValue_ instanceof Integer) {
                rightNodeValue__ = (Integer)rightNodeValue_;
                if ((state & 1L) != 0L) {
                    assert (this.truncate);
                    return JSAddNode.doIntTruncate(leftNodeValue__, rightNodeValue__);
                }
                if ((state & 2L) != 0L) {
                    assert (!this.truncate);
                    try {
                        return JSAddNode.doInt(leftNodeValue__, rightNodeValue__);
                    }
                    catch (ArithmeticException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 2;
                            this.state_ &= 0xFFFFFFFFFFFFFFFDL;
                        }
                        finally {
                            lock.unlock();
                        }
                        return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue__, rightNodeValue__));
                    }
                }
            }
            if ((state & 8L) != 0L && rightNodeValue_ instanceof LargeInteger) {
                LargeInteger rightNodeValue__2 = (LargeInteger)rightNodeValue_;
                assert (this.truncate);
                return JSAddNode.doIntLargeIntegerTruncate(leftNodeValue__, rightNodeValue__2);
            }
        }
        if ((state & 0x30L) != 0L && leftNodeValue_ instanceof LargeInteger) {
            LargeInteger leftNodeValue__ = (LargeInteger)leftNodeValue_;
            if ((state & 0x10L) != 0L && rightNodeValue_ instanceof Integer) {
                rightNodeValue__ = (Integer)rightNodeValue_;
                assert (this.truncate);
                return JSAddNode.doLargeIntegerIntTruncate(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 0x20L) != 0L && rightNodeValue_ instanceof LargeInteger) {
                LargeInteger rightNodeValue__3 = (LargeInteger)rightNodeValue_;
                assert (this.truncate);
                return JSAddNode.doLargeIntegerTruncate(leftNodeValue__, rightNodeValue__3);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        long state = this.state_;
        try {
            if ((state & 0x1FFC4L) == 0L && (state & 0x1FFFFL) != 0L) {
                this.executeInt(frameValue);
                return;
            }
            if ((state & 0x1FDFFL) == 0L && (state & 0x1FFFFL) != 0L) {
                this.executeDouble(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkForPolymorphicSpecialize(long oldState, int oldExclude) {
        long newState = this.state_ & 0x1FFFFL;
        int newExclude = this.exclude_;
        if ((oldState ^ newState) != 0L || (oldExclude ^ newExclude) != 0) {
            this.reportPolymorphicSpecialize();
        }
    }

    public NodeCost getCost() {
        long state = this.state_;
        if ((state & 0x1FFFFL) == 0L) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x1FFFFL & (state & 0x1FFFFL) - 1L) == 0L) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[18];
        data[0] = 0;
        long state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doIntTruncate";
        s[1] = (state & 1L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[1] = s;
        s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 2L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[2] = s;
        s = new Object[3];
        s[0] = "doIntOverflow";
        s[1] = (state & 4L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[3] = s;
        s = new Object[3];
        s[0] = "doIntLargeIntegerTruncate";
        s[1] = (state & 8L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 8) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[4] = s;
        s = new Object[3];
        s[0] = "doLargeIntegerIntTruncate";
        s[1] = (state & 0x10L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 0x10) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[5] = s;
        s = new Object[3];
        s[0] = "doLargeIntegerTruncate";
        s[1] = (state & 0x20L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 0x20) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[6] = s;
        s = new Object[3];
        s[0] = "doIntLargeInteger";
        s[1] = (state & 0x40L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 0x40) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[7] = s;
        s = new Object[3];
        s[0] = "doLargeIntegerInt";
        s[1] = (state & 0x80L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 0x80) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[8] = s;
        s = new Object[3];
        s[0] = "doLargeInteger";
        s[1] = (state & 0x100L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 0x100) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[9] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 0x200L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 0x200) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[10] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x400L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 0x400) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[11] = s;
        s = new Object[3];
        s[0] = "doString";
        if ((state & 0x800L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.concatStringsNode));
            s[2] = cached;
        } else {
            s[1] = (exclude & 0x800) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[12] = s;
        s = new Object[3];
        s[0] = "doStringInt";
        s[1] = (state & 0x1000L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 0x1000) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[13] = s;
        s = new Object[3];
        s[0] = "doIntString";
        s[1] = (state & 0x2000L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 0x2000) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[14] = s;
        s = new Object[3];
        s[0] = "doStringNumber";
        if ((state & 0x4000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.concatStringsNode, this.doubleToStringNode}));
            s[2] = cached;
        } else {
            s[1] = (exclude & 0x4000) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[15] = s;
        s = new Object[3];
        s[0] = "doNumberString";
        if ((state & 0x8000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.concatStringsNode, this.doubleToStringNode}));
            s[2] = cached;
        } else {
            s[1] = (exclude & 0x8000) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[16] = s;
        s = new Object[3];
        s[0] = "doPrimitiveConversion";
        if ((state & 0x10000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            PrimitiveConversionData s17_ = this.primitiveConversion_cache;
            if (s17_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s17_.toPrimitiveA_, s17_.toPrimitiveB_, s17_.toNumericA_, s17_.toNumericB_, s17_.toStringA_, s17_.toStringB_, s17_.profileA_, s17_.profileB_, s17_.add_, s17_.mixedNumericTypes_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[17] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSAddNode create(boolean truncate, JavaScriptNode left, JavaScriptNode right) {
        return new JSAddNodeGen(truncate, left, right);
    }

    @GeneratedBy(value=JSAddNode.class)
    private static final class PrimitiveConversionData
    extends Node {
        @Node.Child
        JSToPrimitiveNode toPrimitiveA_;
        @Node.Child
        JSToPrimitiveNode toPrimitiveB_;
        @Node.Child
        JSToNumericNode toNumericA_;
        @Node.Child
        JSToNumericNode toNumericB_;
        @Node.Child
        JSToStringNode toStringA_;
        @Node.Child
        JSToStringNode toStringB_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile profileA_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile profileB_;
        @Node.Child
        JSAddNode add_;
        @CompilerDirectives.CompilationFinal
        BranchProfile mixedNumericTypes_;

        PrimitiveConversionData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

