/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsArrayNode;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import com.oracle.truffle.js.nodes.control.DeletePropertyNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=DeletePropertyNode.class)
public final class DeletePropertyNodeGen
extends DeletePropertyNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private InteropLibrary interop;
    @Node.Child
    private JSObjectData jSObject_cache;
    @Node.Child
    private ToArrayIndexNode string_toArrayIndexNode_;
    @Node.Child
    private InteropLibrary foreignObject_interopKey_;

    private DeletePropertyNodeGen(boolean strict, JSContext context, JavaScriptNode targetNode, JavaScriptNode propertyNode) {
        super(strict, context, targetNode, propertyNode);
    }

    @Override
    public Object executeWithTarget(VirtualFrame frameValue, Object targetNodeValue) {
        int state = this.state_;
        if ((state & 0x3BF) == 0 && (state & 0x3FF) != 0) {
            return this.executeWithTarget_int0(frameValue, state, targetNodeValue);
        }
        return this.executeWithTarget_generic1(frameValue, state, targetNodeValue);
    }

    private Object executeWithTarget_int0(VirtualFrame frameValue, int state, Object targetNodeValue) {
        TruffleObject targetNodeValue_;
        int propertyNodeValue_;
        try {
            propertyNodeValue_ = this.propertyNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(targetNodeValue, ex.getResult());
        }
        assert ((state & 0x40) != 0);
        if (targetNodeValue instanceof TruffleObject && JSGuards.isForeignObject(targetNodeValue_ = (TruffleObject)targetNodeValue)) {
            return this.arrayElementInt(targetNodeValue_, propertyNodeValue_, this.interop);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue, propertyNodeValue_);
    }

    private Object executeWithTarget_generic1(VirtualFrame frameValue, int state, Object targetNodeValue) {
        Object targetNodeValue_;
        Object propertyNodeValue_ = this.propertyNode.execute(frameValue);
        if ((state & 0x1F) != 0) {
            if ((state & 1) != 0 && JSTypes.isDynamicObject(targetNodeValue)) {
                targetNodeValue_ = (DynamicObject)targetNodeValue;
                JSObjectData s1_ = this.jSObject_cache;
                if (s1_ != null && JSGuards.isJSType(targetNodeValue_)) {
                    return this.doJSObject((DynamicObject)targetNodeValue_, propertyNodeValue_, s1_.isArrayNode_, s1_.arrayProfile_, s1_.toArrayIndexNode_, s1_.arrayIndexProfile_, s1_.arrayTypeProfile_, s1_.jsclassProfile_, s1_.toPropertyKeyNode_);
                }
            }
            if ((state & 2) != 0 && targetNodeValue instanceof Symbol) {
                targetNodeValue_ = (Symbol)targetNodeValue;
                return DeletePropertyNode.doSymbol((Symbol)targetNodeValue_, propertyNodeValue_);
            }
            if ((state & 4) != 0 && targetNodeValue instanceof LargeInteger) {
                targetNodeValue_ = (LargeInteger)targetNodeValue;
                return DeletePropertyNode.doLargeInteger((LargeInteger)targetNodeValue_, propertyNodeValue_);
            }
            if ((state & 8) != 0 && targetNodeValue instanceof BigInt) {
                targetNodeValue_ = (BigInt)targetNodeValue;
                return DeletePropertyNode.doBigInt((BigInt)targetNodeValue_, propertyNodeValue_);
            }
            if ((state & 0x10) != 0 && JSTypesGen.isImplicitString((state & 0x3C00) >>> 10, targetNodeValue)) {
                targetNodeValue_ = JSTypesGen.asImplicitString((state & 0x3C00) >>> 10, targetNodeValue);
                return DeletePropertyNode.doString((String)targetNodeValue_, propertyNodeValue_, this.string_toArrayIndexNode_);
            }
        }
        if ((state & 0x1E0) != 0 && targetNodeValue instanceof TruffleObject) {
            targetNodeValue_ = (TruffleObject)targetNodeValue;
            if ((state & 0x20) != 0 && JSTypesGen.isImplicitString((state & 0x3C000) >>> 14, propertyNodeValue_)) {
                String propertyNodeValue__ = JSTypesGen.asImplicitString((state & 0x3C000) >>> 14, propertyNodeValue_);
                if (JSGuards.isForeignObject((TruffleObject)targetNodeValue_)) {
                    return this.member((TruffleObject)targetNodeValue_, propertyNodeValue__, this.interop);
                }
            }
            if ((state & 0x40) != 0 && propertyNodeValue_ instanceof Integer) {
                int propertyNodeValue__ = (Integer)propertyNodeValue_;
                if (JSGuards.isForeignObject((TruffleObject)targetNodeValue_)) {
                    return this.arrayElementInt((TruffleObject)targetNodeValue_, propertyNodeValue__, this.interop);
                }
            }
            if ((state & 0x80) != 0 && propertyNodeValue_ instanceof Number) {
                Number propertyNodeValue__ = (Number)propertyNodeValue_;
                if (JSGuards.isForeignObject((TruffleObject)targetNodeValue_) && JSGuards.isNumber(propertyNodeValue__)) {
                    return this.arrayElement((TruffleObject)targetNodeValue_, propertyNodeValue__, this.interop);
                }
            }
            if ((state & 0x100) != 0 && JSGuards.isForeignObject((TruffleObject)targetNodeValue_) && !JSGuards.isString(propertyNodeValue_) && !JSGuards.isNumber(propertyNodeValue_)) {
                return this.foreignObject((TruffleObject)targetNodeValue_, propertyNodeValue_, this.interop, this.foreignObject_interopKey_);
            }
        }
        if ((state & 0x200) != 0 && !JSGuards.isTruffleObject(targetNodeValue) && !JSGuards.isString(targetNodeValue)) {
            return this.doOther(targetNodeValue, propertyNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue, propertyNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = this.state_;
        if ((state & 0x2BF) == 0 && (state & 0x2FF) != 0) {
            return this.executeBoolean_int2(frameValue, state);
        }
        return this.executeBoolean_generic3(frameValue, state);
    }

    private boolean executeBoolean_int2(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        TruffleObject targetNodeValue__;
        int propertyNodeValue_;
        Object targetNodeValue_ = this.targetNode.execute(frameValue);
        try {
            propertyNodeValue_ = this.propertyNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectBoolean(this.executeAndSpecialize(targetNodeValue_, ex.getResult()));
        }
        assert ((state & 0x40) != 0);
        if (targetNodeValue_ instanceof TruffleObject && JSGuards.isForeignObject(targetNodeValue__ = (TruffleObject)targetNodeValue_)) {
            return this.arrayElementInt(targetNodeValue__, propertyNodeValue_, this.interop);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectBoolean(this.executeAndSpecialize(targetNodeValue_, propertyNodeValue_));
    }

    private boolean executeBoolean_generic3(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        Object targetNodeValue__;
        Object targetNodeValue_ = this.targetNode.execute(frameValue);
        Object propertyNodeValue_ = this.propertyNode.execute(frameValue);
        if ((state & 0x1F) != 0) {
            if ((state & 1) != 0 && JSTypes.isDynamicObject(targetNodeValue_)) {
                targetNodeValue__ = (DynamicObject)targetNodeValue_;
                JSObjectData s1_ = this.jSObject_cache;
                if (s1_ != null && JSGuards.isJSType(targetNodeValue__)) {
                    return this.doJSObject((DynamicObject)targetNodeValue__, propertyNodeValue_, s1_.isArrayNode_, s1_.arrayProfile_, s1_.toArrayIndexNode_, s1_.arrayIndexProfile_, s1_.arrayTypeProfile_, s1_.jsclassProfile_, s1_.toPropertyKeyNode_);
                }
            }
            if ((state & 2) != 0 && targetNodeValue_ instanceof Symbol) {
                targetNodeValue__ = (Symbol)targetNodeValue_;
                return DeletePropertyNode.doSymbol((Symbol)targetNodeValue__, propertyNodeValue_);
            }
            if ((state & 4) != 0 && targetNodeValue_ instanceof LargeInteger) {
                targetNodeValue__ = (LargeInteger)targetNodeValue_;
                return DeletePropertyNode.doLargeInteger((LargeInteger)targetNodeValue__, propertyNodeValue_);
            }
            if ((state & 8) != 0 && targetNodeValue_ instanceof BigInt) {
                targetNodeValue__ = (BigInt)targetNodeValue_;
                return DeletePropertyNode.doBigInt((BigInt)targetNodeValue__, propertyNodeValue_);
            }
            if ((state & 0x10) != 0 && JSTypesGen.isImplicitString((state & 0x3C00) >>> 10, targetNodeValue_)) {
                targetNodeValue__ = JSTypesGen.asImplicitString((state & 0x3C00) >>> 10, targetNodeValue_);
                return DeletePropertyNode.doString((String)targetNodeValue__, propertyNodeValue_, this.string_toArrayIndexNode_);
            }
        }
        if ((state & 0xE0) != 0 && targetNodeValue_ instanceof TruffleObject) {
            targetNodeValue__ = (TruffleObject)targetNodeValue_;
            if ((state & 0x20) != 0 && JSTypesGen.isImplicitString((state & 0x3C000) >>> 14, propertyNodeValue_)) {
                String propertyNodeValue__ = JSTypesGen.asImplicitString((state & 0x3C000) >>> 14, propertyNodeValue_);
                if (JSGuards.isForeignObject((TruffleObject)targetNodeValue__)) {
                    return this.member((TruffleObject)targetNodeValue__, propertyNodeValue__, this.interop);
                }
            }
            if ((state & 0x40) != 0 && propertyNodeValue_ instanceof Integer) {
                int propertyNodeValue__ = (Integer)propertyNodeValue_;
                if (JSGuards.isForeignObject((TruffleObject)targetNodeValue__)) {
                    return this.arrayElementInt((TruffleObject)targetNodeValue__, propertyNodeValue__, this.interop);
                }
            }
            if ((state & 0x80) != 0 && propertyNodeValue_ instanceof Number) {
                Number propertyNodeValue__ = (Number)propertyNodeValue_;
                if (JSGuards.isForeignObject((TruffleObject)targetNodeValue__) && JSGuards.isNumber(propertyNodeValue__)) {
                    return this.arrayElement((TruffleObject)targetNodeValue__, propertyNodeValue__, this.interop);
                }
            }
        }
        if ((state & 0x200) != 0 && !JSGuards.isTruffleObject(targetNodeValue_) && !JSGuards.isString(targetNodeValue_)) {
            return this.doOther(targetNodeValue_, propertyNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectBoolean(this.executeAndSpecialize(targetNodeValue_, propertyNodeValue_));
    }

    @Override
    public boolean executeEvaluated(TruffleObject targetNodeValue, Object propertyNodeValue) {
        int state = this.state_;
        if ((state & 0xF) != 0) {
            Object targetNodeValue_;
            if ((state & 1) != 0 && JSTypes.isDynamicObject(targetNodeValue)) {
                targetNodeValue_ = (DynamicObject)targetNodeValue;
                JSObjectData s1_ = this.jSObject_cache;
                if (s1_ != null && JSGuards.isJSType(targetNodeValue_)) {
                    return this.doJSObject((DynamicObject)targetNodeValue_, propertyNodeValue, s1_.isArrayNode_, s1_.arrayProfile_, s1_.toArrayIndexNode_, s1_.arrayIndexProfile_, s1_.arrayTypeProfile_, s1_.jsclassProfile_, s1_.toPropertyKeyNode_);
                }
            }
            if ((state & 2) != 0 && targetNodeValue instanceof Symbol) {
                targetNodeValue_ = (Symbol)targetNodeValue;
                return DeletePropertyNode.doSymbol((Symbol)targetNodeValue_, propertyNodeValue);
            }
            if ((state & 4) != 0 && targetNodeValue instanceof LargeInteger) {
                targetNodeValue_ = (LargeInteger)targetNodeValue;
                return DeletePropertyNode.doLargeInteger((LargeInteger)targetNodeValue_, propertyNodeValue);
            }
            if ((state & 8) != 0 && targetNodeValue instanceof BigInt) {
                targetNodeValue_ = (BigInt)targetNodeValue;
                return DeletePropertyNode.doBigInt((BigInt)targetNodeValue_, propertyNodeValue);
            }
        }
        if ((state & 0xE0) != 0) {
            if ((state & 0x20) != 0 && JSTypesGen.isImplicitString((state & 0x3C000) >>> 14, propertyNodeValue)) {
                String propertyNodeValue_ = JSTypesGen.asImplicitString((state & 0x3C000) >>> 14, propertyNodeValue);
                if (JSGuards.isForeignObject(targetNodeValue)) {
                    return this.member(targetNodeValue, propertyNodeValue_, this.interop);
                }
            }
            if ((state & 0x40) != 0 && propertyNodeValue instanceof Integer) {
                int propertyNodeValue_ = (Integer)propertyNodeValue;
                if (JSGuards.isForeignObject(targetNodeValue)) {
                    return this.arrayElementInt(targetNodeValue, propertyNodeValue_, this.interop);
                }
            }
            if ((state & 0x80) != 0 && propertyNodeValue instanceof Number) {
                Number propertyNodeValue_ = (Number)propertyNodeValue;
                if (JSGuards.isForeignObject(targetNodeValue) && JSGuards.isNumber(propertyNodeValue_)) {
                    return this.arrayElement(targetNodeValue, propertyNodeValue_, this.interop);
                }
            }
        }
        if ((state & 0x200) != 0 && !JSGuards.isTruffleObject(targetNodeValue) && !JSGuards.isString(targetNodeValue)) {
            return this.doOther(targetNodeValue, propertyNodeValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return (Boolean)this.executeAndSpecialize(targetNodeValue, propertyNodeValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 0x100) == 0 && (state & 0x3FF) != 0) {
                this.executeBoolean(frameValue);
                return;
            }
            this.executeBoolean(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    private Object executeAndSpecialize(Object targetNodeValue, Object propertyNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            Object targetNodeValue_;
            if (JSTypes.isDynamicObject(targetNodeValue) && JSGuards.isJSType(targetNodeValue_ = (DynamicObject)targetNodeValue)) {
                JSObjectData s1_ = (JSObjectData)super.insert((Node)new JSObjectData());
                s1_.isArrayNode_ = s1_.insertAccessor(IsArrayNode.createIsFastArray());
                s1_.arrayProfile_ = ConditionProfile.createBinaryProfile();
                s1_.toArrayIndexNode_ = s1_.insertAccessor(ToArrayIndexNode.create());
                s1_.arrayIndexProfile_ = ConditionProfile.createBinaryProfile();
                s1_.arrayTypeProfile_ = ValueProfile.createClassProfile();
                s1_.jsclassProfile_ = JSClassProfile.create();
                s1_.toPropertyKeyNode_ = s1_.insertAccessor(JSToPropertyKeyNode.create());
                this.jSObject_cache = s1_;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Boolean bl = this.doJSObject((DynamicObject)targetNodeValue_, propertyNodeValue, s1_.isArrayNode_, s1_.arrayProfile_, s1_.toArrayIndexNode_, s1_.arrayIndexProfile_, s1_.arrayTypeProfile_, s1_.jsclassProfile_, s1_.toPropertyKeyNode_);
                return bl;
            }
            if (targetNodeValue instanceof Symbol) {
                targetNodeValue_ = (Symbol)targetNodeValue;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Boolean s1_ = DeletePropertyNode.doSymbol((Symbol)targetNodeValue_, propertyNodeValue);
                return s1_;
            }
            if (targetNodeValue instanceof LargeInteger) {
                targetNodeValue_ = (LargeInteger)targetNodeValue;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Boolean s1_ = DeletePropertyNode.doLargeInteger((LargeInteger)targetNodeValue_, propertyNodeValue);
                return s1_;
            }
            if (targetNodeValue instanceof BigInt) {
                targetNodeValue_ = (BigInt)targetNodeValue;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                Boolean s1_ = DeletePropertyNode.doBigInt((BigInt)targetNodeValue_, propertyNodeValue);
                return s1_;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(targetNodeValue);
            if (stringCast0 != 0) {
                String targetNodeValue_2 = JSTypesGen.asImplicitString(stringCast0, targetNodeValue);
                this.string_toArrayIndexNode_ = (ToArrayIndexNode)super.insert((Node)ToArrayIndexNode.create());
                state |= stringCast0 << 10;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                Boolean bl = DeletePropertyNode.doString(targetNodeValue_2, propertyNodeValue, this.string_toArrayIndexNode_);
                return bl;
            }
            if (targetNodeValue instanceof TruffleObject) {
                Boolean bl;
                TruffleObject targetNodeValue_3 = (TruffleObject)targetNodeValue;
                int stringCast1 = JSTypesGen.specializeImplicitString(propertyNodeValue);
                if (stringCast1 != 0) {
                    String propertyNodeValue_ = JSTypesGen.asImplicitString(stringCast1, propertyNodeValue);
                    if (JSGuards.isForeignObject(targetNodeValue_3)) {
                        if (this.interop == null) {
                            this.interop = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3)));
                        }
                        state |= stringCast1 << 14;
                        this.state_ = state |= 0x20;
                        lock.unlock();
                        hasLock = false;
                        Boolean bl2 = this.member(targetNodeValue_3, propertyNodeValue_, this.interop);
                        return bl2;
                    }
                }
                if (exclude == 0 && propertyNodeValue instanceof Integer) {
                    int propertyNodeValue_ = (Integer)propertyNodeValue;
                    if (JSGuards.isForeignObject(targetNodeValue_3)) {
                        if (this.interop == null) {
                            this.interop = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3)));
                        }
                        this.state_ = state |= 0x40;
                        lock.unlock();
                        hasLock = false;
                        bl = this.arrayElementInt(targetNodeValue_3, propertyNodeValue_, this.interop);
                        return bl;
                    }
                }
                if (propertyNodeValue instanceof Number) {
                    Number propertyNodeValue_ = (Number)propertyNodeValue;
                    if (JSGuards.isForeignObject(targetNodeValue_3) && JSGuards.isNumber(propertyNodeValue_)) {
                        if (this.interop == null) {
                            this.interop = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3)));
                        }
                        this.exclude_ = exclude |= 1;
                        state &= 0xFFFFFFBF;
                        this.state_ = state |= 0x80;
                        lock.unlock();
                        hasLock = false;
                        bl = this.arrayElement(targetNodeValue_3, propertyNodeValue_, this.interop);
                        return bl;
                    }
                }
                if (JSGuards.isForeignObject(targetNodeValue_3) && !JSGuards.isString(propertyNodeValue) && !JSGuards.isNumber(propertyNodeValue)) {
                    if (this.interop == null) {
                        this.interop = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3)));
                    }
                    this.foreignObject_interopKey_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3)));
                    this.state_ = state |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.foreignObject(targetNodeValue_3, propertyNodeValue, this.interop, this.foreignObject_interopKey_);
                    return object;
                }
            }
            if (!JSGuards.isTruffleObject(targetNodeValue) && !JSGuards.isString(targetNodeValue)) {
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                Boolean bl = this.doOther(targetNodeValue, propertyNodeValue);
                return bl;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.targetNode, this.propertyNode}, new Object[]{targetNodeValue, propertyNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x3FF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x3FF & (state & 0x3FF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[11];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doJSObject";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            JSObjectData s1_ = this.jSObject_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s1_.isArrayNode_, s1_.arrayProfile_, s1_.toArrayIndexNode_, s1_.arrayIndexProfile_, s1_.arrayTypeProfile_, s1_.jsclassProfile_, s1_.toPropertyKeyNode_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doLargeInteger";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doString";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.string_toArrayIndexNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "member";
        if ((state & 0x20) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.interop));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "arrayElementInt";
        if ((state & 0x40) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.interop));
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "arrayElement";
        if ((state & 0x80) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.interop));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "foreignObject";
        if ((state & 0x100) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.interop, this.foreignObject_interopKey_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doOther";
        s[1] = (state & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static DeletePropertyNode create(boolean strict, JSContext context, JavaScriptNode targetNode, JavaScriptNode propertyNode) {
        return new DeletePropertyNodeGen(strict, context, targetNode, propertyNode);
    }

    @GeneratedBy(value=DeletePropertyNode.class)
    private static final class JSObjectData
    extends Node {
        @Node.Child
        IsArrayNode isArrayNode_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile arrayProfile_;
        @Node.Child
        ToArrayIndexNode toArrayIndexNode_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile arrayIndexProfile_;
        @CompilerDirectives.CompilationFinal
        ValueProfile arrayTypeProfile_;
        @CompilerDirectives.CompilationFinal
        JSClassProfile jsclassProfile_;
        @Node.Child
        JSToPropertyKeyNode toPropertyKeyNode_;

        JSObjectData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

