/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.function.DefineMethodNodeFactory;
import com.oracle.truffle.js.nodes.function.JSFunctionExpressionNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionFactory;

public class DefineMethodNode
extends JavaScriptBaseNode {
    private final JSFunctionData functionData;
    @Node.Child
    private FunctionCreateNode functionCreateNode;
    @Node.Child
    private PropertySetNode makeMethodNode;

    protected DefineMethodNode(JSContext context, JSFunctionData functionData) {
        this.functionData = functionData;
        this.functionCreateNode = FunctionCreateNode.create(context, functionData);
        this.makeMethodNode = PropertySetNode.createSetHidden(JSFunction.HOME_OBJECT_ID, context);
    }

    public static DefineMethodNode create(JSContext context, JSFunctionExpressionNode functionExpressionNode) {
        return new DefineMethodNode(context, functionExpressionNode.functionData);
    }

    public JSFunctionData getFunctionData() {
        return this.functionData;
    }

    public DynamicObject execute(VirtualFrame frame, DynamicObject homeObject, DynamicObject functionPrototype) {
        assert (JSRuntime.isObject(functionPrototype));
        assert (JSRuntime.isObject(homeObject));
        DynamicObject closure = this.functionCreateNode.executeWithPrototype(frame, functionPrototype);
        this.makeMethodNode.setValue(closure, homeObject);
        return closure;
    }

    @ImportStatic(value={JSTruffleOptions.class})
    protected static abstract class FunctionCreateNode
    extends JavaScriptBaseNode {
        private final JSFunctionData functionData;

        protected FunctionCreateNode(JSContext context, JSFunctionData functionData) {
            assert (context == functionData.getContext());
            this.functionData = functionData;
        }

        public static FunctionCreateNode create(JSContext context, JSFunctionData functionData) {
            return DefineMethodNodeFactory.FunctionCreateNodeGen.create(context, functionData);
        }

        public abstract DynamicObject executeWithPrototype(VirtualFrame var1, Object var2);

        @Specialization(guards={"!getContext().isMultiContext()", "prototype == cachedPrototype", "isJSObject(cachedPrototype)"}, limit="PropertyCacheLimit")
        protected final DynamicObject doCached(VirtualFrame frame, DynamicObject prototype, @Cached(value="prototype") DynamicObject cachedPrototype, @Cached(value="makeFactory(prototype)") JSFunctionFactory factory) {
            return this.makeFunction(frame, factory, cachedPrototype);
        }

        @Specialization(guards={"!getContext().isMultiContext()", "isJSObject(prototype)"}, replaces={"doCached"})
        protected final DynamicObject doUncached(VirtualFrame frame, DynamicObject prototype) {
            JSFunctionFactory factory = this.makeFactory(prototype);
            return this.makeFunction(frame, factory, prototype);
        }

        @Specialization(guards={"getContext().isMultiContext()", "isJSObject(prototype)"})
        protected final DynamicObject doMultiContext(VirtualFrame frame, DynamicObject prototype, @Cached(value="makeFactoryMultiContext()") JSFunctionFactory factory) {
            return this.makeFunction(frame, factory, prototype);
        }

        @CompilerDirectives.TruffleBoundary
        protected final JSFunctionFactory makeFactory(DynamicObject prototype) {
            return JSFunctionFactory.create(this.getContext(), JSFunction.makeInitialFunctionShape(this.getContext(), prototype, true, this.functionData.getName().isEmpty(), true, this.functionData.isPrototypeNotWritable()).createFactory());
        }

        protected final JSFunctionFactory makeFactoryMultiContext() {
            return this.makeFactory(null);
        }

        protected final DynamicObject makeFunction(VirtualFrame frame, JSFunctionFactory factory, DynamicObject prototype) {
            MaterializedFrame enclosingFrame = this.functionData.needsParentFrame() ? frame.materialize() : JSFrameUtil.NULL_MATERIALIZED_FRAME;
            return JSFunction.createWithPrototype(factory, this.getContext().getRealm(), this.functionData, enclosingFrame, prototype);
        }

        final JSContext getContext() {
            return this.functionData.getContext();
        }

        @Specialization(guards={"!isJSObject(prototype)"})
        protected final DynamicObject doNonObject(Object prototype) {
            throw Errors.createTypeError("functionPrototype not an object", this);
        }
    }
}

