/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.unary.IsIdenticalBaseNode;
import com.oracle.truffle.js.nodes.unary.IsIdenticalStringNodeGen;
import com.oracle.truffle.js.runtime.objects.JSLazyString;

public abstract class IsIdenticalStringNode
extends IsIdenticalBaseNode {
    protected final String string;

    protected IsIdenticalStringNode(String string, JavaScriptNode operand, boolean leftConstant) {
        super(operand, leftConstant);
        this.string = string;
    }

    @Specialization
    protected boolean doLazyString(JSLazyString other, @Cached(value="createBinaryProfile()") ConditionProfile flatten, @Cached(value="createBinaryProfile()") ConditionProfile len) {
        if (len.profile(other.length() != this.string.length())) {
            return false;
        }
        return this.string.equals(other.toString(flatten));
    }

    @Specialization
    protected boolean doString(String other) {
        return this.string.equals(other);
    }

    @Fallback
    protected boolean doOther(Object other) {
        return false;
    }

    public static IsIdenticalStringNode create(String string, JavaScriptNode operand, boolean leftConstant) {
        return IsIdenticalStringNodeGen.create(string, operand, leftConstant);
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return IsIdenticalStringNode.create(this.string, IsIdenticalStringNode.cloneUninitialized(this.getOperand()), this.leftConstant);
    }

    @Override
    protected Object getConstantValue() {
        return this.string;
    }
}

