/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.unary.JSUnaryMinusNodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSTruffleOptions;

@NodeInfo(shortName="-")
public abstract class JSUnaryMinusNode
extends JSUnaryNode {
    protected JSUnaryMinusNode(JavaScriptNode operand) {
        super(operand);
    }

    public static JavaScriptNode create(JavaScriptNode operand) {
        if (JSTruffleOptions.UseSuperOperations && operand instanceof JSConstantNode.JSConstantIntegerNode) {
            int value = ((JSConstantNode.JSConstantIntegerNode)operand).executeInt(null);
            if (value == 0) {
                return JSConstantNode.createDouble(-0.0);
            }
            return JSConstantNode.createInt(-value);
        }
        return JSUnaryMinusNodeGen.create(operand);
    }

    protected static JSUnaryMinusNode create() {
        return JSUnaryMinusNodeGen.create(null);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.UnaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("operator", ((Object)((Object)this)).getClass().getAnnotation(NodeInfo.class).shortName());
    }

    public abstract Object execute(Object var1);

    @Specialization(guards={"isInt(a)"})
    protected static int doInt(int a) {
        return -a;
    }

    protected static boolean isInt(int a) {
        return a > Integer.MIN_VALUE && a != 0;
    }

    @Specialization
    protected static double doDouble(double a) {
        return -a;
    }

    @Specialization
    protected static BigInt doBigInt(BigInt a) {
        return a.negate();
    }

    @Specialization
    protected static Object doGeneric(Object a, @Cached(value="create()") JSToNumericNode toNumericNode, @Cached(value="create()") JSUnaryMinusNode recursiveUnaryMinus) {
        Object value = toNumericNode.execute(a);
        return recursiveUnaryMinus.execute(value);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == Number.class;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return JSUnaryMinusNodeGen.create(JSUnaryMinusNode.cloneUninitialized(this.getOperand()));
    }
}

