/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser;

import com.oracle.js.parser.JSErrorType;
import com.oracle.js.parser.ParserException;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.ScriptNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.EvalNode;
import com.oracle.truffle.js.nodes.function.FunctionRootNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.parser.BinarySnapshotProvider;
import com.oracle.truffle.js.parser.GraalJSParserHelper;
import com.oracle.truffle.js.parser.JSParser;
import com.oracle.truffle.js.parser.JavaScriptTranslator;
import com.oracle.truffle.js.parser.SnapshotProvider;
import com.oracle.truffle.js.parser.date.DateParser;
import com.oracle.truffle.js.parser.env.DebugEnvironment;
import com.oracle.truffle.js.parser.env.Environment;
import com.oracle.truffle.js.parser.env.EvalEnvironment;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSParserOptions;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespace;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.function.Supplier;

public final class GraalJSEvaluator
implements JSParser {
    @Override
    public Object evaluate(JSRealm realm, Node lastNode, Source source) {
        DynamicObject thisObj = realm.getGlobalObject();
        return GraalJSEvaluator.doEvaluate(realm, lastNode, null, thisObj, JSFrameUtil.NULL_MATERIALIZED_FRAME, source, false);
    }

    @Override
    public ScriptNode parseFunction(JSContext context, String parameterList, String body, boolean generatorFunction, boolean asyncFunction, String sourceName) {
        try {
            GraalJSParserHelper.checkFunctionSyntax(context, context.getParserOptions(), parameterList, body, generatorFunction, asyncFunction);
        }
        catch (ParserException e) {
            throw GraalJSEvaluator.parserToJSError(null, e);
        }
        StringBuilder code = new StringBuilder();
        if (asyncFunction) {
            code.append("(async function");
        } else {
            code.append("(function");
        }
        if (generatorFunction) {
            code.append("*");
        }
        if (context.getEcmaScriptVersion() >= 6) {
            code.append(" anonymous");
        }
        if (JSTruffleOptions.NashornCompatibilityMode) {
            code.append(' ');
        }
        code.append('(');
        code.append(parameterList);
        if (!JSTruffleOptions.NashornCompatibilityMode) {
            code.append('\n');
        }
        code.append(") {");
        code.append('\n');
        code.append(body);
        code.append('\n');
        code.append("})");
        Source source = Source.newBuilder((String)"js", (CharSequence)code.toString(), (String)sourceName).build();
        return GraalJSEvaluator.parseEval(context, null, null, source, false);
    }

    @Override
    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    public Object evaluate(JSRealm realm, Node lastNode, Source source, Object currEnvironment, MaterializedFrame frame, Object thisObj) {
        assert (currEnvironment != null);
        assert (currEnvironment instanceof Environment);
        assert (frame != null);
        Environment outerEnv = (Environment)currEnvironment;
        return GraalJSEvaluator.doEvaluate(realm, lastNode, outerEnv, thisObj, frame.materialize(), source, outerEnv.isStrictMode());
    }

    @Override
    public JavaScriptNode parseInlineScript(final JSContext context, Source source, Environment env, boolean isStrict) {
        ScriptNode script = JavaScriptTranslator.translateInlineScript(NodeFactory.getInstance(context), context, env, source, isStrict);
        final RootCallTarget callTarget = script.getCallTarget();
        final JSFunctionData functionData = script.getFunctionData();
        return new JavaScriptNode(){
            @Node.Child
            DirectCallNode callNode;
            {
                this.callNode = DirectCallNode.create((CallTarget)callTarget);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                DynamicObject closure = JSFunction.create(context.getRealm(), functionData, frame.materialize());
                return this.callNode.call(JSArguments.createZeroArg(JSFrameUtil.getThisObj((Frame)frame), closure));
            }
        };
    }

    @CompilerDirectives.TruffleBoundary
    private static Object doEvaluate(JSRealm realm, Node lastNode, Environment env, Object thisObj, MaterializedFrame materializedFrame, Source source, boolean isStrict) {
        JSContext context = realm.getContext();
        ScriptNode scriptNode = GraalJSEvaluator.parseEval(context, lastNode, env, source, isStrict);
        return GraalJSEvaluator.runParsed(scriptNode, realm, thisObj, materializedFrame);
    }

    private static Object runParsed(ScriptNode scriptNode, JSRealm realm, Object thisObj, MaterializedFrame materializedFrame) {
        DynamicObject functionObj = JSFunction.create(realm, scriptNode.getFunctionData(), materializedFrame);
        return scriptNode.run(JSArguments.createZeroArg(thisObj, functionObj));
    }

    private static ScriptNode parseEval(JSContext context, Node lastNode, Environment env, Source source, boolean isStrict) {
        context.checkEvalAllowed();
        NodeFactory nodeFactory = NodeFactory.getInstance(context);
        EvalEnvironment evalEnv = new EvalEnvironment(env, nodeFactory, context, env != null);
        try {
            return JavaScriptTranslator.translateEvalScript(nodeFactory, context, evalEnv, source, isStrict);
        }
        catch (ParserException e) {
            throw GraalJSEvaluator.parserToJSError(lastNode, e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException parserToJSError(Node lastNode, ParserException e) {
        String message = e.getMessage().replace("\r\n", "\n");
        if (e.getErrorType() == JSErrorType.ReferenceError) {
            return Errors.createReferenceError(message, e, lastNode);
        }
        assert (e.getErrorType() == JSErrorType.SyntaxError);
        if (JSTruffleOptions.NashornCompatibilityMode && lastNode instanceof EvalNode) {
            SourceSection sourceSection = lastNode.getSourceSection();
            String name = sourceSection.getSource().getName();
            int lineNumber = sourceSection.getStartLine();
            int columnNumber = sourceSection.getStartColumn() - 1;
            message = name + '#' + lineNumber + ':' + columnNumber + message;
        }
        return Errors.createSyntaxError(message, e, lastNode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public ScriptNode evalCompile(JSContext context, String sourceCode, String name) {
        try {
            context.checkEvalAllowed();
            return JavaScriptTranslator.translateScript(NodeFactory.getInstance(context), context, Source.newBuilder((String)"js", (CharSequence)sourceCode, (String)name).build(), false);
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e.getMessage());
        }
    }

    @Override
    public Object parseJSON(JSContext context, String jsonString) {
        CompilerAsserts.neverPartOfCompilation();
        return GraalJSParserHelper.parseJSON(jsonString, context);
    }

    @Override
    public ScriptNode parseScriptNode(JSContext context, Source source) {
        if ("application/javascript+module".equals(source.getMimeType()) || source.getName().endsWith(".mjs")) {
            return this.fakeScriptForModule(context, source);
        }
        try {
            return JavaScriptTranslator.translateScript(NodeFactory.getInstance(context), context, source, context.getParserOptions().isStrict());
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e.getMessage());
        }
    }

    private ScriptNode fakeScriptForModule(JSContext context, final Source source) {
        JavaScriptRootNode rootNode = new JavaScriptRootNode(context.getLanguage(), JSBuiltin.createSourceSection(), null){

            public Object execute(VirtualFrame frame) {
                JSRealm realm = JSFunction.getRealm(JSFrameUtil.getFunctionObject((Frame)frame));
                return this.evalModule(realm);
            }

            @CompilerDirectives.TruffleBoundary
            private Object evalModule(JSRealm realm) {
                JSModuleRecord moduleRecord = realm.getModuleLoader().loadModule(source);
                GraalJSEvaluator.this.moduleInstantiation(moduleRecord);
                return GraalJSEvaluator.this.moduleEvaluation(realm, moduleRecord);
            }
        };
        JSFunctionData functionData = JSFunctionData.createCallOnly(context, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)rootNode), 0, "");
        return ScriptNode.fromFunctionData(context, functionData);
    }

    @Override
    public ScriptNode parseScriptNode(JSContext context, String sourceCode) {
        try {
            return JavaScriptTranslator.translateScript(NodeFactory.getInstance(context), context, Source.newBuilder((String)"js", (CharSequence)sourceCode, (String)"<unknown>").build(), false);
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e.getMessage());
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Integer[] parseDate(JSRealm realm, String date) {
        DateParser dateParser = new DateParser(realm, date);
        return dateParser.parse() ? dateParser.getDateFields() : null;
    }

    @Override
    public String parseToJSON(JSContext context, String code, String name, boolean includeLoc) {
        return GraalJSParserHelper.parseToJSON(code, name, includeLoc, context.getParserOptions());
    }

    @Override
    public Object getDefaultNodeFactory() {
        return NodeFactory.getDefaultInstance();
    }

    public static Supplier<ScriptNode> internalParseForTiming(JSContext context, Source source) {
        FunctionNode ast = GraalJSParserHelper.parseScript(context, source, new JSParserOptions());
        return () -> JavaScriptTranslator.translateFunction(NodeFactory.getInstance(context), context, null, source, false, ast);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JSModuleRecord parseModule(JSContext context, Source source, JSModuleLoader moduleLoader) {
        try {
            return JavaScriptTranslator.translateModule(NodeFactory.getInstance(context), context, source, moduleLoader);
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e.getMessage(), e, null);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JSModuleRecord hostResolveImportedModule(JSContext context, ScriptOrModule referrer, String specifier) {
        JSModuleLoader moduleLoader = referrer instanceof JSModuleRecord ? ((JSModuleRecord)referrer).getModuleLoader() : context.getRealm().getModuleLoader();
        return moduleLoader.resolveImportedModule(referrer, specifier);
    }

    private static JSModuleRecord hostResolveImportedModule(JSModuleRecord referencingModule, String specifier) {
        return referencingModule.getModuleLoader().resolveImportedModule(referencingModule, specifier);
    }

    Collection<String> getExportedNames(JSModuleRecord moduleRecord) {
        return this.getExportedNames(moduleRecord, new HashSet<JSModuleRecord>());
    }

    private Collection<String> getExportedNames(JSModuleRecord moduleRecord, Set<JSModuleRecord> exportStarSet) {
        if (exportStarSet.contains(moduleRecord)) {
            return Collections.emptySortedSet();
        }
        exportStarSet.add(moduleRecord);
        HashSet<String> exportedNames = new HashSet<String>();
        Module module = (Module)moduleRecord.getModule();
        for (Module.ExportEntry exportEntry : module.getLocalExportEntries()) {
            exportedNames.add(exportEntry.getExportName());
        }
        for (Module.ExportEntry exportEntry : module.getIndirectExportEntries()) {
            exportedNames.add(exportEntry.getExportName());
        }
        for (Module.ExportEntry exportEntry : module.getStarExportEntries()) {
            JSModuleRecord requestedModule = GraalJSEvaluator.hostResolveImportedModule(moduleRecord, exportEntry.getModuleRequest());
            Collection<String> starNames = this.getExportedNames(requestedModule, exportStarSet);
            for (String starName : starNames) {
                if (starName.equals("default") || exportedNames.contains(starName)) continue;
                exportedNames.add(starName);
            }
        }
        return exportedNames;
    }

    public ExportResolution resolveExport(JSModuleRecord referencingModule, String exportName) {
        return this.resolveExport(referencingModule, exportName, new HashSet<Pair<JSModuleRecord, String>>());
    }

    private ExportResolution resolveExport(JSModuleRecord referencingModule, String exportName, Set<Pair<JSModuleRecord, String>> resolveSet) {
        Pair<JSModuleRecord, String> resolved = new Pair<JSModuleRecord, String>(referencingModule, exportName);
        if (resolveSet.contains(resolved)) {
            return ExportResolution.notFound();
        }
        resolveSet.add(resolved);
        Module module = (Module)referencingModule.getModule();
        for (Module.ExportEntry exportEntry : module.getLocalExportEntries()) {
            if (!exportEntry.getExportName().equals(exportName)) continue;
            return ExportResolution.resolved(referencingModule, exportEntry.getLocalName());
        }
        for (Module.ExportEntry exportEntry : module.getIndirectExportEntries()) {
            JSModuleRecord importedModule;
            ExportResolution indirectResolution;
            if (!exportEntry.getExportName().equals(exportName) || (indirectResolution = this.resolveExport(importedModule = GraalJSEvaluator.hostResolveImportedModule(referencingModule, exportEntry.getModuleRequest()), exportEntry.getImportName(), resolveSet)).isNull()) continue;
            return indirectResolution;
        }
        if (exportName.equals("default")) {
            throw Errors.createSyntaxError("A default export cannot be provided by an export *");
        }
        ExportResolution starResolution = ExportResolution.notFound();
        for (Module.ExportEntry exportEntry : module.getStarExportEntries()) {
            JSModuleRecord importedModule = GraalJSEvaluator.hostResolveImportedModule(referencingModule, exportEntry.getModuleRequest());
            ExportResolution resolution = this.resolveExport(importedModule, exportName, resolveSet);
            if (resolution.isAmbiguous()) {
                return resolution;
            }
            if (resolution.isNull()) continue;
            if (starResolution.isNull()) {
                starResolution = resolution;
                continue;
            }
            if (resolution.equals(starResolution)) continue;
            return ExportResolution.ambiguous();
        }
        return starResolution;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public DynamicObject getModuleNamespace(JSModuleRecord moduleRecord) {
        if (moduleRecord.getNamespace() != null) {
            return moduleRecord.getNamespace();
        }
        assert (moduleRecord.getStatus() != JSModuleRecord.Status.Uninstantiated);
        Collection<String> exportedNames = this.getExportedNames(moduleRecord);
        ArrayList<Pair<String, ExportResolution>> unambiguousNames = new ArrayList<Pair<String, ExportResolution>>();
        for (String exportedName : exportedNames) {
            ExportResolution resolution = this.resolveExport(moduleRecord, exportedName);
            if (resolution.isNull()) {
                throw Errors.createSyntaxError("Could not resolve export");
            }
            if (resolution.isAmbiguous()) continue;
            unambiguousNames.add(new Pair<String, ExportResolution>(exportedName, resolution));
        }
        LinkedHashMap<String, ExportResolution> sortedNames = new LinkedHashMap<String, ExportResolution>();
        unambiguousNames.stream().sorted(Comparator.comparing(Pair::getFirst)).forEachOrdered(p -> sortedNames.put((String)p.getFirst(), (ExportResolution)p.getSecond()));
        DynamicObject namespace = JSModuleNamespace.create(moduleRecord.getContext(), moduleRecord, sortedNames);
        moduleRecord.setNamespace(namespace);
        return namespace;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void moduleInstantiation(JSModuleRecord moduleRecord) {
        assert (moduleRecord.getStatus() != JSModuleRecord.Status.Instantiating && moduleRecord.getStatus() != JSModuleRecord.Status.Evaluating);
        ArrayDeque<JSModuleRecord> stack = new ArrayDeque<JSModuleRecord>(4);
        try {
            this.innerModuleInstantiation(moduleRecord, stack, 0);
        }
        catch (GraalJSException e) {
            for (JSModuleRecord m : stack) {
                assert (m.getStatus() == JSModuleRecord.Status.Instantiating);
                m.setUninstantiated();
            }
            assert (moduleRecord.getStatus() == JSModuleRecord.Status.Uninstantiated);
            throw e;
        }
        assert (moduleRecord.getStatus() == JSModuleRecord.Status.Instantiated || moduleRecord.getStatus() == JSModuleRecord.Status.Evaluated);
        assert (stack.isEmpty());
    }

    private int innerModuleInstantiation(JSModuleRecord moduleRecord, Deque<JSModuleRecord> stack, int index0) {
        int index;
        block8: {
            JSModuleRecord requiredModule;
            index = index0;
            if (moduleRecord.getStatus() == JSModuleRecord.Status.Instantiating || moduleRecord.getStatus() == JSModuleRecord.Status.Instantiated || moduleRecord.getStatus() == JSModuleRecord.Status.Evaluated) {
                return index;
            }
            assert (moduleRecord.getStatus() == JSModuleRecord.Status.Uninstantiated);
            moduleRecord.setStatus(JSModuleRecord.Status.Instantiating);
            moduleRecord.setDFSIndex(index);
            moduleRecord.setDFSAncestorIndex(index);
            ++index;
            stack.push(moduleRecord);
            Module module = (Module)moduleRecord.getModule();
            for (String requestedModule : module.getRequestedModules()) {
                JSModuleRecord requiredModule2 = GraalJSEvaluator.hostResolveImportedModule(moduleRecord, requestedModule);
                index = this.innerModuleInstantiation(requiredModule2, stack, index);
                assert (requiredModule2.getStatus() == JSModuleRecord.Status.Instantiating || requiredModule2.getStatus() == JSModuleRecord.Status.Instantiated || requiredModule2.getStatus() == JSModuleRecord.Status.Evaluated) : requiredModule2.getStatus();
                assert (requiredModule2.getStatus() == JSModuleRecord.Status.Instantiating == stack.contains(requiredModule2));
                if (requiredModule2.getStatus() != JSModuleRecord.Status.Instantiating) continue;
                moduleRecord.setDFSAncestorIndex(Math.min(moduleRecord.getDFSAncestorIndex(), requiredModule2.getDFSAncestorIndex()));
            }
            this.moduleDeclarationEnvironmentSetup(moduleRecord);
            assert (GraalJSEvaluator.occursExactlyOnce(moduleRecord, stack));
            assert (moduleRecord.getDFSAncestorIndex() <= moduleRecord.getDFSIndex());
            if (moduleRecord.getDFSAncestorIndex() != moduleRecord.getDFSIndex()) break block8;
            do {
                requiredModule = stack.pop();
                requiredModule.setStatus(JSModuleRecord.Status.Instantiated);
            } while (!requiredModule.equals(moduleRecord));
        }
        return index;
    }

    private void moduleDeclarationEnvironmentSetup(JSModuleRecord moduleRecord) {
        assert (moduleRecord.getStatus() == JSModuleRecord.Status.Instantiating);
        Module module = (Module)moduleRecord.getModule();
        for (Module.ExportEntry exportEntry : module.getIndirectExportEntries()) {
            ExportResolution resolution = this.resolveExport(moduleRecord, exportEntry.getExportName());
            if (!resolution.isNull() && !resolution.isAmbiguous()) continue;
            throw Errors.createSyntaxError("Could not resolve indirect export entry");
        }
        for (Module.ImportEntry importEntry : module.getImportEntries()) {
            JSModuleRecord importedModule = GraalJSEvaluator.hostResolveImportedModule(moduleRecord, importEntry.getModuleRequest());
            if (importEntry.getImportName().equals("*")) {
                DynamicObject namespace = this.getModuleNamespace(importedModule);
                assert (JSModuleNamespace.isJSModuleNamespace(namespace));
                continue;
            }
            ExportResolution resolution = this.resolveExport(importedModule, importEntry.getImportName());
            if (!resolution.isNull() && !resolution.isAmbiguous()) continue;
            throw Errors.createSyntaxError("Could not resolve import entry");
        }
        moduleRecord.finishTranslation();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object moduleEvaluation(JSRealm realm, JSModuleRecord moduleRecord) {
        assert (moduleRecord.getStatus() == JSModuleRecord.Status.Instantiated || moduleRecord.getStatus() == JSModuleRecord.Status.Evaluated);
        ArrayDeque<JSModuleRecord> stack = new ArrayDeque<JSModuleRecord>(4);
        try {
            this.innerModuleEvaluation(realm, moduleRecord, stack, 0);
        }
        catch (Throwable e) {
            if (e instanceof TruffleException && TryCatchNode.shouldCatch(e)) {
                for (JSModuleRecord m : stack) {
                    assert (m.getStatus() == JSModuleRecord.Status.Evaluating);
                    m.setStatus(JSModuleRecord.Status.Evaluated);
                    m.setEvaluationError(e);
                }
                assert (moduleRecord.getStatus() == JSModuleRecord.Status.Evaluated && moduleRecord.getEvaluationError() == e);
            }
            throw e;
        }
        assert (moduleRecord.getStatus() == JSModuleRecord.Status.Evaluated && moduleRecord.getEvaluationError() == null);
        assert (stack.isEmpty());
        return moduleRecord.getExecutionResult();
    }

    private int innerModuleEvaluation(JSRealm realm, JSModuleRecord moduleRecord, Deque<JSModuleRecord> stack, int index0) {
        int index;
        block10: {
            JSModuleRecord requiredModule;
            index = index0;
            if (moduleRecord.getStatus() == JSModuleRecord.Status.Evaluated) {
                if (moduleRecord.getEvaluationError() == null) {
                    return index;
                }
                throw JSRuntime.rethrow(moduleRecord.getEvaluationError());
            }
            if (moduleRecord.getStatus() == JSModuleRecord.Status.Evaluating) {
                return index;
            }
            assert (moduleRecord.getStatus() == JSModuleRecord.Status.Instantiated);
            moduleRecord.setStatus(JSModuleRecord.Status.Evaluating);
            moduleRecord.setDFSIndex(index);
            moduleRecord.setDFSAncestorIndex(index);
            ++index;
            stack.push(moduleRecord);
            Module module = (Module)moduleRecord.getModule();
            for (String requestedModule : module.getRequestedModules()) {
                JSModuleRecord requiredModule2 = GraalJSEvaluator.hostResolveImportedModule(moduleRecord, requestedModule);
                index = this.innerModuleEvaluation(realm, requiredModule2, stack, index);
                assert (requiredModule2.getStatus() == JSModuleRecord.Status.Evaluating || requiredModule2.getStatus() == JSModuleRecord.Status.Evaluated) : requiredModule2.getStatus();
                assert (requiredModule2.getStatus() == JSModuleRecord.Status.Evaluating == stack.contains(requiredModule2));
                if (requiredModule2.getStatus() != JSModuleRecord.Status.Evaluating) continue;
                moduleRecord.setDFSAncestorIndex(Math.min(moduleRecord.getDFSAncestorIndex(), requiredModule2.getDFSAncestorIndex()));
            }
            Object result = GraalJSEvaluator.moduleExecution(realm, moduleRecord);
            moduleRecord.setExecutionResult(result);
            assert (GraalJSEvaluator.occursExactlyOnce(moduleRecord, stack));
            assert (moduleRecord.getDFSAncestorIndex() <= moduleRecord.getDFSIndex());
            if (moduleRecord.getDFSAncestorIndex() != moduleRecord.getDFSIndex()) break block10;
            do {
                requiredModule = stack.pop();
                requiredModule.setStatus(JSModuleRecord.Status.Evaluated);
            } while (!requiredModule.equals(moduleRecord));
        }
        return index;
    }

    private static Object moduleExecution(JSRealm realm, JSModuleRecord moduleRecord) {
        return JSFunction.call(JSArguments.create(Undefined.instance, JSFunction.create(realm, moduleRecord.getFunctionData()), moduleRecord));
    }

    private static boolean occursExactlyOnce(JSModuleRecord moduleRecord, Collection<JSModuleRecord> stack) {
        return stack.stream().filter(moduleRecord::equals).count() == 1L;
    }

    @Override
    public ScriptNode parseScriptNode(JSContext context, Source source, ByteBuffer binary) {
        if (binary == null) {
            return this.parseScriptNode(context, source);
        }
        return ScriptNode.fromFunctionRoot(context, (FunctionRootNode)new BinarySnapshotProvider(binary).apply(NodeFactory.getInstance(context), context, source));
    }

    @Override
    public ScriptNode parseScriptNode(JSContext context, Source source, SnapshotProvider snapshotProvider) {
        if (snapshotProvider == null) {
            return this.parseScriptNode(context, source);
        }
        return ScriptNode.fromFunctionRoot(context, (FunctionRootNode)snapshotProvider.apply(NodeFactory.getInstance(context), context, source));
    }

    @Override
    public JavaScriptNode parseInlineScript(JSContext context, Source source, MaterializedFrame lexicalContextFrame, boolean isStrict) {
        Environment env = GraalJSEvaluator.assembleDebugEnvironment(context, lexicalContextFrame);
        return this.parseInlineScript(context, source, env, isStrict);
    }

    private static Environment assembleDebugEnvironment(JSContext context, MaterializedFrame lexicalContextFrame) {
        DebugEnvironment env = null;
        ArrayList<FrameDescriptor> frameDescriptors = new ArrayList<FrameDescriptor>();
        MaterializedFrame frame = lexicalContextFrame;
        while (frame != null && frame != JSFrameUtil.NULL_MATERIALIZED_FRAME) {
            FrameSlot parentSlot;
            assert (GraalJSEvaluator.isJSArgumentsArray(frame.getArguments()));
            while ((parentSlot = frame.getFrameDescriptor().findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER)) != null) {
                frameDescriptors.add(frame.getFrameDescriptor());
                frame = (Frame)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)parentSlot);
            }
            frameDescriptors.add(frame.getFrameDescriptor());
            frame = JSArguments.getEnclosingFrame(frame.getArguments());
        }
        for (int i = frameDescriptors.size() - 1; i >= 0; --i) {
            env = new DebugEnvironment(env, NodeFactory.getInstance(context), context, (FrameDescriptor)frameDescriptors.get(i));
        }
        return env;
    }

    private static boolean isJSArgumentsArray(Object[] arguments) {
        return arguments != null && arguments.length >= 2 && JSFunction.isJSFunction(JSArguments.getFunctionObject(arguments));
    }

    @Override
    public Expression parseExpression(JSContext context, String sourceString) {
        return GraalJSParserHelper.parseExpression(context, Source.newBuilder((String)"js", (CharSequence)sourceString, (String)"<unknown>").build(), context.getParserOptions());
    }
}

