/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser;

import com.oracle.js.parser.ECMAErrors;
import com.oracle.js.parser.ErrorManager;
import com.oracle.js.parser.Lexer;
import com.oracle.js.parser.Token;
import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.AccessNode;
import com.oracle.js.parser.ir.BinaryNode;
import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.BlockExpression;
import com.oracle.js.parser.ir.BlockStatement;
import com.oracle.js.parser.ir.BreakNode;
import com.oracle.js.parser.ir.CallNode;
import com.oracle.js.parser.ir.CaseNode;
import com.oracle.js.parser.ir.CatchNode;
import com.oracle.js.parser.ir.ClassNode;
import com.oracle.js.parser.ir.ContinueNode;
import com.oracle.js.parser.ir.DebuggerNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.ExpressionStatement;
import com.oracle.js.parser.ir.ForNode;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.IndexNode;
import com.oracle.js.parser.ir.JoinPredecessorExpression;
import com.oracle.js.parser.ir.LabelNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LexicalContextNode;
import com.oracle.js.parser.ir.LexicalContextScope;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.ObjectNode;
import com.oracle.js.parser.ir.ParameterNode;
import com.oracle.js.parser.ir.RuntimeNode;
import com.oracle.js.parser.ir.Scope;
import com.oracle.js.parser.ir.Statement;
import com.oracle.js.parser.ir.SwitchNode;
import com.oracle.js.parser.ir.Symbol;
import com.oracle.js.parser.ir.TernaryNode;
import com.oracle.js.parser.ir.ThrowNode;
import com.oracle.js.parser.ir.TryNode;
import com.oracle.js.parser.ir.UnaryNode;
import com.oracle.js.parser.ir.VarNode;
import com.oracle.js.parser.ir.WhileNode;
import com.oracle.js.parser.ir.WithNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.ReadNode;
import com.oracle.truffle.js.nodes.RepeatableNode;
import com.oracle.truffle.js.nodes.ScriptNode;
import com.oracle.truffle.js.nodes.access.ArrayLiteralNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.DeclareEvalVariableNode;
import com.oracle.truffle.js.nodes.access.DeclareGlobalNode;
import com.oracle.truffle.js.nodes.access.FrameSlotNode;
import com.oracle.truffle.js.nodes.access.GlobalPropertyNode;
import com.oracle.truffle.js.nodes.access.GlobalScopeVarWrapperNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.LazyReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.LazyWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ObjectLiteralNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.access.WritePropertyNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.binary.DualNode;
import com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import com.oracle.truffle.js.nodes.binary.JSOrNode;
import com.oracle.truffle.js.nodes.binary.JSTypeofIdenticalNode;
import com.oracle.truffle.js.nodes.control.AbstractBlockNode;
import com.oracle.truffle.js.nodes.control.BreakTarget;
import com.oracle.truffle.js.nodes.control.ContinueTarget;
import com.oracle.truffle.js.nodes.control.DiscardResultNode;
import com.oracle.truffle.js.nodes.control.EmptyNode;
import com.oracle.truffle.js.nodes.control.GeneratorWrapperNode;
import com.oracle.truffle.js.nodes.control.IfNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.ReturnNode;
import com.oracle.truffle.js.nodes.control.ReturnTargetNode;
import com.oracle.truffle.js.nodes.control.SequenceNode;
import com.oracle.truffle.js.nodes.control.StatementNode;
import com.oracle.truffle.js.nodes.control.SuspendNode;
import com.oracle.truffle.js.nodes.function.AbstractFunctionArgumentsNode;
import com.oracle.truffle.js.nodes.function.BlockScopeNode;
import com.oracle.truffle.js.nodes.function.EvalNode;
import com.oracle.truffle.js.nodes.function.FunctionBodyNode;
import com.oracle.truffle.js.nodes.function.FunctionNameHolder;
import com.oracle.truffle.js.nodes.function.FunctionRootNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.function.JSFunctionExpressionNode;
import com.oracle.truffle.js.nodes.function.JSNewNode;
import com.oracle.truffle.js.nodes.function.SpreadArgumentNode;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.nodes.unary.TypeOfNode;
import com.oracle.truffle.js.nodes.unary.VoidNode;
import com.oracle.truffle.js.parser.env.BlockEnvironment;
import com.oracle.truffle.js.parser.env.DebugEnvironment;
import com.oracle.truffle.js.parser.env.Environment;
import com.oracle.truffle.js.parser.env.EvalEnvironment;
import com.oracle.truffle.js.parser.env.FunctionEnvironment;
import com.oracle.truffle.js.parser.env.GlobalEnvironment;
import com.oracle.truffle.js.parser.env.WithEnvironment;
import com.oracle.truffle.js.parser.internal.ir.debug.PrintVisitor;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.objects.Dead;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

abstract class GraalJSTranslator
extends TranslatorNodeVisitor<LexicalContext, JavaScriptNode> {
    public static final JavaScriptNode[] EMPTY_NODE_ARRAY = new JavaScriptNode[0];
    private static final JavaScriptNode ANY_JAVA_SCRIPT_NODE = new JavaScriptNode(){

        @Override
        public Object execute(VirtualFrame frame) {
            CompilerAsserts.neverPartOfCompilation();
            throw new UnsupportedOperationException();
        }
    };
    private static final SourceSection unavailableInternalSection = Source.newBuilder((String)"js", (CharSequence)"<internal>", (String)"<internal>").mimeType("application/javascript").internal(true).build().createUnavailableSection();
    private Environment environment;
    protected final JSContext context;
    protected final NodeFactory factory;
    protected final Source source;
    private final boolean isParentStrict;

    protected GraalJSTranslator(NodeFactory factory, JSContext context, Source source, Environment environment, boolean isParentStrict) {
        super(new LexicalContext());
        this.context = context;
        this.environment = environment;
        this.factory = factory;
        this.source = source;
        this.isParentStrict = isParentStrict;
    }

    protected final JavaScriptNode transform(Node node) {
        if (node != null) {
            return node.accept(this);
        }
        return null;
    }

    private JavaScriptNode tagStatement(JavaScriptNode resultNode, Node parseNode) {
        if (!resultNode.hasSourceSection()) {
            this.assignSourceSection(resultNode, parseNode);
        }
        assert (resultNode.getSourceSection() != null);
        if (resultNode instanceof GlobalScopeVarWrapperNode) {
            this.tagStatement(((GlobalScopeVarWrapperNode)resultNode).getDelegateNode(), parseNode);
        } else {
            resultNode.addStatementTag();
        }
        return resultNode;
    }

    private JavaScriptNode tagExpression(JavaScriptNode resultNode, Node parseNode) {
        if (!resultNode.hasSourceSection()) {
            this.assignSourceSection(resultNode, parseNode);
        }
        assert (resultNode.getSourceSection() != null);
        if (resultNode instanceof GlobalScopeVarWrapperNode) {
            this.tagExpression(((GlobalScopeVarWrapperNode)resultNode).getDelegateNode(), parseNode);
        } else {
            resultNode.addExpressionTag();
        }
        return resultNode;
    }

    private static JavaScriptNode tagCall(JavaScriptNode resultNode) {
        resultNode.addCallTag();
        return resultNode;
    }

    private JavaScriptNode tagBody(JavaScriptNode resultNode, Node parseNode) {
        if (!resultNode.hasSourceSection()) {
            this.assignSourceSection(resultNode, parseNode);
        }
        assert (resultNode.getSourceSection() != null);
        if (resultNode instanceof GlobalScopeVarWrapperNode) {
            this.tagBody(((GlobalScopeVarWrapperNode)resultNode).getDelegateNode(), parseNode);
        } else {
            resultNode.addRootBodyTag();
        }
        return resultNode;
    }

    private FunctionEnvironment currentFunction() {
        return this.environment.function();
    }

    private JavaScriptNode createBlock(JavaScriptNode ... statements) {
        return this.createBlock(statements, false, false);
    }

    private JavaScriptNode createBlock(JavaScriptNode[] statements, boolean terminal, boolean expressionBlock) {
        if (JSTruffleOptions.ReturnOptimizer && terminal || expressionBlock || this.currentFunction().returnsLastStatementResult()) {
            return this.factory.createExprBlock(statements);
        }
        return this.factory.createVoidBlock(statements);
    }

    protected final ScriptNode translateScript(FunctionNode functionNode) {
        if (!functionNode.isScript()) {
            throw new IllegalArgumentException("root function node is not a script");
        }
        JSFunctionExpressionNode functionExpression = (JSFunctionExpressionNode)this.transformFunction(functionNode);
        return ScriptNode.fromFunctionRoot(this.context, functionExpression.getFunctionNode());
    }

    protected final JavaScriptNode translateExpression(Expression expression) {
        try (EnvironmentCloseable dummyFunctionEnv = this.enterFunctionEnvironment(true, false, false, false, false, false);){
            this.currentFunction().setNeedsParentFrame(true);
            this.currentFunction().freeze();
            JavaScriptNode javaScriptNode = this.transform(expression);
            return javaScriptNode;
        }
    }

    protected final JavaScriptNode transformFunction(FunctionNode functionNode) {
        return this.transform(functionNode);
    }

    protected abstract GraalJSTranslator newTranslator(Environment var1);

    @Override
    public JavaScriptNode enterFunctionNode(FunctionNode functionNode) {
        JavaScriptNode functionExpression;
        FunctionRootNode functionRoot;
        JSFunctionData functionData;
        boolean isGlobal;
        boolean isConstructor;
        if (JSTruffleOptions.PrintParse) {
            GraalJSTranslator.printParse(functionNode);
        }
        boolean isStrict = functionNode.isStrict() || this.isParentStrict || this.environment != null && this.environment.function() != null && this.environment.isStrictMode();
        boolean isArrowFunction = functionNode.isArrow();
        boolean isGeneratorFunction = functionNode.isGenerator();
        boolean isAsyncFunction = functionNode.isAsync();
        boolean isDerivedConstructor = functionNode.isSubclassConstructor();
        boolean isMethod = functionNode.isMethod();
        boolean needsNewTarget = functionNode.needsNewTarget() || functionNode.hasDirectSuper();
        boolean isClassConstructor = functionNode.isClassConstructor();
        boolean bl = isConstructor = !isArrowFunction && !isGeneratorFunction && !isAsyncFunction && (!isMethod || this.context.getEcmaScriptVersion() == 5 || isClassConstructor);
        assert (!isDerivedConstructor || isConstructor);
        boolean strictFunctionProperties = isStrict || isArrowFunction || isMethod || isGeneratorFunction;
        boolean isBuiltin = false;
        boolean isEval = false;
        boolean isIndirectEval = false;
        boolean inDirectEval = false;
        if (this.environment instanceof EvalEnvironment) {
            isEval = true;
            boolean isDirectEval = ((EvalEnvironment)this.environment).isDirectEval();
            isIndirectEval = !isDirectEval;
            Environment evalParent = this.environment.getParent();
            isGlobal = evalParent == null || isDirectEval && !isStrict && evalParent.function().isGlobal();
            inDirectEval = isDirectEval || evalParent != null && evalParent.function().inDirectEval();
        } else if (this.environment instanceof DebugEnvironment) {
            isGlobal = this.environment.getParent() == null;
            isEval = true;
            inDirectEval = true;
        } else {
            isGlobal = this.environment == null;
            inDirectEval = this.environment != null && this.currentFunction().inDirectEval();
        }
        boolean functionMode = !isGlobal || isStrict && isIndirectEval;
        boolean lazyTranslation = JSTruffleOptions.LazyTranslation && functionMode && !functionNode.isProgram() && !inDirectEval;
        String functionName = this.getFunctionName(functionNode);
        if (lazyTranslation) {
            assert (functionMode && !functionNode.isProgram());
            boolean needsParentFrame = functionNode.usesAncestorScope();
            functionData = this.factory.createFunctionData(this.context, functionNode.getLength(), functionName, isConstructor, isDerivedConstructor, isStrict, isBuiltin, needsParentFrame, isGeneratorFunction, isAsyncFunction, isClassConstructor, strictFunctionProperties, needsNewTarget);
            Environment parentEnv = this.environment;
            functionData.setLazyInit(fd -> {
                GraalJSTranslator translator = this.newTranslator(parentEnv);
                translator.translateFunctionOnDemand(functionNode, fd, isStrict, isArrowFunction, isGeneratorFunction, isAsyncFunction, isDerivedConstructor, isGlobal, needsNewTarget, needsParentFrame, functionName);
            });
            functionRoot = null;
        } else {
            try (EnvironmentCloseable functionEnv = this.enterFunctionEnvironment(isStrict, isArrowFunction, isGeneratorFunction, isDerivedConstructor, isAsyncFunction, isGlobal);){
                List<JavaScriptNode> declarations;
                FunctionEnvironment currentFunction = this.currentFunction();
                currentFunction.setFunctionName(functionName);
                currentFunction.setInternalFunctionName(!functionName.isEmpty() ? functionName : functionNode.getIdent().getName());
                currentFunction.setNamedFunctionExpression(functionNode.isNamedFunctionExpression());
                this.declareParameters(functionNode);
                if ((long)functionNode.getNumOfParams() > this.context.getFunctionArgumentsLimit()) {
                    throw Errors.createSyntaxError("function has too many arguments");
                }
                if (functionMode) {
                    declarations = this.functionEnvInit(functionNode);
                } else if (functionNode.isModule()) {
                    assert (currentFunction.isGlobal());
                    declarations = this.setupModuleEnvironment(functionNode);
                    this.verifyModuleLocalExports(functionNode.getBody());
                } else {
                    assert (currentFunction.isGlobal());
                    declarations = this.collectGlobalVars(functionNode, isEval);
                }
                if (functionNode.isProgram()) {
                    GraalJSTranslator.functionNeedsParentFramePass(functionNode);
                }
                boolean needsParentFrame = functionNode.usesAncestorScope();
                currentFunction.setNeedsParentFrame(needsParentFrame);
                JavaScriptNode body = this.translateFunctionBody(functionNode, isArrowFunction, isGeneratorFunction, isAsyncFunction, isDerivedConstructor, needsNewTarget, currentFunction, declarations);
                needsParentFrame = currentFunction.needsParentFrame();
                currentFunction.freeze();
                functionData = this.factory.createFunctionData(this.context, functionNode.getLength(), functionName, isConstructor, isDerivedConstructor, isStrict, isBuiltin, needsParentFrame, isGeneratorFunction, isAsyncFunction, isClassConstructor, strictFunctionProperties, needsNewTarget);
                functionRoot = this.createFunctionRoot(functionNode, functionData, currentFunction, body);
                if (isEval) {
                    functionData.getCallTarget();
                }
            }
        }
        if (isArrowFunction && functionNode.needsThis()) {
            JavaScriptNode thisNode = !this.currentFunction().isGlobal() ? this.environment.findThisVar().createReadNode() : this.factory.createAccessThis();
            functionExpression = this.factory.createFunctionExpressionLexicalThis(functionData, functionRoot, thisNode);
        } else {
            functionExpression = this.factory.createFunctionExpression(functionData, functionRoot);
        }
        if (functionNode.isDeclared()) {
            this.ensureHasSourceSection(functionExpression, functionNode);
        } else {
            functionExpression = this.tagExpression(functionExpression, functionNode);
        }
        return functionExpression;
    }

    JavaScriptNode translateFunctionBody(FunctionNode functionNode, boolean isArrowFunction, boolean isGeneratorFunction, boolean isAsyncFunction, boolean isDerivedConstructor, boolean needsNewTarget, FunctionEnvironment currentFunction, List<JavaScriptNode> declarations) {
        JavaScriptNode body = this.transform(functionNode.getBody());
        if (!isGeneratorFunction) {
            body = this.handleFunctionReturn(functionNode, body);
            if (isAsyncFunction) {
                body = this.handleAsyncFunctionBody(body, currentFunction.getFunctionName());
            }
        }
        if (!declarations.isEmpty()) {
            body = this.prepareDeclarations(declarations, body);
        }
        if (currentFunction.hasArgumentsSlot() && !currentFunction.isDirectArgumentsAccess() && !currentFunction.isDirectEval()) {
            body = this.prepareArguments(body);
        }
        if (currentFunction.getParameterCount() > 0) {
            body = this.prepareParameters(body);
        }
        if (currentFunction.getThisSlot() != null && !isDerivedConstructor) {
            body = this.prepareThis(body, isArrowFunction);
        }
        if (currentFunction.getSuperSlot() != null) {
            body = this.prepareSuper(body);
        }
        if (needsNewTarget) {
            body = this.prepareNewTarget(body);
        }
        if (isDerivedConstructor) {
            JavaScriptNode getThisBinding = this.checkThisBindingInitialized(functionNode.hasDirectSuper() ? this.environment.findThisVar().createReadNode() : this.factory.createConstantUndefined());
            body = this.factory.createDerivedConstructorResult(body, getThisBinding);
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionRootNode translateFunctionOnDemand(FunctionNode functionNode, JSFunctionData functionData, boolean isStrict, boolean isArrowFunction, boolean isGeneratorFunction, boolean isAsyncFunction, boolean isDerivedConstructor, boolean isGlobal, boolean needsNewTarget, boolean needsParentFrame, String functionName) {
        try (EnvironmentCloseable functionEnv = this.enterFunctionEnvironment(isStrict, isArrowFunction, isGeneratorFunction, isDerivedConstructor, isAsyncFunction, isGlobal);){
            FunctionRootNode functionRootNode;
            FunctionEnvironment currentFunction = this.currentFunction();
            currentFunction.setFunctionName(functionName);
            currentFunction.setInternalFunctionName(!functionName.isEmpty() ? functionName : functionNode.getIdent().getName());
            currentFunction.setNamedFunctionExpression(functionNode.isNamedFunctionExpression());
            currentFunction.setNeedsParentFrame(needsParentFrame);
            this.declareParameters(functionNode);
            if ((long)functionNode.getNumOfParams() > this.context.getFunctionArgumentsLimit()) {
                throw Errors.createSyntaxError("function has too many arguments");
            }
            this.functionEnvInit(functionNode);
            currentFunction.freeze();
            assert (currentFunction.isDeepFrozen());
            assert (((LexicalContext)this.getLexicalContext()).isEmpty());
            ((LexicalContext)((Object)this.getLexicalContext())).push((FunctionNode)functionNode);
            try {
                JavaScriptNode body = this.translateFunctionBody(functionNode, isArrowFunction, isGeneratorFunction, isAsyncFunction, isDerivedConstructor, needsNewTarget, currentFunction, Collections.emptyList());
                functionRootNode = this.createFunctionRoot(functionNode, functionData, currentFunction, body);
                ((LexicalContext)((Object)this.getLexicalContext())).pop((FunctionNode)functionNode);
            }
            catch (Throwable throwable) {
                ((LexicalContext)((Object)this.getLexicalContext())).pop((FunctionNode)functionNode);
                throw throwable;
            }
            return functionRootNode;
        }
    }

    private FunctionRootNode createFunctionRoot(FunctionNode functionNode, JSFunctionData functionData, FunctionEnvironment currentFunction, JavaScriptNode body) {
        SourceSection functionSourceSection = this.createSourceSection(functionNode);
        FunctionBodyNode functionBody = this.factory.createFunctionBody(body);
        FunctionRootNode functionRoot = this.factory.createFunctionRootNode(functionBody, this.environment.getFunctionFrameDescriptor(), functionData, functionSourceSection, currentFunction.getInternalFunctionName());
        if (JSTruffleOptions.PrintAst) {
            GraalJSTranslator.printAST(functionRoot);
        }
        return functionRoot;
    }

    private static void printAST(FunctionRootNode functionRoot) {
        NodeUtil.printCompactTree((OutputStream)System.out, (com.oracle.truffle.api.nodes.Node)functionRoot);
    }

    private static void printParse(FunctionNode functionNode) {
        System.out.printf(new PrintVisitor(functionNode).toString(), new Object[0]);
    }

    private JavaScriptNode handleAsyncFunctionBody(JavaScriptNode body, String functionName) {
        assert (this.currentFunction().isAsyncFunction() && !this.currentFunction().isGeneratorFunction());
        Environment.VarRef asyncContextVar = this.environment.findAsyncContextVar();
        Environment.VarRef asyncResultVar = this.environment.findAsyncResultVar();
        JSWriteFrameSlotNode writeResultNode = (JSWriteFrameSlotNode)asyncResultVar.createWriteNode(null);
        JSWriteFrameSlotNode writeContextNode = (JSWriteFrameSlotNode)asyncContextVar.createWriteNode(null);
        JavaScriptNode instrumentedBody = this.instrumentSuspendNodes(body);
        return this.factory.createAsyncFunctionBody(this.context, instrumentedBody, writeContextNode, writeResultNode, functionName);
    }

    private JavaScriptNode finishGeneratorBody(JavaScriptNode bodyBlock) {
        JavaScriptNode body = this.handleFunctionReturn(this.lc.getCurrentFunction(), bodyBlock);
        if (this.currentFunction().isAsyncGeneratorFunction()) {
            return this.handleAsyncGeneratorBody(body);
        }
        return this.handleGeneratorBody(body);
    }

    private JavaScriptNode handleGeneratorBody(JavaScriptNode body) {
        assert (this.currentFunction().isGeneratorFunction() && !this.currentFunction().isAsyncGeneratorFunction());
        Environment.VarRef yieldVar = this.environment.findYieldValueVar();
        JSWriteFrameSlotNode writeYieldValueNode = (JSWriteFrameSlotNode)yieldVar.createWriteNode(null);
        JSReadFrameSlotNode readYieldResultNode = JSTruffleOptions.YieldResultInFrame ? (JSReadFrameSlotNode)this.environment.findTempVar(this.currentFunction().getYieldResultSlot()).createReadNode() : null;
        JavaScriptNode instrumentedBody = this.instrumentSuspendNodes(body);
        return this.factory.createGeneratorBody(this.context, instrumentedBody, writeYieldValueNode, readYieldResultNode);
    }

    private JavaScriptNode handleAsyncGeneratorBody(JavaScriptNode body) {
        assert (this.currentFunction().isAsyncGeneratorFunction());
        JSWriteFrameSlotNode writeAsyncContextNode = (JSWriteFrameSlotNode)this.environment.findAsyncContextVar().createWriteNode(null);
        Environment.VarRef yieldVar = this.environment.findAsyncResultVar();
        JSWriteFrameSlotNode writeYieldValueNode = (JSWriteFrameSlotNode)yieldVar.createWriteNode(null);
        JSReadFrameSlotNode readYieldResultNode = JSTruffleOptions.YieldResultInFrame ? (JSReadFrameSlotNode)this.environment.findTempVar(this.currentFunction().getYieldResultSlot()).createReadNode() : null;
        JavaScriptNode instrumentedBody = this.instrumentSuspendNodes(body);
        return this.factory.createAsyncGeneratorBody(this.context, instrumentedBody, writeYieldValueNode, readYieldResultNode, writeAsyncContextNode);
    }

    private JavaScriptNode instrumentSuspendNodes(JavaScriptNode body) {
        if (!this.currentFunction().hasYield() && !this.currentFunction().hasAwait()) {
            return body;
        }
        JavaScriptNode newBody = (JavaScriptNode)this.instrumentSuspendHelper(body, null);
        Objects.requireNonNull(newBody);
        return newBody;
    }

    private com.oracle.truffle.api.nodes.Node instrumentSuspendHelper(com.oracle.truffle.api.nodes.Node parent, com.oracle.truffle.api.nodes.Node grandparent) {
        boolean hasSuspendChild = false;
        BitSet suspendableIndices = null;
        if (parent instanceof AbstractBlockNode) {
            JavaScriptNode[] statements = ((AbstractBlockNode)parent).getStatements();
            for (int i = 0; i < statements.length; ++i) {
                com.oracle.truffle.api.nodes.Node newChild = this.instrumentSuspendHelper((com.oracle.truffle.api.nodes.Node)statements[i], parent);
                if (newChild == null) continue;
                hasSuspendChild = true;
                statements[i] = newChild;
                if (suspendableIndices == null) {
                    suspendableIndices = new BitSet();
                }
                suspendableIndices.set(i);
            }
        } else {
            for (com.oracle.truffle.api.nodes.Node child : GraalJSTranslator.getChildrenInExecutionOrder(parent)) {
                com.oracle.truffle.api.nodes.Node newChild = this.instrumentSuspendHelper(child, parent);
                if (newChild == null) continue;
                hasSuspendChild = true;
                NodeUtil.replaceChild((com.oracle.truffle.api.nodes.Node)parent, (com.oracle.truffle.api.nodes.Node)child, (com.oracle.truffle.api.nodes.Node)newChild);
                assert (!(child instanceof ResumableNode) || newChild instanceof GeneratorWrapperNode) : "resumable node not wrapped: " + child;
            }
        }
        if (parent instanceof SuspendNode) {
            return this.wrapResumableNode(parent);
        }
        if (!hasSuspendChild) {
            return null;
        }
        if (parent instanceof AbstractBlockNode) {
            assert (suspendableIndices != null && !suspendableIndices.isEmpty());
            return this.toGeneratorBlockNode((AbstractBlockNode)parent, suspendableIndices);
        }
        if (parent instanceof ResumableNode) {
            return this.wrapResumableNode(parent);
        }
        if (parent instanceof ReturnNode || parent instanceof ReturnTargetNode || GraalJSTranslator.isSideEffectFreeUnaryOpNode(parent)) {
            return parent;
        }
        if (GraalJSTranslator.isSupportedDispersibleExpression(parent)) {
            ArrayList<JavaScriptNode> extracted = new ArrayList<JavaScriptNode>();
            if (grandparent == null || NodeUtil.isReplacementSafe((com.oracle.truffle.api.nodes.Node)grandparent, (com.oracle.truffle.api.nodes.Node)parent, (com.oracle.truffle.api.nodes.Node)ANY_JAVA_SCRIPT_NODE)) {
                this.extractChildrenTo(parent, extracted);
            }
            if (!extracted.isEmpty()) {
                extracted.add((JavaScriptNode)parent);
                JavaScriptNode exprBlock = this.wrapResumableNode(this.factory.createExprBlock(extracted.toArray(EMPTY_NODE_ARRAY)));
                GraalJSTranslator.tagHiddenExpression(exprBlock);
                return exprBlock;
            }
            return parent;
        }
        return parent;
    }

    private JavaScriptNode wrapResumableNode(com.oracle.truffle.api.nodes.Node resumableNode) {
        if (resumableNode instanceof AbstractBlockNode) {
            BitSet all = new BitSet();
            all.set(0, ((AbstractBlockNode)resumableNode).getStatements().length);
            return this.toGeneratorBlockNode((AbstractBlockNode)resumableNode, all);
        }
        String identifier = ":generatorstate:" + this.environment.getFunctionFrameDescriptor().getSize();
        this.environment.getFunctionFrameDescriptor().addFrameSlot((Object)identifier);
        LazyReadFrameSlotNode readState = this.factory.createLazyReadFrameSlot(identifier);
        LazyWriteFrameSlotNode writeState = this.factory.createLazyWriteFrameSlot(identifier, null);
        return this.factory.createGeneratorWrapper((JavaScriptNode)resumableNode, readState, writeState);
    }

    private JavaScriptNode toGeneratorBlockNode(AbstractBlockNode blockNode, BitSet suspendableIndices) {
        JavaScriptNode genBlock;
        String identifier = ":generatorstate:" + this.environment.getFunctionFrameDescriptor().getSize();
        this.environment.getFunctionFrameDescriptor().addFrameSlot((Object)identifier);
        LazyReadFrameSlotNode readState = this.factory.createLazyReadFrameSlot(identifier);
        LazyWriteFrameSlotNode writeState = this.factory.createLazyWriteFrameSlot(identifier, null);
        JavaScriptNode[] statements = blockNode.getStatements();
        boolean returnsResult = !blockNode.isResultAlwaysOfType(Undefined.class);
        int resumePoints = suspendableIndices.cardinality() + (suspendableIndices.get(0) ? 0 : 1);
        if (resumePoints == statements.length) {
            genBlock = returnsResult ? this.factory.createGeneratorExprBlock(statements, readState, writeState) : this.factory.createGeneratorVoidBlock(statements, readState, writeState);
        } else {
            JavaScriptNode[] chunks = new JavaScriptNode[resumePoints];
            int fromIndex = 0;
            for (int chunkI = 0; chunkI < resumePoints; ++chunkI) {
                JavaScriptNode chunk;
                int toIndex = suspendableIndices.nextSetBit(fromIndex + 1);
                if (toIndex < 0) {
                    assert (chunkI == resumePoints - 1);
                    toIndex = statements.length;
                }
                boolean bl = returnsResult = chunkI == resumePoints - 1 && !blockNode.isResultAlwaysOfType(Undefined.class);
                if (fromIndex + 1 == toIndex) {
                    chunk = statements[fromIndex];
                } else {
                    JavaScriptNode[] chunkStatements = Arrays.copyOfRange(statements, fromIndex, toIndex);
                    chunk = returnsResult && chunkI == resumePoints - 1 ? this.factory.createExprBlock(chunkStatements) : this.factory.createVoidBlock(chunkStatements);
                }
                chunks[chunkI] = chunk;
                fromIndex = toIndex;
            }
            genBlock = returnsResult ? this.factory.createGeneratorExprBlock(chunks, readState, writeState) : this.factory.createGeneratorVoidBlock(chunks, readState, writeState);
        }
        JavaScriptNode.transferSourceSectionAndTags(blockNode, genBlock);
        return genBlock;
    }

    private static boolean isSideEffectFreeUnaryOpNode(com.oracle.truffle.api.nodes.Node node) {
        return node instanceof DiscardResultNode || node instanceof VoidNode || node instanceof TypeOfNode || node instanceof JSTypeofIdenticalNode;
    }

    private static boolean isSupportedDispersibleExpression(com.oracle.truffle.api.nodes.Node node) {
        return node instanceof JSBinaryNode || node instanceof JSUnaryNode || node instanceof ArrayLiteralNode || node instanceof ObjectLiteralNode || node instanceof PropertyNode || node instanceof GlobalPropertyNode || node instanceof ReadElementNode || node instanceof WritePropertyNode || node instanceof WriteElementNode || node instanceof JSFunctionCallNode || node instanceof JSNewNode;
    }

    private static boolean isStatelessExpression(com.oracle.truffle.api.nodes.Node child) {
        return child instanceof JSConstantNode || child instanceof CreateObjectNode || child instanceof RepeatableNode && !(child instanceof ReadNode);
    }

    private static boolean skipOverToChildren(com.oracle.truffle.api.nodes.Node node) {
        return node instanceof ObjectLiteralNode.ObjectLiteralMemberNode || node instanceof AbstractFunctionArgumentsNode || node instanceof ArrayLiteralNode.SpreadArrayNode || node instanceof SpreadArgumentNode;
    }

    private void extractChildTo(com.oracle.truffle.api.nodes.Node child, com.oracle.truffle.api.nodes.Node parent, List<JavaScriptNode> extracted) {
        if (GraalJSTranslator.isStatelessExpression(child)) {
            return;
        }
        if (GraalJSTranslator.skipOverToChildren(child)) {
            this.extractChildrenTo(child, extracted);
        } else if (child instanceof JavaScriptNode) {
            JavaScriptNode jschild = (JavaScriptNode)child;
            String identifier = ":generatorexpr:" + this.environment.getFunctionFrameDescriptor().getSize();
            LazyReadFrameSlotNode readState = this.factory.createLazyReadFrameSlot(identifier);
            if (jschild.hasTag(StandardTags.ExpressionTag.class) || jschild instanceof GeneratorWrapperNode && ((GeneratorWrapperNode)jschild).getResumableNode().hasTag(StandardTags.ExpressionTag.class)) {
                GraalJSTranslator.tagHiddenExpression(readState);
            }
            LazyWriteFrameSlotNode writeState = this.factory.createLazyWriteFrameSlot(identifier, jschild);
            if (NodeUtil.isReplacementSafe((com.oracle.truffle.api.nodes.Node)parent, (com.oracle.truffle.api.nodes.Node)child, (com.oracle.truffle.api.nodes.Node)readState)) {
                this.environment.getFunctionFrameDescriptor().addFrameSlot((Object)identifier);
                extracted.add(writeState);
                boolean ok = NodeUtil.replaceChild((com.oracle.truffle.api.nodes.Node)parent, (com.oracle.truffle.api.nodes.Node)child, (com.oracle.truffle.api.nodes.Node)readState);
                assert (ok);
            } else {
                this.extractChildrenTo(child, extracted);
            }
        }
    }

    private static Iterable<com.oracle.truffle.api.nodes.Node> getChildrenInExecutionOrder(com.oracle.truffle.api.nodes.Node parent) {
        return parent.getChildren();
    }

    private void extractChildrenTo(com.oracle.truffle.api.nodes.Node parent, List<JavaScriptNode> extracted) {
        for (com.oracle.truffle.api.nodes.Node child : GraalJSTranslator.getChildrenInExecutionOrder(parent)) {
            this.extractChildTo(child, parent, extracted);
        }
    }

    private JavaScriptNode handleFunctionReturn(FunctionNode functionNode, JavaScriptNode body) {
        assert ((this.currentFunction().isGlobal() || this.currentFunction().isEval()) == (functionNode.isScript() || functionNode.isModule()));
        if (this.currentFunction().returnsLastStatementResult()) {
            assert (!this.currentFunction().hasReturn());
            return this.wrapGetCompletionValue(body);
        }
        if (this.currentFunction().hasReturn()) {
            if (JSTruffleOptions.ReturnValueInFrame) {
                return this.factory.createFrameReturnTarget(body, this.factory.createLocal(this.currentFunction().getReturnSlot(), 0, 0, ScopeFrameNode.EMPTY_FRAME_SLOT_ARRAY));
            }
            return this.factory.createReturnTarget(body);
        }
        return body;
    }

    private EnvironmentCloseable enterFunctionEnvironment(boolean isStrict, boolean isArrowFunction, boolean isGeneratorFunction, boolean isDerivedConstructor, boolean isAsyncFunction, boolean isGlobal) {
        FunctionEnvironment functionEnv;
        if (this.environment instanceof EvalEnvironment) {
            assert (!(isArrowFunction || isGeneratorFunction || isDerivedConstructor || isAsyncFunction));
            functionEnv = new FunctionEnvironment(this.environment.getParent(), this.factory, this.context, isStrict, true, ((EvalEnvironment)this.environment).isDirectEval(), false, false, false, false, isGlobal);
        } else if (this.environment instanceof DebugEnvironment) {
            assert (!(isArrowFunction || isGeneratorFunction || isDerivedConstructor || isAsyncFunction));
            functionEnv = new FunctionEnvironment(this.environment, this.factory, this.context, isStrict, true, true, false, false, false, false, isGlobal);
        } else {
            functionEnv = new FunctionEnvironment(this.environment, this.factory, this.context, isStrict, false, false, isArrowFunction, isGeneratorFunction, isDerivedConstructor, isAsyncFunction, isGlobal);
        }
        return new EnvironmentCloseable(functionEnv);
    }

    private void declareParameters(FunctionNode functionNode) {
        FunctionEnvironment currentFunction = this.currentFunction();
        currentFunction.setSimpleParameterList(functionNode.hasSimpleParameterList());
        List<IdentNode> parameters = functionNode.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            IdentNode parameter = parameters.get(i);
            currentFunction.declareParameter(parameter.getName());
            if (!parameter.isRestParameter()) continue;
            assert (i == parameters.size() - 1);
            currentFunction.setRestParameter(true);
        }
    }

    private JavaScriptNode prepareDeclarations(List<JavaScriptNode> declarations, JavaScriptNode body) {
        declarations.add(body);
        return this.factory.createExprBlock(declarations.toArray(EMPTY_NODE_ARRAY));
    }

    private static JavaScriptNode[] javaScriptNodeArray(int size) {
        return size == 0 ? EMPTY_NODE_ARRAY : new JavaScriptNode[size];
    }

    private String getFunctionName(FunctionNode functionNode) {
        if (this.context.getEcmaScriptVersion() < 6 && (functionNode.isGetter() || functionNode.isSetter())) {
            assert (!functionNode.isAnonymous());
            String name = functionNode.getIdent().getName();
            if (functionNode.isGetter() && name.startsWith("get ") || functionNode.isSetter() && name.startsWith("set ")) {
                name = name.substring(4);
            }
            return name;
        }
        return !functionNode.isAnonymous() ? functionNode.getIdent().getName() : "";
    }

    private JavaScriptNode prepareParameters(JavaScriptNode body) {
        FrameSlot[] frameSlots = this.currentFunction().getParameters().toArray(new FrameSlot[this.currentFunction().getParameterCount()]);
        return this.createEnterFrameBlock(frameSlots, body);
    }

    private JavaScriptNode createEnterFrameBlock(FrameSlot[] parameterSlots, JavaScriptNode body) {
        if (parameterSlots.length != 0) {
            JavaScriptNode[] parameterAssignment = GraalJSTranslator.javaScriptNodeArray(parameterSlots.length + 1);
            int i = 0;
            boolean hasRestParameter = this.currentFunction().hasRestParameter();
            int argIndex = this.currentFunction().getLeadingArgumentCount();
            while (i < parameterSlots.length) {
                JavaScriptNode valueNode = hasRestParameter && i == parameterSlots.length - 1 ? GraalJSTranslator.tagHiddenExpression(this.factory.createAccessRestArgument(this.context, argIndex, this.currentFunction().getTrailingArgumentCount())) : GraalJSTranslator.tagHiddenExpression(this.factory.createAccessArgument(argIndex));
                parameterAssignment[i] = GraalJSTranslator.tagHiddenExpression(this.factory.createWriteFrameSlot(parameterSlots[i], 0, 0, ScopeFrameNode.EMPTY_FRAME_SLOT_ARRAY, valueNode));
                ++i;
                ++argIndex;
            }
            parameterAssignment[i] = body;
            return this.factory.createExprBlock(parameterAssignment);
        }
        return body;
    }

    private static JavaScriptNode tagHiddenExpression(JavaScriptNode node) {
        node.setSourceSection(unavailableInternalSection);
        if (node instanceof GlobalScopeVarWrapperNode) {
            GraalJSTranslator.tagHiddenExpression(((GlobalScopeVarWrapperNode)node).getDelegateNode());
        } else {
            node.addExpressionTag();
        }
        return node;
    }

    static int getBlockScopedSymbolFlags(VarNode varNode) {
        if (varNode.isConst()) {
            return 2;
        }
        assert (varNode.isLet());
        return 1 | (varNode.getName().isCatchParameter() ? 33792 : 0);
    }

    private List<JavaScriptNode> functionEnvInit(FunctionNode functionNode) {
        FunctionEnvironment currentFunction = this.currentFunction();
        assert (!currentFunction.isGlobal() || currentFunction.isIndirectEval());
        if (JSTruffleOptions.ReturnOptimizer) {
            GraalJSTranslator.markTerminalReturnNodes(functionNode.getBody());
        }
        if (!functionNode.isArrow() && functionNode.needsArguments()) {
            currentFunction.reserveArgumentsSlot();
            if (JSTruffleOptions.OptimizeApplyArguments && functionNode.getNumOfParams() == 0 && !functionNode.hasEval() && functionNode.hasApplyArgumentsCall() && GraalJSTranslator.checkDirectArgumentsAccess(functionNode, currentFunction)) {
                currentFunction.setDirectArgumentsAccess(true);
            } else {
                currentFunction.declareVar("arguments");
            }
        }
        if (!(!functionNode.needsThis() || functionNode.isArrow() && currentFunction.getNonArrowParentFunction().isDerivedConstructor())) {
            currentFunction.reserveThisSlot();
        }
        if (functionNode.hasDirectSuper()) {
            assert (!functionNode.isArrow());
            currentFunction.reserveThisSlot();
        }
        if (functionNode.usesSuper()) {
            assert (!functionNode.isArrow());
            currentFunction.reserveThisSlot();
            currentFunction.reserveSuperSlot();
        }
        if (functionNode.needsNewTarget() || functionNode.hasDirectSuper()) {
            currentFunction.reserveNewTargetSlot();
        }
        if (functionNode.needsDynamicScope() && !currentFunction.isDirectEval()) {
            currentFunction.setIsDynamicallyScoped(true);
            currentFunction.reserveDynamicScopeSlot();
        }
        return Collections.emptyList();
    }

    private static void functionNeedsParentFramePass(FunctionNode rootFunctionNode) {
        if (!JSTruffleOptions.LazyTranslation) {
            return;
        }
        NodeVisitor<LexicalContext> visitor = new NodeVisitor<LexicalContext>(new LexicalContext()){

            @Override
            public boolean enterIdentNode(IdentNode identNode) {
                if (!identNode.isPropertyName()) {
                    String varName = identNode.getName();
                    this.findSymbol(varName);
                }
                return true;
            }

            private void findSymbol(String varName) {
                boolean local = true;
                FunctionNode lastFunction = null;
                Iterator<LexicalContextNode> iterator = this.lc.getAllNodes();
                while (iterator.hasNext()) {
                    LexicalContextNode node = iterator.next();
                    if (node instanceof LexicalContextScope) {
                        Symbol foundSymbol = ((LexicalContextScope)node).getScope().getExistingSymbol(varName);
                        if (foundSymbol == null || foundSymbol.isGlobal() || foundSymbol.isImportBinding()) continue;
                        if (local) break;
                        this.markUsesAncestorScopeUntil(lastFunction, true);
                        break;
                    }
                    if (node instanceof FunctionNode) {
                        FunctionNode function = (FunctionNode)node;
                        if (function.isNamedFunctionExpression() && varName.equals(function.getIdent().getName())) {
                            if (local) break;
                            this.markUsesAncestorScopeUntil(lastFunction, true);
                            break;
                        }
                        if (function.isArrow() && this.isVarLexicallyScopedInArrowFunction(varName)) {
                            FunctionNode nonArrowFunction = this.lc.getCurrentNonArrowFunction();
                            if (varName.equals("this") && !nonArrowFunction.isSubclassConstructor() || nonArrowFunction.isProgram()) break;
                            this.markUsesAncestorScopeUntil(nonArrowFunction, false);
                            break;
                        }
                        if (!function.isProgram() && varName.equals("arguments")) {
                            assert (!function.isArrow());
                            assert (local);
                            break;
                        }
                        if (function.hasEval() && !function.isProgram() && !local) {
                            this.markUsesAncestorScopeUntil(lastFunction, true);
                        }
                        lastFunction = function;
                        local = false;
                        continue;
                    }
                    if (!(node instanceof WithNode) || local) continue;
                    this.markUsesAncestorScopeUntil(lastFunction, true);
                }
            }

            private boolean isVarLexicallyScopedInArrowFunction(String varName) {
                switch (varName) {
                    case "arguments": 
                    case "new.target": 
                    case "super": 
                    case "this": {
                        return true;
                    }
                }
                return false;
            }

            private void markUsesAncestorScopeUntil(FunctionNode untilFunction, boolean inclusive) {
                Iterator<FunctionNode> functions = this.lc.getFunctions();
                while (functions.hasNext()) {
                    FunctionNode function = functions.next();
                    if (!inclusive && function == untilFunction) break;
                    function.setUsesAncestorScope(true);
                    if (!inclusive || function != untilFunction) continue;
                    break;
                }
            }

            @Override
            public boolean enterFunctionNode(FunctionNode functionNode) {
                if (functionNode.hasEval()) {
                    this.markUsesAncestorScopeUntil(null, false);
                }
                return true;
            }
        };
        rootFunctionNode.accept((NodeVisitor<? extends LexicalContext>)visitor);
    }

    private static boolean checkDirectArgumentsAccess(final FunctionNode functionNode, final FunctionEnvironment currentFunction) {
        class DirectArgumentsAccessVisitor
        extends NodeVisitor<LexicalContext> {
            boolean directArgumentsAccess;

            DirectArgumentsAccessVisitor(LexicalContext lc) {
                super(lc);
                this.directArgumentsAccess = true;
            }

            @Override
            public boolean enterIdentNode(IdentNode identNode) {
                if (JSTruffleOptions.OptimizeApplyArguments) {
                    if (identNode.isArguments() && !identNode.isPropertyName() && functionNode.needsArguments() && !currentFunction.isDirectEval() && !identNode.isApplyArguments()) {
                        this.directArgumentsAccess = false;
                    } else {
                        this.checkParameterUse(identNode);
                    }
                }
                return false;
            }

            private void checkParameterUse(IdentNode identNode) {
                if (this.directArgumentsAccess && !currentFunction.isStrictMode() && currentFunction.isParameter(identNode.getName())) {
                    this.directArgumentsAccess = false;
                }
            }

            @Override
            public boolean enterFunctionNode(FunctionNode nestedFunctionNode) {
                if (nestedFunctionNode == functionNode) {
                    return true;
                }
                if (JSTruffleOptions.OptimizeApplyArguments && (nestedFunctionNode.isArrow() || !currentFunction.isStrictMode())) {
                    this.directArgumentsAccess = false;
                }
                return false;
            }
        }
        DirectArgumentsAccessVisitor visitor = new DirectArgumentsAccessVisitor(new LexicalContext());
        functionNode.accept(visitor);
        return visitor.directArgumentsAccess;
    }

    static boolean isApply(CallNode callNode) {
        return callNode.getFunction() instanceof AccessNode && ((AccessNode)callNode.getFunction()).getProperty().equals("apply");
    }

    private static void markTerminalReturnNodes(Node node) {
        if (node instanceof Block && ((Block)node).isTerminal()) {
            Statement lastStatement = ((Block)node).getLastStatement();
            if (lastStatement != null) {
                GraalJSTranslator.markTerminalReturnNodes(lastStatement);
            }
        } else if (node instanceof BlockStatement && ((BlockStatement)node).isTerminal()) {
            GraalJSTranslator.markTerminalReturnNodes(((BlockStatement)node).getBlock());
        } else if (node instanceof com.oracle.js.parser.ir.IfNode && ((com.oracle.js.parser.ir.IfNode)node).isTerminal()) {
            GraalJSTranslator.markTerminalReturnNodes(((com.oracle.js.parser.ir.IfNode)node).getPass());
            GraalJSTranslator.markTerminalReturnNodes(((com.oracle.js.parser.ir.IfNode)node).getFail());
        } else if (node instanceof com.oracle.js.parser.ir.ReturnNode) {
            ((com.oracle.js.parser.ir.ReturnNode)node).setInTerminalPosition(true);
        }
    }

    private List<JavaScriptNode> collectGlobalVars(FunctionNode functionNode, boolean configurable) {
        int symbolCount = functionNode.getBody().getSymbolCount();
        if (symbolCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<DeclareGlobalNode> declarations = new ArrayList<DeclareGlobalNode>(symbolCount);
        for (Symbol symbol : functionNode.getBody().getSymbols()) {
            if (symbol.isGlobal() && symbol.isVar()) {
                if (symbol.isHoistableDeclaration()) {
                    declarations.add(this.factory.createDeclareGlobalFunction(symbol.getName(), configurable, null));
                    continue;
                }
                declarations.add(this.factory.createDeclareGlobalVariable(symbol.getName(), configurable));
                continue;
            }
            if (configurable) continue;
            assert (symbol.isBlockScoped());
            declarations.add(this.factory.createDeclareGlobalLexicalVariable(symbol.getName(), symbol.isConst()));
        }
        ArrayList<JavaScriptNode> nodes = new ArrayList<JavaScriptNode>(2);
        nodes.add(this.factory.createGlobalDeclarationInstantiation(this.context, declarations));
        return nodes;
    }

    protected List<JavaScriptNode> setupModuleEnvironment(FunctionNode functionNode) {
        throw new UnsupportedOperationException();
    }

    protected void createImportBinding(String localName, JSModuleRecord module, String bindingName) {
        this.currentFunction().addImportBinding(localName, module, bindingName);
    }

    protected void verifyModuleLocalExports(Block moduleBodyBlock) {
        throw new UnsupportedOperationException();
    }

    protected JavaScriptNode getActiveScriptOrModule() {
        throw new UnsupportedOperationException();
    }

    private JavaScriptNode prepareArguments(JavaScriptNode body) {
        Environment.VarRef argumentsVar = this.environment.findLocalVar("arguments");
        boolean unmappedArgumentsObject = this.currentFunction().isStrictMode() || !this.currentFunction().hasSimpleParameterList();
        JavaScriptNode argumentsObject = this.factory.createArgumentsObjectNode(this.context, unmappedArgumentsObject, this.currentFunction().getLeadingArgumentCount(), this.currentFunction().getTrailingArgumentCount());
        if (!unmappedArgumentsObject) {
            argumentsObject = this.environment.findArgumentsVar().createWriteNode(argumentsObject);
        }
        JavaScriptNode setArgumentsNode = argumentsVar.createWriteNode(argumentsObject);
        return this.factory.createExprBlock(setArgumentsNode, body);
    }

    private JavaScriptNode prepareThis(JavaScriptNode body, boolean isLexicalThis) {
        JavaScriptNode getThisNode;
        Environment.VarRef thisVar = this.environment.findThisVar();
        JavaScriptNode javaScriptNode = getThisNode = isLexicalThis ? this.factory.createAccessLexicalThis() : this.factory.createAccessThis();
        if (!this.environment.isStrictMode() && !isLexicalThis) {
            getThisNode = this.factory.createPrepareThisBinding(this.context, getThisNode);
        }
        JavaScriptNode setThisNode = thisVar.createWriteNode(getThisNode);
        return this.factory.createExprBlock(setThisNode, body);
    }

    private JavaScriptNode prepareSuper(JavaScriptNode body) {
        JavaScriptNode getHomeObject = this.factory.createAccessHomeObject(this.context);
        JavaScriptNode setSuperNode = this.environment.findSuperVar().createWriteNode(getHomeObject);
        return this.factory.createExprBlock(setSuperNode, body);
    }

    private JavaScriptNode prepareNewTarget(JavaScriptNode body) {
        JavaScriptNode getNewTarget = this.factory.createAccessNewTarget();
        JavaScriptNode setNewTarget = this.environment.findNewTargetVar().createWriteNode(getNewTarget);
        return this.factory.createExprBlock(setNewTarget, body);
    }

    @Override
    public JavaScriptNode enterReturnNode(com.oracle.js.parser.ir.ReturnNode returnNode) {
        JavaScriptNode expression;
        if (returnNode.getExpression() != null) {
            expression = this.transform(returnNode.getExpression());
            if (this.currentFunction().isAsyncGeneratorFunction()) {
                expression = this.createAwaitNode(expression);
            }
        } else {
            expression = this.factory.createConstantUndefined();
        }
        ReturnNode returnStatement = returnNode.isInTerminalPosition() ? this.factory.createTerminalPositionReturn(expression) : this.createReturnNode(expression);
        return this.tagStatement(returnStatement, returnNode);
    }

    private ReturnNode createReturnNode(JavaScriptNode expression) {
        FunctionEnvironment currentFunction = this.currentFunction();
        currentFunction.addReturn();
        if (JSTruffleOptions.ReturnValueInFrame) {
            JavaScriptNode writeReturnSlotNode = this.environment.findTempVar(currentFunction.getReturnSlot()).createWriteNode(expression);
            return this.factory.createFrameReturn(writeReturnSlotNode);
        }
        return this.factory.createReturn(expression);
    }

    @Override
    public JavaScriptNode enterBlock(Block block) {
        JavaScriptNode result;
        try (EnvironmentCloseable blockEnv = this.enterBlockEnvironment(block);){
            List<Statement> blockStatements = block.getStatements();
            List<JavaScriptNode> scopeInit = this.createTemporalDeadZoneInit(block);
            JavaScriptNode blockNode = this.transformStatements(blockStatements, block.isTerminal(), scopeInit, block.isExpressionBlock() || block.isParameterBlock());
            if (block.isFunctionBody() && this.currentFunction().isCallerContextEval()) {
                blockNode = this.prependDynamicScopeBindingInit(block, blockNode);
            }
            result = blockEnv.wrapBlockScope(blockNode);
        }
        if (block.isFunctionBody()) {
            if (this.currentFunction().isGeneratorFunction()) {
                result = this.finishGeneratorBody(result);
            }
            this.tagBody(result, block);
        }
        this.ensureHasSourceSection(result, block);
        return result;
    }

    private List<JavaScriptNode> createTemporalDeadZoneInit(Block block) {
        if (!block.getScope().hasBlockScopedOrRedeclaredSymbols() || this.environment instanceof GlobalEnvironment) {
            return Collections.emptyList();
        }
        ArrayList<JavaScriptNode> blockWithInit = new ArrayList<JavaScriptNode>(block.getSymbolCount() + 1);
        for (Symbol symbol : block.getSymbols()) {
            if (symbol.isImportBinding()) continue;
            if (symbol.isBlockScoped() && !symbol.hasBeenDeclared()) {
                blockWithInit.add(this.findScopeVar(symbol.getName(), true).createWriteNode(this.factory.createConstant(Dead.instance())));
            }
            if (!symbol.isVarRedeclaredHere()) continue;
            assert (block.isFunctionBody());
            assert (this.environment.getScopeLevel() == 1);
            JavaScriptNode outerVar = this.factory.createLocal(this.environment.getParent().findLocalVar(symbol.getName()).getFrameSlot(), 0, 1, this.environment.getParentSlots());
            blockWithInit.add(this.findScopeVar(symbol.getName(), true).createWriteNode(outerVar));
        }
        return blockWithInit;
    }

    private JavaScriptNode prependDynamicScopeBindingInit(Block block, JavaScriptNode blockNode) {
        assert (this.currentFunction().isCallerContextEval());
        ArrayList<JavaScriptNode> blockWithInit = new ArrayList<JavaScriptNode>();
        for (Symbol symbol : block.getSymbols()) {
            if (!symbol.isVar() || this.environment.getVariableEnvironment().hasLocalVar(symbol.getName())) continue;
            blockWithInit.add(this.createDynamicScopeBinding(symbol.getName(), true));
        }
        if (blockWithInit.isEmpty()) {
            return blockNode;
        }
        blockWithInit.add(blockNode);
        return this.factory.createExprBlock(blockWithInit.toArray(EMPTY_NODE_ARRAY));
    }

    private JavaScriptNode createDynamicScopeBinding(String varName, boolean deleteable) {
        assert (deleteable);
        Environment.VarRef dynamicScopeVar = this.environment.findDynamicScopeVar();
        return new DeclareEvalVariableNode(this.context, varName, dynamicScopeVar.createReadNode(), (WriteNode)((Object)dynamicScopeVar.createWriteNode(null)));
    }

    private JavaScriptNode transformStatements(List<Statement> blockStatements, boolean terminal) {
        return this.transformStatements(blockStatements, terminal, Collections.emptyList(), false);
    }

    private JavaScriptNode transformStatements(List<Statement> blockStatements, boolean terminal, List<JavaScriptNode> prolog, boolean expressionBlock) {
        int pos;
        int size = prolog.size() + blockStatements.size();
        JavaScriptNode[] statements = GraalJSTranslator.javaScriptNodeArray(size);
        if (!prolog.isEmpty()) {
            for (pos = 0; pos < prolog.size(); ++pos) {
                statements[pos] = prolog.get(pos);
            }
        }
        int lastNonEmptyIndex = -1;
        for (int i = 0; i < blockStatements.size(); ++i) {
            Statement statement = blockStatements.get(i);
            JavaScriptNode statementNode = this.transformStatementInBlock(statement);
            if (this.currentFunction().returnsLastStatementResult()) {
                if (!statement.isCompletionValueNeverEmpty()) {
                    if (lastNonEmptyIndex >= 0) {
                        statements[lastNonEmptyIndex] = this.wrapSetCompletionValue(statements[lastNonEmptyIndex]);
                        lastNonEmptyIndex = -1;
                    }
                } else {
                    lastNonEmptyIndex = pos;
                }
            }
            statements[pos++] = statementNode;
        }
        if (this.currentFunction().returnsLastStatementResult() && lastNonEmptyIndex >= 0) {
            statements[lastNonEmptyIndex] = this.wrapSetCompletionValue(statements[lastNonEmptyIndex]);
        }
        assert (pos == size);
        return this.createBlock(statements, terminal, expressionBlock);
    }

    private EnvironmentCloseable enterBlockEnvironment(Block block) {
        if (block.isFunctionBody() && this.lc.getCurrentFunction().isScript() && !this.currentFunction().isEval()) {
            GlobalEnvironment globalEnv = new GlobalEnvironment(this.environment, this.factory, this.context);
            GraalJSTranslator.setupGlobalEnvironment(globalEnv, block);
            return new EnvironmentCloseable(globalEnv);
        }
        return this.enterBlockEnvironment(block.getScope());
    }

    private EnvironmentCloseable enterBlockEnvironment(Scope scope) {
        if (scope != null && (scope.hasDeclarations() || JSTruffleOptions.ManyBlockScopes)) {
            if (scope.isFunctionTopScope()) {
                assert (this.environment instanceof FunctionEnvironment);
                boolean onlyBlockScoped = this.currentFunction().isCallerContextEval();
                this.environment.addFrameSlotsFromSymbols(scope.getSymbols(), onlyBlockScoped);
                return new EnvironmentCloseable(this.environment);
            }
            BlockEnvironment blockEnv = new BlockEnvironment(this.environment, this.factory, this.context);
            blockEnv.addFrameSlotsFromSymbols(scope.getSymbols());
            return new EnvironmentCloseable(blockEnv);
        }
        return new EnvironmentCloseable(this.environment);
    }

    private static void setupGlobalEnvironment(GlobalEnvironment globalEnv, Block block) {
        for (Symbol symbol : block.getSymbols()) {
            if (symbol.isImportBinding()) continue;
            if (symbol.isBlockScoped()) {
                globalEnv.addLexicalDeclaration(symbol.getName(), symbol.isConst());
                continue;
            }
            if (!symbol.isGlobal() || !symbol.isVar()) continue;
            globalEnv.addVarDeclaration(symbol.getName());
        }
    }

    private JavaScriptNode transformStatementInBlock(Statement statement) {
        return this.transform(statement);
    }

    @Override
    public JavaScriptNode enterBlockStatement(BlockStatement blockStatement) {
        return this.transform(blockStatement.getBlock());
    }

    @Override
    public JavaScriptNode enterLiteralNode(LiteralNode<?> literalNode) {
        if (literalNode instanceof LiteralNode.ArrayLiteralNode) {
            return this.tagExpression(this.enterLiteralArrayNode((LiteralNode.ArrayLiteralNode)literalNode), literalNode);
        }
        return this.tagExpression(this.enterLiteralDefaultNode(literalNode), literalNode);
    }

    private JavaScriptNode enterLiteralDefaultNode(LiteralNode<?> literalNode) {
        Object value = literalNode.getValue();
        if (value == null) {
            return this.factory.createConstantNull();
        }
        if (value instanceof Long) {
            return this.factory.createConstantDouble(((Long)value).doubleValue());
        }
        if (value instanceof Lexer.RegexToken) {
            return this.factory.createRegExpLiteral(this.context, ((Lexer.RegexToken)value).getExpression(), ((Lexer.RegexToken)value).getOptions());
        }
        if (value instanceof BigInteger) {
            value = BigInt.fromBigInteger((BigInteger)value);
        }
        return this.factory.createConstant(value);
    }

    private JavaScriptNode enterLiteralArrayNode(LiteralNode.ArrayLiteralNode arrayLiteralNode) {
        List<Expression> elementExpressions = arrayLiteralNode.getElementExpressions();
        JavaScriptNode[] elements = GraalJSTranslator.javaScriptNodeArray(elementExpressions.size());
        boolean hasSpread = false;
        for (int i = 0; i < elementExpressions.size(); ++i) {
            Expression elementExpression = elementExpressions.get(i);
            hasSpread = hasSpread || elementExpression != null && elementExpression.isTokenType(TokenType.SPREAD_ARRAY);
            elements[i] = elementExpression != null ? this.transform(elementExpression) : this.factory.createEmpty();
        }
        return hasSpread ? this.factory.createArrayLiteralWithSpread(this.context, elements) : this.factory.createArrayLiteral(this.context, elements);
    }

    @Override
    public JavaScriptNode enterIdentNode(IdentNode identNode) {
        JavaScriptNode result;
        assert (!identNode.isPropertyName());
        if (identNode.isThis()) {
            result = this.createThisNode();
        } else if (identNode.isSuper()) {
            result = this.enterIdentNodeSuper(identNode);
        } else if (identNode.isNewTarget()) {
            result = this.enterNewTarget(identNode);
        } else if (identNode.isImportMeta()) {
            result = this.factory.createImportMeta(this.getActiveScriptOrModule());
        } else {
            String varName = identNode.getName();
            Environment.VarRef varRef = this.findScopeVarCheckTDZ(varName, false);
            result = varRef.createReadNode();
        }
        return this.tagExpression(result, identNode);
    }

    private JavaScriptNode enterNewTarget(IdentNode identNode) {
        Environment.VarRef newTargetVar = this.environment.findNewTargetVar();
        if (newTargetVar == null) {
            throw Errors.createSyntaxError(GraalJSTranslator.error(ECMAErrors.getMessage("parser.error.new.target.in.function", new String[0]), identNode.getToken(), this.lc));
        }
        return newTargetVar.createReadNode();
    }

    private JavaScriptNode enterIdentNodeSuper(IdentNode identNode) {
        if (!identNode.isDirectSuper()) {
            JavaScriptNode getSuperBase = this.factory.createGetPrototype(this.environment.findSuperVar().createReadNode());
            JavaScriptNode receiver = this.checkThisBindingInitialized(this.environment.findThisVar().createReadNode());
            return this.factory.createSuperPropertyReference(getSuperBase, receiver);
        }
        assert (identNode.isDirectSuper());
        JavaScriptNode activeFunction = this.factory.createAccessCallee(this.currentFunction().getArrowFunctionLevel());
        JavaScriptNode superConstructor = this.factory.createGetPrototype(activeFunction);
        JavaScriptNode receiver = this.environment.findThisVar().createReadNode();
        return this.factory.createTargetableWrapper(this.factory.createRequireConstructor(superConstructor), receiver);
    }

    private JavaScriptNode createThisNode() {
        return !this.currentFunction().isGlobal() ? this.checkThisBindingInitialized(this.environment.findThisVar().createReadNode()) : this.factory.createAccessThis();
    }

    private JavaScriptNode checkThisBindingInitialized(JavaScriptNode accessThisNode) {
        if (this.currentFunction().getNonArrowParentFunction().isDerivedConstructor()) {
            return this.factory.createDerivedConstructorThis(accessThisNode);
        }
        return accessThisNode;
    }

    private Environment.VarRef findScopeVar(String name, boolean skipWith) {
        return this.environment.findVar(name, skipWith);
    }

    private Environment.VarRef findScopeVarCheckTDZ(String name, boolean initializationAssignment) {
        final Environment.VarRef varRef = this.findScopeVar(name, false);
        if (varRef.isFunctionLocal()) {
            Symbol symbol = this.lc.getCurrentScope().findBlockScopedSymbolInFunction(varRef.getName());
            if (symbol == null) {
                return varRef;
            }
            if (symbol.hasBeenDeclared()) {
                return varRef;
            }
            if (symbol.isDeclaredInSwitchBlock()) {
                return varRef.withTDZCheck();
            }
            assert (!symbol.hasBeenDeclared());
            if (initializationAssignment) {
                symbol.setHasBeenDeclared();
                return varRef;
            }
            Environment environment = this.environment;
            Objects.requireNonNull(environment);
            return new Environment.VarRef(environment, name){
                {
                    Environment environment = x0;
                    Objects.requireNonNull(environment);
                    super(environment, name);
                }

                @Override
                public boolean isGlobal() {
                    return varRef.isGlobal();
                }

                @Override
                public boolean isFunctionLocal() {
                    return varRef.isFunctionLocal();
                }

                @Override
                public FrameSlot getFrameSlot() {
                    return null;
                }

                @Override
                public JavaScriptNode createReadNode() {
                    return GraalJSTranslator.this.factory.createThrowError(JSErrorType.ReferenceError, String.format("\"%s\" is not defined", varRef.getName()));
                }

                @Override
                public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
                    JavaScriptNode throwErrorNode = this.createReadNode();
                    return GraalJSTranslator.isPotentiallySideEffecting(rhs) ? DualNode.create(rhs, throwErrorNode) : throwErrorNode;
                }
            };
        }
        return varRef.withTDZCheck();
    }

    @Override
    public JavaScriptNode enterVarNode(VarNode varNode) {
        String varName = varNode.getName().getName();
        assert (this.currentFunction().isGlobal() && (!varNode.isBlockScoped() || this.lc.getCurrentBlock().isFunctionBody()) || !this.findScopeVar(varName, true).isGlobal() || this.currentFunction().isCallerContextEval()) : varNode;
        Symbol symbol = null;
        if (varNode.isBlockScoped()) {
            symbol = this.lc.getCurrentScope().getExistingSymbol(varName);
            assert (symbol != null) : varName;
        }
        JavaScriptNode assignment = varNode.isAssignment() ? this.createVarAssignNode(varNode, varName) : (varNode.isBlockScoped() && (!varNode.isDestructuring() || symbol.isDeclaredInSwitchBlock()) && !symbol.hasBeenDeclared() ? this.findScopeVar(varName, false).createWriteNode(this.factory.createConstantUndefined()) : this.factory.createEmpty());
        if (varNode.isBlockScoped() && !symbol.isDeclaredInSwitchBlock() && !varNode.isDestructuring()) {
            symbol.setHasBeenDeclared();
        }
        return assignment;
    }

    private JavaScriptNode createVarAssignNode(VarNode varNode, String varName) {
        Symbol symbol;
        FunctionNode fn;
        JavaScriptNode rhs = this.transform(varNode.getAssignmentSource());
        String functionName = varNode.isExport() && "*default*".equals(varName) ? "default" : varName;
        this.setAnonymousFunctionName(rhs, functionName);
        JavaScriptNode assignment = this.findScopeVar(varName, false).createWriteNode(rhs);
        if (varNode.isBlockScoped() && varNode.isFunctionDeclaration() && this.context.isOptionAnnexB() && !(fn = this.lc.getCurrentFunction()).isStrict() && !varName.equals("arguments") && (symbol = this.lc.getCurrentScope().getExistingSymbol(varName)).isHoistedBlockFunctionDeclaration()) {
            assert (GraalJSTranslator.hasVarSymbol(fn.getVarDeclarationBlock().getScope(), varName)) : varName;
            assignment = this.environment.findVar(varName, true, false, true, false).withRequired(false).createWriteNode(assignment);
            this.tagExpression(assignment, varNode);
        }
        if (varNode.isClassDeclaration()) {
            return this.discardResult(assignment);
        }
        if (!varNode.isHoistableDeclaration()) {
            this.tagStatement(assignment, varNode);
        }
        this.ensureHasSourceSection(assignment, varNode);
        return this.discardResult(assignment);
    }

    private static boolean hasVarSymbol(Scope scope, String varName) {
        Symbol varSymbol = scope.getExistingSymbol(varName);
        return varSymbol != null && varSymbol.isVar() && !varSymbol.isParam();
    }

    private void setAnonymousFunctionName(JavaScriptNode rhs, String name) {
        IfNode ifNode;
        JavaScriptNode thenPart;
        if (this.context.getEcmaScriptVersion() < 6) {
            return;
        }
        if (rhs instanceof FunctionNameHolder) {
            FunctionNameHolder functionNameHolder = (FunctionNameHolder)((Object)rhs);
            if (functionNameHolder.isAnonymous()) {
                functionNameHolder.setFunctionName(name);
            }
        } else if (rhs instanceof JSOrNode.NotUndefinedOrNode && ((JSOrNode.NotUndefinedOrNode)rhs).getRight() instanceof FunctionNameHolder) {
            this.setAnonymousFunctionName(((JSOrNode.NotUndefinedOrNode)rhs).getRight(), name);
        } else if (rhs instanceof IfNode && (thenPart = (ifNode = (IfNode)rhs).getThenPart()) instanceof FunctionNameHolder && ifNode.getElsePart() instanceof AccessIndexedArgumentNode) {
            this.setAnonymousFunctionName(thenPart, name);
        }
    }

    @Override
    public JavaScriptNode enterWhileNode(WhileNode whileNode) {
        JavaScriptNode test = this.transform(whileNode.getTest());
        this.tagStatement(test, whileNode.getTest());
        try (FunctionEnvironment.JumpTargetCloseable<ContinueTarget> target = this.currentFunction().pushContinueTarget(null);){
            JavaScriptNode body = this.transform(whileNode.getBody());
            JavaScriptNode wrappedBody = this.wrapClearCompletionValue(target.wrapContinueTargetNode(body));
            JavaScriptNode result = whileNode.isDoWhile() ? this.createDoWhile(test, wrappedBody) : this.createWhileDo(test, wrappedBody);
            JavaScriptNode javaScriptNode = this.wrapClearAndGetCompletionValue(target.wrapBreakTargetNode(this.ensureHasSourceSection(result, whileNode)));
            return javaScriptNode;
        }
    }

    private JavaScriptNode createDoWhile(JavaScriptNode condition, JavaScriptNode body) {
        return this.factory.createDoWhile(condition, body);
    }

    private JavaScriptNode createWhileDo(JavaScriptNode condition, JavaScriptNode body) {
        return this.factory.createWhileDo(condition, body);
    }

    private JavaScriptNode wrapGetCompletionValue(JavaScriptNode target) {
        if (this.currentFunction().returnsLastStatementResult()) {
            Environment.VarRef returnVar = this.environment.findTempVar(this.currentFunction().getReturnSlot());
            return this.factory.createExprBlock(target, returnVar.createReadNode());
        }
        return target;
    }

    private JavaScriptNode wrapSetCompletionValue(JavaScriptNode statement) {
        if (this.currentFunction().returnsLastStatementResult()) {
            Environment.VarRef returnVar = this.environment.findTempVar(this.currentFunction().getReturnSlot());
            return returnVar.createWriteNode(statement);
        }
        return statement;
    }

    private JavaScriptNode wrapClearCompletionValue(JavaScriptNode statement) {
        if (this.currentFunction().returnsLastStatementResult()) {
            Environment.VarRef returnVar = this.environment.findTempVar(this.currentFunction().getReturnSlot());
            return this.factory.createExprBlock(returnVar.createWriteNode(this.factory.createConstantUndefined()), statement);
        }
        return statement;
    }

    private JavaScriptNode wrapClearAndGetCompletionValue(JavaScriptNode statement) {
        if (this.currentFunction().returnsLastStatementResult()) {
            Environment.VarRef returnVar = this.environment.findTempVar(this.currentFunction().getReturnSlot());
            return this.factory.createExprBlock(returnVar.createWriteNode(this.factory.createConstantUndefined()), statement, returnVar.createReadNode());
        }
        return statement;
    }

    private JavaScriptNode wrapSaveAndRestoreCompletionValue(JavaScriptNode statement) {
        if (this.currentFunction().returnsLastStatementResult()) {
            Environment.VarRef returnVar = this.environment.findTempVar(this.currentFunction().getReturnSlot());
            Environment.VarRef tempVar = this.environment.createTempVar();
            return this.factory.createExprBlock(tempVar.createWriteNode(returnVar.createReadNode()), statement, returnVar.createWriteNode(tempVar.createReadNode()));
        }
        return statement;
    }

    @Override
    public JavaScriptNode enterForNode(ForNode forNode) {
        JavaScriptNode init = forNode.getInit() != null && !forNode.isForInOrOf() ? this.tagStatement(this.transform(forNode.getInit()), forNode.getInit()) : this.factory.createEmpty();
        JavaScriptNode test = forNode.getTest() != null && forNode.getTest().getExpression() != null ? this.tagStatement(this.transform(forNode.getTest()), forNode.getTest()) : this.factory.createConstantBoolean(true);
        JavaScriptNode modify = forNode.getModify() != null ? this.tagStatement(this.transform(forNode.getModify()), forNode.getModify()) : this.factory.createEmpty();
        try (FunctionEnvironment.JumpTargetCloseable<ContinueTarget> target = this.currentFunction().pushContinueTarget(null);){
            JavaScriptNode result;
            if (forNode.isForOf()) {
                result = this.desugarForOf(forNode, modify, target);
            } else if (forNode.isForIn()) {
                result = this.desugarForIn(forNode, modify, target);
            } else if (forNode.isForAwaitOf()) {
                result = this.desugarForAwaitOf(forNode, modify, target);
            } else {
                JavaScriptNode body = this.transform(forNode.getBody());
                JavaScriptNode wrappedBody = this.wrapClearCompletionValue(target.wrapContinueTargetNode(body));
                result = target.wrapBreakTargetNode(this.desugarFor(forNode, init, test, modify, wrappedBody));
            }
            JavaScriptNode javaScriptNode = this.wrapClearAndGetCompletionValue(result);
            return javaScriptNode;
        }
    }

    private JavaScriptNode desugarFor(ForNode forNode, JavaScriptNode init, JavaScriptNode test, JavaScriptNode modify, JavaScriptNode wrappedBody) {
        if (this.needsPerIterationScope(forNode)) {
            Environment.VarRef firstTempVar = this.environment.createTempVar();
            FrameDescriptor iterationBlockFrameDescriptor = this.environment.getBlockFrameDescriptor();
            StatementNode newFor = this.factory.createFor(test, wrappedBody, modify, iterationBlockFrameDescriptor, firstTempVar.createReadNode(), firstTempVar.createWriteNode(this.factory.createConstantBoolean(false)));
            this.ensureHasSourceSection(newFor, forNode);
            return this.createBlock(init, firstTempVar.createWriteNode(this.factory.createConstantBoolean(true)), newFor);
        }
        JavaScriptNode whileDo = this.factory.createDesugaredFor(test, this.createBlock(wrappedBody, modify));
        if (forNode.getTest() == null) {
            this.tagStatement(test, forNode);
        } else {
            this.ensureHasSourceSection(whileDo, forNode);
        }
        return this.createBlock(init, whileDo);
    }

    private JavaScriptNode desugarForIn(ForNode forNode, JavaScriptNode modify, FunctionEnvironment.JumpTargetCloseable<ContinueTarget> jumpTarget) {
        JavaScriptNode createIteratorNode;
        if (forNode.isForEach()) {
            createIteratorNode = this.factory.createEnumerate(this.context, modify, true);
        } else {
            assert (forNode.isForIn() && !forNode.isForEach() && !forNode.isForOf());
            createIteratorNode = this.factory.createEnumerate(this.context, modify, false);
        }
        return this.desugarForInOrOfBody(forNode, this.factory.createGetIterator(this.context, createIteratorNode), jumpTarget);
    }

    private JavaScriptNode desugarForOf(ForNode forNode, JavaScriptNode modify, FunctionEnvironment.JumpTargetCloseable<ContinueTarget> jumpTarget) {
        assert (forNode.isForOf());
        JavaScriptNode getIterator = this.factory.createGetIterator(this.context, modify);
        return this.desugarForInOrOfBody(forNode, getIterator, jumpTarget);
    }

    private JavaScriptNode desugarForInOrOfBody(ForNode forNode, JavaScriptNode iterator, FunctionEnvironment.JumpTargetCloseable<ContinueTarget> jumpTarget) {
        JavaScriptNode wrappedBody;
        assert (forNode.isForInOrOf());
        Environment.VarRef iteratorVar = this.environment.createTempVar();
        JavaScriptNode iteratorInit = iteratorVar.createWriteNode(iterator);
        Environment.VarRef nextResultVar = this.environment.createTempVar();
        JavaScriptNode iteratorNext = this.factory.createIteratorNext(iteratorVar.createReadNode());
        JavaScriptNode condition = this.factory.createDual(this.context, this.factory.createIteratorSetDone(iteratorVar.createReadNode(), this.factory.createConstantBoolean(true)), this.factory.createUnary(NodeFactory.UnaryOperation.NOT, this.factory.createIteratorComplete(this.context, nextResultVar.createWriteNode(iteratorNext))));
        try (EnvironmentCloseable blockEnv = this.needsPerIterationScope(forNode) ? this.enterBlockEnvironment(this.lc.getCurrentBlock()) : new EnvironmentCloseable(this.environment);){
            Environment.VarRef nextResultVar2 = this.environment.findTempVar(nextResultVar.getFrameSlot());
            Environment.VarRef nextValueVar = this.environment.createTempVar();
            Environment.VarRef iteratorVar2 = this.environment.findTempVar(iteratorVar.getFrameSlot());
            JavaScriptNode nextResult = nextResultVar2.createReadNode();
            JavaScriptNode nextValue = this.factory.createIteratorValue(this.context, nextResult);
            JavaScriptNode writeNextValue = nextValueVar.createWriteNode(nextValue);
            JavaScriptNode writeNext = this.tagStatement(this.desugarForHeadAssignment(forNode, nextValueVar.createReadNode()), forNode);
            JavaScriptNode body = this.transform(forNode.getBody());
            wrappedBody = blockEnv.wrapBlockScope(this.createBlock(writeNextValue, this.factory.createIteratorSetDone(iteratorVar2.createReadNode(), this.factory.createConstantBoolean(false)), writeNext, body));
        }
        wrappedBody = jumpTarget.wrapContinueTargetNode(wrappedBody);
        JavaScriptNode whileNode = forNode.isForOf() ? this.factory.createDesugaredForOf(condition, wrappedBody) : this.factory.createDesugaredForIn(condition, wrappedBody);
        JavaScriptNode wrappedWhile = this.factory.createIteratorCloseIfNotDone(this.context, jumpTarget.wrapBreakTargetNode(whileNode), iteratorVar.createReadNode());
        JavaScriptNode resetIterator = iteratorVar.createWriteNode(this.factory.createConstant(JSFrameUtil.DEFAULT_VALUE));
        wrappedWhile = this.factory.createTryFinally(wrappedWhile, resetIterator);
        this.ensureHasSourceSection(whileNode, forNode);
        return this.createBlock(iteratorInit, wrappedWhile);
    }

    private JavaScriptNode desugarForHeadAssignment(ForNode forNode, JavaScriptNode next) {
        boolean lexicalBindingInit = forNode.hasPerIterationScope();
        if (forNode.getInit() instanceof IdentNode && lexicalBindingInit) {
            return this.tagExpression(this.findScopeVarCheckTDZ(((IdentNode)forNode.getInit()).getName(), lexicalBindingInit).createWriteNode(next), forNode);
        }
        return this.tagExpression(this.transformAssignment(forNode.getInit(), forNode.getInit(), next, lexicalBindingInit), forNode);
    }

    private JavaScriptNode desugarForAwaitOf(ForNode forNode, JavaScriptNode modify, FunctionEnvironment.JumpTargetCloseable<ContinueTarget> jumpTarget) {
        JavaScriptNode wrappedBody;
        assert (forNode.isForAwaitOf());
        JavaScriptNode getIterator = this.factory.createGetAsyncIterator(this.context, modify);
        Environment.VarRef iteratorVar = this.environment.createTempVar();
        JavaScriptNode iteratorInit = iteratorVar.createWriteNode(getIterator);
        Environment.VarRef nextResultVar = this.environment.createTempVar();
        this.currentFunction().addAwait();
        JSReadFrameSlotNode asyncResultNode = (JSReadFrameSlotNode)this.environment.findTempVar(this.currentFunction().getAsyncResultSlot()).createReadNode();
        JSReadFrameSlotNode asyncContextNode = (JSReadFrameSlotNode)this.environment.findTempVar(this.currentFunction().getAsyncContextSlot()).createReadNode();
        JavaScriptNode iteratorNext = this.factory.createAsyncIteratorNext(this.context, iteratorVar.createReadNode(), asyncContextNode, asyncResultNode);
        JavaScriptNode condition = this.factory.createDual(this.context, this.factory.createIteratorSetDone(iteratorVar.createReadNode(), this.factory.createConstantBoolean(true)), this.factory.createUnary(NodeFactory.UnaryOperation.NOT, this.factory.createIteratorComplete(this.context, nextResultVar.createWriteNode(iteratorNext))));
        try (EnvironmentCloseable blockEnv = this.needsPerIterationScope(forNode) ? this.enterBlockEnvironment(this.lc.getCurrentBlock()) : new EnvironmentCloseable(this.environment);){
            Environment.VarRef nextResultVar2 = this.environment.findTempVar(nextResultVar.getFrameSlot());
            Environment.VarRef nextValueVar = this.environment.createTempVar();
            Environment.VarRef iteratorVar2 = this.environment.findTempVar(iteratorVar.getFrameSlot());
            JavaScriptNode nextResult = nextResultVar2.createReadNode();
            JavaScriptNode nextValue = this.factory.createIteratorValue(this.context, nextResult);
            JavaScriptNode writeNextValue = nextValueVar.createWriteNode(nextValue);
            JavaScriptNode writeNext = this.tagStatement(this.desugarForHeadAssignment(forNode, nextValueVar.createReadNode()), forNode);
            JavaScriptNode body = this.transform(forNode.getBody());
            wrappedBody = blockEnv.wrapBlockScope(this.createBlock(writeNextValue, this.factory.createIteratorSetDone(iteratorVar2.createReadNode(), this.factory.createConstantBoolean(false)), writeNext, body));
        }
        wrappedBody = jumpTarget.wrapContinueTargetNode(wrappedBody);
        JavaScriptNode whileNode = this.factory.createDesugaredForAwaitOf(condition, wrappedBody);
        this.currentFunction().addAwait();
        JavaScriptNode wrappedWhile = this.factory.createAsyncIteratorCloseWrapper(this.context, jumpTarget.wrapBreakTargetNode(whileNode), iteratorVar.createReadNode(), asyncContextNode, asyncResultNode);
        JavaScriptNode resetIterator = iteratorVar.createWriteNode(this.factory.createConstant(JSFrameUtil.DEFAULT_VALUE));
        wrappedWhile = this.factory.createTryFinally(wrappedWhile, resetIterator);
        this.ensureHasSourceSection(whileNode, forNode);
        return this.createBlock(iteratorInit, wrappedWhile);
    }

    private boolean needsPerIterationScope(ForNode forNode) {
        return forNode.hasPerIterationScope() && GraalJSTranslator.hasClosures(this.lc.getCurrentBlock());
    }

    private static boolean hasClosures(Node node) {
        class HasClosuresVisitor
        extends NodeVisitor<LexicalContext> {
            boolean hasClosures;

            HasClosuresVisitor(LexicalContext lc) {
                super(lc);
            }

            @Override
            public boolean enterFunctionNode(FunctionNode functionNode) {
                this.hasClosures = true;
                return false;
            }
        }
        HasClosuresVisitor visitor = new HasClosuresVisitor(new LexicalContext());
        node.accept(visitor);
        return visitor.hasClosures;
    }

    @Override
    public JavaScriptNode enterLabelNode(LabelNode labelNode) {
        try (FunctionEnvironment.JumpTargetCloseable<BreakTarget> breakTarget = this.currentFunction().pushBreakTarget(labelNode.getLabelName());){
            JavaScriptNode body = this.transform(labelNode.getBody());
            JavaScriptNode javaScriptNode = breakTarget.wrapLabelBreakTargetNode(body);
            return javaScriptNode;
        }
    }

    @Override
    public JavaScriptNode enterBreakNode(BreakNode breakNode) {
        return this.tagStatement(this.factory.createBreak(this.currentFunction().findBreakTarget(breakNode.getLabelName())), breakNode);
    }

    @Override
    public JavaScriptNode enterContinueNode(ContinueNode continueNode) {
        return this.tagStatement(this.factory.createContinue(this.currentFunction().findContinueTarget(continueNode.getLabelName())), continueNode);
    }

    @Override
    public JavaScriptNode enterIfNode(com.oracle.js.parser.ir.IfNode ifNode) {
        JavaScriptNode test = this.transform(ifNode.getTest());
        JavaScriptNode pass = this.transform(ifNode.getPass());
        JavaScriptNode fail = this.transform(ifNode.getFail());
        return this.tagStatement(this.factory.createIf(test, pass, fail), ifNode);
    }

    @Override
    public JavaScriptNode enterTernaryNode(TernaryNode ternaryNode) {
        JavaScriptNode test = this.transform(ternaryNode.getTest());
        JavaScriptNode pass = this.transform(ternaryNode.getTrueExpression());
        JavaScriptNode fail = this.transform(ternaryNode.getFalseExpression());
        return this.tagExpression(this.factory.createIf(test, pass, fail), ternaryNode);
    }

    @Override
    public JavaScriptNode enterUnaryNode(UnaryNode unaryNode) {
        switch (unaryNode.tokenType()) {
            case ADD: 
            case BIT_NOT: 
            case NOT: 
            case SUB: 
            case VOID: {
                return this.enterUnaryDefaultNode(unaryNode);
            }
            case TYPEOF: {
                return this.enterTypeofNode(unaryNode);
            }
            case INCPREFIX: 
            case INCPOSTFIX: 
            case DECPREFIX: 
            case DECPOSTFIX: {
                return this.enterUnaryIncDecNode(unaryNode);
            }
            case NEW: {
                return this.enterNewNode(unaryNode);
            }
            case DELETE: {
                return this.enterDelete(unaryNode);
            }
            case SPREAD_ARGUMENT: {
                return this.tagExpression(this.factory.createSpreadArgument(this.context, this.transform(unaryNode.getExpression())), unaryNode);
            }
            case SPREAD_ARRAY: {
                return this.tagExpression(this.factory.createSpreadArray(this.context, this.transform(unaryNode.getExpression())), unaryNode);
            }
            case YIELD: 
            case YIELD_STAR: {
                return this.tagExpression(this.createYieldNode(unaryNode), unaryNode);
            }
            case AWAIT: {
                return this.tagExpression(this.translateAwaitNode(unaryNode), unaryNode);
            }
        }
        throw new UnsupportedOperationException(unaryNode.tokenType().toString());
    }

    private JavaScriptNode translateAwaitNode(UnaryNode unaryNode) {
        JavaScriptNode expression = this.transform(unaryNode.getExpression());
        return this.createAwaitNode(expression);
    }

    private JavaScriptNode createAwaitNode(JavaScriptNode expression) {
        FunctionEnvironment currentFunction = this.currentFunction();
        currentFunction.addAwait();
        JSReadFrameSlotNode asyncContextNode = (JSReadFrameSlotNode)this.environment.findTempVar(currentFunction.getAsyncContextSlot()).createReadNode();
        JSReadFrameSlotNode asyncResultNode = (JSReadFrameSlotNode)this.environment.findTempVar(currentFunction.getAsyncResultSlot()).createReadNode();
        return this.factory.createAwait(this.context, expression, asyncContextNode, asyncResultNode);
    }

    private JavaScriptNode createYieldNode(UnaryNode unaryNode) {
        FunctionEnvironment currentFunction = this.currentFunction();
        assert (currentFunction.isGeneratorFunction());
        boolean asyncGeneratorYield = currentFunction.isAsyncFunction();
        boolean yieldStar = unaryNode.tokenType() == TokenType.YIELD_STAR;
        JavaScriptNode expression = this.transform(unaryNode.getExpression());
        ReturnNode returnNode = this.createReturnNode(null);
        if (asyncGeneratorYield) {
            currentFunction.addAwait();
            JSReadFrameSlotNode asyncContextNode = (JSReadFrameSlotNode)this.environment.findTempVar(currentFunction.getAsyncContextSlot()).createReadNode();
            JSReadFrameSlotNode asyncResultNode = (JSReadFrameSlotNode)this.environment.findTempVar(currentFunction.getAsyncResultSlot()).createReadNode();
            if (yieldStar) {
                Environment.VarRef tempVar = this.environment.createTempVar();
                return this.factory.createAsyncGeneratorYieldStar(this.context, expression, asyncContextNode, asyncResultNode, returnNode, tempVar.createReadNode(), (WriteNode)((Object)tempVar.createWriteNode(null)));
            }
            return this.factory.createAsyncGeneratorYield(this.context, expression, asyncContextNode, asyncResultNode, returnNode);
        }
        currentFunction.addYield();
        JSWriteFrameSlotNode writeYieldResultNode = JSTruffleOptions.YieldResultInFrame ? (JSWriteFrameSlotNode)this.environment.findTempVar(currentFunction.getYieldResultSlot()).createWriteNode(null) : null;
        return this.factory.createYield(this.context, expression, this.environment.findYieldValueVar().createReadNode(), yieldStar, returnNode, writeYieldResultNode);
    }

    private JavaScriptNode enterUnaryDefaultNode(UnaryNode unaryNode) {
        assert (unaryNode.tokenType() != TokenType.TYPEOF);
        JavaScriptNode operand = this.transform(unaryNode.getExpression());
        return this.tagExpression(this.factory.createUnary(GraalJSTranslator.tokenTypeToUnaryOperation(unaryNode.tokenType()), operand), unaryNode);
    }

    private JavaScriptNode enterTypeofNode(UnaryNode unaryNode) {
        assert (unaryNode.tokenType() == TokenType.TYPEOF);
        JavaScriptNode operand = null;
        if (unaryNode.getExpression() instanceof IdentNode) {
            IdentNode identNode = (IdentNode)unaryNode.getExpression();
            String identNodeName = identNode.getName();
            if (this.context.isOptionNashornCompatibilityMode() && (identNodeName.equals("__LINE__") || identNodeName.equals("__FILE__") || identNodeName.equals("__DIR__"))) {
                operand = GlobalPropertyNode.createPropertyNode(this.context, identNodeName);
            } else if (!identNode.isThis() && !identNode.isMetaProperty()) {
                operand = this.findScopeVarCheckTDZ(identNodeName, false).withRequired(false).createReadNode();
            }
        }
        if (operand == null) {
            operand = this.transform(unaryNode.getExpression());
        } else {
            this.tagExpression(operand, unaryNode.getExpression());
        }
        return this.tagExpression(this.factory.createUnary(GraalJSTranslator.tokenTypeToUnaryOperation(unaryNode.tokenType()), operand), unaryNode);
    }

    private JavaScriptNode enterUnaryIncDecNode(UnaryNode unaryNode) {
        JavaScriptNode operand = this.transform(unaryNode.getExpression());
        if (JSTruffleOptions.LocalVarIncDecNode && GraalJSTranslator.isLocalVariableOperand(operand)) {
            FrameSlot frameSlot = ((FrameSlotNode)operand).getFrameSlot();
            if (JSFrameUtil.isConst(frameSlot)) {
                return this.checkMutableBinding(operand, frameSlot.getIdentifier());
            }
            return this.tagExpression(this.createUnaryIncDecLocalNode(unaryNode, operand), unaryNode);
        }
        NodeFactory.BinaryOperation operation = unaryNode.tokenType() == TokenType.INCPREFIX || unaryNode.tokenType() == TokenType.INCPOSTFIX ? NodeFactory.BinaryOperation.ADD : NodeFactory.BinaryOperation.SUBTRACT;
        boolean isPostfix = unaryNode.tokenType() == TokenType.INCPOSTFIX || unaryNode.tokenType() == TokenType.DECPOSTFIX;
        return this.tagExpression(this.transformCompoundAssignment(unaryNode, unaryNode.getExpression(), this.factory.createConstantNumericUnit(), operation, isPostfix, true), unaryNode);
    }

    private static boolean isLocalVariableOperand(JavaScriptNode operand) {
        return operand instanceof JSReadFrameSlotNode;
    }

    private JavaScriptNode createUnaryIncDecLocalNode(UnaryNode unaryNode, JavaScriptNode operand) {
        switch (unaryNode.tokenType()) {
            case INCPREFIX: {
                return this.factory.createUnary(NodeFactory.UnaryOperation.PREFIX_LOCAL_INCREMENT, operand);
            }
            case INCPOSTFIX: {
                return this.factory.createUnary(NodeFactory.UnaryOperation.POSTFIX_LOCAL_INCREMENT, operand);
            }
            case DECPREFIX: {
                return this.factory.createUnary(NodeFactory.UnaryOperation.PREFIX_LOCAL_DECREMENT, operand);
            }
            case DECPOSTFIX: {
                return this.factory.createUnary(NodeFactory.UnaryOperation.POSTFIX_LOCAL_DECREMENT, operand);
            }
        }
        throw Errors.shouldNotReachHere();
    }

    private static NodeFactory.UnaryOperation tokenTypeToUnaryOperation(TokenType tokenType) {
        switch (tokenType) {
            case ADD: {
                return NodeFactory.UnaryOperation.PLUS;
            }
            case BIT_NOT: {
                return NodeFactory.UnaryOperation.BITWISE_COMPLEMENT;
            }
            case NOT: {
                return NodeFactory.UnaryOperation.NOT;
            }
            case SUB: {
                return NodeFactory.UnaryOperation.MINUS;
            }
            case TYPEOF: {
                return NodeFactory.UnaryOperation.TYPE_OF;
            }
            case VOID: {
                return NodeFactory.UnaryOperation.VOID;
            }
        }
        throw new UnsupportedOperationException(tokenType.toString());
    }

    private JavaScriptNode enterDelete(UnaryNode unaryNode) {
        Expression rhs = unaryNode.getExpression();
        JavaScriptNode result = rhs instanceof AccessNode ? this.enterDeleteAccess(rhs) : (rhs instanceof IndexNode ? this.enterDeleteIndex(rhs) : (rhs instanceof IdentNode ? this.enterDeleteIdent(rhs) : this.factory.createConstantBoolean(true)));
        return this.tagExpression(result, unaryNode);
    }

    private JavaScriptNode enterDeleteIdent(Expression rhs) {
        String varName = ((IdentNode)rhs).getName();
        Environment.VarRef varRef = this.findScopeVar(varName, varName.equals("this"));
        return varRef.createDeleteNode();
    }

    private JavaScriptNode enterDeleteIndex(Expression rhs) {
        IndexNode indexNode = (IndexNode)rhs;
        JavaScriptNode target = this.transform(indexNode.getBase());
        JavaScriptNode element = this.transform(indexNode.getIndex());
        return this.factory.createDeleteProperty(target, element, this.environment.isStrictMode(), this.context);
    }

    private JavaScriptNode enterDeleteAccess(Expression rhs) {
        AccessNode accessNode = (AccessNode)rhs;
        JavaScriptNode target = this.transform(accessNode.getBase());
        return this.factory.createDeleteProperty(target, this.factory.createConstantString(accessNode.getProperty()), this.environment.isStrictMode(), this.context);
    }

    private JavaScriptNode[] transformArgs(List<Expression> argList) {
        int len = argList.size();
        if ((long)len > this.context.getFunctionArgumentsLimit()) {
            throw Errors.createSyntaxError("function has too many parameters");
        }
        JavaScriptNode[] args = GraalJSTranslator.javaScriptNodeArray(len);
        for (int i = 0; i < len; ++i) {
            args[i] = this.transform(argList.get(i));
        }
        return args;
    }

    private JavaScriptNode enterNewNode(UnaryNode unaryNode) {
        CallNode callNode = (CallNode)unaryNode.getExpression();
        JavaScriptNode function = this.transform(callNode.getFunction());
        JavaScriptNode[] args = this.transformArgs(callNode.getArgs());
        JavaScriptNode call = this.factory.createNew(this.context, function, args);
        return this.tagExpression(GraalJSTranslator.tagCall(call), unaryNode);
    }

    @Override
    public JavaScriptNode enterCallNode(CallNode callNode) {
        JavaScriptNode call;
        JavaScriptNode function = this.transform(callNode.getFunction());
        JavaScriptNode[] args = this.transformArgs(callNode.getArgs());
        if (callNode.isEval() && args.length >= 1) {
            call = this.createCallEvalNode(function, args);
        } else if (callNode.isApplyArguments() && this.currentFunction().isDirectArgumentsAccess()) {
            call = this.createCallApplyArgumentsNode(function, args);
        } else if (callNode.getFunction() instanceof IdentNode && ((IdentNode)callNode.getFunction()).isDirectSuper()) {
            args = this.insertNewTargetArg(args);
            call = this.initializeThis(this.factory.createFunctionCallWithNewTarget(this.context, function, args));
        } else {
            call = callNode.isImport() ? this.createImportCallNode(args) : this.createCallDefaultNode(function, args);
        }
        return this.tagExpression(GraalJSTranslator.tagCall(call), callNode);
    }

    private JavaScriptNode[] insertNewTargetArg(JavaScriptNode[] args) {
        JavaScriptNode[] result = new JavaScriptNode[args.length + 1];
        result[0] = this.environment.findNewTargetVar().createReadNode();
        System.arraycopy(args, 0, result, 1, args.length);
        return result;
    }

    private JavaScriptNode initializeThis(JavaScriptNode thisValueNode) {
        Environment.VarRef thisVar = this.environment.findThisVar();
        Environment.VarRef tempVar = this.environment.createTempVar();
        JavaScriptNode uninitialized = this.factory.createBinary(this.context, NodeFactory.BinaryOperation.IDENTICAL, thisVar.createReadNode(), this.factory.createConstantUndefined());
        return this.factory.createIf(this.factory.createDual(this.context, tempVar.createWriteNode(thisValueNode), uninitialized), thisVar.createWriteNode(tempVar.createReadNode()), this.factory.createThrowError(JSErrorType.ReferenceError, "super() called twice"));
    }

    private JavaScriptNode createCallDefaultNode(JavaScriptNode function, JavaScriptNode[] args) {
        return this.factory.createFunctionCall(this.context, function, args);
    }

    private JavaScriptNode createCallEvalNode(JavaScriptNode function, JavaScriptNode[] args) {
        if (!this.currentFunction().isGlobal() && !this.currentFunction().isStrictMode() && !this.currentFunction().isDirectEval()) assert (this.environment.function().isDynamicallyScoped());
        FunctionEnvironment func = this.currentFunction();
        while (func.getParentFunction() != null) {
            func.setNeedsParentFrame(true);
            func = func.getParentFunction();
        }
        return EvalNode.create(this.context, this.environment, function, args, this.createThisNode());
    }

    private JavaScriptNode createCallApplyArgumentsNode(JavaScriptNode function, JavaScriptNode[] args) {
        return this.factory.createCallApplyArguments(this.context, (JSFunctionCallNode)this.createCallDefaultNode(function, args));
    }

    private JavaScriptNode createImportCallNode(JavaScriptNode[] args) {
        assert (args.length == 1);
        return this.factory.createImportCall(this.context, args[0], this.getActiveScriptOrModule());
    }

    @Override
    public JavaScriptNode enterBinaryNode(BinaryNode binaryNode) {
        switch (binaryNode.tokenType()) {
            case ASSIGN: 
            case ASSIGN_INIT: {
                return this.enterBinaryAssignNode(binaryNode);
            }
            case ASSIGN_ADD: 
            case ASSIGN_BIT_AND: 
            case ASSIGN_BIT_OR: 
            case ASSIGN_BIT_XOR: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_MUL: 
            case ASSIGN_EXP: 
            case ASSIGN_SAR: 
            case ASSIGN_SHL: 
            case ASSIGN_SHR: 
            case ASSIGN_SUB: {
                return this.enterBinaryTransformNode(binaryNode);
            }
            case ADD: 
            case SUB: 
            case MUL: 
            case EXP: 
            case DIV: 
            case MOD: 
            case EQ: 
            case EQ_STRICT: 
            case GE: 
            case GT: 
            case LE: 
            case LT: 
            case NE: 
            case NE_STRICT: 
            case BIT_AND: 
            case BIT_OR: 
            case BIT_XOR: 
            case SAR: 
            case SHL: 
            case SHR: 
            case AND: 
            case OR: 
            case NULLISHCOALESC: 
            case INSTANCEOF: 
            case IN: 
            case COMMARIGHT: {
                return this.enterBinaryExpressionNode(binaryNode);
            }
        }
        throw new UnsupportedOperationException(binaryNode.tokenType().toString());
    }

    private JavaScriptNode enterBinaryExpressionNode(BinaryNode binaryNode) {
        JavaScriptNode lhs = this.transform(binaryNode.getLhs());
        JavaScriptNode rhs = this.transform(binaryNode.getRhs());
        return this.tagExpression(this.factory.createBinary(this.context, GraalJSTranslator.tokenTypeToBinaryOperation(binaryNode.tokenType()), lhs, rhs), binaryNode);
    }

    private JavaScriptNode enterBinaryTransformNode(BinaryNode binaryNode) {
        JavaScriptNode assignedValue = this.transform(binaryNode.getAssignmentSource());
        return this.tagExpression(this.transformCompoundAssignment(binaryNode, binaryNode.getAssignmentDest(), assignedValue, GraalJSTranslator.tokenTypeToBinaryOperation(binaryNode.tokenType()), false, false), binaryNode);
    }

    private JavaScriptNode enterBinaryAssignNode(BinaryNode binaryNode) {
        Expression assignmentDest = binaryNode.getAssignmentDest();
        JavaScriptNode assignedValue = this.transform(binaryNode.getAssignmentSource());
        JavaScriptNode assignment = this.transformAssignment(binaryNode, assignmentDest, assignedValue, binaryNode.isTokenType(TokenType.ASSIGN_INIT));
        assert (assignedValue.hasTag(StandardTags.ExpressionTag.class) || !assignedValue.isInstrumentable()) : "ExpressionTag expected but not found for: " + (Object)((Object)assignedValue);
        return this.tagExpression(assignment, binaryNode);
    }

    private static NodeFactory.BinaryOperation tokenTypeToBinaryOperation(TokenType tokenType) {
        switch (tokenType) {
            case ADD: 
            case ASSIGN_ADD: {
                return NodeFactory.BinaryOperation.ADD;
            }
            case SUB: 
            case ASSIGN_SUB: {
                return NodeFactory.BinaryOperation.SUBTRACT;
            }
            case ASSIGN_MUL: 
            case MUL: {
                return NodeFactory.BinaryOperation.MULTIPLY;
            }
            case ASSIGN_EXP: 
            case EXP: {
                return NodeFactory.BinaryOperation.EXPONENTIATE;
            }
            case ASSIGN_DIV: 
            case DIV: {
                return NodeFactory.BinaryOperation.DIVIDE;
            }
            case ASSIGN_MOD: 
            case MOD: {
                return NodeFactory.BinaryOperation.MODULO;
            }
            case ASSIGN_BIT_AND: 
            case BIT_AND: {
                return NodeFactory.BinaryOperation.BITWISE_AND;
            }
            case ASSIGN_BIT_OR: 
            case BIT_OR: {
                return NodeFactory.BinaryOperation.BITWISE_OR;
            }
            case ASSIGN_BIT_XOR: 
            case BIT_XOR: {
                return NodeFactory.BinaryOperation.BITWISE_XOR;
            }
            case ASSIGN_SHL: 
            case SHL: {
                return NodeFactory.BinaryOperation.BITWISE_LEFT_SHIFT;
            }
            case ASSIGN_SAR: 
            case SAR: {
                return NodeFactory.BinaryOperation.BITWISE_RIGHT_SHIFT;
            }
            case ASSIGN_SHR: 
            case SHR: {
                return NodeFactory.BinaryOperation.BITWISE_UNSIGNED_RIGHT_SHIFT;
            }
            case EQ: {
                return NodeFactory.BinaryOperation.EQUAL;
            }
            case EQ_STRICT: {
                return NodeFactory.BinaryOperation.IDENTICAL;
            }
            case GE: {
                return NodeFactory.BinaryOperation.GREATER_OR_EQUAL;
            }
            case GT: {
                return NodeFactory.BinaryOperation.GREATER;
            }
            case LE: {
                return NodeFactory.BinaryOperation.LESS_OR_EQUAL;
            }
            case LT: {
                return NodeFactory.BinaryOperation.LESS;
            }
            case NE: {
                return NodeFactory.BinaryOperation.NOT_EQUAL;
            }
            case NE_STRICT: {
                return NodeFactory.BinaryOperation.NOT_IDENTICAL;
            }
            case AND: {
                return NodeFactory.BinaryOperation.LOGICAL_AND;
            }
            case OR: {
                return NodeFactory.BinaryOperation.LOGICAL_OR;
            }
            case NULLISHCOALESC: {
                return NodeFactory.BinaryOperation.NULLISH_COALESCING;
            }
            case INSTANCEOF: {
                return NodeFactory.BinaryOperation.INSTANCEOF;
            }
            case IN: {
                return NodeFactory.BinaryOperation.IN;
            }
            case COMMARIGHT: {
                return NodeFactory.BinaryOperation.DUAL;
            }
        }
        throw new UnsupportedOperationException(tokenType.toString());
    }

    private JavaScriptNode transformAssignment(Expression assignmentExpression, Expression lhsExpression, JavaScriptNode assignedValue, boolean initializationAssignment) {
        return this.transformAssignmentImpl(assignmentExpression, lhsExpression, assignedValue, initializationAssignment, null, false, false);
    }

    private JavaScriptNode transformCompoundAssignment(Expression assignmentExpression, Expression lhsExpression, JavaScriptNode assignedValue, NodeFactory.BinaryOperation binaryOp, boolean returnOldValue, boolean convertLHSToNumeric) {
        return this.transformAssignmentImpl(assignmentExpression, lhsExpression, assignedValue, false, binaryOp, returnOldValue, convertLHSToNumeric);
    }

    private JavaScriptNode transformAssignmentImpl(Expression assignmentExpression, Expression lhsExpression, JavaScriptNode assignedValue, boolean initializationAssignment, NodeFactory.BinaryOperation binaryOp, boolean returnOldValue, boolean convertLHSToNumeric) {
        JavaScriptNode assignedNode;
        switch (lhsExpression.tokenType()) {
            default: {
                if (!(lhsExpression instanceof IdentNode)) {
                    throw Errors.unsupported("unsupported assignment to token type: " + lhsExpression.tokenType().toString() + " " + lhsExpression.toString());
                }
            }
            case IDENT: {
                assignedNode = this.transformAssignmentIdent((IdentNode)lhsExpression, assignedValue, binaryOp, returnOldValue, convertLHSToNumeric, initializationAssignment);
                break;
            }
            case LBRACKET: {
                assignedNode = this.transformIndexAssignment((IndexNode)lhsExpression, assignedValue, binaryOp, returnOldValue, convertLHSToNumeric);
                break;
            }
            case PERIOD: {
                assignedNode = this.transformPropertyAssignment((AccessNode)lhsExpression, assignedValue, binaryOp, returnOldValue, convertLHSToNumeric);
                break;
            }
            case ARRAY: {
                assert (binaryOp == null);
                assignedNode = this.transformDestructuringArrayAssignment(lhsExpression, assignedValue, initializationAssignment);
                break;
            }
            case LBRACE: {
                assert (binaryOp == null);
                assignedNode = this.transformDestructuringObjectAssignment(lhsExpression, assignedValue, initializationAssignment);
            }
        }
        if (returnOldValue && assignedNode instanceof DualNode) {
            this.ensureHasSourceSection(((DualNode)assignedNode).getLeft(), assignmentExpression);
        }
        return this.tagExpression(assignedNode, assignmentExpression);
    }

    private JavaScriptNode transformAssignmentIdent(IdentNode identNode, JavaScriptNode assignedValue, NodeFactory.BinaryOperation binaryOp, boolean returnOldValue, boolean convertLHSToNumeric, boolean initializationAssignment) {
        if (!identNode.isParenthesized()) {
            this.setAnonymousFunctionName(assignedValue, identNode.getName());
        }
        JavaScriptNode rhs = assignedValue;
        String ident = identNode.getName();
        Environment.VarRef scopeVar = this.findScopeVarCheckTDZ(ident, initializationAssignment);
        if (!initializationAssignment && scopeVar.isConst()) {
            if (this.context.getContextOptions().isV8LegacyConst() && !this.environment.isStrictMode()) {
                return rhs;
            }
            rhs = this.checkMutableBinding(rhs, scopeVar.getName());
        }
        if (binaryOp == null) {
            return scopeVar.createWriteNode(rhs);
        }
        Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> pair = scopeVar.createCompoundAssignNode();
        JavaScriptNode readNode = this.tagExpression(pair.getFirst().get(), identNode);
        if (convertLHSToNumeric) {
            readNode = this.factory.createToNumeric(readNode);
        }
        Environment.VarRef prevValueTemp = null;
        if (returnOldValue) {
            prevValueTemp = this.environment.createTempVar();
            readNode = prevValueTemp.createWriteNode(readNode);
        }
        JavaScriptNode binOpNode = this.tagExpression(this.factory.createBinary(this.context, binaryOp, readNode, rhs), identNode);
        JavaScriptNode writeNode = (JavaScriptNode)((Object)pair.getSecond().apply(binOpNode));
        if (returnOldValue) {
            return this.factory.createDual(this.context, writeNode, prevValueTemp.createReadNode());
        }
        return writeNode;
    }

    private JavaScriptNode checkMutableBinding(JavaScriptNode rhsNode, Object identifier) {
        if (this.context.getContextOptions().isV8LegacyConst() && !this.environment.isStrictMode()) {
            return rhsNode;
        }
        String message = this.context.isOptionV8CompatibilityMode() ? "Assignment to constant variable." : "Assignment to constant \"" + identifier + "\"";
        JavaScriptNode throwTypeError = this.factory.createThrowError(JSErrorType.TypeError, message);
        return GraalJSTranslator.isPotentiallySideEffecting(rhsNode) ? this.createBlock(rhsNode, throwTypeError) : throwTypeError;
    }

    private JavaScriptNode transformPropertyAssignment(AccessNode accessNode, JavaScriptNode assignedValue, NodeFactory.BinaryOperation binaryOp, boolean returnOldValue, boolean convertToNumeric) {
        JavaScriptNode assignedNode;
        JavaScriptNode target = this.transform(accessNode.getBase());
        if (binaryOp == null) {
            assignedNode = this.factory.createWriteProperty(target, accessNode.getProperty(), assignedValue, this.context, this.environment.isStrictMode());
        } else {
            JavaScriptNode target2;
            JavaScriptNode target1;
            if (target instanceof RepeatableNode) {
                target1 = target;
                target2 = this.factory.copy(target);
            } else {
                Environment.VarRef targetTemp = this.environment.createTempVar();
                target1 = targetTemp.createWriteNode(target);
                target2 = targetTemp.createReadNode();
            }
            Environment.VarRef prevValueTemp = null;
            JavaScriptNode readNode = this.tagExpression(this.factory.createReadProperty(this.context, target2, accessNode.getProperty()), accessNode);
            if (convertToNumeric) {
                readNode = this.factory.createToNumeric(readNode);
            }
            if (returnOldValue) {
                prevValueTemp = this.environment.createTempVar();
                readNode = prevValueTemp.createWriteNode(readNode);
            }
            JavaScriptNode binOpNode = this.tagExpression(this.factory.createBinary(this.context, binaryOp, readNode, assignedValue), accessNode);
            WritePropertyNode writeNode = this.factory.createWriteProperty(target1, accessNode.getProperty(), binOpNode, this.context, this.environment.isStrictMode());
            assignedNode = returnOldValue ? this.factory.createDual(this.context, writeNode, prevValueTemp.createReadNode()) : writeNode;
        }
        return assignedNode;
    }

    private JavaScriptNode transformIndexAssignment(IndexNode indexNode, JavaScriptNode assignedValue, NodeFactory.BinaryOperation binaryOp, boolean returnOldValue, boolean convertToNumeric) {
        JavaScriptNode assignedNode;
        JavaScriptNode target = this.transform(indexNode.getBase());
        JavaScriptNode elem = this.transform(indexNode.getIndex());
        if (binaryOp == null) {
            assignedNode = this.factory.createWriteElementNode(target, elem, assignedValue, this.context, this.environment.isStrictMode());
        } else {
            JavaScriptNode target2;
            JavaScriptNode target1;
            Environment.VarRef keyTemp = this.environment.createTempVar();
            JavaScriptNode readIndex = keyTemp.createReadNode();
            JSWriteFrameSlotNode writeIndex = (JSWriteFrameSlotNode)keyTemp.createWriteNode(null);
            if (target instanceof RepeatableNode) {
                target1 = target;
                target2 = this.factory.copy(target);
            } else {
                Environment.VarRef targetTemp = this.environment.createTempVar();
                target1 = targetTemp.createWriteNode(target);
                target2 = targetTemp.createReadNode();
            }
            JavaScriptNode readNode = this.tagExpression(this.factory.createReadElementNode(this.context, target2, readIndex), indexNode);
            if (convertToNumeric) {
                readNode = this.factory.createToNumeric(readNode);
            }
            Environment.VarRef prevValueTemp = null;
            if (returnOldValue) {
                prevValueTemp = this.environment.createTempVar();
                readNode = prevValueTemp.createWriteNode(readNode);
            }
            JavaScriptNode binOpNode = this.tagExpression(this.factory.createBinary(this.context, binaryOp, readNode, assignedValue), indexNode);
            WriteElementNode writeNode = this.factory.createCompoundWriteElementNode(target1, elem, binOpNode, writeIndex, this.context, this.environment.isStrictMode());
            assignedNode = returnOldValue ? this.factory.createDual(this.context, writeNode, prevValueTemp.createReadNode()) : writeNode;
        }
        return assignedNode;
    }

    private JavaScriptNode transformDestructuringArrayAssignment(Expression lhsExpression, JavaScriptNode assignedValue, boolean initializationAssignment) {
        LiteralNode.ArrayLiteralNode arrayLiteralNode = (LiteralNode.ArrayLiteralNode)lhsExpression;
        List<Expression> elementExpressions = arrayLiteralNode.getElementExpressions();
        JavaScriptNode[] initElements = GraalJSTranslator.javaScriptNodeArray(elementExpressions.size());
        Environment.VarRef iteratorTempVar = this.environment.createTempVar();
        Environment.VarRef valueTempVar = this.environment.createTempVar();
        JavaScriptNode initValue = valueTempVar.createWriteNode(assignedValue);
        JavaScriptNode getIterator = this.factory.createGetIterator(this.context, initValue);
        JavaScriptNode initIteratorTempVar = iteratorTempVar.createWriteNode(getIterator);
        for (int i = 0; i < elementExpressions.size(); ++i) {
            Expression lhsExpr;
            Expression element = elementExpressions.get(i);
            Expression init = null;
            if (element instanceof IdentNode) {
                lhsExpr = element;
            } else if (element instanceof BinaryNode) {
                assert (element.isTokenType(TokenType.ASSIGN) || element.isTokenType(TokenType.ASSIGN_INIT));
                lhsExpr = ((BinaryNode)element).getLhs();
                init = ((BinaryNode)element).getRhs();
            } else {
                lhsExpr = element;
            }
            JavaScriptNode rhsNode = this.factory.createIteratorGetNextValue(this.context, iteratorTempVar.createReadNode(), this.factory.createConstantUndefined(), true);
            if (init != null) {
                rhsNode = this.factory.createNotUndefinedOr(rhsNode, this.transform(init));
            }
            if (lhsExpr != null && lhsExpr.isTokenType(TokenType.SPREAD_ARRAY)) {
                rhsNode = this.factory.createIteratorToArray(this.context, iteratorTempVar.createReadNode());
                lhsExpr = ((UnaryNode)lhsExpr).getExpression();
            }
            initElements[i] = lhsExpr != null ? this.transformAssignment(lhsExpr, lhsExpr, rhsNode, initializationAssignment) : rhsNode;
        }
        JavaScriptNode closeIfNotDone = this.factory.createIteratorCloseIfNotDone(this.context, this.createBlock(initElements), iteratorTempVar.createReadNode());
        return this.factory.createExprBlock(initIteratorTempVar, closeIfNotDone, valueTempVar.createReadNode());
    }

    private JavaScriptNode transformDestructuringObjectAssignment(Expression lhsExpression, JavaScriptNode assignedValue, boolean initializationAssignment) {
        ObjectNode objectLiteralNode = (ObjectNode)lhsExpression;
        List<com.oracle.js.parser.ir.PropertyNode> propertyExpressions = objectLiteralNode.getElements();
        if (propertyExpressions.isEmpty()) {
            return this.factory.createRequireObjectCoercible(assignedValue);
        }
        int numberOfProperties = propertyExpressions.size();
        boolean hasRest = propertyExpressions.get(numberOfProperties - 1).isRest();
        boolean requireObjectCoercible = hasRest && numberOfProperties == 1;
        JavaScriptNode[] initElements = GraalJSTranslator.javaScriptNodeArray(numberOfProperties);
        JavaScriptNode[] excludedKeys = hasRest ? GraalJSTranslator.javaScriptNodeArray(numberOfProperties - 1) : null;
        Environment.VarRef valueTempVar = this.environment.createTempVar();
        JavaScriptNode initValueTempVar = valueTempVar.createWriteNode(requireObjectCoercible ? this.factory.createRequireObjectCoercible(assignedValue) : assignedValue);
        for (int i = 0; i < numberOfProperties; ++i) {
            JavaScriptNode rhsNode;
            Expression lhsExpr;
            com.oracle.js.parser.ir.PropertyNode property = propertyExpressions.get(i);
            Expression init = null;
            if (property.getValue() instanceof BinaryNode) {
                assert (property.getValue().isTokenType(TokenType.ASSIGN) || property.getValue().isTokenType(TokenType.ASSIGN_INIT));
                lhsExpr = ((BinaryNode)property.getValue()).getLhs();
                init = ((BinaryNode)property.getValue()).getRhs();
            } else if (property.isRest()) {
                assert (hasRest);
                lhsExpr = ((UnaryNode)property.getKey()).getExpression();
            } else {
                lhsExpr = property.getValue();
            }
            JavaScriptNode toPropertyKey = null;
            if (property.isRest()) {
                JavaScriptNode restObj = this.factory.createObjectLiteral(this.context, new ArrayList<ObjectLiteralNode.ObjectLiteralMemberNode>());
                JavaScriptNode excludedItemsArray = excludedKeys.length == 0 ? null : this.factory.createArrayLiteral(this.context, excludedKeys);
                rhsNode = this.factory.createCopyDataProperties(this.context, restObj, valueTempVar.createReadNode(), excludedItemsArray);
            } else if (property.getKey() instanceof IdentNode && !property.isComputed()) {
                String keyName = property.getKeyName();
                if (hasRest) {
                    excludedKeys[i] = this.factory.createConstantString(keyName);
                }
                rhsNode = this.factory.createReadProperty(this.context, valueTempVar.createReadNode(), keyName);
            } else {
                JavaScriptNode key = this.transform(property.getKey());
                Environment.VarRef keyTempVar = this.environment.createTempVar();
                if (hasRest) {
                    excludedKeys[i] = keyTempVar.createReadNode();
                }
                toPropertyKey = keyTempVar.createWriteNode(this.factory.createToPropertyKey(key));
                rhsNode = this.factory.createReadElementNode(this.context, valueTempVar.createReadNode(), keyTempVar.createReadNode());
            }
            if (init != null) {
                rhsNode = this.factory.createNotUndefinedOr(rhsNode, this.transform(init));
            }
            JavaScriptNode initElement = this.transformAssignment(lhsExpr, lhsExpr, rhsNode, initializationAssignment);
            initElements[i] = toPropertyKey == null ? initElement : this.factory.createDual(this.context, toPropertyKey, initElement);
        }
        return this.factory.createExprBlock(initValueTempVar, this.createBlock(initElements), valueTempVar.createReadNode());
    }

    @Override
    public JavaScriptNode enterAccessNode(AccessNode accessNode) {
        String propertyName = accessNode.getProperty();
        JavaScriptNode base = this.transform(accessNode.getBase());
        return this.tagExpression(this.factory.createReadProperty(this.context, base, propertyName), accessNode);
    }

    @Override
    public JavaScriptNode enterIndexNode(IndexNode indexNode) {
        JavaScriptNode base = this.transform(indexNode.getBase());
        JavaScriptNode index = this.transform(indexNode.getIndex());
        return this.tagExpression(this.factory.createReadElementNode(this.context, base, index), indexNode);
    }

    @Override
    public JavaScriptNode enterObjectNode(ObjectNode objectNode) {
        ArrayList<ObjectLiteralNode.ObjectLiteralMemberNode> members = this.transformPropertyDefinitionList(objectNode.getElements(), false, null);
        return this.tagExpression(this.factory.createObjectLiteral(this.context, members), objectNode);
    }

    private ArrayList<ObjectLiteralNode.ObjectLiteralMemberNode> transformPropertyDefinitionList(List<com.oracle.js.parser.ir.PropertyNode> properties, boolean isClass, Symbol classNameSymbol) {
        ArrayList<ObjectLiteralNode.ObjectLiteralMemberNode> members = new ArrayList<ObjectLiteralNode.ObjectLiteralMemberNode>(properties.size());
        for (int i = 0; i < properties.size(); ++i) {
            com.oracle.js.parser.ir.PropertyNode property = properties.get(i);
            String keyName = property.getKeyName();
            ObjectLiteralNode.ObjectLiteralMemberNode member = property.getValue() != null ? this.enterObjectPropertyNode(property, keyName, isClass, classNameSymbol) : (property.isRest() ? this.factory.createSpreadObjectMember(property.isStatic(), this.transform(((UnaryNode)property.getKey()).getExpression())) : this.enterObjectAccessorNode(property, keyName, isClass));
            members.add(member);
        }
        return members;
    }

    private ObjectLiteralNode.ObjectLiteralMemberNode enterObjectAccessorNode(com.oracle.js.parser.ir.PropertyNode property, String keyName, boolean isClass) {
        boolean enumerable;
        JavaScriptNode getter = this.getAccessor(property.getGetter());
        JavaScriptNode setter = this.getAccessor(property.getSetter());
        boolean bl = enumerable = !isClass;
        if (property.isComputed()) {
            return this.factory.createComputedAccessorMember(this.transform(property.getKey()), property.isStatic(), enumerable, getter, setter);
        }
        return this.factory.createAccessorMember(keyName, property.isStatic(), enumerable, getter, setter);
    }

    private JavaScriptNode getAccessor(FunctionNode accessorFunction) {
        if (accessorFunction == null) {
            return null;
        }
        JavaScriptNode function = this.transform(accessorFunction);
        if (accessorFunction.usesSuper()) {
            assert (accessorFunction.isMethod());
            function = this.factory.createMakeMethod(this.context, function);
        }
        return function;
    }

    private ObjectLiteralNode.ObjectLiteralMemberNode enterObjectPropertyNode(com.oracle.js.parser.ir.PropertyNode property, String keyName, boolean isClass, Symbol classNameSymbol) {
        boolean enumerable;
        if (classNameSymbol != null) {
            classNameSymbol.setHasBeenDeclared(true);
        }
        JavaScriptNode value = this.transform(property.getValue());
        if (classNameSymbol != null) {
            classNameSymbol.setHasBeenDeclared(false);
        }
        if (property.getValue() instanceof FunctionNode && ((FunctionNode)property.getValue()).usesSuper()) {
            assert (((FunctionNode)property.getValue()).isMethod());
            value = this.factory.createMakeMethod(this.context, value);
        }
        boolean bl = enumerable = !isClass;
        if (property.isComputed()) {
            return this.factory.createComputedDataMember(this.transform(property.getKey()), property.isStatic(), enumerable, value);
        }
        if (!isClass && property.isProto()) {
            return this.factory.createProtoMember(keyName, property.isStatic(), value);
        }
        this.setAnonymousFunctionName(value, keyName);
        return this.factory.createDataMember(keyName, property.isStatic(), enumerable, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaScriptNode enterTryNode(TryNode tryNode) {
        JavaScriptNode tryBlock;
        JavaScriptNode result = tryBlock = this.transform(tryNode.getBody());
        if (!tryNode.getCatchBlocks().isEmpty()) {
            for (Block catchParamBlock : tryNode.getCatchBlocks()) {
                CatchNode catchClause = (CatchNode)catchParamBlock.getLastStatement();
                Expression catchParameter = catchClause.getException();
                Block catchBody = catchClause.getBody();
                Expression pattern = catchClause.getDestructuringPattern();
                try (EnvironmentCloseable catchParamEnv = this.enterBlockEnvironment(catchParamBlock);){
                    this.lc.push(catchParamBlock);
                    try {
                        for (Statement statement : catchParamBlock.getStatements().subList(0, catchParamBlock.getStatementCount() - 1)) {
                            assert (statement instanceof VarNode);
                            JavaScriptNode empty = this.transform(statement);
                            assert (empty instanceof EmptyNode);
                        }
                        JavaScriptNode writeErrorVar = null;
                        JavaScriptNode destructuring = null;
                        if (catchParameter != null) {
                            String errorVarName = ((IdentNode)catchParameter).getName();
                            Environment.VarRef errorVar = this.environment.findLocalVar(errorVarName);
                            writeErrorVar = errorVar.createWriteNode(null);
                            if (pattern != null) {
                                destructuring = this.transformAssignment(pattern, pattern, errorVar.createReadNode(), true);
                            }
                        }
                        JavaScriptNode catchBlock = this.transform(catchBody);
                        JavaScriptNode conditionExpression = catchClause.getExceptionCondition() != null ? this.transform(catchClause.getExceptionCondition()) : null;
                        BlockScopeNode blockScope = (BlockScopeNode)catchParamEnv.wrapBlockScope(null);
                        result = this.factory.createTryCatch(this.context, result, catchBlock, writeErrorVar, blockScope, destructuring, conditionExpression);
                        this.ensureHasSourceSection(result, tryNode);
                    }
                    finally {
                        this.lc.pop(catchParamBlock);
                    }
                }
            }
        }
        if (tryNode.getFinallyBody() != null) {
            JavaScriptNode finallyBlock = this.transform(tryNode.getFinallyBody());
            result = this.factory.createTryFinally(result, this.wrapSaveAndRestoreCompletionValue(finallyBlock));
        }
        result = this.wrapClearAndGetCompletionValue(result);
        return result;
    }

    @Override
    public JavaScriptNode enterThrowNode(ThrowNode throwNode) {
        return this.tagStatement(this.factory.createThrow(this.transform(throwNode.getExpression())), throwNode);
    }

    @Override
    public JavaScriptNode enterSwitchNode(SwitchNode switchNode) {
        JavaScriptNode switchBody;
        Block switchBlock = this.lc.getCurrentBlock();
        assert (switchBlock.isSwitchBlock());
        String switchVarName = this.makeUniqueTempVarNameForStatement(switchNode);
        this.environment.declareLocalVar(switchVarName);
        JavaScriptNode switchExpression = this.transform(switchNode.getExpression());
        boolean isSwitchTypeofString = GraalJSTranslator.isSwitchTypeofStringConstant(switchNode, switchExpression);
        if (isSwitchTypeofString) {
            switchExpression = ((TypeOfNode)switchExpression).getOperand();
        }
        Environment.VarRef switchVar = this.environment.findLocalVar(switchVarName);
        JavaScriptNode writeSwitchNode = switchVar.createWriteNode(switchExpression);
        try (FunctionEnvironment.JumpTargetCloseable<BreakTarget> target = this.currentFunction().pushBreakTarget(null);){
            switchBody = JSTruffleOptions.OptimizeNoFallthroughSwitch && GraalJSTranslator.isNoFallthroughSwitch(switchNode) ? this.ifElseFromSwitch(switchNode, switchVar, isSwitchTypeofString) : this.defaultSwitchNode(switchNode, switchVar, isSwitchTypeofString);
            this.tagStatement(switchBody, switchNode);
            switchBody = this.wrapClearAndGetCompletionValue(target.wrapBreakTargetNode(switchBody));
        }
        return this.createBlock(writeSwitchNode, switchBody);
    }

    private JavaScriptNode defaultSwitchNode(SwitchNode switchNode, Environment.VarRef switchVar, boolean isSwitchTypeofString) {
        List<CaseNode> cases = switchNode.getCases();
        int size = cases.size() + (switchNode.hasDefaultCase() ? 0 : 1);
        int[] jumptable = new int[size];
        int defaultpos = -1;
        ArrayList<JavaScriptNode> statementList = new ArrayList<JavaScriptNode>();
        ArrayList<JavaScriptNode> caseExprList = new ArrayList<JavaScriptNode>();
        int lastNonEmptyIndex = -1;
        for (CaseNode switchCase : cases) {
            if (switchCase.getTest() != null) {
                jumptable[caseExprList.size()] = statementList.size();
                JavaScriptNode readSwitchVarNode = switchVar.createReadNode();
                caseExprList.add(this.createSwitchCaseExpr(isSwitchTypeofString, switchCase, readSwitchVarNode));
            } else {
                defaultpos = statementList.size();
            }
            if (switchCase.getStatements().isEmpty()) continue;
            List<Statement> statements = switchCase.getStatements();
            for (int i = 0; i < statements.size(); ++i) {
                Statement statement = statements.get(i);
                JavaScriptNode statementNode = this.transform(statement);
                if (this.currentFunction().returnsLastStatementResult()) {
                    if (!statement.isCompletionValueNeverEmpty()) {
                        if (lastNonEmptyIndex >= 0) {
                            statementList.set(lastNonEmptyIndex, this.wrapSetCompletionValue((JavaScriptNode)((Object)statementList.get(lastNonEmptyIndex))));
                            lastNonEmptyIndex = -1;
                        }
                    } else {
                        lastNonEmptyIndex = statementList.size();
                    }
                }
                statementList.add(statementNode);
            }
        }
        if (this.currentFunction().returnsLastStatementResult() && lastNonEmptyIndex >= 0) {
            statementList.set(lastNonEmptyIndex, this.wrapSetCompletionValue((JavaScriptNode)((Object)statementList.get(lastNonEmptyIndex))));
        }
        jumptable[jumptable.length - 1] = defaultpos != -1 ? defaultpos : statementList.size();
        return this.factory.createSwitch(caseExprList.toArray(EMPTY_NODE_ARRAY), jumptable, statementList.toArray(EMPTY_NODE_ARRAY));
    }

    private JavaScriptNode createSwitchCaseExpr(boolean isSwitchTypeofString, CaseNode switchCase, JavaScriptNode readSwitchVarNode) {
        GraalJSTranslator.tagHiddenExpression(readSwitchVarNode);
        if (isSwitchTypeofString) {
            String typeString = (String)((LiteralNode)switchCase.getTest()).getValue();
            return this.tagExpression(this.factory.createTypeofIdentical(readSwitchVarNode, typeString), switchCase);
        }
        return this.tagExpression(this.factory.createBinary(this.context, NodeFactory.BinaryOperation.IDENTICAL, readSwitchVarNode, this.transform(switchCase.getTest())), switchCase);
    }

    private JavaScriptNode ifElseFromSwitch(SwitchNode switchNode, Environment.VarRef switchVar, boolean isSwitchTypeofString) {
        assert (GraalJSTranslator.isNoFallthroughSwitch(switchNode));
        List<CaseNode> cases = switchNode.getCases();
        CaseNode defaultCase = switchNode.getDefaultCase();
        JavaScriptNode curNode = null;
        if (defaultCase != null) {
            curNode = this.dropTerminalDirectBreakStatement(this.transformStatements(defaultCase.getStatements(), false));
            this.ensureHasSourceSection(curNode, defaultCase);
        }
        for (int i = cases.size() - 1; i >= 0; --i) {
            CaseNode caseNode = cases.get(i);
            if (caseNode.getTest() == null) continue;
            JavaScriptNode readSwitchVarNode = switchVar.createReadNode();
            JavaScriptNode test = this.createSwitchCaseExpr(isSwitchTypeofString, caseNode, readSwitchVarNode);
            if (caseNode.getStatements().isEmpty()) {
                if (curNode instanceof IfNode) {
                    IfNode prevIfNode = (IfNode)curNode;
                    curNode = this.factory.copyIfWithCondition(prevIfNode, this.factory.createLogicalOr(test, prevIfNode.getCondition()));
                } else if (GraalJSTranslator.isPotentiallySideEffecting(test)) {
                    test = this.factory.createIf(test, null, null);
                    this.ensureHasSourceSection(test, caseNode);
                    curNode = curNode == null ? this.discardResult(test) : this.createBlock(test, curNode);
                }
            } else {
                JavaScriptNode pass = this.dropTerminalDirectBreakStatement(this.transformStatements(caseNode.getStatements(), false));
                this.ensureHasSourceSection(pass, caseNode);
                curNode = this.factory.createIf(test, pass, curNode);
            }
            this.ensureHasSourceSection(curNode, caseNode);
        }
        return curNode == null ? this.factory.createEmpty() : curNode;
    }

    private static boolean isPotentiallySideEffecting(JavaScriptNode test) {
        if (test instanceof JSReadFrameSlotNode) {
            return ((JSReadFrameSlotNode)test).hasTemporalDeadZone();
        }
        return !(test instanceof RepeatableNode);
    }

    private JavaScriptNode dropTerminalDirectBreakStatement(JavaScriptNode pass) {
        JavaScriptNode[] statements;
        if (pass instanceof SequenceNode && (statements = ((SequenceNode)((Object)pass)).getStatements()).length > 0 && GraalJSTranslator.isDirectBreakStatement(statements[statements.length - 1])) {
            return this.createBlock(Arrays.copyOfRange(statements, 0, statements.length - 1));
        }
        return pass;
    }

    private static boolean isDirectBreakStatement(JavaScriptNode statement) {
        return statement instanceof com.oracle.truffle.js.nodes.control.BreakNode && ((com.oracle.truffle.js.nodes.control.BreakNode)statement).isDirectBreak();
    }

    private static boolean isNoFallthroughSwitch(SwitchNode switchNode) {
        List<CaseNode> cases = switchNode.getCases();
        for (int i = 0; i < cases.size() - 1; ++i) {
            Statement lastStatement;
            CaseNode caseNode = cases.get(i);
            List<Statement> statements = caseNode.getStatements();
            if (!(statements.isEmpty() ? caseNode.getTest() == null : !GraalJSTranslator.isExceptionalControlFlowNode(lastStatement = statements.get(statements.size() - 1)))) continue;
            return false;
        }
        return true;
    }

    private static boolean isExceptionalControlFlowNode(Node node) {
        return node instanceof BreakNode || node instanceof com.oracle.js.parser.ir.ReturnNode || node instanceof ContinueNode || node instanceof ThrowNode;
    }

    private static boolean isSwitchTypeofStringConstant(SwitchNode switchNode, JavaScriptNode switchExpression) {
        if (!(switchExpression instanceof TypeOfNode)) {
            return false;
        }
        for (CaseNode switchCase : switchNode.getCases()) {
            Expression test = switchCase.getTest();
            if (test == null || test instanceof LiteralNode && ((LiteralNode)test).getValue() instanceof String) continue;
            return false;
        }
        return true;
    }

    private JavaScriptNode discardResult(JavaScriptNode test) {
        if (this.currentFunction().returnsLastStatementResult()) {
            return this.factory.createVoidBlock(test);
        }
        return test;
    }

    @Override
    public JavaScriptNode enterEmptyNode(com.oracle.js.parser.ir.EmptyNode emptyNode) {
        return this.factory.createEmpty();
    }

    @Override
    public JavaScriptNode enterWithNode(WithNode withNode) {
        if (this.context.isOptionDisableWith()) {
            throw Errors.createSyntaxError("with statement is disabled.");
        }
        JavaScriptNode withExpression = this.transform(withNode.getExpression());
        JavaScriptNode toObject = this.factory.createToObjectFromWith(this.context, withExpression, true);
        String withVarName = this.makeUniqueTempVarNameForStatement(withNode);
        this.environment.declareLocalVar(withVarName);
        JavaScriptNode writeWith = this.environment.findLocalVar(withVarName).createWriteNode(toObject);
        try (EnvironmentCloseable withEnv = this.enterWithEnvironment(withVarName);){
            JavaScriptNode withBody = this.transform(withNode.getBody());
            JavaScriptNode javaScriptNode = this.tagStatement(this.factory.createWith(writeWith, this.wrapClearAndGetCompletionValue(withBody)), withNode);
            return javaScriptNode;
        }
    }

    private EnvironmentCloseable enterWithEnvironment(String withVarName) {
        return new EnvironmentCloseable(new WithEnvironment(this.environment, this.factory, this.context, withVarName));
    }

    @Override
    public JavaScriptNode enterRuntimeNode(RuntimeNode runtimeNode) {
        if (runtimeNode.getRequest() == RuntimeNode.Request.REFERENCE_ERROR) {
            String msg = ECMAErrors.getMessage("parser.error.invalid.lvalue", new String[0]);
            return this.factory.createThrowError(JSErrorType.ReferenceError, GraalJSTranslator.error(msg, runtimeNode.getToken(), this.lc));
        }
        if (runtimeNode.getRequest() == RuntimeNode.Request.GET_TEMPLATE_OBJECT) {
            JavaScriptNode rawStrings = this.transform(runtimeNode.getArgs().get(0));
            JavaScriptNode cookedStrings = this.transform(runtimeNode.getArgs().get(1));
            return this.tagExpression(this.factory.createTemplateObject(this.context, rawStrings, cookedStrings), runtimeNode);
        }
        if (runtimeNode.getRequest() == RuntimeNode.Request.TO_STRING) {
            JavaScriptNode value = this.transform(runtimeNode.getArgs().get(0));
            return this.tagExpression(this.factory.createToString(value), runtimeNode);
        }
        throw new UnsupportedOperationException(runtimeNode.toString());
    }

    @Override
    public JavaScriptNode enterDebuggerNode(DebuggerNode debuggerNode) {
        return this.tagStatement(this.factory.createDebugger(), debuggerNode);
    }

    protected static String error(String message, long errorToken, LexicalContext lc) {
        int position = Token.descPosition(errorToken);
        com.oracle.js.parser.Source internalSource = lc.getCurrentFunction().getSource();
        int lineNum = internalSource.getLine(position);
        int columnNum = internalSource.getColumn(position);
        String formatted = ErrorManager.format(message, internalSource, lineNum, columnNum, errorToken);
        return formatted.replace("\r\n", "\n");
    }

    @Override
    public JavaScriptNode enterExpressionStatement(ExpressionStatement expressionStatement) {
        JavaScriptNode expression = this.transform(expressionStatement.getExpression());
        return this.tagStatement(expression, expressionStatement);
    }

    @Override
    public JavaScriptNode enterJoinPredecessorExpression(JoinPredecessorExpression expr) {
        return this.tagExpression(this.transform(expr.getExpression()), expr);
    }

    @Override
    public JavaScriptNode enterClassNode(ClassNode classNode) {
        try (EnvironmentCloseable blockEnv = this.enterBlockEnvironment(classNode.getScope());){
            JavaScriptNode classHeritage = this.transform(classNode.getClassHeritage());
            JavaScriptNode classFunction = this.transform(classNode.getConstructor().getValue());
            String className = null;
            Symbol classNameSymbol = null;
            if (classNode.getIdent() != null) {
                className = classNode.getIdent().getName();
                classNameSymbol = classNode.getScope().getExistingSymbol(className);
            }
            ArrayList<ObjectLiteralNode.ObjectLiteralMemberNode> members = this.transformPropertyDefinitionList(classNode.getClassElements(), true, classNameSymbol);
            JavaScriptNode classDefinition = this.factory.createClassDefinition(this.context, (JSFunctionExpressionNode)classFunction, classHeritage, members.toArray(ObjectLiteralNode.ObjectLiteralMemberNode.EMPTY), className);
            if (className != null) {
                classDefinition = this.ensureHasSourceSection(this.findScopeVar(className, true).createWriteNode(classDefinition), classNode);
            }
            JavaScriptNode javaScriptNode = this.tagExpression(blockEnv.wrapBlockScope(classDefinition), classNode);
            return javaScriptNode;
        }
    }

    @Override
    public JavaScriptNode enterBlockExpression(BlockExpression blockExpression) {
        return this.tagExpression(this.transform(blockExpression.getBlock()), blockExpression);
    }

    @Override
    public JavaScriptNode enterParameterNode(ParameterNode paramNode) {
        FunctionEnvironment currentFunction = this.currentFunction();
        JavaScriptNode valueNode = paramNode.isRestParameter() ? this.factory.createAccessRestArgument(this.context, currentFunction.getLeadingArgumentCount() + paramNode.getIndex(), currentFunction.getTrailingArgumentCount()) : this.factory.createAccessArgument(currentFunction.getLeadingArgumentCount() + paramNode.getIndex());
        return this.tagExpression(GraalJSTranslator.tagHiddenExpression(valueNode), paramNode);
    }

    @Override
    protected JavaScriptNode enterDefault(Node node) {
        throw GraalJSTranslator.shouldNotReachHere(node);
    }

    private static AssertionError shouldNotReachHere(Node node) {
        throw new AssertionError((Object)String.format("should not reach here. %s(%s)", node.getClass().getSimpleName(), node));
    }

    private SourceSection createSourceSection(FunctionNode functionNode) {
        int start = functionNode.getStartWithoutParens();
        int finish = functionNode.getFinishWithoutParens();
        return this.source.createSection(start, finish - start);
    }

    private JavaScriptNode ensureHasSourceSection(JavaScriptNode resultNode, Node parseNode) {
        if (!resultNode.hasSourceSection()) {
            this.assignSourceSection(resultNode, parseNode);
            if (resultNode instanceof GlobalScopeVarWrapperNode) {
                this.ensureHasSourceSection(((GlobalScopeVarWrapperNode)resultNode).getDelegateNode(), parseNode);
            }
        }
        return resultNode;
    }

    private void assignSourceSection(JavaScriptNode resultNode, Node parseNode) {
        resultNode.setSourceSection(this.source, parseNode.getStart(), parseNode.getFinish() - parseNode.getStart());
    }

    private String makeUniqueTempVarNameForStatement(Statement statement) {
        String name = ':' + statement.getClass().getSimpleName() + ':' + statement.getLineNumber() + ':' + statement.getStart();
        assert (!this.environment.hasLocalVar(name));
        return name;
    }

    private final class EnvironmentCloseable
    implements AutoCloseable {
        private final Environment prevEnv;
        private final Environment newEnv;
        private int wrappedInBlockScopeNode;

        EnvironmentCloseable(Environment newEnv) {
            this.prevEnv = GraalJSTranslator.this.environment;
            this.newEnv = newEnv;
            GraalJSTranslator.this.environment = newEnv;
        }

        public JavaScriptNode wrapBlockScope(JavaScriptNode block) {
            if (this.prevEnv != this.newEnv) {
                ++this.wrappedInBlockScopeNode;
                if (this.newEnv instanceof BlockEnvironment) {
                    BlockEnvironment blockEnv = (BlockEnvironment)this.newEnv;
                    return GraalJSTranslator.this.factory.createBlockScope(blockEnv.getBlockFrameDescriptor(), blockEnv.getParentSlot(), block);
                }
            }
            return block;
        }

        @Override
        public void close() {
            assert (GraalJSTranslator.this.environment == this.newEnv);
            assert (this.prevEnv == this.newEnv.getParent() || this.prevEnv == this.newEnv || this.prevEnv instanceof EvalEnvironment);
            assert (this.newEnv == this.prevEnv || !(this.newEnv instanceof BlockEnvironment) || this.wrappedInBlockScopeNode == 1);
            GraalJSTranslator.this.environment = this.prevEnv;
        }
    }
}

