/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class UserScriptException
extends GraalJSException {
    private static final long serialVersionUID = -6624166672101791072L;
    private final Object exceptionObject;

    private UserScriptException(Object exceptionObject, Node originatingNode, int stackTraceLimit) {
        super(UserScriptException.getMessage(exceptionObject), originatingNode, stackTraceLimit);
        this.exceptionObject = exceptionObject;
    }

    private UserScriptException(Throwable exception, Node originatingNode, int stackTraceLimit) {
        super(exception.toString(), exception, originatingNode, stackTraceLimit);
        this.exceptionObject = exception;
    }

    @CompilerDirectives.TruffleBoundary
    public static UserScriptException createCapture(Object exceptionObject, Node originatingNode, int stackTraceLimit, DynamicObject skipFramesUpTo) {
        return UserScriptException.fillInStackTrace(new UserScriptException(exceptionObject, originatingNode, stackTraceLimit), skipFramesUpTo, true);
    }

    @CompilerDirectives.TruffleBoundary
    public static UserScriptException create(Object exceptionObject, Node originatingNode) {
        return UserScriptException.fillInStackTrace(new UserScriptException(exceptionObject, originatingNode, JSTruffleOptions.StackTraceLimit), Undefined.instance, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static UserScriptException create(Object exceptionObject) {
        return UserScriptException.create(exceptionObject, null);
    }

    @CompilerDirectives.TruffleBoundary
    public static UserScriptException createJavaException(Throwable exception) {
        return UserScriptException.createJavaException(exception, null);
    }

    @CompilerDirectives.TruffleBoundary
    public static UserScriptException createJavaException(Throwable exception, Node originatingNode) {
        return UserScriptException.fillInStackTrace(new UserScriptException(exception, originatingNode, JSTruffleOptions.StackTraceLimit), Undefined.instance, false);
    }

    @Override
    public Object getErrorObject() {
        return this.exceptionObject;
    }

    @Override
    public Object getErrorObjectEager(JSContext context) {
        return this.exceptionObject;
    }

    @CompilerDirectives.TruffleBoundary
    private static String getMessage(Object exc) {
        String name;
        Object constructor;
        DynamicObject prototype;
        if (JSRuntime.isObject(exc) && (prototype = JSObject.getPrototype((DynamicObject)exc)) != Null.instance && JSFunction.isJSFunction(constructor = prototype.get((Object)"constructor", null)) && !(name = JSFunction.getName((DynamicObject)constructor)).isEmpty()) {
            Object message = ((DynamicObject)exc).get((Object)"message", null);
            if (JSRuntime.isString(message)) {
                return name + ": " + message;
            }
            return name;
        }
        return JSRuntime.safeToString(exc);
    }
}

