/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.EnumSet;
import java.util.function.Function;

public final class JSDataView
extends JSBuiltinObject
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final String CLASS_NAME = "DataView";
    public static final String PROTOTYPE_NAME = "DataView.prototype";
    public static final JSDataView INSTANCE = new JSDataView();
    private static final String BYTE_LENGTH = "byteLength";
    private static final String BUFFER = "buffer";
    private static final String BYTE_OFFSET = "byteOffset";
    private static final HiddenKey ARRAY_BUFFER_ID = new HiddenKey("arrayBuffer");
    private static final HiddenKey OFFSET_ID = new HiddenKey("offset");
    private static final HiddenKey LENGTH_ID = new HiddenKey("length");
    private static final Property ARRAY_BUFFER_PROPERTY;
    private static final Property ARRAY_LENGTH_PROPERTY;
    private static final Property ARRAY_OFFSET_PROPERTY;

    public static int typedArrayGetLength(DynamicObject thisObj) {
        return (Integer)ARRAY_LENGTH_PROPERTY.get(thisObj, JSDataView.isJSDataView(thisObj));
    }

    public static int typedArrayGetLength(DynamicObject thisObj, boolean condition) {
        return (Integer)ARRAY_LENGTH_PROPERTY.get(thisObj, condition);
    }

    public static void typedArraySetLength(DynamicObject thisObj, int length) {
        ARRAY_LENGTH_PROPERTY.setSafe(thisObj, (Object)length, null);
    }

    public static int typedArrayGetOffset(DynamicObject thisObj) {
        return (Integer)ARRAY_OFFSET_PROPERTY.get(thisObj, JSDataView.isJSDataView(thisObj));
    }

    public static int typedArrayGetOffset(DynamicObject thisObj, boolean condition) {
        return (Integer)ARRAY_OFFSET_PROPERTY.get(thisObj, condition);
    }

    public static void typedArraySetOffset(DynamicObject thisObj, int arrayOffset) {
        ARRAY_OFFSET_PROPERTY.setSafe(thisObj, (Object)arrayOffset, null);
    }

    private JSDataView() {
    }

    public static DynamicObject getArrayBuffer(DynamicObject thisObj) {
        assert (JSDataView.isJSDataView(thisObj));
        return (DynamicObject)ARRAY_BUFFER_PROPERTY.get(thisObj, JSDataView.isJSDataView(thisObj));
    }

    public static DynamicObject createDataView(JSContext context, DynamicObject arrayBuffer, int offset, int length) {
        assert (offset >= 0 && offset + length <= (JSArrayBuffer.isJSDirectOrSharedArrayBuffer(arrayBuffer) ? JSArrayBuffer.getDirectByteLength(arrayBuffer) : JSArrayBuffer.getByteLength(arrayBuffer)));
        DynamicObject dataView = JSObject.create(context, context.getDataViewFactory(), arrayBuffer, length, offset);
        assert (JSArrayBuffer.isJSHeapArrayBuffer(arrayBuffer) || JSArrayBuffer.isJSDirectOrSharedArrayBuffer(arrayBuffer));
        assert (JSDataView.isJSDataView(dataView));
        return dataView;
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext context = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(context, prototype, ctor);
        JSDataView.putGetters(realm, prototype);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, PROTOTYPE_NAME);
        JSObjectUtil.putDataProperty(context, prototype, Symbol.SYMBOL_TO_STRING_TAG, CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        return prototype;
    }

    private static void putGetters(JSRealm realm, DynamicObject prototype) {
        JSDataView.putGetter(realm, prototype, BUFFER, JSContext.BuiltinFunctionKey.DataViewBuffer, view -> JSDataView.getArrayBuffer(view));
        JSDataView.putGetter(realm, prototype, BYTE_LENGTH, JSContext.BuiltinFunctionKey.DataViewByteLength, view -> JSDataView.typedArrayGetLengthChecked(view));
        JSDataView.putGetter(realm, prototype, BYTE_OFFSET, JSContext.BuiltinFunctionKey.DataViewByteOffset, view -> JSDataView.typedArrayGetOffsetChecked(view));
    }

    public static int typedArrayGetLengthChecked(DynamicObject thisObj) {
        if (JSArrayBuffer.isDetachedBuffer(JSDataView.getArrayBuffer(thisObj))) {
            throw Errors.createTypeErrorDetachedBuffer();
        }
        return JSDataView.typedArrayGetLength(thisObj);
    }

    public static int typedArrayGetOffsetChecked(DynamicObject thisObj) {
        if (JSArrayBuffer.isDetachedBuffer(JSDataView.getArrayBuffer(thisObj))) {
            throw Errors.createTypeErrorDetachedBuffer();
        }
        return JSDataView.typedArrayGetOffset(thisObj);
    }

    private static void putGetter(JSRealm realm, DynamicObject prototype, String name, JSContext.BuiltinFunctionKey key, final Function<DynamicObject, Object> function) {
        JSFunctionData getterData = realm.getContext().getOrCreateBuiltinFunctionData(key, c -> JSFunctionData.createCallOnly(c, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference realmRef;

            public Object execute(VirtualFrame frame) {
                DynamicObject dataView;
                Object obj = JSArguments.getThisObject(frame.getArguments());
                if (JSObject.isDynamicObject(obj) && JSDataView.isJSDataView(dataView = JSObject.castJSObject(obj))) {
                    return function.apply(dataView);
                }
                if (this.realmRef == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.realmRef = this.lookupContextReference(JavaScriptLanguage.class);
                }
                throw Errors.createTypeErrorNotADataView().setRealm((JSRealm)this.realmRef.get());
            }
        }), 0, "get " + name));
        JSContext context = realm.getContext();
        DynamicObject getter = JSFunction.create(realm, getterData);
        JSObjectUtil.putConstantAccessorProperty(context, prototype, name, getter, Undefined.instance);
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        Shape childTree = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        childTree = childTree.addProperty(ARRAY_BUFFER_PROPERTY);
        childTree = childTree.addProperty(ARRAY_LENGTH_PROPERTY);
        childTree = childTree.addProperty(ARRAY_OFFSET_PROPERTY);
        return childTree;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    public static boolean isJSDataView(Object obj) {
        return JSObject.isDynamicObject(obj) && JSDataView.isJSDataView((DynamicObject)obj);
    }

    public static boolean isJSDataView(DynamicObject obj) {
        return JSDataView.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getDataViewPrototype();
    }

    static {
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        ARRAY_BUFFER_PROPERTY = JSObjectUtil.makeHiddenProperty(ARRAY_BUFFER_ID, allocator.locationForType(JSObject.CLASS, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        ARRAY_LENGTH_PROPERTY = JSObjectUtil.makeHiddenProperty(LENGTH_ID, allocator.locationForType(Integer.TYPE));
        ARRAY_OFFSET_PROPERTY = JSObjectUtil.makeHiddenProperty(OFFSET_ID, allocator.locationForType(Integer.TYPE));
    }
}

