/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.PluralRules;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSNumberFormat;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import java.text.ParseException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public final class JSPluralRules
extends JSBuiltinObject
implements JSConstructorFactory.Default.WithFunctions,
PrototypeSupplier {
    public static final String CLASS_NAME = "PluralRules";
    public static final String PROTOTYPE_NAME = "PluralRules.prototype";
    private static final HiddenKey INTERNAL_STATE_ID = new HiddenKey("_internalState");
    private static final Property INTERNAL_STATE_PROPERTY;
    public static final JSPluralRules INSTANCE;

    private JSPluralRules() {
    }

    public static boolean isJSPluralRules(Object obj) {
        return JSObject.isDynamicObject(obj) && JSPluralRules.isJSPluralRules((DynamicObject)obj);
    }

    public static boolean isJSPluralRules(DynamicObject obj) {
        return JSPluralRules.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject pluralRulesPrototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(ctx, pluralRulesPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, pluralRulesPrototype, PROTOTYPE_NAME);
        JSObjectUtil.putDataProperty(ctx, pluralRulesPrototype, Symbol.SYMBOL_TO_STRING_TAG, "Object", JSAttributes.configurableNotEnumerableNotWritable());
        return pluralRulesPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        initialShape = initialShape.addProperty(INTERNAL_STATE_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static DynamicObject create(JSContext context) {
        InternalState state = new InternalState();
        DynamicObject result = JSObject.create(context, context.getPluralRulesFactory(), state);
        assert (JSPluralRules.isJSPluralRules(result));
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static void setupInternalPluralRulesAndNumberFormat(InternalState state) {
        state.pluralRules = PluralRules.forLocale((Locale)state.javaLocale, (PluralRules.PluralType)(state.type.equals("ordinal") ? PluralRules.PluralType.ORDINAL : PluralRules.PluralType.CARDINAL));
        state.pluralCategories.addAll(state.pluralRules.getKeywords());
        state.numberFormat = NumberFormat.getInstance((Locale)state.javaLocale);
    }

    public static PluralRules getPluralRulesProperty(DynamicObject obj) {
        return JSPluralRules.getInternalState(obj).pluralRules;
    }

    public static NumberFormat getNumberFormatProperty(DynamicObject obj) {
        return JSPluralRules.getInternalState((DynamicObject)obj).numberFormat;
    }

    @CompilerDirectives.TruffleBoundary
    public static String select(DynamicObject pluralRulesObj, Object n) {
        PluralRules pluralRules = JSPluralRules.getPluralRulesProperty(pluralRulesObj);
        NumberFormat numberFormat = JSPluralRules.getNumberFormatProperty(pluralRulesObj);
        Number x = JSRuntime.toNumber(n);
        String s = numberFormat.format((Object)x);
        try {
            Number toSelectFrom = numberFormat.parse(s);
            return pluralRules.select(JSRuntime.doubleValue(toSelectFrom));
        }
        catch (ParseException pe) {
            return pluralRules.select(JSRuntime.doubleValue(x));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject resolvedOptions(JSContext context, DynamicObject pluralRulesObj) {
        InternalState state = JSPluralRules.getInternalState(pluralRulesObj);
        return state.toResolvedOptionsObject(context);
    }

    public static InternalState getInternalState(DynamicObject pluralRulesObj) {
        return (InternalState)INTERNAL_STATE_PROPERTY.get(pluralRulesObj, JSPluralRules.isJSPluralRules(pluralRulesObj));
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getPluralRulesPrototype();
    }

    static {
        INSTANCE = new JSPluralRules();
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        INTERNAL_STATE_PROPERTY = JSObjectUtil.makeHiddenProperty(INTERNAL_STATE_ID, allocator.locationForType(InternalState.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)));
    }

    public static class InternalState
    extends JSNumberFormat.BasicInternalState {
        private String type = "cardinal";
        private PluralRules pluralRules;
        private List<Object> pluralCategories = new LinkedList<Object>();

        @Override
        void fillResolvedOptions(JSContext context, DynamicObject result) {
            JSObjectUtil.defineDataProperty(result, "locale", this.locale, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "type", this.type, JSAttributes.getDefault());
            super.fillResolvedOptions(context, result);
            JSObjectUtil.defineDataProperty(result, "pluralCategories", JSRuntime.createArrayFromList(context, this.pluralCategories), JSAttributes.getDefault());
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

