/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.joni;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.nodes.Node;

public class JoniRegexSyntaxException
extends RuntimeException
implements TruffleException {
    private static final String template = "Invalid regular expression: /%s/%s: %s";
    private static final String templateNoFlags = "Invalid regular expression: %s: %s";
    private static final String templatePosition = "Invalid regular expression: /%s/%s:%d: %s";
    private static final long serialVersionUID = 1L;

    public JoniRegexSyntaxException(String msg) {
        super(msg);
    }

    @CompilerDirectives.TruffleBoundary
    public JoniRegexSyntaxException(String pattern, String msg) {
        super(String.format(templateNoFlags, pattern, msg));
    }

    @CompilerDirectives.TruffleBoundary
    public JoniRegexSyntaxException(String pattern, String flags, String msg) {
        super(String.format(template, pattern, flags, msg));
    }

    @CompilerDirectives.TruffleBoundary
    public JoniRegexSyntaxException(String pattern, String flags, String msg, int position) {
        super(String.format(templatePosition, pattern, flags, position, msg));
    }

    @CompilerDirectives.TruffleBoundary
    public JoniRegexSyntaxException(String pattern, String flags, String msg, Throwable ex) {
        super(String.format(template, pattern, flags, msg), ex);
    }

    public Node getLocation() {
        return null;
    }

    public boolean isSyntaxError() {
        return true;
    }
}

