/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.joni.result;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.runtime.joni.result.JoniNoMatchResult;
import com.oracle.truffle.js.runtime.joni.result.JoniRegexResult;
import com.oracle.truffle.js.runtime.joni.result.JoniSingleResult;
import com.oracle.truffle.js.runtime.joni.result.JoniStartsEndsIndexArrayResult;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JoniRegexResult.class)
public final class JoniRegexResultFactory {

    @GeneratedBy(value=JoniRegexResult.GetEndNode.class)
    static final class GetEndNodeGen
    extends JoniRegexResult.GetEndNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile singleResult_boundsProfile_;

        private GetEndNodeGen() {
        }

        @Override
        int execute(Object arg0Value, int arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg0Value instanceof JoniNoMatchResult) {
                    JoniNoMatchResult arg0Value_ = (JoniNoMatchResult)arg0Value;
                    return JoniRegexResult.GetEndNode.doNoMatch(arg0Value_, arg1Value);
                }
                if ((state & 2) != 0 && arg0Value instanceof JoniSingleResult) {
                    JoniSingleResult arg0Value_ = (JoniSingleResult)arg0Value;
                    return JoniRegexResult.GetEndNode.doSingleResult(arg0Value_, arg1Value, this.singleResult_boundsProfile_);
                }
                if ((state & 4) != 0 && arg0Value instanceof JoniStartsEndsIndexArrayResult) {
                    JoniStartsEndsIndexArrayResult arg0Value_ = (JoniStartsEndsIndexArrayResult)arg0Value;
                    return JoniRegexResult.GetEndNode.doStartsEndsIndexArray(arg0Value_, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private int executeAndSpecialize(Object arg0Value, int arg1Value) {
            int state;
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int oldState = state = this.state_;
            try {
                if (arg0Value instanceof JoniNoMatchResult) {
                    JoniNoMatchResult arg0Value_ = (JoniNoMatchResult)arg0Value;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    int n = JoniRegexResult.GetEndNode.doNoMatch(arg0Value_, arg1Value);
                    return n;
                }
                if (arg0Value instanceof JoniSingleResult) {
                    JoniSingleResult arg0Value_ = (JoniSingleResult)arg0Value;
                    this.singleResult_boundsProfile_ = ConditionProfile.createBinaryProfile();
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    int n = JoniRegexResult.GetEndNode.doSingleResult(arg0Value_, arg1Value, this.singleResult_boundsProfile_);
                    return n;
                }
                if (arg0Value instanceof JoniStartsEndsIndexArrayResult) {
                    JoniStartsEndsIndexArrayResult arg0Value_ = (JoniStartsEndsIndexArrayResult)arg0Value;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    int n = JoniRegexResult.GetEndNode.doStartsEndsIndexArray(arg0Value_, arg1Value);
                    return n;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (oldState != 0) {
                    this.checkForPolymorphicSpecialize(oldState);
                }
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        private void checkForPolymorphicSpecialize(int oldState) {
            int newState = this.state_;
            if ((oldState ^ newState) != 0) {
                this.reportPolymorphicSpecialize();
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static JoniRegexResult.GetEndNode create() {
            return new GetEndNodeGen();
        }

        public static JoniRegexResult.GetEndNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=JoniRegexResult.GetEndNode.class)
        private static final class Uncached
        extends JoniRegexResult.GetEndNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Object arg0Value, int arg1Value) {
                if (arg0Value instanceof JoniNoMatchResult) {
                    JoniNoMatchResult arg0Value_ = (JoniNoMatchResult)arg0Value;
                    return JoniRegexResult.GetEndNode.doNoMatch(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof JoniSingleResult) {
                    JoniSingleResult arg0Value_ = (JoniSingleResult)arg0Value;
                    return JoniRegexResult.GetEndNode.doSingleResult(arg0Value_, arg1Value, ConditionProfile.getUncached());
                }
                if (arg0Value instanceof JoniStartsEndsIndexArrayResult) {
                    JoniStartsEndsIndexArrayResult arg0Value_ = (JoniStartsEndsIndexArrayResult)arg0Value;
                    return JoniRegexResult.GetEndNode.doStartsEndsIndexArray(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=JoniRegexResult.GetStartNode.class)
    static final class GetStartNodeGen
    extends JoniRegexResult.GetStartNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile singleResult_boundsProfile_;

        private GetStartNodeGen() {
        }

        @Override
        int execute(JoniRegexResult arg0Value, int arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg0Value instanceof JoniNoMatchResult) {
                    JoniNoMatchResult arg0Value_ = (JoniNoMatchResult)arg0Value;
                    return JoniRegexResult.GetStartNode.doNoMatch(arg0Value_, arg1Value);
                }
                if ((state & 2) != 0 && arg0Value instanceof JoniSingleResult) {
                    JoniSingleResult arg0Value_ = (JoniSingleResult)arg0Value;
                    return JoniRegexResult.GetStartNode.doSingleResult(arg0Value_, arg1Value, this.singleResult_boundsProfile_);
                }
                if ((state & 4) != 0 && arg0Value instanceof JoniStartsEndsIndexArrayResult) {
                    JoniStartsEndsIndexArrayResult arg0Value_ = (JoniStartsEndsIndexArrayResult)arg0Value;
                    return JoniRegexResult.GetStartNode.doStartsEndsIndexArray(arg0Value_, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private int executeAndSpecialize(JoniRegexResult arg0Value, int arg1Value) {
            int state;
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int oldState = state = this.state_;
            try {
                if (arg0Value instanceof JoniNoMatchResult) {
                    JoniNoMatchResult arg0Value_ = (JoniNoMatchResult)arg0Value;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    int n = JoniRegexResult.GetStartNode.doNoMatch(arg0Value_, arg1Value);
                    return n;
                }
                if (arg0Value instanceof JoniSingleResult) {
                    JoniSingleResult arg0Value_ = (JoniSingleResult)arg0Value;
                    this.singleResult_boundsProfile_ = ConditionProfile.createBinaryProfile();
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    int n = JoniRegexResult.GetStartNode.doSingleResult(arg0Value_, arg1Value, this.singleResult_boundsProfile_);
                    return n;
                }
                if (arg0Value instanceof JoniStartsEndsIndexArrayResult) {
                    JoniStartsEndsIndexArrayResult arg0Value_ = (JoniStartsEndsIndexArrayResult)arg0Value;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    int n = JoniRegexResult.GetStartNode.doStartsEndsIndexArray(arg0Value_, arg1Value);
                    return n;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (oldState != 0) {
                    this.checkForPolymorphicSpecialize(oldState);
                }
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        private void checkForPolymorphicSpecialize(int oldState) {
            int newState = this.state_;
            if ((oldState ^ newState) != 0) {
                this.reportPolymorphicSpecialize();
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static JoniRegexResult.GetStartNode create() {
            return new GetStartNodeGen();
        }

        public static JoniRegexResult.GetStartNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=JoniRegexResult.GetStartNode.class)
        private static final class Uncached
        extends JoniRegexResult.GetStartNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(JoniRegexResult arg0Value, int arg1Value) {
                if (arg0Value instanceof JoniNoMatchResult) {
                    JoniNoMatchResult arg0Value_ = (JoniNoMatchResult)arg0Value;
                    return JoniRegexResult.GetStartNode.doNoMatch(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof JoniSingleResult) {
                    JoniSingleResult arg0Value_ = (JoniSingleResult)arg0Value;
                    return JoniRegexResult.GetStartNode.doSingleResult(arg0Value_, arg1Value, ConditionProfile.getUncached());
                }
                if (arg0Value instanceof JoniStartsEndsIndexArrayResult) {
                    JoniStartsEndsIndexArrayResult arg0Value_ = (JoniStartsEndsIndexArrayResult)arg0Value;
                    return JoniRegexResult.GetStartNode.doStartsEndsIndexArray(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=JoniRegexResult.InvokeCacheNode.class)
    static final class InvokeCacheNodeGen
    extends JoniRegexResult.InvokeCacheNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private GetStartIdentityData getStartIdentity_cache;
        @Node.Child
        private GetStartEqualsData getStartEquals_cache;
        @Node.Child
        private GetEndIdentityData getEndIdentity_cache;
        @Node.Child
        private GetEndEqualsData getEndEquals_cache;
        @Node.Child
        private JoniRegexResult.GetStartNode read_getStartNode_;
        @Node.Child
        private JoniRegexResult.GetEndNode read_getEndNode_;

        private InvokeCacheNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        Object execute(JoniRegexResult arg0Value, String arg1Value, int arg2Value) throws UnknownIdentifierException {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    GetStartIdentityData s1_ = this.getStartIdentity_cache;
                    while (s1_ != null) {
                        if (arg1Value == s1_.cachedSymbol_) {
                            assert (s1_.cachedSymbol_.equals("getStart"));
                            return this.getStartIdentity(arg0Value, arg1Value, arg2Value, s1_.cachedSymbol_, s1_.getStartNode_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    GetStartEqualsData s2_ = this.getStartEquals_cache;
                    while (s2_ != null) {
                        if (arg1Value.equals(s2_.cachedSymbol_)) {
                            assert (s2_.cachedSymbol_.equals("getStart"));
                            return this.getStartEquals(arg0Value, arg1Value, arg2Value, s2_.cachedSymbol_, s2_.getStartNode_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 4) != 0) {
                    GetEndIdentityData s3_ = this.getEndIdentity_cache;
                    while (s3_ != null) {
                        if (arg1Value == s3_.cachedSymbol_) {
                            assert (s3_.cachedSymbol_.equals("getEnd"));
                            return this.getEndIdentity(arg0Value, arg1Value, arg2Value, s3_.cachedSymbol_, s3_.getEndNode_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    GetEndEqualsData s4_ = this.getEndEquals_cache;
                    while (s4_ != null) {
                        if (arg1Value.equals(s4_.cachedSymbol_)) {
                            assert (s4_.cachedSymbol_.equals("getEnd"));
                            return this.getEndEquals(arg0Value, arg1Value, arg2Value, s4_.cachedSymbol_, s4_.getEndNode_);
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state & 0x10) != 0) {
                    return JoniRegexResult.InvokeCacheNode.read(arg0Value, arg1Value, arg2Value, this.read_getStartNode_, this.read_getEndNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(JoniRegexResult arg0Value, String arg1Value, int arg2Value) throws UnknownIdentifierException {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                Object cachedSymbol__;
                if ((exclude & 1) == 0) {
                    int count1_ = 0;
                    GetStartIdentityData s1_ = this.getStartIdentity_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null) {
                            if (arg1Value == s1_.cachedSymbol_) {
                                assert (s1_.cachedSymbol_.equals("getStart"));
                                break;
                            }
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && ((String)(cachedSymbol__ = arg1Value)).equals("getStart") && count1_ < 2) {
                        s1_ = (GetStartIdentityData)super.insert((Node)new GetStartIdentityData(this.getStartIdentity_cache));
                        s1_.cachedSymbol_ = cachedSymbol__;
                        s1_.getStartNode_ = s1_.insertAccessor(GetStartNodeGen.create());
                        this.getStartIdentity_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        cachedSymbol__ = this.getStartIdentity(arg0Value, arg1Value, arg2Value, s1_.cachedSymbol_, s1_.getStartNode_);
                        return cachedSymbol__;
                    }
                }
                if ((exclude & 2) == 0) {
                    int count2_ = 0;
                    GetStartEqualsData s2_ = this.getStartEquals_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null) {
                            if (arg1Value.equals(s2_.cachedSymbol_)) {
                                assert (s2_.cachedSymbol_.equals("getStart"));
                                break;
                            }
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && ((String)(cachedSymbol__ = arg1Value)).equals("getStart") && count2_ < 2) {
                        s2_ = (GetStartEqualsData)super.insert((Node)new GetStartEqualsData(this.getStartEquals_cache));
                        s2_.cachedSymbol_ = cachedSymbol__;
                        s2_.getStartNode_ = s2_.insertAccessor(GetStartNodeGen.create());
                        this.getStartEquals_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        this.getStartIdentity_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        cachedSymbol__ = this.getStartEquals(arg0Value, arg1Value, arg2Value, s2_.cachedSymbol_, s2_.getStartNode_);
                        return cachedSymbol__;
                    }
                }
                if ((exclude & 4) == 0) {
                    int count3_ = 0;
                    GetEndIdentityData s3_ = this.getEndIdentity_cache;
                    if ((state & 4) != 0) {
                        while (s3_ != null) {
                            if (arg1Value == s3_.cachedSymbol_) {
                                assert (s3_.cachedSymbol_.equals("getEnd"));
                                break;
                            }
                            s3_ = s3_.next_;
                            ++count3_;
                        }
                    }
                    if (s3_ == null && ((String)(cachedSymbol__ = arg1Value)).equals("getEnd") && count3_ < 2) {
                        s3_ = (GetEndIdentityData)super.insert((Node)new GetEndIdentityData(this.getEndIdentity_cache));
                        s3_.cachedSymbol_ = cachedSymbol__;
                        s3_.getEndNode_ = s3_.insertAccessor(GetEndNodeGen.create());
                        this.getEndIdentity_cache = s3_;
                        this.state_ = state |= 4;
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        cachedSymbol__ = this.getEndIdentity(arg0Value, arg1Value, arg2Value, s3_.cachedSymbol_, s3_.getEndNode_);
                        return cachedSymbol__;
                    }
                }
                if ((exclude & 8) == 0) {
                    int count4_ = 0;
                    GetEndEqualsData s4_ = this.getEndEquals_cache;
                    if ((state & 8) != 0) {
                        while (s4_ != null) {
                            if (arg1Value.equals(s4_.cachedSymbol_)) {
                                assert (s4_.cachedSymbol_.equals("getEnd"));
                                break;
                            }
                            s4_ = s4_.next_;
                            ++count4_;
                        }
                    }
                    if (s4_ == null && ((String)(cachedSymbol__ = arg1Value)).equals("getEnd") && count4_ < 2) {
                        s4_ = (GetEndEqualsData)super.insert((Node)new GetEndEqualsData(this.getEndEquals_cache));
                        s4_.cachedSymbol_ = cachedSymbol__;
                        s4_.getEndNode_ = s4_.insertAccessor(GetEndNodeGen.create());
                        this.getEndEquals_cache = s4_;
                        this.exclude_ = exclude |= 4;
                        this.getEndIdentity_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                    }
                    if (s4_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.getEndEquals(arg0Value, arg1Value, arg2Value, s4_.cachedSymbol_, s4_.getEndNode_);
                        return object;
                    }
                }
                this.read_getStartNode_ = (JoniRegexResult.GetStartNode)super.insert((Node)GetStartNodeGen.create());
                this.read_getEndNode_ = (JoniRegexResult.GetEndNode)super.insert((Node)GetEndNodeGen.create());
                this.exclude_ = exclude |= 0xF;
                this.getStartIdentity_cache = null;
                this.getStartEquals_cache = null;
                this.getEndIdentity_cache = null;
                this.getEndEquals_cache = null;
                state &= 0xFFFFFFF0;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                Object object = JoniRegexResult.InvokeCacheNode.read(arg0Value, arg1Value, arg2Value, this.read_getStartNode_, this.read_getEndNode_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                GetStartIdentityData s1_ = this.getStartIdentity_cache;
                GetStartEqualsData s2_ = this.getStartEquals_cache;
                GetEndIdentityData s3_ = this.getEndIdentity_cache;
                GetEndEqualsData s4_ = this.getEndEquals_cache;
                if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null || s3_ != null && s3_.next_ != null || s4_ != null && s4_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static JoniRegexResult.InvokeCacheNode create() {
            return new InvokeCacheNodeGen();
        }

        public static JoniRegexResult.InvokeCacheNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=JoniRegexResult.InvokeCacheNode.class)
        private static final class Uncached
        extends JoniRegexResult.InvokeCacheNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object execute(JoniRegexResult arg0Value, String arg1Value, int arg2Value) throws UnknownIdentifierException {
                return JoniRegexResult.InvokeCacheNode.read(arg0Value, arg1Value, arg2Value, GetStartNodeGen.getUncached(), GetEndNodeGen.getUncached());
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=JoniRegexResult.InvokeCacheNode.class)
        private static final class GetEndEqualsData
        extends Node {
            @Node.Child
            GetEndEqualsData next_;
            @CompilerDirectives.CompilationFinal
            String cachedSymbol_;
            @Node.Child
            JoniRegexResult.GetEndNode getEndNode_;

            GetEndEqualsData(GetEndEqualsData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=JoniRegexResult.InvokeCacheNode.class)
        private static final class GetEndIdentityData
        extends Node {
            @Node.Child
            GetEndIdentityData next_;
            @CompilerDirectives.CompilationFinal
            String cachedSymbol_;
            @Node.Child
            JoniRegexResult.GetEndNode getEndNode_;

            GetEndIdentityData(GetEndIdentityData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=JoniRegexResult.InvokeCacheNode.class)
        private static final class GetStartEqualsData
        extends Node {
            @Node.Child
            GetStartEqualsData next_;
            @CompilerDirectives.CompilationFinal
            String cachedSymbol_;
            @Node.Child
            JoniRegexResult.GetStartNode getStartNode_;

            GetStartEqualsData(GetStartEqualsData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=JoniRegexResult.InvokeCacheNode.class)
        private static final class GetStartIdentityData
        extends Node {
            @Node.Child
            GetStartIdentityData next_;
            @CompilerDirectives.CompilationFinal
            String cachedSymbol_;
            @Node.Child
            JoniRegexResult.GetStartNode getStartNode_;

            GetStartIdentityData(GetStartIdentityData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=JoniRegexResult.IsInvocableCacheNode.class)
    static final class IsInvocableCacheNodeGen
    extends JoniRegexResult.IsInvocableCacheNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private CacheIdentityData cacheIdentity_cache;
        @CompilerDirectives.CompilationFinal
        private CacheEqualsData cacheEquals_cache;

        private IsInvocableCacheNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        boolean execute(JoniRegexResult arg0Value, String arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    CacheIdentityData s1_ = this.cacheIdentity_cache;
                    while (s1_ != null) {
                        if (arg1Value == s1_.cachedSymbol_) {
                            return JoniRegexResult.IsInvocableCacheNode.cacheIdentity(arg0Value, arg1Value, s1_.cachedSymbol_, s1_.result_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    CacheEqualsData s2_ = this.cacheEquals_cache;
                    while (s2_ != null) {
                        if (arg1Value.equals(s2_.cachedSymbol_)) {
                            return JoniRegexResult.IsInvocableCacheNode.cacheEquals(arg0Value, arg1Value, s2_.cachedSymbol_, s2_.result_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 4) != 0) {
                    return JoniRegexResult.IsInvocableCacheNode.isInvocable(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(JoniRegexResult arg0Value, String arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if ((exclude & 1) == 0) {
                    int count1_ = 0;
                    CacheIdentityData s1_ = this.cacheIdentity_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && arg1Value != s1_.cachedSymbol_) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 2) {
                        s1_ = new CacheIdentityData(this.cacheIdentity_cache);
                        s1_.cachedSymbol_ = arg1Value;
                        s1_.result_ = JoniRegexResult.IsInvocableCacheNode.isInvocable(arg0Value, s1_.cachedSymbol_);
                        this.cacheIdentity_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl = JoniRegexResult.IsInvocableCacheNode.cacheIdentity(arg0Value, arg1Value, s1_.cachedSymbol_, s1_.result_);
                        return bl;
                    }
                }
                if ((exclude & 2) == 0) {
                    int count2_ = 0;
                    CacheEqualsData s2_ = this.cacheEquals_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null && !arg1Value.equals(s2_.cachedSymbol_)) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && count2_ < 2) {
                        s2_ = new CacheEqualsData(this.cacheEquals_cache);
                        s2_.cachedSymbol_ = arg1Value;
                        s2_.result_ = JoniRegexResult.IsInvocableCacheNode.isInvocable(arg0Value, s2_.cachedSymbol_);
                        this.cacheEquals_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        this.cacheIdentity_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl = JoniRegexResult.IsInvocableCacheNode.cacheEquals(arg0Value, arg1Value, s2_.cachedSymbol_, s2_.result_);
                        return bl;
                    }
                }
                this.exclude_ = exclude |= 3;
                this.cacheIdentity_cache = null;
                this.cacheEquals_cache = null;
                state &= 0xFFFFFFFC;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                boolean bl = JoniRegexResult.IsInvocableCacheNode.isInvocable(arg0Value, arg1Value);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                CacheIdentityData s1_ = this.cacheIdentity_cache;
                CacheEqualsData s2_ = this.cacheEquals_cache;
                if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static JoniRegexResult.IsInvocableCacheNode create() {
            return new IsInvocableCacheNodeGen();
        }

        public static JoniRegexResult.IsInvocableCacheNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=JoniRegexResult.IsInvocableCacheNode.class)
        private static final class Uncached
        extends JoniRegexResult.IsInvocableCacheNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            boolean execute(JoniRegexResult arg0Value, String arg1Value) {
                return JoniRegexResult.IsInvocableCacheNode.isInvocable(arg0Value, arg1Value);
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=JoniRegexResult.IsInvocableCacheNode.class)
        private static final class CacheEqualsData {
            @CompilerDirectives.CompilationFinal
            CacheEqualsData next_;
            @CompilerDirectives.CompilationFinal
            String cachedSymbol_;
            @CompilerDirectives.CompilationFinal
            boolean result_;

            CacheEqualsData(CacheEqualsData next_) {
                this.next_ = next_;
            }
        }

        @GeneratedBy(value=JoniRegexResult.IsInvocableCacheNode.class)
        private static final class CacheIdentityData {
            @CompilerDirectives.CompilationFinal
            CacheIdentityData next_;
            @CompilerDirectives.CompilationFinal
            String cachedSymbol_;
            @CompilerDirectives.CompilationFinal
            boolean result_;

            CacheIdentityData(CacheIdentityData next_) {
                this.next_ = next_;
            }
        }
    }
}

