/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.builtins.AbstractJSClass;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class Null {
    public static final String TYPE_NAME = "object";
    public static final String NAME = "null";
    public static final JSClass NULL_CLASS = NullClass.INSTANCE;
    private static final Shape SHAPE = JSShape.makeStaticRoot(JSObject.LAYOUT, NULL_CLASS, 0);
    public static final String CLASS_NAME = "null|undefined";
    public static final DynamicObject instance = JSObject.createStatic(SHAPE);

    private Null() {
    }

    static final class NullClass
    extends AbstractJSClass {
        static final NullClass INSTANCE = new NullClass();

        private NullClass() {
        }

        @Override
        public String getClassName(DynamicObject object) {
            return object == Undefined.instance ? "undefined" : Null.NAME;
        }

        @Override
        public String toString() {
            return Null.CLASS_NAME;
        }

        @Override
        public boolean delete(DynamicObject thisObj, long index, boolean isStrict) {
            return this.delete(thisObj, Boundaries.stringValueOf(index), isStrict);
        }

        @Override
        public boolean delete(DynamicObject thisObj, Object key, boolean isStrict) {
            throw Errors.createTypeErrorCannotDeletePropertyOf(key, thisObj);
        }

        @Override
        public String safeToString(DynamicObject object, int depth) {
            return object == Undefined.instance ? "[object Undefined]" : "[object Null]";
        }

        @Override
        public String defaultToString(DynamicObject thisObj) {
            return thisObj == Undefined.instance ? "undefined" : Null.NAME;
        }

        @CompilerDirectives.TruffleBoundary
        public String toString(DynamicObject object) {
            return "DynamicObject<" + this.defaultToString(object) + ">@" + Integer.toHexString(this.hashCode(object));
        }
    }
}

