/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.truffleinterop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNodeGen;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.truffleinterop.InteropBoundFunction;
import com.oracle.truffle.js.runtime.truffleinterop.InteropFunction;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=InteropBoundFunction.class)
final class InteropBoundFunctionGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private InteropBoundFunctionGen() {
    }

    static {
        LibraryExport.register(InteropBoundFunction.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=InteropBoundFunction.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, InteropBoundFunction.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof InteropBoundFunction);
            return new Uncached();
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof InteropBoundFunction);
            return new Cached(receiver);
        }

        @GeneratedBy(value=InteropBoundFunction.class)
        private static final class Uncached
        extends InteropLibrary {
            private final TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_ = this.lookupLanguageReference(JavaScriptLanguage.class);
            private final TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_ = this.lookupContextReference(JavaScriptLanguage.class);

            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof InteropBoundFunction) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.js.runtime.truffleinterop.InteropBoundFunction'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof InteropBoundFunction;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropFunction)receiver).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.getMembers(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.function));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.isMemberInvocable(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.function));
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.invokeMember(arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.function));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.isMemberReadable(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.function));
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.readMember(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.function));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.isMemberModifiable(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.function));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.isMemberInsertable(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.function));
            }

            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                arg0Value.writeMember(arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.function));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.isMemberRemovable(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.function));
            }

            @CompilerDirectives.TruffleBoundary
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                arg0Value.removeMember(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.function));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.hasMemberReadSideEffects(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.function));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.hasMemberWriteSideEffects(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.function));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isInstantiable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.isInstantiable((InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.function));
            }

            @CompilerDirectives.TruffleBoundary
            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.instantiate(arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value.function));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropBoundFunction)receiver).isExecutable();
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropBoundFunction arg0Value = (InteropBoundFunction)arg0Value_;
                return arg0Value.execute(arg1Value, (JavaScriptLanguage)this.javaScriptLanguageReference_.get(), (JSRealm)this.javaScriptLanguageContextReference_.get(), JSInteropExecuteNodeGen.getUncached(), ExportValueNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=InteropBoundFunction.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private InteropLibrary receiverfunctionInteropLibrary;
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_;
            @Node.Child
            private JSInteropExecuteNode executeNode__callNode_;
            @Node.Child
            private ExportValueNode executeNode__exportNode_;

            Cached(Object receiver) {
                this.receiverfunctionInteropLibrary = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create((Object)((InteropBoundFunction)receiver).function)));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof InteropBoundFunction) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.js.runtime.truffleinterop.InteropBoundFunction'. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof InteropBoundFunction)) {
                    return false;
                }
                return this.receiverfunctionInteropLibrary.accepts((Object)((InteropBoundFunction)receiver).function);
            }

            public boolean hasMembers(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropFunction)receiver).hasMembers();
            }

            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.getMembers(arg1Value, this.receiverfunctionInteropLibrary);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.isMemberInvocable(arg1Value, this.receiverfunctionInteropLibrary);
            }

            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.invokeMember(arg1Value, arg2Value, this.receiverfunctionInteropLibrary);
            }

            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.isMemberReadable(arg1Value, this.receiverfunctionInteropLibrary);
            }

            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.readMember(arg1Value, this.receiverfunctionInteropLibrary);
            }

            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.isMemberModifiable(arg1Value, this.receiverfunctionInteropLibrary);
            }

            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.isMemberInsertable(arg1Value, this.receiverfunctionInteropLibrary);
            }

            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                arg0Value.writeMember(arg1Value, arg2Value, this.receiverfunctionInteropLibrary);
            }

            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.isMemberRemovable(arg1Value, this.receiverfunctionInteropLibrary);
            }

            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                arg0Value.removeMember(arg1Value, this.receiverfunctionInteropLibrary);
            }

            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.hasMemberReadSideEffects(arg1Value, this.receiverfunctionInteropLibrary);
            }

            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.hasMemberWriteSideEffects(arg1Value, this.receiverfunctionInteropLibrary);
            }

            public boolean isInstantiable(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.isInstantiable(this.receiverfunctionInteropLibrary);
            }

            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction)arg0Value_;
                return arg0Value.instantiate(arg1Value, this.receiverfunctionInteropLibrary);
            }

            public boolean isExecutable(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropBoundFunction)receiver).isExecutable();
            }

            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                InteropBoundFunction arg0Value = (InteropBoundFunction)arg0Value_;
                int state = this.state_;
                if (state != 0) {
                    return arg0Value.execute(arg1Value, (JavaScriptLanguage)this.javaScriptLanguageReference_.get(), (JSRealm)this.javaScriptLanguageContextReference_.get(), this.executeNode__callNode_, this.executeNode__exportNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeNode_AndSpecialize(InteropBoundFunction arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__ == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    if ((javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_) == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    this.executeNode__callNode_ = (JSInteropExecuteNode)super.insert((Node)JSInteropExecuteNodeGen.create());
                    this.executeNode__exportNode_ = (ExportValueNode)super.insert((Node)ExportValueNode.create());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.execute(arg1Value, (JavaScriptLanguage)javaScriptLanguageReference__.get(), (JSRealm)javaScriptLanguageContextReference__.get(), this.executeNode__callNode_, this.executeNode__exportNode_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

