/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.llvm;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.BytePointer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.LLVM;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.Pointer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.PointerPointer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.llvm.LLVMUtils;
import org.graalvm.compiler.debug.GraalError;

public class LLVMIRBuilder {
    private static final String DEFAULT_INSTR_NAME = "";
    private LLVM.LLVMContextRef context;
    private LLVM.LLVMModuleRef module;
    private LLVM.LLVMValueRef function;
    private LLVM.LLVMBuilderRef builder;
    private String functionName;
    private LLVM.LLVMValueRef gcRegisterFunction;
    public static final AtomicLong nextPatchpointId = new AtomicLong(0L);
    private static final int LLVM_CMPXCHG_VALUE = 0;
    private static final int LLVM_CMPXCHG_SUCCESS = 1;

    public LLVMIRBuilder(String functionName, LLVM.LLVMContextRef context) {
        this.context = context;
        this.functionName = functionName;
        this.module = LLVM.LLVMModuleCreateWithNameInContext((String)functionName, (LLVM.LLVMContextRef)context);
        this.builder = LLVM.LLVMCreateBuilderInContext((LLVM.LLVMContextRef)context);
        this.gcRegisterFunction = this.addFunction("__llvm_gc_register", this.functionType(this.objectType(), this.rawPointerType()));
        LLVM.LLVMSetLinkage((LLVM.LLVMValueRef)this.gcRegisterFunction, (int)2);
        this.setAttribute(this.gcRegisterFunction, -1L, "alwaysinline");
        this.setAttribute(this.gcRegisterFunction, -1L, "gc-leaf-function");
        LLVM.LLVMBasicBlockRef block = this.appendBasicBlock("main", this.gcRegisterFunction);
        this.positionAtEnd(block);
        LLVM.LLVMValueRef arg = LLVMIRBuilder.getParam(this.gcRegisterFunction, 0);
        LLVM.LLVMValueRef ref = this.buildAddrSpaceCast(arg, this.objectType());
        this.buildRet(ref);
    }

    public LLVM.LLVMModuleRef getModule() {
        return this.module;
    }

    public byte[] getBitcode() {
        if (LLVM.LLVMVerifyModule((LLVM.LLVMModuleRef)this.module, (int)1, (BytePointer)new BytePointer(LLVMUtils.NULL)) == 1) {
            LLVM.LLVMDumpModule((LLVM.LLVMModuleRef)this.module);
            throw new GraalError("LLVM module verification failed");
        }
        LLVM.LLVMMemoryBufferRef buffer = LLVM.LLVMWriteBitcodeToMemoryBuffer((LLVM.LLVMModuleRef)this.module);
        LLVM.LLVMDisposeModule((LLVM.LLVMModuleRef)this.module);
        LLVM.LLVMDisposeBuilder((LLVM.LLVMBuilderRef)this.builder);
        LLVM.LLVMContextDispose((LLVM.LLVMContextRef)this.context);
        BytePointer start = LLVM.LLVMGetBufferStart((LLVM.LLVMMemoryBufferRef)buffer);
        int size = NumUtil.safeToInt((long)LLVM.LLVMGetBufferSize((LLVM.LLVMMemoryBufferRef)buffer));
        byte[] bitcode = new byte[size];
        start.get(bitcode, 0, size);
        LLVM.LLVMDisposeMemoryBuffer((LLVM.LLVMMemoryBufferRef)buffer);
        return bitcode;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    LLVM.LLVMValueRef addFunction(String name, LLVM.LLVMTypeRef type) {
        return LLVM.LLVMAddFunction((LLVM.LLVMModuleRef)this.module, (String)name, (LLVM.LLVMTypeRef)type);
    }

    public void addMainFunction(LLVM.LLVMTypeRef type) {
        this.function = this.addFunction(this.functionName, type);
        LLVM.LLVMSetGC((LLVM.LLVMValueRef)this.function, (String)"statepoint-example");
        LLVMIRBuilder.setLinkage(this.function, 0);
        this.setAttribute(this.function, -1L, "noinline");
        this.setAttribute(this.function, -1L, "noredzone");
    }

    public LLVM.LLVMValueRef getMainFunction() {
        return this.function;
    }

    public void addAlias(String alias) {
        LLVM.LLVMAddAlias((LLVM.LLVMModuleRef)this.getModule(), (LLVM.LLVMTypeRef)LLVM.LLVMTypeOf((LLVM.LLVMValueRef)this.getMainFunction()), (LLVM.LLVMValueRef)this.getMainFunction(), (String)alias);
    }

    private static void setLinkage(LLVM.LLVMValueRef global, int linkage) {
        LLVM.LLVMSetLinkage((LLVM.LLVMValueRef)global, (int)linkage);
    }

    public void setAttribute(LLVM.LLVMValueRef func, long index, String attribute) {
        LLVM.LLVMAttributeRef attr;
        int kind = LLVM.LLVMGetEnumAttributeKindForName((String)attribute, (long)attribute.length());
        if (kind != 0) {
            attr = LLVM.LLVMCreateEnumAttribute((LLVM.LLVMContextRef)this.context, (int)kind, (long)1L);
        } else {
            String value = "true";
            attr = LLVM.LLVMCreateStringAttribute((LLVM.LLVMContextRef)this.context, (String)attribute, (int)attribute.length(), (String)value, (int)value.length());
        }
        LLVM.LLVMAddAttributeAtIndex((LLVM.LLVMValueRef)func, (int)((int)index), (LLVM.LLVMAttributeRef)attr);
    }

    void setCallSiteAttribute(LLVM.LLVMValueRef call, long index, String attribute) {
        LLVM.LLVMAttributeRef attr;
        int kind = LLVM.LLVMGetEnumAttributeKindForName((String)attribute, (long)attribute.length());
        if (kind != 0) {
            attr = LLVM.LLVMCreateEnumAttribute((LLVM.LLVMContextRef)this.context, (int)kind, (long)1L);
        } else {
            String value = "true";
            attr = LLVM.LLVMCreateStringAttribute((LLVM.LLVMContextRef)this.context, (String)attribute, (int)attribute.length(), (String)value, (int)value.length());
        }
        LLVM.LLVMAddCallSiteAttribute((LLVM.LLVMValueRef)call, (int)((int)index), (LLVM.LLVMAttributeRef)attr);
    }

    void setPersonalityFunction(LLVM.LLVMValueRef function, LLVM.LLVMValueRef personality) {
        LLVM.LLVMSetPersonalityFn((LLVM.LLVMValueRef)function, (LLVM.LLVMValueRef)personality);
    }

    public void setPersonalityFunction(LLVM.LLVMValueRef personality) {
        this.setPersonalityFunction(this.getMainFunction(), personality);
    }

    public LLVM.LLVMValueRef createJNIWrapper(LLVM.LLVMValueRef callee, long statepointId, int numArgs, int anchorIPOffset, LLVM.LLVMBasicBlockRef currentBlock) {
        LLVM.LLVMTypeRef calleeType = LLVMIRBuilder.getElementType(LLVMIRBuilder.typeOf(callee));
        LLVM.LLVMTypeRef wrapperType = this.prependArguments(calleeType, this.rawPointerType(), LLVMIRBuilder.typeOf(callee));
        LLVM.LLVMValueRef transitionWrapper = this.addFunction("__llvm_jni_wrapper_" + LLVMIRBuilder.intrinsicType(calleeType), wrapperType);
        LLVM.LLVMSetLinkage((LLVM.LLVMValueRef)transitionWrapper, (int)2);
        this.setAttribute(transitionWrapper, -1L, "noinline");
        LLVM.LLVMBasicBlockRef block = this.appendBasicBlock("main", transitionWrapper);
        this.positionAtEnd(block);
        LLVM.LLVMValueRef anchor = LLVMIRBuilder.getParam(transitionWrapper, 0);
        LLVM.LLVMValueRef lastIPAddr = this.buildGEP(anchor, this.constantInt(anchorIPOffset));
        LLVM.LLVMValueRef callIP = this.buildReturnAddress(this.constantInt(0));
        this.buildStore(callIP, lastIPAddr);
        LLVM.LLVMValueRef[] args = new LLVM.LLVMValueRef[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            args[i] = LLVMIRBuilder.getParam(transitionWrapper, i + 2);
        }
        LLVM.LLVMValueRef target = LLVMIRBuilder.getParam(transitionWrapper, 1);
        LLVM.LLVMValueRef ret = this.buildCall(target, args);
        this.setCallSiteAttribute(ret, -1L, "gc-leaf-function");
        if (LLVMIRBuilder.isVoidType(LLVMIRBuilder.getReturnType(calleeType))) {
            this.buildRetVoid();
        } else {
            this.buildRet(ret);
        }
        this.positionAtEnd(currentBlock);
        return transitionWrapper;
    }

    LLVM.LLVMBasicBlockRef appendBasicBlock(String name, LLVM.LLVMValueRef func) {
        return LLVM.LLVMAppendBasicBlockInContext((LLVM.LLVMContextRef)this.context, (LLVM.LLVMValueRef)func, (String)name);
    }

    public LLVM.LLVMBasicBlockRef appendBasicBlock(String name) {
        return this.appendBasicBlock(name, this.function);
    }

    void positionAtStart() {
        LLVM.LLVMValueRef firstInstruction = LLVM.LLVMGetFirstInstruction((LLVM.LLVMBasicBlockRef)LLVM.LLVMGetFirstBasicBlock((LLVM.LLVMValueRef)this.function));
        if (firstInstruction != null) {
            this.positionBefore(firstInstruction);
        }
    }

    private void positionBefore(LLVM.LLVMValueRef instr) {
        LLVM.LLVMPositionBuilderBefore((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)instr);
    }

    public void positionAtEnd(LLVM.LLVMBasicBlockRef block) {
        LLVM.LLVMPositionBuilderAtEnd((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMBasicBlockRef)block);
    }

    LLVM.LLVMValueRef blockTerminator(LLVM.LLVMBasicBlockRef block) {
        return LLVM.LLVMGetBasicBlockTerminator((LLVM.LLVMBasicBlockRef)block);
    }

    LLVM.LLVMTypeRef getLLVMStackType(JavaKind kind) {
        return this.getLLVMType(kind.getStackKind());
    }

    LLVM.LLVMTypeRef getLLVMType(JavaKind kind) {
        switch (kind) {
            case Boolean: {
                return this.booleanType();
            }
            case Byte: {
                return this.byteType();
            }
            case Short: {
                return this.shortType();
            }
            case Char: {
                return this.charType();
            }
            case Int: {
                return this.intType();
            }
            case Float: {
                return this.floatType();
            }
            case Long: {
                return this.longType();
            }
            case Double: {
                return this.doubleType();
            }
            case Object: {
                return this.objectType();
            }
            case Void: {
                return this.voidType();
            }
        }
        throw GraalError.shouldNotReachHere((String)"Illegal type");
    }

    static LLVM.LLVMTypeRef typeOf(LLVM.LLVMValueRef value) {
        return LLVM.LLVMTypeOf((LLVM.LLVMValueRef)value);
    }

    LLVM.LLVMTypeRef booleanType() {
        return this.integerType(1);
    }

    LLVM.LLVMTypeRef byteType() {
        return this.integerType(8);
    }

    private LLVM.LLVMTypeRef shortType() {
        return this.integerType(16);
    }

    private LLVM.LLVMTypeRef charType() {
        return this.integerType(16);
    }

    public LLVM.LLVMTypeRef intType() {
        return this.integerType(32);
    }

    public LLVM.LLVMTypeRef longType() {
        return this.integerType(64);
    }

    private LLVM.LLVMTypeRef integerType(int bits) {
        return LLVM.LLVMIntTypeInContext((LLVM.LLVMContextRef)this.context, (int)bits);
    }

    LLVM.LLVMTypeRef floatType() {
        return LLVM.LLVMFloatTypeInContext((LLVM.LLVMContextRef)this.context);
    }

    LLVM.LLVMTypeRef doubleType() {
        return LLVM.LLVMDoubleTypeInContext((LLVM.LLVMContextRef)this.context);
    }

    public LLVM.LLVMTypeRef pointerType(LLVM.LLVMTypeRef type, boolean tracked) {
        return LLVM.LLVMPointerType((LLVM.LLVMTypeRef)type, (int)LLVMIRBuilder.pointerAddressSpace(tracked));
    }

    private static int pointerAddressSpace(boolean tracked) {
        return tracked ? 1 : 0;
    }

    public LLVM.LLVMTypeRef objectType() {
        return this.pointerType(this.byteType(), true);
    }

    public LLVM.LLVMTypeRef rawPointerType() {
        return this.pointerType(this.byteType(), false);
    }

    public LLVM.LLVMTypeRef arrayType(LLVM.LLVMTypeRef type, int length) {
        return LLVM.LLVMArrayType((LLVM.LLVMTypeRef)type, (int)length);
    }

    public LLVM.LLVMTypeRef structType(LLVM.LLVMTypeRef ... types) {
        return LLVM.LLVMStructTypeInContext((LLVM.LLVMContextRef)this.context, (PointerPointer)new PointerPointer((Pointer[])types), (int)types.length, (int)0);
    }

    LLVM.LLVMTypeRef functionType(LLVM.LLVMTypeRef returnType, LLVM.LLVMTypeRef ... argTypes) {
        return this.functionType(returnType, false, argTypes);
    }

    LLVM.LLVMTypeRef functionType(LLVM.LLVMTypeRef returnType, boolean varargs, LLVM.LLVMTypeRef ... argTypes) {
        return LLVM.LLVMFunctionType((LLVM.LLVMTypeRef)returnType, (PointerPointer)new PointerPointer((Pointer[])argTypes), (int)argTypes.length, (int)(varargs ? 1 : 0));
    }

    private static LLVM.LLVMTypeRef getReturnType(LLVM.LLVMTypeRef functionType) {
        return LLVM.LLVMGetReturnType((LLVM.LLVMTypeRef)functionType);
    }

    private static boolean isFunctionVarArg(LLVM.LLVMTypeRef functionType) {
        return LLVM.LLVMIsFunctionVarArg((LLVM.LLVMTypeRef)functionType) == 1;
    }

    public LLVM.LLVMTypeRef prependArguments(LLVM.LLVMTypeRef functionType, LLVM.LLVMTypeRef ... typesToAdd) {
        LLVM.LLVMTypeRef returnType = LLVMIRBuilder.getReturnType(functionType);
        boolean varargs = LLVMIRBuilder.isFunctionVarArg(functionType);
        LLVM.LLVMTypeRef[] oldTypes = LLVMIRBuilder.getParamTypes(functionType);
        LLVM.LLVMTypeRef[] newTypes = new LLVM.LLVMTypeRef[oldTypes.length + typesToAdd.length];
        System.arraycopy(typesToAdd, 0, newTypes, 0, typesToAdd.length);
        System.arraycopy(oldTypes, 0, newTypes, typesToAdd.length, oldTypes.length);
        return this.functionType(returnType, varargs, newTypes);
    }

    private static LLVM.LLVMTypeRef[] getParamTypes(LLVM.LLVMTypeRef functionType) {
        int numParams = LLVM.LLVMCountParamTypes((LLVM.LLVMTypeRef)functionType);
        PointerPointer argTypesPointer = new PointerPointer((long)numParams);
        LLVM.LLVMGetParamTypes((LLVM.LLVMTypeRef)functionType, (PointerPointer)argTypesPointer);
        return (LLVM.LLVMTypeRef[])IntStream.range(0, numParams).mapToObj(i -> (LLVM.LLVMTypeRef)argTypesPointer.get(LLVM.LLVMTypeRef.class, (long)i)).toArray(LLVM.LLVMTypeRef[]::new);
    }

    private LLVM.LLVMTypeRef voidType() {
        return LLVM.LLVMVoidTypeInContext((LLVM.LLVMContextRef)this.context);
    }

    LLVM.LLVMTypeRef vectorType(LLVM.LLVMTypeRef type, int count) {
        return LLVM.LLVMVectorType((LLVM.LLVMTypeRef)type, (int)count);
    }

    private LLVM.LLVMTypeRef tokenType() {
        return LLVM.LLVMTokenTypeInContext((LLVM.LLVMContextRef)this.context);
    }

    private LLVM.LLVMTypeRef metadataType() {
        return LLVM.LLVMMetadataTypeInContext((LLVM.LLVMContextRef)this.context);
    }

    static boolean isIntegerType(LLVM.LLVMTypeRef type) {
        return LLVM.LLVMGetTypeKind((LLVM.LLVMTypeRef)type) == 8;
    }

    static int integerTypeWidth(LLVM.LLVMTypeRef intType) {
        return LLVM.LLVMGetIntTypeWidth((LLVM.LLVMTypeRef)intType);
    }

    static boolean isFloatType(LLVM.LLVMTypeRef type) {
        return LLVM.LLVMGetTypeKind((LLVM.LLVMTypeRef)type) == 2;
    }

    static boolean isDoubleType(LLVM.LLVMTypeRef type) {
        return LLVM.LLVMGetTypeKind((LLVM.LLVMTypeRef)type) == 3;
    }

    static boolean isPointer(LLVM.LLVMTypeRef type) {
        return LLVM.LLVMGetTypeKind((LLVM.LLVMTypeRef)type) == 12;
    }

    private static boolean isTracked(LLVM.LLVMTypeRef pointerType) {
        return LLVM.LLVMGetPointerAddressSpace((LLVM.LLVMTypeRef)pointerType) == 1;
    }

    private static LLVM.LLVMTypeRef getElementType(LLVM.LLVMTypeRef pointerType) {
        return LLVM.LLVMGetElementType((LLVM.LLVMTypeRef)pointerType);
    }

    static boolean isObject(LLVM.LLVMTypeRef type) {
        return LLVMIRBuilder.isPointer(type) && LLVMIRBuilder.isTracked(type);
    }

    static boolean isRawPointer(LLVM.LLVMTypeRef type) {
        return LLVMIRBuilder.isPointer(type) && !LLVMIRBuilder.isTracked(type);
    }

    static boolean isVoidType(LLVM.LLVMTypeRef type) {
        return LLVM.LLVMGetTypeKind((LLVM.LLVMTypeRef)type) == 0;
    }

    static boolean compatibleTypes(LLVM.LLVMTypeRef a, LLVM.LLVMTypeRef b) {
        int bKind;
        int aKind = LLVM.LLVMGetTypeKind((LLVM.LLVMTypeRef)a);
        if (aKind != (bKind = LLVM.LLVMGetTypeKind((LLVM.LLVMTypeRef)b))) {
            return false;
        }
        if (aKind == 8) {
            return LLVM.LLVMGetIntTypeWidth((LLVM.LLVMTypeRef)a) == LLVM.LLVMGetIntTypeWidth((LLVM.LLVMTypeRef)b);
        }
        if (aKind == 12) {
            return LLVM.LLVMGetPointerAddressSpace((LLVM.LLVMTypeRef)a) == LLVM.LLVMGetPointerAddressSpace((LLVM.LLVMTypeRef)b) && LLVMIRBuilder.compatibleTypes(LLVM.LLVMGetElementType((LLVM.LLVMTypeRef)a), LLVM.LLVMGetElementType((LLVM.LLVMTypeRef)b));
        }
        return true;
    }

    private static String intrinsicType(LLVM.LLVMTypeRef type) {
        switch (LLVM.LLVMGetTypeKind((LLVM.LLVMTypeRef)type)) {
            case 8: {
                return "i" + LLVMIRBuilder.integerTypeWidth(type);
            }
            case 2: {
                return "f32";
            }
            case 3: {
                return "f64";
            }
            case 0: {
                return "isVoid";
            }
            case 12: {
                return "p" + LLVM.LLVMGetPointerAddressSpace((LLVM.LLVMTypeRef)type) + LLVMIRBuilder.intrinsicType(LLVM.LLVMGetElementType((LLVM.LLVMTypeRef)type));
            }
            case 9: {
                String args = Arrays.stream(LLVMIRBuilder.getParamTypes(type)).map(LLVMIRBuilder::intrinsicType).collect(Collectors.joining(DEFAULT_INSTR_NAME));
                return "f_" + LLVMIRBuilder.intrinsicType(LLVMIRBuilder.getReturnType(type)) + args + "f";
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    LLVM.LLVMValueRef constantBoolean(boolean x) {
        return this.constantInteger(x ? 1L : 0L, 1);
    }

    LLVM.LLVMValueRef constantByte(byte x) {
        return this.constantInteger(x, 8);
    }

    LLVM.LLVMValueRef constantShort(short x) {
        return this.constantInteger(x, 16);
    }

    LLVM.LLVMValueRef constantChar(char x) {
        return this.constantInteger(x, 16);
    }

    public LLVM.LLVMValueRef constantInt(int x) {
        return this.constantInteger(x, 32);
    }

    public LLVM.LLVMValueRef constantLong(long x) {
        return this.constantInteger(x, 64);
    }

    LLVM.LLVMValueRef constantInteger(long value, int bits) {
        return LLVM.LLVMConstInt((LLVM.LLVMTypeRef)this.integerType(bits), (long)value, (int)0);
    }

    LLVM.LLVMValueRef constantFloat(float x) {
        return LLVM.LLVMConstReal((LLVM.LLVMTypeRef)this.floatType(), (double)x);
    }

    LLVM.LLVMValueRef constantDouble(double x) {
        return LLVM.LLVMConstReal((LLVM.LLVMTypeRef)this.doubleType(), (double)x);
    }

    public LLVM.LLVMValueRef constantNull(LLVM.LLVMTypeRef type) {
        return LLVM.LLVMConstNull((LLVM.LLVMTypeRef)type);
    }

    LLVM.LLVMValueRef buildGlobalStringPtr(String name) {
        return LLVM.LLVMBuildGlobalStringPtr((LLVM.LLVMBuilderRef)this.builder, (String)name, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef constantString(String string) {
        return LLVM.LLVMConstStringInContext((LLVM.LLVMContextRef)this.context, (String)string, (int)string.length(), (int)0);
    }

    LLVM.LLVMValueRef constantVector(LLVM.LLVMValueRef ... values) {
        return LLVM.LLVMConstVector((PointerPointer)new PointerPointer((Pointer[])values), (int)values.length);
    }

    LLVM.LLVMValueRef getFunction(String name, LLVM.LLVMTypeRef type) {
        LLVM.LLVMValueRef func = LLVM.LLVMGetNamedFunction((LLVM.LLVMModuleRef)this.module, (String)name);
        if (func == null) {
            func = this.addFunction(name, type);
            LLVMIRBuilder.setLinkage(func, 0);
        }
        return func;
    }

    private static LLVM.LLVMValueRef getParam(LLVM.LLVMValueRef func, int index) {
        return LLVM.LLVMGetParam((LLVM.LLVMValueRef)func, (int)index);
    }

    public LLVM.LLVMValueRef getParam(int index) {
        return LLVMIRBuilder.getParam(this.function, index);
    }

    LLVM.LLVMValueRef buildPhi(LLVM.LLVMTypeRef phiType, LLVM.LLVMValueRef[] incomingValues, LLVM.LLVMBasicBlockRef[] incomingBlocks) {
        LLVM.LLVMValueRef phi = LLVM.LLVMBuildPhi((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMTypeRef)phiType, (String)DEFAULT_INSTR_NAME);
        this.addIncoming(phi, incomingValues, incomingBlocks);
        return phi;
    }

    void addIncoming(LLVM.LLVMValueRef phi, LLVM.LLVMValueRef[] values, LLVM.LLVMBasicBlockRef[] blocks) {
        assert (values.length == blocks.length);
        LLVM.LLVMAddIncoming((LLVM.LLVMValueRef)phi, (PointerPointer)new PointerPointer((Pointer[])values), (PointerPointer)new PointerPointer((Pointer[])blocks), (int)blocks.length);
    }

    LLVM.LLVMValueRef getExternalObject(String name) {
        LLVM.LLVMValueRef val = this.getGlobal(name);
        if (val == null) {
            val = LLVM.LLVMAddGlobalInAddressSpace((LLVM.LLVMModuleRef)this.module, (LLVM.LLVMTypeRef)this.objectType(), (String)name, (int)1);
            LLVMIRBuilder.setLinkage(val, 0);
        }
        return val;
    }

    public LLVM.LLVMValueRef getExternalSymbol(String name) {
        LLVM.LLVMValueRef val = this.getGlobal(name);
        if (val == null) {
            val = LLVM.LLVMAddGlobalInAddressSpace((LLVM.LLVMModuleRef)this.module, (LLVM.LLVMTypeRef)this.rawPointerType(), (String)name, (int)0);
            LLVMIRBuilder.setLinkage(val, 0);
        }
        return val;
    }

    public LLVM.LLVMValueRef getUniqueGlobal(String name, LLVM.LLVMTypeRef type, boolean zeroInitialized) {
        LLVM.LLVMValueRef global = this.getGlobal(name);
        if (global == null) {
            global = LLVM.LLVMAddGlobalInAddressSpace((LLVM.LLVMModuleRef)this.module, (LLVM.LLVMTypeRef)type, (String)name, (int)LLVMIRBuilder.pointerAddressSpace(LLVMIRBuilder.isObject(type)));
            if (zeroInitialized) {
                this.setInitializer(global, LLVM.LLVMConstNull((LLVM.LLVMTypeRef)type));
            }
            LLVMIRBuilder.setLinkage(global, 3);
        }
        return global;
    }

    private LLVM.LLVMValueRef getGlobal(String name) {
        return LLVM.LLVMGetNamedGlobal((LLVM.LLVMModuleRef)this.module, (String)name);
    }

    void setInitializer(LLVM.LLVMValueRef global, LLVM.LLVMValueRef value) {
        LLVM.LLVMSetInitializer((LLVM.LLVMValueRef)global, (LLVM.LLVMValueRef)value);
    }

    public LLVM.LLVMValueRef register(String name) {
        String nameEncoding = name + "\u0000";
        LLVM.LLVMValueRef[] vals = new LLVM.LLVMValueRef[]{LLVM.LLVMMDStringInContext((LLVM.LLVMContextRef)this.context, (String)nameEncoding, (int)nameEncoding.length())};
        return LLVM.LLVMMDNodeInContext((LLVM.LLVMContextRef)this.context, (PointerPointer)new PointerPointer((Pointer[])vals), (int)vals.length);
    }

    public LLVM.LLVMValueRef buildReadRegister(LLVM.LLVMValueRef register) {
        LLVM.LLVMTypeRef readRegisterType = this.functionType(this.longType(), this.metadataType());
        return this.buildIntrinsicCall("llvm.read_register.i64", readRegisterType, register);
    }

    LLVM.LLVMValueRef buildExtractValue(LLVM.LLVMValueRef struct, int i) {
        return LLVM.LLVMBuildExtractValue((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)struct, (int)i, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildExtractElement(LLVM.LLVMValueRef vector, LLVM.LLVMValueRef index) {
        return LLVM.LLVMBuildExtractElement((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)vector, (LLVM.LLVMValueRef)index, (String)DEFAULT_INSTR_NAME);
    }

    public void setMetadata(LLVM.LLVMValueRef instr, String kind, LLVM.LLVMValueRef metadata) {
        LLVM.LLVMSetMetadata((LLVM.LLVMValueRef)instr, (int)LLVM.LLVMGetMDKindIDInContext((LLVM.LLVMContextRef)this.context, (String)kind, (int)kind.length()), (LLVM.LLVMValueRef)metadata);
    }

    public void setValueName(LLVM.LLVMValueRef value, String name) {
        LLVM.LLVMSetValueName((LLVM.LLVMValueRef)value, (String)name);
    }

    public LLVM.LLVMValueRef buildCall(LLVM.LLVMValueRef callee, LLVM.LLVMValueRef ... args) {
        return LLVM.LLVMBuildCall((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)callee, (PointerPointer)new PointerPointer((Pointer[])args), (int)args.length, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildCall(LLVM.LLVMValueRef callee, long statepointId, LLVM.LLVMValueRef ... args) {
        LLVM.LLVMValueRef result = this.buildCall(callee, args);
        this.addCallSiteAttribute(result, "statepoint-id", Long.toString(statepointId));
        return result;
    }

    private LLVM.LLVMValueRef buildInvoke(LLVM.LLVMValueRef callee, LLVM.LLVMBasicBlockRef successor, LLVM.LLVMBasicBlockRef handler, LLVM.LLVMValueRef ... args) {
        return LLVM.LLVMBuildInvoke((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)callee, (PointerPointer)new PointerPointer((Pointer[])args), (int)args.length, (LLVM.LLVMBasicBlockRef)successor, (LLVM.LLVMBasicBlockRef)handler, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildInvoke(LLVM.LLVMValueRef callee, LLVM.LLVMBasicBlockRef successor, LLVM.LLVMBasicBlockRef handler, long statepointId, LLVM.LLVMValueRef ... args) {
        LLVM.LLVMValueRef result = this.buildInvoke(callee, successor, handler, args);
        this.addCallSiteAttribute(result, "statepoint-id", Long.toString(statepointId));
        return result;
    }

    private void addCallSiteAttribute(LLVM.LLVMValueRef call, String key, String value) {
        LLVM.LLVMAttributeRef attribute = LLVM.LLVMCreateStringAttribute((LLVM.LLVMContextRef)this.context, (String)key, (int)key.length(), (String)value, (int)value.length());
        LLVM.LLVMAddCallSiteAttribute((LLVM.LLVMValueRef)call, (int)-1, (LLVM.LLVMAttributeRef)attribute);
    }

    private LLVM.LLVMValueRef buildIntrinsicCall(String name, LLVM.LLVMTypeRef type, LLVM.LLVMValueRef ... args) {
        LLVM.LLVMValueRef intrinsic = this.getFunction(name, type);
        return this.buildCall(intrinsic, args);
    }

    void buildRetVoid() {
        LLVM.LLVMBuildRetVoid((LLVM.LLVMBuilderRef)this.builder);
    }

    void buildRet(LLVM.LLVMValueRef value) {
        LLVM.LLVMBuildRet((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)value);
    }

    void buildBranch(LLVM.LLVMBasicBlockRef block) {
        LLVM.LLVMBuildBr((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMBasicBlockRef)block);
    }

    LLVM.LLVMValueRef buildIf(LLVM.LLVMValueRef condition, LLVM.LLVMBasicBlockRef thenBlock, LLVM.LLVMBasicBlockRef elseBlock) {
        return LLVM.LLVMBuildCondBr((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)condition, (LLVM.LLVMBasicBlockRef)thenBlock, (LLVM.LLVMBasicBlockRef)elseBlock);
    }

    LLVM.LLVMValueRef buildSwitch(LLVM.LLVMValueRef value, LLVM.LLVMBasicBlockRef defaultBlock, LLVM.LLVMValueRef[] switchValues, LLVM.LLVMBasicBlockRef[] switchBlocks) {
        assert (switchValues.length == switchBlocks.length);
        LLVM.LLVMValueRef switchVal = LLVM.LLVMBuildSwitch((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)value, (LLVM.LLVMBasicBlockRef)defaultBlock, (int)switchBlocks.length);
        for (int i = 0; i < switchBlocks.length; ++i) {
            LLVM.LLVMAddCase((LLVM.LLVMValueRef)switchVal, (LLVM.LLVMValueRef)switchValues[i], (LLVM.LLVMBasicBlockRef)switchBlocks[i]);
        }
        return switchVal;
    }

    public LLVM.LLVMValueRef buildLandingPad() {
        LLVM.LLVMValueRef landingPad = LLVM.LLVMBuildLandingPad((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMTypeRef)this.tokenType(), null, (int)1, (String)DEFAULT_INSTR_NAME);
        LLVM.LLVMAddClause((LLVM.LLVMValueRef)landingPad, (LLVM.LLVMValueRef)this.constantNull(this.rawPointerType()));
        return landingPad;
    }

    public void buildUnreachable() {
        LLVM.LLVMBuildUnreachable((LLVM.LLVMBuilderRef)this.builder);
    }

    public void buildStackmap(LLVM.LLVMValueRef patchpointId, LLVM.LLVMValueRef ... liveValues) {
        LLVM.LLVMTypeRef stackmapType = this.functionType(this.voidType(), true, this.longType(), this.intType());
        LLVM.LLVMValueRef[] allArgs = new LLVM.LLVMValueRef[2 + liveValues.length];
        allArgs[0] = patchpointId;
        allArgs[1] = this.constantInt(0);
        System.arraycopy(liveValues, 0, allArgs, 2, liveValues.length);
        this.buildIntrinsicCall("llvm.experimental.stackmap", stackmapType, allArgs);
    }

    public void buildDebugtrap() {
        this.buildIntrinsicCall("llvm.debugtrap", this.functionType(this.voidType(), new LLVM.LLVMTypeRef[0]), new LLVM.LLVMValueRef[0]);
    }

    LLVM.LLVMValueRef buildInlineAsm(LLVM.LLVMTypeRef functionType, String asm, String constraints, boolean hasSideEffects, boolean alignStack) {
        return LLVM.LLVMConstInlineAsm((LLVM.LLVMTypeRef)functionType, (String)asm, (String)constraints, (int)(hasSideEffects ? 1 : 0), (int)(alignStack ? 1 : 0));
    }

    public LLVM.LLVMValueRef functionEntryCount(LLVM.LLVMValueRef count) {
        String functionEntryCountName = "function_entry_count";
        LLVM.LLVMValueRef[] values = new LLVM.LLVMValueRef[]{LLVM.LLVMMDStringInContext((LLVM.LLVMContextRef)this.context, (String)functionEntryCountName, (int)functionEntryCountName.length()), count};
        return LLVM.LLVMMDNodeInContext((LLVM.LLVMContextRef)this.context, (PointerPointer)new PointerPointer((Pointer[])values), (int)values.length);
    }

    LLVM.LLVMValueRef branchWeights(LLVM.LLVMValueRef ... weights) {
        String branchWeightsName = "branch_weights";
        LLVM.LLVMValueRef[] values = new LLVM.LLVMValueRef[weights.length + 1];
        values[0] = LLVM.LLVMMDStringInContext((LLVM.LLVMContextRef)this.context, (String)branchWeightsName, (int)branchWeightsName.length());
        System.arraycopy(weights, 0, values, 1, weights.length);
        return LLVM.LLVMMDNodeInContext((LLVM.LLVMContextRef)this.context, (PointerPointer)new PointerPointer((Pointer[])values), (int)values.length);
    }

    public LLVM.LLVMValueRef buildIsNull(LLVM.LLVMValueRef value) {
        return LLVM.LLVMBuildIsNull((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)value, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildCompare(Condition cond, LLVM.LLVMValueRef a, LLVM.LLVMValueRef b, boolean unordered) {
        LLVM.LLVMTypeRef aType = LLVM.LLVMTypeOf((LLVM.LLVMValueRef)a);
        LLVM.LLVMTypeRef bType = LLVM.LLVMTypeOf((LLVM.LLVMValueRef)b);
        assert (LLVMIRBuilder.compatibleTypes(aType, bType)) : LLVMUtils.dumpTypes("comparison", aType, bType);
        switch (LLVM.LLVMGetTypeKind((LLVM.LLVMTypeRef)aType)) {
            case 8: 
            case 12: {
                return this.buildICmp(cond, a, b);
            }
            case 2: 
            case 3: {
                return this.buildFCmp(cond, a, b, unordered);
            }
        }
        throw GraalError.shouldNotReachHere((String)LLVMUtils.dumpTypes("comparison", aType, bType));
    }

    public LLVM.LLVMValueRef buildICmp(Condition cond, LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return LLVM.LLVMBuildICmp((LLVM.LLVMBuilderRef)this.builder, (int)LLVMUtils.getLLVMIntCond(cond), (LLVM.LLVMValueRef)a, (LLVM.LLVMValueRef)b, (String)DEFAULT_INSTR_NAME);
    }

    private LLVM.LLVMValueRef buildFCmp(Condition cond, LLVM.LLVMValueRef a, LLVM.LLVMValueRef b, boolean unordered) {
        return LLVM.LLVMBuildFCmp((LLVM.LLVMBuilderRef)this.builder, (int)LLVMUtils.getLLVMRealCond(cond, unordered), (LLVM.LLVMValueRef)a, (LLVM.LLVMValueRef)b, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildSelect(LLVM.LLVMValueRef condition, LLVM.LLVMValueRef trueVal, LLVM.LLVMValueRef falseVal) {
        return LLVM.LLVMBuildSelect((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)condition, (LLVM.LLVMValueRef)trueVal, (LLVM.LLVMValueRef)falseVal, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildNeg(LLVM.LLVMValueRef a) {
        UnaryBuilder unaryBuilder;
        LLVM.LLVMTypeRef type = LLVM.LLVMTypeOf((LLVM.LLVMValueRef)a);
        switch (LLVM.LLVMGetTypeKind((LLVM.LLVMTypeRef)type)) {
            case 8: {
                unaryBuilder = LLVM::LLVMBuildNeg;
                break;
            }
            case 2: 
            case 3: {
                unaryBuilder = LLVM::LLVMBuildFNeg;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)LLVMUtils.dumpTypes("invalid negation type", type));
            }
        }
        return unaryBuilder.build(this.builder, a, DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildAdd(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return this.buildBinaryNumberOp(a, b, LLVM::LLVMBuildAdd, LLVM::LLVMBuildFAdd);
    }

    public LLVM.LLVMValueRef buildSub(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return this.buildBinaryNumberOp(a, b, LLVM::LLVMBuildSub, LLVM::LLVMBuildFSub);
    }

    LLVM.LLVMValueRef buildMul(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return this.buildBinaryNumberOp(a, b, LLVM::LLVMBuildMul, LLVM::LLVMBuildFMul);
    }

    LLVM.LLVMValueRef buildDiv(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return this.buildBinaryNumberOp(a, b, LLVM::LLVMBuildSDiv, LLVM::LLVMBuildFDiv);
    }

    LLVM.LLVMValueRef buildRem(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return this.buildBinaryNumberOp(a, b, LLVM::LLVMBuildSRem, LLVM::LLVMBuildFRem);
    }

    LLVM.LLVMValueRef buildUDiv(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return this.buildBinaryNumberOp(a, b, LLVM::LLVMBuildUDiv, null);
    }

    LLVM.LLVMValueRef buildURem(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return this.buildBinaryNumberOp(a, b, LLVM::LLVMBuildURem, null);
    }

    private LLVM.LLVMValueRef buildBinaryNumberOp(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b, BinaryBuilder integerBuilder, BinaryBuilder realBuilder) {
        BinaryBuilder binaryBuilder;
        LLVM.LLVMTypeRef aType = LLVM.LLVMTypeOf((LLVM.LLVMValueRef)a);
        LLVM.LLVMTypeRef bType = LLVM.LLVMTypeOf((LLVM.LLVMValueRef)b);
        assert (LLVMIRBuilder.compatibleTypes(aType, bType)) : LLVMUtils.dumpValues("invalid binary operation arguments", a, b);
        switch (LLVM.LLVMGetTypeKind((LLVM.LLVMTypeRef)aType)) {
            case 8: {
                binaryBuilder = integerBuilder;
                break;
            }
            case 2: 
            case 3: {
                binaryBuilder = realBuilder;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)LLVMUtils.dumpValues("invalid binary operation arguments", a, b));
            }
        }
        return binaryBuilder.build(this.builder, a, b, DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildAbs(LLVM.LLVMValueRef a) {
        return this.buildIntrinsicOp("fabs", a);
    }

    LLVM.LLVMValueRef buildLog(LLVM.LLVMValueRef a) {
        return this.buildIntrinsicOp("log", a);
    }

    LLVM.LLVMValueRef buildLog10(LLVM.LLVMValueRef a) {
        return this.buildIntrinsicOp("log10", a);
    }

    LLVM.LLVMValueRef buildSqrt(LLVM.LLVMValueRef a) {
        return this.buildIntrinsicOp("sqrt", a);
    }

    LLVM.LLVMValueRef buildCos(LLVM.LLVMValueRef a) {
        return this.buildIntrinsicOp("cos", a);
    }

    LLVM.LLVMValueRef buildSin(LLVM.LLVMValueRef a) {
        return this.buildIntrinsicOp("sin", a);
    }

    LLVM.LLVMValueRef buildExp(LLVM.LLVMValueRef a) {
        return this.buildIntrinsicOp("exp", a);
    }

    LLVM.LLVMValueRef buildPow(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return this.buildIntrinsicOp("pow", a, b);
    }

    public LLVM.LLVMValueRef buildRound(LLVM.LLVMValueRef a) {
        String intrinsicName;
        LLVM.LLVMTypeRef returnType;
        LLVM.LLVMTypeRef type = LLVM.LLVMTypeOf((LLVM.LLVMValueRef)a);
        if (LLVMIRBuilder.isFloatType(type)) {
            returnType = this.intType();
            intrinsicName = "llvm.lround";
        } else if (LLVMIRBuilder.isDoubleType(type)) {
            returnType = this.longType();
            intrinsicName = "llvm.llround";
        } else {
            throw GraalError.shouldNotReachHere();
        }
        intrinsicName = intrinsicName + "." + LLVMIRBuilder.intrinsicType(returnType) + "." + LLVMIRBuilder.intrinsicType(type);
        LLVM.LLVMTypeRef intrinsicType = this.functionType(returnType, type);
        return this.buildIntrinsicCall(intrinsicName, intrinsicType, a);
    }

    public LLVM.LLVMValueRef buildRint(LLVM.LLVMValueRef a) {
        return this.buildIntrinsicOp("round", a);
    }

    public LLVM.LLVMValueRef buildCeil(LLVM.LLVMValueRef a) {
        return this.buildIntrinsicOp("ceil", a);
    }

    public LLVM.LLVMValueRef buildFloor(LLVM.LLVMValueRef a) {
        return this.buildIntrinsicOp("floor", a);
    }

    public LLVM.LLVMValueRef buildMin(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return this.buildIntrinsicOp("minimum", a, b);
    }

    public LLVM.LLVMValueRef buildMax(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return this.buildIntrinsicOp("maximum", a, b);
    }

    public LLVM.LLVMValueRef buildCopysign(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return this.buildIntrinsicOp("copysign", a, b);
    }

    public LLVM.LLVMValueRef buildFma(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b, LLVM.LLVMValueRef c) {
        return this.buildIntrinsicOp("fma", a, b, c);
    }

    LLVM.LLVMValueRef buildBswap(LLVM.LLVMValueRef a) {
        return this.buildIntrinsicOp("bswap", a);
    }

    private LLVM.LLVMValueRef buildIntrinsicOp(String name, LLVM.LLVMTypeRef retType, LLVM.LLVMValueRef ... args) {
        String intrinsicName = "llvm." + name + "." + LLVMIRBuilder.intrinsicType(retType);
        LLVM.LLVMTypeRef intrinsicType = this.functionType(retType, (LLVM.LLVMTypeRef[])Arrays.stream(args).map(LLVM::LLVMTypeOf).toArray(LLVM.LLVMTypeRef[]::new));
        return this.buildIntrinsicCall(intrinsicName, intrinsicType, args);
    }

    private LLVM.LLVMValueRef buildIntrinsicOp(String name, LLVM.LLVMValueRef ... args) {
        return this.buildIntrinsicOp(name, LLVM.LLVMTypeOf((LLVM.LLVMValueRef)args[0]), args);
    }

    LLVM.LLVMValueRef buildNot(LLVM.LLVMValueRef input) {
        return LLVM.LLVMBuildNot((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)input, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildAnd(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return LLVM.LLVMBuildAnd((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)a, (LLVM.LLVMValueRef)b, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildOr(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return LLVM.LLVMBuildOr((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)a, (LLVM.LLVMValueRef)b, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildXor(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return LLVM.LLVMBuildXor((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)a, (LLVM.LLVMValueRef)b, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildShl(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return this.buildShift(LLVM::LLVMBuildShl, a, b);
    }

    LLVM.LLVMValueRef buildShr(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return this.buildShift(LLVM::LLVMBuildAShr, a, b);
    }

    LLVM.LLVMValueRef buildUShr(LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return this.buildShift(LLVM::LLVMBuildLShr, a, b);
    }

    private LLVM.LLVMValueRef buildShift(BinaryBuilder binaryBuilder, LLVM.LLVMValueRef a, LLVM.LLVMValueRef b) {
        return binaryBuilder.build(this.builder, a, this.buildIntegerConvert(b, LLVMIRBuilder.integerTypeWidth(LLVM.LLVMTypeOf((LLVM.LLVMValueRef)a))), DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildCtlz(LLVM.LLVMValueRef a) {
        return this.buildIntrinsicOp("ctlz", a, this.constantBoolean(false));
    }

    LLVM.LLVMValueRef buildCttz(LLVM.LLVMValueRef a) {
        return this.buildIntrinsicOp("cttz", a, this.constantBoolean(false));
    }

    LLVM.LLVMValueRef buildCtpop(LLVM.LLVMValueRef a) {
        return this.buildIntrinsicOp("ctpop", a);
    }

    public LLVM.LLVMValueRef buildBitcast(LLVM.LLVMValueRef value, LLVM.LLVMTypeRef type) {
        LLVM.LLVMTypeRef valueType = LLVM.LLVMTypeOf((LLVM.LLVMValueRef)value);
        if (LLVMIRBuilder.compatibleTypes(valueType, type)) {
            return value;
        }
        return LLVM.LLVMBuildBitCast((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)value, (LLVM.LLVMTypeRef)type, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildAddrSpaceCast(LLVM.LLVMValueRef value, LLVM.LLVMTypeRef type) {
        return LLVM.LLVMBuildAddrSpaceCast((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)value, (LLVM.LLVMTypeRef)type, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildRegisterObject(LLVM.LLVMValueRef pointer) {
        return this.buildCall(this.gcRegisterFunction, pointer);
    }

    public LLVM.LLVMValueRef buildIntToPtr(LLVM.LLVMValueRef value, LLVM.LLVMTypeRef type) {
        return LLVM.LLVMBuildIntToPtr((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)value, (LLVM.LLVMTypeRef)type, (String)DEFAULT_INSTR_NAME);
    }

    public LLVM.LLVMValueRef buildPtrToInt(LLVM.LLVMValueRef value, LLVM.LLVMTypeRef type) {
        return LLVM.LLVMBuildPtrToInt((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)value, (LLVM.LLVMTypeRef)type, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildFPToSI(LLVM.LLVMValueRef value, LLVM.LLVMTypeRef type) {
        return LLVM.LLVMBuildFPToSI((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)value, (LLVM.LLVMTypeRef)type, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildSIToFP(LLVM.LLVMValueRef value, LLVM.LLVMTypeRef type) {
        return LLVM.LLVMBuildSIToFP((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)value, (LLVM.LLVMTypeRef)type, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildFPCast(LLVM.LLVMValueRef value, LLVM.LLVMTypeRef type) {
        return LLVM.LLVMBuildFPCast((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)value, (LLVM.LLVMTypeRef)type, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildIntegerConvert(LLVM.LLVMValueRef value, int toBits) {
        int fromBits = LLVMIRBuilder.integerTypeWidth(LLVM.LLVMTypeOf((LLVM.LLVMValueRef)value));
        if (fromBits < toBits) {
            return fromBits == 1 ? this.buildZExt(value, toBits) : this.buildSExt(value, toBits);
        }
        if (fromBits > toBits) {
            return this.buildTrunc(value, toBits);
        }
        return value;
    }

    public LLVM.LLVMValueRef buildTrunc(LLVM.LLVMValueRef value, int toBits) {
        return LLVM.LLVMBuildTrunc((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)value, (LLVM.LLVMTypeRef)this.integerType(toBits), (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildSExt(LLVM.LLVMValueRef value, int toBits) {
        return LLVM.LLVMBuildSExt((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)value, (LLVM.LLVMTypeRef)this.integerType(toBits), (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildZExt(LLVM.LLVMValueRef value, int toBits) {
        return LLVM.LLVMBuildZExt((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)value, (LLVM.LLVMTypeRef)this.integerType(toBits), (String)DEFAULT_INSTR_NAME);
    }

    public LLVM.LLVMValueRef buildGEP(LLVM.LLVMValueRef base, LLVM.LLVMValueRef ... indices) {
        return LLVM.LLVMBuildGEP((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)base, (PointerPointer)new PointerPointer((Pointer[])indices), (int)indices.length, (String)DEFAULT_INSTR_NAME);
    }

    public LLVM.LLVMValueRef buildLoad(LLVM.LLVMValueRef address, LLVM.LLVMTypeRef type) {
        LLVM.LLVMTypeRef addressType = LLVM.LLVMTypeOf((LLVM.LLVMValueRef)address);
        LLVM.LLVMTypeRef pointedType = type;
        boolean postRegister = false;
        if (LLVMIRBuilder.isObject(type) && !LLVMIRBuilder.isObject(addressType)) {
            pointedType = this.rawPointerType();
            postRegister = true;
        }
        LLVM.LLVMValueRef castedAddress = this.buildBitcast(address, this.pointerType(pointedType, LLVMIRBuilder.isObject(addressType)));
        LLVM.LLVMValueRef loadedValue = this.buildLoad(castedAddress);
        if (postRegister) {
            loadedValue = this.buildRegisterObject(loadedValue);
        }
        return loadedValue;
    }

    LLVM.LLVMValueRef buildLoad(LLVM.LLVMValueRef address) {
        return LLVM.LLVMBuildLoad((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)address, (String)DEFAULT_INSTR_NAME);
    }

    public void buildStore(LLVM.LLVMValueRef value, LLVM.LLVMValueRef address) {
        LLVM.LLVMTypeRef addressType = LLVM.LLVMTypeOf((LLVM.LLVMValueRef)address);
        LLVM.LLVMTypeRef valueType = LLVM.LLVMTypeOf((LLVM.LLVMValueRef)value);
        LLVM.LLVMValueRef castedValue = value;
        if (LLVMIRBuilder.isObject(valueType) && !LLVMIRBuilder.isObject(addressType)) {
            valueType = this.rawPointerType();
            castedValue = this.buildAddrSpaceCast(value, this.rawPointerType());
        }
        LLVM.LLVMValueRef castedAddress = this.buildBitcast(address, this.pointerType(valueType, LLVMIRBuilder.isObject(addressType)));
        LLVM.LLVMBuildStore((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)castedValue, (LLVM.LLVMValueRef)castedAddress);
    }

    public LLVM.LLVMValueRef buildArrayAlloca(int slots) {
        return LLVM.LLVMBuildArrayAlloca((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMTypeRef)this.rawPointerType(), (LLVM.LLVMValueRef)this.constantInt(slots), (String)DEFAULT_INSTR_NAME);
    }

    void buildPrefetch(LLVM.LLVMValueRef address) {
        LLVM.LLVMTypeRef prefetchType = this.functionType(this.voidType(), LLVM.LLVMTypeOf((LLVM.LLVMValueRef)address), this.intType(), this.intType(), this.intType());
        this.buildIntrinsicCall("llvm.prefetch", prefetchType, address, this.constantInt(1), this.constantInt(0), this.constantInt(1));
    }

    public LLVM.LLVMValueRef buildReturnAddress(LLVM.LLVMValueRef level) {
        LLVM.LLVMTypeRef returnAddressType = this.functionType(this.rawPointerType(), this.intType());
        return this.buildIntrinsicCall("llvm.returnaddress", returnAddressType, level);
    }

    LLVM.LLVMValueRef buildFrameAddress(LLVM.LLVMValueRef level) {
        LLVM.LLVMTypeRef frameAddressType = this.functionType(this.rawPointerType(), this.intType());
        return this.buildIntrinsicCall("llvm.frameaddress", frameAddressType, level);
    }

    void buildFence() {
        LLVM.LLVMBuildFence((LLVM.LLVMBuilderRef)this.builder, (int)7, (int)0, (String)DEFAULT_INSTR_NAME);
    }

    LLVM.LLVMValueRef buildLogicCmpxchg(LLVM.LLVMValueRef address, LLVM.LLVMValueRef expectedValue, LLVM.LLVMValueRef newValue) {
        return this.buildCmpxchg(address, expectedValue, newValue, 1);
    }

    LLVM.LLVMValueRef buildValueCmpxchg(LLVM.LLVMValueRef address, LLVM.LLVMValueRef expectedValue, LLVM.LLVMValueRef newValue) {
        return this.buildCmpxchg(address, expectedValue, newValue, 0);
    }

    private LLVM.LLVMValueRef buildCmpxchg(LLVM.LLVMValueRef address, LLVM.LLVMValueRef expectedValue, LLVM.LLVMValueRef newValue, int resultIndex) {
        LLVM.LLVMTypeRef expectedType = LLVM.LLVMTypeOf((LLVM.LLVMValueRef)expectedValue);
        LLVM.LLVMTypeRef newType = LLVM.LLVMTypeOf((LLVM.LLVMValueRef)newValue);
        assert (LLVMIRBuilder.compatibleTypes(expectedType, newType)) : LLVMUtils.dumpValues("invalid cmpxchg arguments", expectedValue, newValue);
        boolean isObject = LLVMIRBuilder.isObject(expectedType);
        LLVM.LLVMTypeRef operationType = isObject ? this.rawPointerType() : expectedType;
        LLVM.LLVMValueRef castedAddress = isObject && LLVMIRBuilder.isTracked(LLVMIRBuilder.typeOf(address)) ? this.buildAddrSpaceCast(address, this.pointerType(operationType, false)) : this.buildBitcast(address, this.pointerType(operationType, LLVMIRBuilder.isTracked(LLVMIRBuilder.typeOf(address))));
        LLVM.LLVMValueRef castedExpectedValue = isObject ? this.buildAddrSpaceCast(expectedValue, operationType) : expectedValue;
        LLVM.LLVMValueRef castedNewValue = isObject ? this.buildAddrSpaceCast(newValue, operationType) : newValue;
        LLVM.LLVMValueRef cas = LLVM.LLVMBuildAtomicCmpXchg((LLVM.LLVMBuilderRef)this.builder, (LLVM.LLVMValueRef)castedAddress, (LLVM.LLVMValueRef)castedExpectedValue, (LLVM.LLVMValueRef)castedNewValue, (int)2, (int)2, (int)0);
        LLVM.LLVMValueRef result = this.buildExtractValue(cas, resultIndex);
        if (isObject && resultIndex == 0) {
            result = this.buildRegisterObject(result);
        }
        return result;
    }

    LLVM.LLVMValueRef buildAtomicXchg(LLVM.LLVMValueRef address, LLVM.LLVMValueRef value) {
        return this.buildAtomicRMW(0, address, value);
    }

    LLVM.LLVMValueRef buildAtomicAdd(LLVM.LLVMValueRef address, LLVM.LLVMValueRef value) {
        return this.buildAtomicRMW(1, address, value);
    }

    private LLVM.LLVMValueRef buildAtomicRMW(int operation, LLVM.LLVMValueRef address, LLVM.LLVMValueRef value) {
        LLVM.LLVMTypeRef valueType = LLVM.LLVMTypeOf((LLVM.LLVMValueRef)value);
        boolean pointerOp = LLVMIRBuilder.isObject(valueType);
        LLVM.LLVMTypeRef operationType = pointerOp ? this.longType() : valueType;
        LLVM.LLVMValueRef castedValue = pointerOp ? this.buildPtrToInt(value, operationType) : value;
        LLVM.LLVMValueRef castedAddress = this.buildBitcast(address, this.pointerType(operationType, LLVMIRBuilder.isObject(LLVMIRBuilder.typeOf(address))));
        LLVM.LLVMValueRef atomicRMW = LLVM.LLVMBuildAtomicRMW((LLVM.LLVMBuilderRef)this.builder, (int)operation, (LLVM.LLVMValueRef)castedAddress, (LLVM.LLVMValueRef)castedValue, (int)2, (int)0);
        if (pointerOp) {
            atomicRMW = this.buildIntToPtr(atomicRMW, this.rawPointerType());
            atomicRMW = this.buildRegisterObject(atomicRMW);
        }
        return atomicRMW;
    }

    public LLVM.LLVMValueRef buildInlineGetRegister(String registerName) {
        LLVM.LLVMValueRef getRegister = this.buildInlineAsm(this.functionType(this.rawPointerType(), new LLVM.LLVMTypeRef[0]), LLVMUtils.TargetSpecific.get().getRegisterInlineAsm(registerName), "={" + LLVMUtils.TargetSpecific.get().getLLVMRegisterName(registerName) + "}", false, false);
        LLVM.LLVMValueRef call = this.buildCall(getRegister, new LLVM.LLVMValueRef[0]);
        this.setCallSiteAttribute(call, -1L, "gc-leaf-function");
        return call;
    }

    public LLVM.LLVMValueRef buildInlineJump(LLVM.LLVMValueRef address) {
        LLVM.LLVMValueRef jump = this.buildInlineAsm(this.functionType(this.voidType(), this.rawPointerType()), LLVMUtils.TargetSpecific.get().getJumpInlineAsm(), "r", true, false);
        LLVM.LLVMValueRef call = this.buildCall(jump, address);
        this.setCallSiteAttribute(call, -1L, "gc-leaf-function");
        return call;
    }

    private static interface BinaryBuilder {
        public LLVM.LLVMValueRef build(LLVM.LLVMBuilderRef var1, LLVM.LLVMValueRef var2, LLVM.LLVMValueRef var3, String var4);
    }

    private static interface UnaryBuilder {
        public LLVM.LLVMValueRef build(LLVM.LLVMBuilderRef var1, LLVM.LLVMValueRef var2, String var3);
    }
}

