/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.llvm;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.llvm.LLVMGenerator;
import org.graalvm.compiler.core.llvm.LLVMUtils;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.replacements.llvm.LLVMUnaryIntrinsicNode;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1, nameTemplate="LLVMIntrinsic#{p#op}")
public class LLVMCountTrailingZerosNode
extends LLVMUnaryIntrinsicNode {
    public static final NodeClass<LLVMCountTrailingZerosNode> TYPE = NodeClass.create(LLVMCountTrailingZerosNode.class);

    public LLVMCountTrailingZerosNode(JavaKind kind, ValueNode arg) {
        super(TYPE, LLVMUtils.LLVMIntrinsicOperation.CTTZ, kind, arg);
    }

    @Override
    protected Value emitIntrinsic(LLVMGenerator.ArithmeticLLVMGenerator gen, Value arg) {
        return gen.emitCountTrailingZeros(arg);
    }

    public static ConstantNode fold(JavaConstant constant) {
        int ctlz = constant.getJavaKind() == JavaKind.Int ? Integer.numberOfTrailingZeros(constant.asInt()) : Long.numberOfTrailingZeros(constant.asLong());
        return ConstantNode.forInt((int)ctlz);
    }
}

