/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.launcher;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.launcher.AbstractLanguageLauncher;
import org.graalvm.launcher.Launcher;
import org.graalvm.launcher.MultiLanguageShell;
import org.graalvm.options.OptionCategory;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public final class PolyglotLauncher
extends Launcher {
    private String mainLanguage = null;
    private boolean verbose = false;
    private boolean version = false;
    private boolean shell = false;
    static final Map<String, Class<AbstractLanguageLauncher>> AOT_LAUNCHER_CLASSES;

    @Override
    protected void printHelp(OptionCategory maxCategory) {
        Engine engine = PolyglotLauncher.getTempEngine();
        PolyglotLauncher.printVersion(engine);
        System.out.println();
        System.out.println("Usage: polyglot [OPTION]... [FILE] [ARGS]...");
        List<Language> languages = PolyglotLauncher.sortedLanguages(engine);
        System.out.print("Available languages: ");
        String sep = "";
        for (Language language : languages) {
            System.out.print(sep);
            System.out.print(language.getId());
            sep = ", ";
        }
        System.out.println();
        System.out.println("Basic Options:");
        PolyglotLauncher.printOption("--language <lang>", "Specifies the main language.");
        PolyglotLauncher.printOption("--file [<lang>:]FILE", "Additional file to execute.");
        PolyglotLauncher.printOption("--eval [<lang>:]CODE", "Evaluates code snippets, for example, '--eval js:42'.");
        PolyglotLauncher.printOption("--shell", "Start a multi language shell.");
        PolyglotLauncher.printOption("--verbose", "Enable verbose stack trace for internal errors.");
    }

    @Override
    protected void collectArguments(Set<String> args) {
        args.addAll(Arrays.asList("--language", "--file [<lang>:]FILE", "--eval [<lang>:]CODE", "--shell"));
    }

    @Override
    protected void printVersion() {
        PolyglotLauncher.printVersion(PolyglotLauncher.getTempEngine());
    }

    protected static void printVersion(Engine engine) {
        String engineImplementationName = engine.getImplementationName();
        if (PolyglotLauncher.isAOT()) {
            engineImplementationName = engineImplementationName + " Native";
        }
        System.out.println(String.format("%s polyglot launcher %s", engineImplementationName, engine.getVersion()));
    }

    private List<String> parsePolyglotLauncherOptions(Deque<String> arguments, List<Script> scripts) {
        ArrayList<String> unrecognizedArgs = new ArrayList<String>();
        while (!arguments.isEmpty()) {
            String arg = arguments.removeFirst();
            if (arg.equals("--eval") || arg.equals("--file")) {
                String script;
                String value = this.getNextArgument(arguments, arg);
                int index = value.indexOf(":");
                String languageId = null;
                if (index != -1) {
                    languageId = value.substring(0, index);
                    script = value.substring(index + 1);
                } else {
                    script = value;
                }
                if (arg.equals("--eval")) {
                    scripts.add(new EvalScript(languageId, script));
                    continue;
                }
                scripts.add(new FileScript(languageId, script, false));
                continue;
            }
            if (arg.equals("--")) break;
            if (!arg.startsWith("-")) {
                scripts.add(new FileScript(this.mainLanguage, arg, true));
                break;
            }
            if (arg.equals("--version")) {
                this.version = true;
                continue;
            }
            if (arg.equals("--shell")) {
                this.shell = true;
                continue;
            }
            if (arg.equals("--verbose")) {
                this.verbose = true;
                continue;
            }
            if (arg.equals("--language")) {
                this.mainLanguage = this.getNextArgument(arguments, arg);
                continue;
            }
            unrecognizedArgs.add(arg);
        }
        return unrecognizedArgs;
    }

    private String getNextArgument(Deque<String> arguments, String option) {
        if (arguments.isEmpty()) {
            throw this.abort(option + " expects an argument");
        }
        return arguments.removeFirst();
    }

    private void launch(String[] args) {
        ArrayDeque<String> arguments;
        ArrayList<String> argumentsList = new ArrayList<String>(Arrays.asList(args));
        if (PolyglotLauncher.isAOT()) {
            this.nativeAccess.maybeExec(argumentsList, true, Collections.emptyMap(), Launcher.VMType.Native);
        }
        if (!(arguments = new ArrayDeque<String>(argumentsList)).isEmpty() && ((String)arguments.getFirst()).equals("--use-launcher")) {
            arguments.removeFirst();
            String launcherName = this.getNextArgument(arguments, "--use-launcher");
            this.switchToLauncher(launcherName, new HashMap<String, String>(), new ArrayList<String>(arguments));
            return;
        }
        ArrayList<Script> scripts = new ArrayList<Script>();
        List<String> unrecognizedArgs = this.parsePolyglotLauncherOptions(arguments, scripts);
        HashMap<String, String> polyglotOptions = new HashMap<String, String>();
        this.parsePolyglotOptions(null, polyglotOptions, unrecognizedArgs);
        String[] programArgs = arguments.toArray(new String[0]);
        if (this.runPolyglotAction()) {
            return;
        }
        this.argumentsProcessingDone();
        Context.Builder contextBuilder = Context.newBuilder((String[])new String[0]).options(polyglotOptions);
        contextBuilder.allowAllAccess(true);
        this.setupLogHandler(contextBuilder);
        if (this.version) {
            PolyglotLauncher.printVersion(Engine.newBuilder().options(polyglotOptions).build());
            throw this.exit();
        }
        if (this.shell) {
            this.runShell(contextBuilder);
        } else {
            if (scripts.size() == 0) {
                throw this.abort("No files specified. Use --help for usage instructions.");
            }
            this.runScripts(scripts, contextBuilder, programArgs);
        }
    }

    private static Stream<PolyglotLauncherConfig> loadPolyglotConfig(Path p) {
        Path configPath = p.resolve("polyglot.config");
        if (!Files.exists(configPath, new LinkOption[0])) {
            return null;
        }
        try {
            return Files.lines(configPath, StandardCharsets.UTF_8).map(String::trim).filter(s -> !s.isEmpty()).map(l -> PolyglotLauncherConfig.parse(l, configPath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<AbstractLanguageLauncher> getLauncherClass(String launcherName) {
        return PolyglotLauncher.getLauncherClass(launcherName, PolyglotLauncher.class.getClassLoader());
    }

    private static Class<AbstractLanguageLauncher> getLauncherClass(String launcherName, ClassLoader loader) {
        try {
            Class<AbstractLanguageLauncher> launcherClass = Class.forName(launcherName, false, loader);
            if (launcherClass != null && !AbstractLanguageLauncher.class.isAssignableFrom(launcherClass)) {
                throw new RuntimeException("Launcher class " + launcherName + " does not extend AbstractLanguageLauncher");
            }
            return launcherClass;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Launcher class " + launcherName + " does not exist", e);
        }
    }

    private void switchToLauncher(String launcherName, Map<String, String> options, List<String> args) {
        AbstractLanguageLauncher launcher;
        Class<AbstractLanguageLauncher> launcherClass;
        if (PolyglotLauncher.isAOT()) {
            launcherClass = AOT_LAUNCHER_CLASSES.get(launcherName);
            if (launcherClass == null) {
                throw this.abort("Could not find class '" + launcherName + "'.\nYou might need to rebuild the polyglot launcher with 'gu rebuild-images polyglot'.\nThe following launchers are available:\n" + AOT_LAUNCHER_CLASSES.keySet().stream().sorted().map(s -> " - " + s).collect(Collectors.joining("\n")));
            }
        } else {
            launcherClass = PolyglotLauncher.getLauncherClass(launcherName);
            if (launcherClass == null) {
                throw this.abort("Could not find class '" + launcherName + "'.");
            }
        }
        try {
            launcher = launcherClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate launcher class " + launcherName, e);
        }
        launcher.setPolyglot(true);
        launcher.launch(args, options, false);
    }

    private void checkLanguage(String language, Engine engine) {
        if (language == null) {
            return;
        }
        if (!engine.getLanguages().containsKey(language)) {
            throw this.abort("Language '" + language + "' not found");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runScripts(List<Script> scripts, Context.Builder contextBuilder, String[] programArgs) {
        Script mainScript = scripts.get(scripts.size() - 1);
        try (Context context = contextBuilder.arguments(mainScript.getLanguage(), programArgs).build();){
            Engine engine = context.getEngine();
            this.checkLanguage(this.mainLanguage, engine);
            for (Script script : scripts) {
                this.checkLanguage(script.languageId, engine);
            }
            for (Script script : scripts) {
                try {
                    Value result = context.eval(script.getSource());
                    if (!script.isPrintResult()) continue;
                    System.out.println(result);
                }
                catch (PolyglotException e) {
                    throw this.abort(e);
                }
                catch (IOException e) {
                    throw this.abort(e);
                }
                catch (Throwable t) {
                    throw this.abort(t);
                    return;
                }
            }
        }
    }

    Launcher.AbortException abort(PolyglotException e) {
        if (e.isInternalError()) {
            System.err.println("Internal error occurred: " + e.toString());
            if (this.verbose) {
                e.printStackTrace(System.err);
            } else {
                System.err.println("Run with --verbose to see the full stack trace.");
            }
            throw this.exit(1);
        }
        if (e.isExit()) {
            throw this.exit(e.getExitStatus());
        }
        if (e.isSyntaxError()) {
            throw this.abort(e.getMessage(), 1);
        }
        ArrayList<PolyglotException.StackFrame> trace = new ArrayList<PolyglotException.StackFrame>();
        for (PolyglotException.StackFrame stackFrame : e.getPolyglotStackTrace()) {
            trace.add(stackFrame);
        }
        for (int i = trace.size() - 1; i >= 0 && ((PolyglotException.StackFrame)trace.get(i)).isHostFrame(); --i) {
            trace.remove(i);
        }
        if (e.isHostException()) {
            System.err.println(e.asHostException().toString());
        } else {
            System.err.println(e.getMessage());
        }
        for (PolyglotException.StackFrame stackFrame : trace) {
            System.err.print("        at ");
            System.err.println(stackFrame.toString());
        }
        throw this.exit(1);
    }

    private void runShell(Context.Builder contextBuilder) {
        try {
            Context context = contextBuilder.build();
            try {
                MultiLanguageShell polyglotShell = new MultiLanguageShell(context, System.in, System.out, this.mainLanguage);
                throw this.exit(polyglotShell.readEvalPrint());
            }
            catch (Throwable throwable) {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw this.abort(e);
        }
    }

    public static void main(String[] args) {
        try {
            PolyglotLauncher launcher = new PolyglotLauncher();
            try {
                launcher.launch(args);
            }
            catch (Launcher.AbortException e) {
                throw e;
            }
            catch (PolyglotException e) {
                PolyglotLauncher.handlePolyglotException(e);
            }
            catch (Throwable t) {
                throw launcher.abort(t);
            }
        }
        catch (Launcher.AbortException e) {
            PolyglotLauncher.handleAbortException(e);
        }
    }

    static {
        if (IS_AOT) {
            AOT_LAUNCHER_CLASSES = new HashMap<String, Class<AbstractLanguageLauncher>>();
            Engine engine = Engine.newBuilder().allowExperimentalOptions(true).build();
            Set languages = Collections.unmodifiableSet(engine.getLanguages().keySet());
            engine.close();
            String macrosPathsPorperty = System.getProperty("com.oracle.graalvm.launcher.macrospaths");
            if (macrosPathsPorperty != null && !macrosPathsPorperty.isEmpty()) {
                Path macrosDir = Paths.get(macrosPathsPorperty, new String[0]);
                if (!Files.isDirectory(macrosDir, new LinkOption[0])) {
                    throw new RuntimeException("Expected " + macrosDir + " to be a directory");
                }
                try {
                    ArrayList classpath = new ArrayList();
                    ArrayList classes = new ArrayList();
                    Files.list(macrosDir).flatMap(PolyglotLauncher::loadPolyglotConfig).filter(c -> languages.contains(c.language)).forEach(c -> {
                        c.classpath.stream().map(c.dir::resolve).map(p -> {
                            if (!Files.exists(p, new LinkOption[0])) {
                                throw new RuntimeException(p + " does not exist");
                            }
                            try {
                                return p.normalize().toUri().toURL();
                            }
                            catch (MalformedURLException e) {
                                throw new RuntimeException(e);
                            }
                        }).forEach(classpath::add);
                        classes.add(c.launcher);
                    });
                    URLClassLoader loader = new URLClassLoader(classpath.toArray(new URL[0]), PolyglotLauncher.class.getClassLoader());
                    for (String launcher : classes) {
                        AOT_LAUNCHER_CLASSES.put(launcher, PolyglotLauncher.getLauncherClass(launcher, loader));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                System.err.println("ERROR: com.oracle.graalvm.launcher.macrospaths was not provided");
            }
        } else {
            AOT_LAUNCHER_CLASSES = null;
        }
    }

    private class EvalScript
    extends Script {
        final String script;

        EvalScript(String languageId, String script) {
            super(languageId);
            this.script = script;
        }

        @Override
        public Source getSource() {
            return Source.create((String)this.getLanguage(), (CharSequence)this.script);
        }

        public String toString() {
            return this.script;
        }

        @Override
        protected String getLanguageSpecifierHelp() {
            return "specify the language using --eval <language>:<source>.";
        }

        @Override
        public boolean isPrintResult() {
            return true;
        }
    }

    private class FileScript
    extends Script {
        private final boolean main;
        final String file;
        private Source source;

        FileScript(String languageId, String file, boolean main) {
            super(languageId);
            this.file = file;
            this.main = main;
        }

        @Override
        public Source getSource() throws IOException {
            if (this.source == null) {
                this.source = Source.newBuilder((String)this.getLanguage(), (File)new File(this.file)).build();
            }
            return this.source;
        }

        @Override
        protected String findLanguage() {
            try {
                return Source.findLanguage((File)new File(this.file));
            }
            catch (IOException e) {
                return null;
            }
        }

        public String toString() {
            return this.file;
        }

        @Override
        protected String getLanguageSpecifierHelp() {
            if (this.main) {
                return "use the --language option";
            }
            return "specify the language using --file <language>:<file>. ";
        }

        @Override
        public boolean isPrintResult() {
            return false;
        }
    }

    private abstract class Script {
        final String languageId;

        Script(String languageId) {
            this.languageId = languageId;
        }

        final String getLanguage() {
            String language = this.languageId;
            if (language == null) {
                language = this.findLanguage();
            }
            if (language == null && PolyglotLauncher.this.mainLanguage != null) {
                return PolyglotLauncher.this.mainLanguage;
            }
            if (language == null) {
                throw PolyglotLauncher.this.abort(String.format("Can not determine language for '%s' %s", this, this.getLanguageSpecifierHelp()));
            }
            return language;
        }

        protected String findLanguage() {
            return null;
        }

        public abstract boolean isPrintResult();

        public abstract Source getSource() throws IOException;

        protected abstract String getLanguageSpecifierHelp();
    }

    private static final class PolyglotLauncherConfig {
        final Path dir;
        final String language;
        final List<String> classpath;
        final String launcher;

        static PolyglotLauncherConfig parse(String spec, Path context) {
            Object[] parts = spec.split("\\|");
            if (parts.length != 3) {
                throw new RuntimeException("Expected 3 `|`-separated parts in polyglot config (" + context + "). Got: " + Arrays.toString(parts));
            }
            return new PolyglotLauncherConfig(context.getParent(), parts[0], Arrays.asList(parts[1].split(":")), (String)parts[2]);
        }

        PolyglotLauncherConfig(Path dir, String language, List<String> classpath, String launcher) {
            this.dir = dir;
            this.language = language;
            this.classpath = classpath;
            this.launcher = launcher;
        }
    }
}

