/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.libgraal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompiler;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.HotSpotToSVM;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.SVMToHotSpot;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSCompilableTruffleAST;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCompilationTask;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCompilerRuntimeGen;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleInliningPlan;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.jni.HSObject;
import org.graalvm.libgraal.jni.HotSpotToSVMScope;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIUtil;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.WordFactory;

final class HSTruffleCompilerRuntime
extends HSObject
implements HotSpotTruffleCompilerRuntime {
    private static final Map<Integer, JavaKind> JAVA_KINDS;
    private final ResolvedJavaType classLoaderDelegate;
    private final OptionValues initialOptions;
    private volatile Map<String, Object> cachedOptionsMap;

    HSTruffleCompilerRuntime(JNI.JNIEnv env, JNI.JObject handle, ResolvedJavaType classLoaderDelegate, OptionValues options) {
        super(env, handle);
        this.classLoaderDelegate = classLoaderDelegate;
        this.initialOptions = options;
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.CreateInliningPlan)
    public TruffleInliningPlan createInliningPlan(CompilableTruffleAST compilable, TruffleCompilationTask task) {
        HotSpotToSVMScope scope = HotSpotToSVMScope.scopeOrNull();
        if (scope == null) {
            return null;
        }
        JNI.JObject compilableHandle = ((HSCompilableTruffleAST)compilable).getHandle();
        JNI.JObject taskHandle = task == null ? (JNI.JObject)WordFactory.nullPointer() : ((HSTruffleCompilationTask)task).getHandle();
        Object hsInliningPlan = HSTruffleCompilerRuntimeGen.callCreateInliningPlan(scope.getEnv(), this.getHandle(), compilableHandle, taskHandle);
        return new HSTruffleInliningPlan((HotSpotToSVMScope<HotSpotToSVM.Id>)scope.narrow(HotSpotToSVM.Id.class), (JNI.JObject)hsInliningPlan);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.AsCompilableTruffleAST)
    public CompilableTruffleAST asCompilableTruffleAST(JavaConstant constant) {
        HotSpotToSVMScope scope = HotSpotToSVMScope.scopeOrNull();
        if (scope == null) {
            return null;
        }
        long constantHandle = LibGraal.translate((HotSpotJVMCIRuntime)HotSpotJVMCIRuntime.runtime(), (Object)constant);
        Object hsCompilable = HSTruffleCompilerRuntimeGen.callAsCompilableTruffleAST(scope.getEnv(), this.getHandle(), constantHandle);
        if (hsCompilable.isNull()) {
            return null;
        }
        return new HSCompilableTruffleAST((HotSpotToSVMScope<HotSpotToSVM.Id>)scope.narrow(HotSpotToSVM.Id.class), (JNI.JObject)hsCompilable);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.OnCodeInstallation)
    public void onCodeInstallation(CompilableTruffleAST compilable, InstalledCode installedCode) {
        long installedCodeHandle = LibGraal.translate((HotSpotJVMCIRuntime)HotSpotJVMCIRuntime.runtime(), (Object)installedCode);
        JNI.JNIEnv env = HotSpotToSVMScope.env();
        HSTruffleCompilerRuntimeGen.callOnCodeInstallation(env, this.getHandle(), ((HSCompilableTruffleAST)compilable).getHandle(), installedCodeHandle);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.RegisterOptimizedAssumptionDependency)
    public Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant optimizedAssumption) {
        long optimizedAssumptionHandle = LibGraal.translate((HotSpotJVMCIRuntime)HotSpotJVMCIRuntime.runtime(), (Object)optimizedAssumption);
        JNI.JNIEnv env = HotSpotToSVMScope.env();
        Object assumptionConsumer = HSTruffleCompilerRuntimeGen.callRegisterOptimizedAssumptionDependency(env, this.getHandle(), optimizedAssumptionHandle);
        return assumptionConsumer.isNull() ? null : new HSConsumer((HotSpotToSVMScope<HotSpotToSVM.Id>)HotSpotToSVMScope.scope().narrow(HotSpotToSVM.Id.class), (JNI.JObject)assumptionConsumer);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetCallTargetForCallNode)
    public JavaConstant getCallTargetForCallNode(JavaConstant callNode) {
        HotSpotJVMCIRuntime jvmciRuntime = HotSpotJVMCIRuntime.runtime();
        long callNodeHandle = LibGraal.translate((HotSpotJVMCIRuntime)jvmciRuntime, (Object)callNode);
        JNI.JNIEnv env = HotSpotToSVMScope.env();
        long callTargetHandle = HSTruffleCompilerRuntimeGen.callGetCallTargetForCallNode(env, this.getHandle(), callNodeHandle);
        return (JavaConstant)LibGraal.unhand((HotSpotJVMCIRuntime)jvmciRuntime, JavaConstant.class, (long)callTargetHandle);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.IsTruffleBoundary)
    public boolean isTruffleBoundary(ResolvedJavaMethod method) {
        return HSTruffleCompilerRuntimeGen.callIsTruffleBoundary(HotSpotToSVMScope.env(), this.getHandle(), LibGraal.translate((HotSpotJVMCIRuntime)HotSpotJVMCIRuntime.runtime(), (Object)method));
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.IsValueType)
    public boolean isValueType(ResolvedJavaType type) {
        return HSTruffleCompilerRuntimeGen.callIsValueType(HotSpotToSVMScope.env(), this.getHandle(), LibGraal.translate((HotSpotJVMCIRuntime)HotSpotJVMCIRuntime.runtime(), (Object)type));
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetInlineKind)
    public TruffleCompilerRuntime.InlineKind getInlineKind(ResolvedJavaMethod original, boolean duringPartialEvaluation) {
        long methodHandle = LibGraal.translate((HotSpotJVMCIRuntime)HotSpotJVMCIRuntime.runtime(), (Object)original);
        int inlineKindOrdinal = HSTruffleCompilerRuntimeGen.callGetInlineKind(HotSpotToSVMScope.env(), this.getHandle(), methodHandle, duringPartialEvaluation);
        return TruffleCompilerRuntime.InlineKind.values()[inlineKindOrdinal];
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetLoopExplosionKind)
    public TruffleCompilerRuntime.LoopExplosionKind getLoopExplosionKind(ResolvedJavaMethod method) {
        long methodHandle = LibGraal.translate((HotSpotJVMCIRuntime)HotSpotJVMCIRuntime.runtime(), (Object)method);
        int loopExplosionKindOrdinal = HSTruffleCompilerRuntimeGen.callGetLoopExplosionKind(HotSpotToSVMScope.env(), this.getHandle(), methodHandle);
        return TruffleCompilerRuntime.LoopExplosionKind.values()[loopExplosionKindOrdinal];
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetConstantFieldInfo)
    public TruffleCompilerRuntime.ConstantFieldInfo getConstantFieldInfo(ResolvedJavaField field) {
        ResolvedJavaType enclosingType = field.getDeclaringClass();
        boolean isStatic = field.isStatic();
        Object[] declaredFields = isStatic ? enclosingType.getStaticFields() : enclosingType.getInstanceFields(false);
        int fieldIndex = -1;
        for (int i = 0; i < declaredFields.length; ++i) {
            if (!field.equals(declaredFields[i])) continue;
            fieldIndex = i;
            break;
        }
        if (fieldIndex == -1) {
            throw new IllegalStateException(String.format("%s field: %s declared in: %s is not in declared fields: %s", isStatic ? "Static" : "Instance", field, enclosingType, Arrays.toString(declaredFields)));
        }
        long typeHandle = LibGraal.translate((HotSpotJVMCIRuntime)HotSpotJVMCIRuntime.runtime(), (Object)enclosingType);
        int fieldInfoDimension = HSTruffleCompilerRuntimeGen.callGetConstantFieldInfo(HotSpotToSVMScope.env(), this.getHandle(), typeHandle, isStatic, fieldIndex);
        switch (fieldInfoDimension) {
            case -2147483648: {
                return null;
            }
            case -2: {
                return TruffleCompilerRuntime.ConstantFieldInfo.CHILDREN;
            }
            case -1: {
                return TruffleCompilerRuntime.ConstantFieldInfo.CHILD;
            }
        }
        return TruffleCompilerRuntime.ConstantFieldInfo.forDimensions((int)fieldInfoDimension);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetJavaKindForFrameSlotKind)
    public JavaKind getJavaKindForFrameSlotKind(int frameSlotKindTag) {
        int basicType = HSTruffleCompilerRuntimeGen.callGetJavaKindForFrameSlotKind(HotSpotToSVMScope.env(), this.getHandle(), frameSlotKindTag);
        return JAVA_KINDS.get(basicType);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetFrameSlotKindTagsCount)
    public int getFrameSlotKindTagsCount() {
        return HSTruffleCompilerRuntimeGen.callGetFrameSlotKindTagsCount(HotSpotToSVMScope.env(), this.getHandle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SVMToHotSpot(value=SVMToHotSpot.Id.GetTruffleCallBoundaryMethods)
    public Iterable<ResolvedJavaMethod> getTruffleCallBoundaryMethods() {
        JNI.JNIEnv env = HotSpotToSVMScope.env();
        JNI.JLongArray handles = (JNI.JLongArray)HSTruffleCompilerRuntimeGen.callGetTruffleCallBoundaryMethods(env, this.getHandle());
        int len = JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)handles);
        HotSpotJVMCIRuntime runtime = HotSpotJVMCIRuntime.runtime();
        ArrayList<ResolvedJavaMethod> res = new ArrayList<ResolvedJavaMethod>();
        CLongPointer longs = JNIUtil.GetLongArrayElements((JNI.JNIEnv)env, (JNI.JLongArray)handles, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
        try {
            for (int i = 0; i < len; ++i) {
                res.add((ResolvedJavaMethod)LibGraal.unhand((HotSpotJVMCIRuntime)runtime, ResolvedJavaMethod.class, (long)longs.read(i)));
            }
        }
        finally {
            JNIUtil.ReleaseLongArrayElements((JNI.JNIEnv)env, (JNI.JLongArray)handles, (CLongPointer)longs, (int)2);
        }
        return res;
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetFrameSlotKindTagForJavaKind)
    public int getFrameSlotKindTagForJavaKind(JavaKind kind) {
        return HSTruffleCompilerRuntimeGen.callGetFrameSlotKindTagForJavaKind(HotSpotToSVMScope.env(), this.getHandle(), kind.getBasicType());
    }

    public ResolvedJavaType resolveType(MetaAccessProvider metaAccess, String className, boolean required) {
        String internalName = JNIUtil.getInternalName((String)className);
        JavaType jt = HotSpotJVMCIRuntime.runtime().lookupType(internalName, (HotSpotResolvedObjectType)this.classLoaderDelegate, true);
        if (jt instanceof UnresolvedJavaType) {
            if (required) {
                throw new NoClassDefFoundError(internalName);
            }
            return null;
        }
        return (ResolvedJavaType)jt;
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.Log)
    public void log(String message) {
        JNI.JNIEnv env = HotSpotToSVMScope.env();
        JNI.JString jniMessage = JNIUtil.createHSString((JNI.JNIEnv)env, (String)message);
        HSTruffleCompilerRuntimeGen.callLog(env, this.getHandle(), (JNI.JObject)jniMessage);
    }

    public Map<String, Object> getOptions() {
        Map<String, Object> res = this.cachedOptionsMap;
        if (res == null) {
            res = new HashMap<String, Object>();
            UnmodifiableMapCursor optionValues = this.initialOptions.getMap().getEntries();
            while (optionValues.advance()) {
                OptionKey key = (OptionKey)optionValues.getKey();
                Object value = optionValues.getValue();
                res.put(key.getName(), value);
            }
            this.cachedOptionsMap = res;
        }
        return res;
    }

    public <T> T getOptions(Class<T> optionValuesType) {
        if (optionValuesType == OptionValues.class) {
            return optionValuesType.cast(this.initialOptions);
        }
        return (T)super.getOptions(optionValuesType);
    }

    public <T> T convertOptions(Class<T> optionValuesType, Map<String, Object> map) {
        if (optionValuesType == OptionValues.class) {
            EconomicMap values = OptionValues.newOptionMap();
            Iterable loader = OptionsParser.getOptionsLoader();
            for (Map.Entry<String, Object> e : map.entrySet()) {
                String optionName = e.getKey();
                Object optionValue = e.getValue();
                OptionsParser.parseOption((String)optionName, (Object)optionValue, (EconomicMap)values, (Iterable)loader);
            }
            return optionValuesType.cast(new OptionValues((UnmodifiableEconomicMap)values));
        }
        return (T)super.convertOptions(optionValuesType, map);
    }

    public TruffleCompiler getTruffleCompiler() {
        throw new UnsupportedOperationException("Should never be called in the compiler.");
    }

    static {
        HashMap<Integer, JavaKind> m = new HashMap<Integer, JavaKind>();
        for (JavaKind jk : JavaKind.values()) {
            m.put(jk.getBasicType(), jk);
        }
        JAVA_KINDS = Collections.unmodifiableMap(m);
    }

    private static class HSConsumer
    extends HSObject
    implements Consumer<OptimizedAssumptionDependency> {
        HSConsumer(HotSpotToSVMScope<HotSpotToSVM.Id> scope, JNI.JObject handle) {
            super(scope, handle);
        }

        @Override
        @SVMToHotSpot(value=SVMToHotSpot.Id.ConsumeOptimizedAssumptionDependency)
        public void accept(OptimizedAssumptionDependency dependency) {
            JNI.JObject dependencyHandle = dependency == null ? (JNI.JObject)WordFactory.nullPointer() : ((HSCompilableTruffleAST)dependency).getHandle();
            HSTruffleCompilerRuntimeGen.callConsumeOptimizedAssumptionDependency(HotSpotToSVMScope.env(), this.getHandle(), dependencyHandle);
        }
    }
}

