/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.AnalysisPolicy;
import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContextPolicy;
import com.oracle.graal.pointsto.flow.context.object.AllocationContextSensitiveObject;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.typestore.ArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.FieldTypeStore;
import com.oracle.graal.pointsto.typestore.SplitArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.SplitFieldTypeStore;
import com.oracle.graal.pointsto.typestore.UnifiedArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.UnifiedFieldTypeStore;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.options.OptionValues;

public class BytecodeSensitiveAnalysisPolicy
extends AnalysisPolicy {
    private BytecodeAnalysisContextPolicy contextPolicy = new BytecodeAnalysisContextPolicy();

    public BytecodeSensitiveAnalysisPolicy(OptionValues options) {
        super(options);
    }

    public BytecodeAnalysisContextPolicy contextPolicy() {
        return this.contextPolicy;
    }

    @Override
    public boolean needsConstantCache() {
        return true;
    }

    @Override
    public boolean isSummaryObject(AnalysisObject object) {
        return object.isContextInsensitiveObject();
    }

    @Override
    public boolean isMergingEnabled() {
        return true;
    }

    @Override
    public void noteMerge(BigBang bb, TypeState t) {
        t.noteMerge(bb);
    }

    @Override
    public void noteMerge(BigBang bb, AnalysisObject ... a) {
        for (AnalysisObject o : a) {
            o.noteMerge(bb);
        }
    }

    @Override
    public void noteMerge(BigBang bb, AnalysisObject o) {
        o.noteMerge(bb);
    }

    @Override
    public boolean isContextSensitiveAllocation(BigBang bb, AnalysisType type, AnalysisContext allocationContext) {
        return bb.trackConcreteAnalysisObjects(type);
    }

    @Override
    public AnalysisObject createHeapObject(BigBang bb, AnalysisType type, BytecodeLocation allocationSite, AnalysisContext allocationContext) {
        assert (((Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(this.options)).booleanValue());
        if (this.isContextSensitiveAllocation(bb, type, allocationContext)) {
            return new AllocationContextSensitiveObject(bb, type, allocationSite, allocationContext);
        }
        return type.getContextInsensitiveAnalysisObject();
    }

    @Override
    public AnalysisObject createConstantObject(BigBang bb, JavaConstant constant, AnalysisType exactType) {
        if (bb.trackConcreteAnalysisObjects(exactType)) {
            return exactType.getCachedConstantObject(bb, constant);
        }
        return exactType.getContextInsensitiveAnalysisObject();
    }

    @Override
    public BytecodeLocation createAllocationSite(BigBang bb, int bci, AnalysisMethod method) {
        return BytecodeLocation.create(bci, method);
    }

    @Override
    public FieldTypeStore createFieldTypeStore(AnalysisObject object, AnalysisField field, AnalysisUniverse universe) {
        assert (((Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(this.options)).booleanValue());
        if (object.isContextInsensitiveObject()) {
            return new SplitFieldTypeStore(field, object);
        }
        return new UnifiedFieldTypeStore(field, object);
    }

    @Override
    public ArrayElementsTypeStore createArrayElementsTypeStore(AnalysisObject object, AnalysisUniverse universe) {
        assert (((Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(this.options)).booleanValue());
        if (object.type().isArray()) {
            if (object.isContextInsensitiveObject()) {
                return new SplitArrayElementsTypeStore(object);
            }
            return new UnifiedArrayElementsTypeStore(object);
        }
        return null;
    }

    @Override
    public AbstractVirtualInvokeTypeFlow createVirtualInvokeTypeFlow(Invoke invoke, MethodCallTargetNode target, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
        return new BytecodeSensitiveVirtualInvokeTypeFlow(invoke, target, actualParameters, actualReturn, location);
    }

    private static class BytecodeSensitiveVirtualInvokeTypeFlow
    extends AbstractVirtualInvokeTypeFlow {
        private final ConcurrentMap<MethodFlowsGraph, Object> calleesFlows;
        private final AnalysisContext callerContext;

        protected BytecodeSensitiveVirtualInvokeTypeFlow(Invoke invoke, MethodCallTargetNode target, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
            super(invoke, target, actualParameters, actualReturn, location);
            this.calleesFlows = null;
            this.callerContext = null;
        }

        protected BytecodeSensitiveVirtualInvokeTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, BytecodeSensitiveVirtualInvokeTypeFlow original) {
            super(bb, methodFlows, original);
            this.calleesFlows = new ConcurrentHashMap<MethodFlowsGraph, Object>(4, 0.75f, 1);
            this.callerContext = methodFlows.context();
        }

        @Override
        public TypeFlow<MethodCallTargetNode> copy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new BytecodeSensitiveVirtualInvokeTypeFlow(bb, methodFlows, this);
        }

        @Override
        public void onObservedUpdate(BigBang bb) {
            assert (this.isClone());
            TypeState receiverState = this.getReceiver().getState();
            if (receiverState.isUnknown()) {
                bb.reportIllegalUnknownUse(this.graphRef.getMethod(), (Node)this.source, "Illegal: Invoke on UnknownTypeState objects. Invoke: " + this);
                return;
            }
            TypeState.TypesObjectsIterator toi = receiverState.getTypesObjectsIterator();
            while (toi.hasNextType()) {
                AnalysisType type = toi.nextType();
                AnalysisMethod method = type.resolveConcreteMethod(this.getTargetMethod(), ((MethodCallTargetNode)this.getSource()).invoke().getContextType());
                if (method == null || Modifier.isAbstract(method.getModifiers())) continue;
                assert (!Modifier.isAbstract(method.getModifiers()));
                MethodTypeFlow callee = method.getTypeFlow();
                while (toi.hasNextObject(type)) {
                    AnalysisObject actualReceiverObject = toi.nextObject(type);
                    AnalysisContext calleeContext = bb.contextPolicy().calleeContext(bb, actualReceiverObject, this.callerContext, callee);
                    MethodFlowsGraph calleeFlows = callee.addContext(bb, calleeContext, this);
                    if (this.calleesFlows.put(calleeFlows, Boolean.TRUE) == null) {
                        this.addCallee(calleeFlows.getMethod());
                        this.linkCallee(bb, false, calleeFlows);
                    }
                    this.updateReceiver(bb, calleeFlows, actualReceiverObject);
                }
            }
        }

        @Override
        public Collection<MethodFlowsGraph> getCalleesFlows(BigBang bb) {
            return new ArrayList<MethodFlowsGraph>(this.calleesFlows.keySet());
        }
    }
}

