/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.AllSynchronizedTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.CloneTypeFlow;
import com.oracle.graal.pointsto.flow.DynamicNewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InitialParamTypeFlow;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.LoadFieldTypeFlow;
import com.oracle.graal.pointsto.flow.MonitorEnterTypeFlow;
import com.oracle.graal.pointsto.flow.NewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetLoadTypeFlow;
import com.oracle.graal.pointsto.flow.SourceTypeFlow;
import com.oracle.graal.pointsto.flow.StaticInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.vm.ci.common.JVMCIError;
import org.graalvm.compiler.graph.Node;

public class MethodFlowsGraph {
    protected final int id = TypeFlow.nextId.incrementAndGet();
    private final AnalysisMethod method;
    private AnalysisContext context;
    private boolean isClone;
    public TypeFlow<?>[] linearizedGraph;
    private FormalParamTypeFlow[] parameters;
    private InitialParamTypeFlow[] initialParameterFlows;
    private List<SourceTypeFlow> sources;
    private List<LoadFieldTypeFlow> fieldLoads;
    private List<OffsetLoadTypeFlow.LoadIndexedTypeFlow> indexedLoads;
    private List<TypeFlow<?>> miscEntryFlows;
    private List<NewInstanceTypeFlow> allocations;
    private List<DynamicNewInstanceTypeFlow> dynamicAllocations;
    private List<CloneTypeFlow> clones;
    private List<MonitorEnterTypeFlow> monitorEntries;
    private Map<Object, InstanceOfTypeFlow> instanceOfFlows;
    private Map<Object, InvokeTypeFlow> invokeFlows;
    private FormalReturnTypeFlow result;
    private boolean isLinearized = false;
    private boolean sealed;

    public MethodFlowsGraph(AnalysisMethod analysisMethod) {
        int offset;
        this.method = analysisMethod;
        this.context = null;
        this.isClone = false;
        boolean isStatic = Modifier.isStatic(this.method.getModifiers());
        int parameterCount = this.method.getSignature().getParameterCount(!isStatic);
        this.parameters = new FormalParamTypeFlow[parameterCount];
        for (int i = offset = isStatic ? 0 : 1; i < this.parameters.length; ++i) {
            this.method.getSignature().getParameterType(i - offset, this.method.getDeclaringClass());
        }
        this.initialParameterFlows = new InitialParamTypeFlow[parameterCount];
        this.method.getSignature().getReturnType(this.method.getDeclaringClass());
        this.allocations = new ArrayList<NewInstanceTypeFlow>();
        this.dynamicAllocations = new ArrayList<DynamicNewInstanceTypeFlow>();
        this.monitorEntries = new ArrayList<MonitorEnterTypeFlow>();
        this.clones = new ArrayList<CloneTypeFlow>();
        this.sources = new ArrayList<SourceTypeFlow>();
        this.fieldLoads = new ArrayList<LoadFieldTypeFlow>();
        this.indexedLoads = new ArrayList<OffsetLoadTypeFlow.LoadIndexedTypeFlow>();
        this.miscEntryFlows = new ArrayList();
        this.instanceOfFlows = new HashMap<Object, InstanceOfTypeFlow>();
        this.invokeFlows = new HashMap<Object, InvokeTypeFlow>(4, 0.75f);
    }

    public MethodFlowsGraph(AnalysisMethod method, AnalysisContext context) {
        this.context = context;
        this.method = method;
        this.isClone = true;
    }

    public void cloneOriginalFlows(BigBang bb) {
        assert (this.isClone && this.context != null);
        MethodFlowsGraph originalMethodFlowsGraph = this.method.getTypeFlow().originalMethodFlows;
        assert (originalMethodFlowsGraph != null && originalMethodFlowsGraph.isLinearized()) : " Method " + this + " is not linearized";
        this.linearizedGraph = new TypeFlow[originalMethodFlowsGraph.linearizedGraph.length];
        this.parameters = new FormalParamTypeFlow[originalMethodFlowsGraph.parameters.length];
        for (int i = 0; i < originalMethodFlowsGraph.parameters.length; ++i) {
            if (originalMethodFlowsGraph.getParameter(i) == null) continue;
            this.parameters[i] = this.lookupCloneOf(bb, originalMethodFlowsGraph.getParameter(i));
        }
        this.initialParameterFlows = new InitialParamTypeFlow[originalMethodFlowsGraph.initialParameterFlows.length];
        this.allocations = originalMethodFlowsGraph.allocations.stream().map(f -> this.lookupCloneOf(bb, f)).collect(Collectors.toList());
        this.dynamicAllocations = originalMethodFlowsGraph.dynamicAllocations.stream().map(f -> this.lookupCloneOf(bb, f)).collect(Collectors.toList());
        this.monitorEntries = originalMethodFlowsGraph.monitorEntries.stream().map(f -> this.lookupCloneOf(bb, f)).collect(Collectors.toList());
        this.clones = originalMethodFlowsGraph.clones.stream().map(f -> this.lookupCloneOf(bb, f)).collect(Collectors.toList());
        this.sources = originalMethodFlowsGraph.sources.stream().map(f -> this.lookupCloneOf(bb, f)).collect(Collectors.toList());
        this.result = originalMethodFlowsGraph.getResult() != null ? this.lookupCloneOf(bb, originalMethodFlowsGraph.getResult()) : null;
        this.fieldLoads = originalMethodFlowsGraph.fieldLoads.stream().map(f -> this.lookupCloneOf(bb, f)).collect(Collectors.toList());
        this.indexedLoads = originalMethodFlowsGraph.indexedLoads.stream().map(f -> this.lookupCloneOf(bb, f)).collect(Collectors.toList());
        this.instanceOfFlows = originalMethodFlowsGraph.instanceOfFlows.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> this.lookupCloneOf(bb, (InstanceOfTypeFlow)e.getValue())));
        this.miscEntryFlows = originalMethodFlowsGraph.miscEntryFlows.stream().map(f -> this.lookupCloneOf(bb, f)).collect(Collectors.toList());
        this.invokeFlows = originalMethodFlowsGraph.invokeFlows.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> this.lookupCloneOf(bb, (InvokeTypeFlow)e.getValue())));
        this.sealed = true;
    }

    public <T extends TypeFlow<?>> T lookupCloneOf(BigBang bb, T original) {
        assert (original != null && !original.isClone());
        assert (!(original instanceof FieldTypeFlow)) : "Trying to clone a field type flow";
        assert (!(original instanceof ArrayElementsTypeFlow)) : "Trying to clone an mixed elements type flow";
        if (original instanceof AllInstantiatedTypeFlow || original instanceof AllSynchronizedTypeFlow) {
            return original;
        }
        int slot = original.getSlot();
        assert (slot >= 0 && slot < this.linearizedGraph.length) : "Slot index out of bounds " + slot + " : " + original + " [" + original.getSource() + "]";
        TypeFlow<?> clone = this.linearizedGraph[slot];
        if (clone == null) {
            if (this.sealed) {
                JVMCIError.shouldNotReachHere((String)"Trying to create a clone after the method flows have been sealed.");
            }
            clone = original.copy(bb, this);
            assert (slot == clone.getSlot());
            assert (this.linearizedGraph[slot] == null) : "Clone already exists: " + slot + " : " + original;
            this.linearizedGraph[slot] = clone;
        }
        return (T)clone;
    }

    public void linkClones(BigBang bb) {
        MethodFlowsGraph originalMethodFlowsGraph = this.method.getTypeFlow().originalMethodFlows;
        for (int i = 0; i < originalMethodFlowsGraph.initialParameterFlows.length; ++i) {
            InitialParamTypeFlow initialParameterFlow = originalMethodFlowsGraph.getInitialParameterFlow(i);
            if (initialParameterFlow == null || this.parameters[i] == null) continue;
            initialParameterFlow.addUse(bb, this.parameters[i]);
            this.initialParameterFlows[i] = initialParameterFlow;
        }
        for (TypeFlow<?> original : originalMethodFlowsGraph.linearizedGraph) {
            TypeFlow<?> clone = this.lookupCloneOf(bb, original);
            clone.initClone(bb);
            for (TypeFlow<?> originalObserver : original.getObservers()) {
                assert (!(originalObserver instanceof AllInstantiatedTypeFlow));
                assert (!originalObserver.isClone());
                if (MethodFlowsGraph.nonCloneableFlow(originalObserver)) {
                    clone.addObserver(bb, originalObserver);
                    continue;
                }
                if (MethodFlowsGraph.crossMethodUse(original, originalObserver)) continue;
                TypeFlow<?> clonedObserver = this.lookupCloneOf(bb, originalObserver);
                clone.addObserver(bb, clonedObserver);
            }
            for (TypeFlow<?> originalUse : original.getUses()) {
                assert (!(originalUse instanceof AllInstantiatedTypeFlow));
                assert (!originalUse.isClone());
                if (MethodFlowsGraph.nonCloneableFlow(originalUse)) {
                    clone.addUse(bb, originalUse);
                    continue;
                }
                if (MethodFlowsGraph.crossMethodUse(original, originalUse)) continue;
                TypeFlow<?> clonedUse = this.lookupCloneOf(bb, originalUse);
                clone.addUse(bb, clonedUse);
            }
            if (!(clone instanceof StaticInvokeTypeFlow)) continue;
            StaticInvokeTypeFlow invokeFlow = (StaticInvokeTypeFlow)clone;
            bb.postFlow(invokeFlow);
        }
    }

    public static boolean nonCloneableFlow(TypeFlow<?> flow) {
        return flow instanceof FieldTypeFlow || flow instanceof ArrayElementsTypeFlow;
    }

    public static boolean crossMethodUse(TypeFlow<?> flow, TypeFlow<?> use) {
        return flow instanceof FormalReturnTypeFlow || use instanceof FormalParamTypeFlow;
    }

    public void linearizeGraph() {
        this.linearizedGraph = this.getLinearizeGraph();
        this.isLinearized = true;
    }

    public TypeFlow<?>[] getLinearizeGraph() {
        ArrayDeque worklist = new ArrayDeque();
        for (FormalParamTypeFlow param : this.parameters) {
            if (param == null) continue;
            worklist.add(param);
        }
        worklist.addAll(this.allocations);
        worklist.addAll(this.dynamicAllocations);
        worklist.addAll(this.monitorEntries);
        worklist.addAll(this.clones);
        worklist.addAll(this.sources);
        worklist.addAll(this.miscEntryFlows);
        worklist.addAll(this.fieldLoads);
        worklist.addAll(this.indexedLoads);
        worklist.addAll(this.instanceOfFlows.values());
        worklist.addAll(this.invokeFlows.values());
        if (this.result != null) {
            worklist.add(this.result);
        }
        ArrayList<TypeFlow> resultFlows = new ArrayList<TypeFlow>();
        while (worklist.size() > 0) {
            TypeFlow flow = (TypeFlow)worklist.pop();
            if (flow.getSlot() != -1 || flow instanceof AllInstantiatedTypeFlow) continue;
            int slot = resultFlows.size();
            flow.setSlot(slot);
            resultFlows.add(flow);
            for (TypeFlow<?> use : flow.getUses()) {
                assert (use != null);
                if (use.isClone() || MethodFlowsGraph.crossMethodUse(flow, use) || MethodFlowsGraph.nonCloneableFlow(use)) continue;
                worklist.add(use);
            }
        }
        return resultFlows.toArray(new TypeFlow[resultFlows.size()]);
    }

    public int id() {
        return this.id;
    }

    public AnalysisContext context() {
        return this.context;
    }

    public AnalysisMethod getMethod() {
        return this.method;
    }

    public FormalReceiverTypeFlow getFormalReceiver() {
        return (FormalReceiverTypeFlow)this.getParameter(0);
    }

    public void setParameter(int index, FormalParamTypeFlow parameter) {
        assert (index >= 0 && index < this.parameters.length);
        this.parameters[index] = parameter;
    }

    public FormalParamTypeFlow getParameter(int idx) {
        assert (idx >= 0 && idx < this.parameters.length);
        return this.parameters[idx];
    }

    public TypeFlow<?>[] getParameters() {
        return this.parameters;
    }

    public void setInitialParameterFlow(InitialParamTypeFlow initialParameterFlow, int i) {
        assert (i >= 0 && i < this.initialParameterFlows.length);
        this.initialParameterFlows[i] = initialParameterFlow;
    }

    public InitialParamTypeFlow getInitialParameterFlow(int i) {
        assert (i >= 0 && i < this.initialParameterFlows.length);
        return this.initialParameterFlows[i];
    }

    public TypeFlow<?>[] getInitialParameterFlows() {
        return this.initialParameterFlows;
    }

    public void addAllocation(NewInstanceTypeFlow allocation) {
        this.allocations.add(allocation);
    }

    public List<NewInstanceTypeFlow> getAllocations() {
        return this.allocations;
    }

    public void addDynamicAllocation(DynamicNewInstanceTypeFlow allocation) {
        this.dynamicAllocations.add(allocation);
    }

    public List<DynamicNewInstanceTypeFlow> getDynamicAllocations() {
        return this.dynamicAllocations;
    }

    public void addMonitorEntry(MonitorEnterTypeFlow monitorEntry) {
        this.monitorEntries.add(monitorEntry);
    }

    public List<MonitorEnterTypeFlow> getMonitorEntries() {
        return this.monitorEntries;
    }

    public void addClone(CloneTypeFlow clone) {
        this.clones.add(clone);
    }

    public List<CloneTypeFlow> getClones() {
        return this.clones;
    }

    public void addSource(SourceTypeFlow source) {
        this.sources.add(source);
    }

    public void addMiscEntryFlow(TypeFlow<?> entryFlow) {
        assert (!(entryFlow instanceof AllInstantiatedTypeFlow));
        this.miscEntryFlows.add(entryFlow);
    }

    public void addFieldLoad(LoadFieldTypeFlow fieldLoad) {
        this.fieldLoads.add(fieldLoad);
    }

    public void addIndexedLoad(OffsetLoadTypeFlow.LoadIndexedTypeFlow indexedLoad) {
        this.indexedLoads.add(indexedLoad);
    }

    public void setResult(FormalReturnTypeFlow result) {
        this.result = result;
    }

    public FormalReturnTypeFlow getResult() {
        return this.result;
    }

    public Set<Map.Entry<Object, InvokeTypeFlow>> getInvokes() {
        return this.invokeFlows.entrySet();
    }

    public Collection<InvokeTypeFlow> getInvokeFlows() {
        return this.invokeFlows.values();
    }

    public Set<Map.Entry<Object, InstanceOfTypeFlow>> getInstanceOfFlows() {
        return this.instanceOfFlows.entrySet();
    }

    void addInstanceOf(Object key, InstanceOfTypeFlow instanceOf) {
        MethodFlowsGraph.doAddFlow(key, instanceOf, this.instanceOfFlows);
    }

    void addInvoke(Object key, InvokeTypeFlow invokeTypeFlow) {
        MethodFlowsGraph.doAddFlow(key, invokeTypeFlow, this.invokeFlows);
    }

    private static <T extends TypeFlow<? extends Node>> void doAddFlow(Object key, T flow, Map<Object, T> map) {
        if (map.containsKey(key)) {
            assert (key instanceof Integer);
            TypeFlow oldFlow = (TypeFlow)map.remove(key);
            map.put(new Object(), oldFlow);
            map.put(new Object(), flow);
        } else {
            map.put(key, flow);
        }
    }

    public InvokeTypeFlow getInvoke(Object key) {
        return this.invokeFlows.get(key);
    }

    public boolean isLinearized() {
        return this.isLinearized;
    }

    public List<MethodFlowsGraph> callers(BigBang bb) {
        ArrayList<MethodFlowsGraph> callers = new ArrayList<MethodFlowsGraph>();
        for (AnalysisMethod caller : this.method.getJavaInvocations()) {
            for (MethodFlowsGraph callerFlowGraph : caller.getTypeFlow().getFlows()) {
                for (InvokeTypeFlow callerInvoke : callerFlowGraph.getInvokeFlows()) {
                    for (MethodFlowsGraph calleeFlowGraph : callerInvoke.getCalleesFlows(bb)) {
                        if (!calleeFlowGraph.equals(this)) continue;
                        callers.add(callerFlowGraph);
                    }
                }
            }
        }
        return callers;
    }

    public InvokeTypeFlow invokeFlow(MethodFlowsGraph callerFlowGraph, BigBang bb) {
        for (InvokeTypeFlow callerInvoke : callerFlowGraph.getInvokeFlows()) {
            for (MethodFlowsGraph calleeFlowGraph : callerInvoke.getCalleesFlows(bb)) {
                if (!calleeFlowGraph.equals(this)) continue;
                return callerInvoke;
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodFlowsGraph that = (MethodFlowsGraph)obj;
        return this.method.equals(that.method) && this.isClone == that.isClone && this.context.equals(that.context);
    }

    public int hashCode() {
        return 0x2A ^ this.method.hashCode() ^ (this.isClone ? this.context.hashCode() : 1);
    }

    public String toString() {
        return "MethodFlowsGraph<" + this.method.format("%h.%n(%p)") + " " + (this.isClone ? this.context : "original") + ">";
    }
}

