/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.model;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.ClassNameComparator;
import org.graalvm.visualvm.core.datasupport.DataChangeListener;
import org.graalvm.visualvm.core.datasupport.DataChangeSupport;
import org.graalvm.visualvm.core.model.Model;
import org.graalvm.visualvm.core.model.ModelProvider;

public abstract class ModelFactory<M extends Model, D extends DataSource> {
    protected static final Logger LOGGER = Logger.getLogger(ModelFactory.class.getName());
    private final Reference<M> NULL_MODEL = new SoftReference<Object>(null);
    private SortedSet<ModelProvider<M, D>> providers = new TreeSet<ModelProvider<M, D>>(new ModelProviderComparator());
    private ReadWriteLock providersLock;
    private Map<DataSourceKey<D>, Reference<M>> modelCache = Collections.synchronizedMap(new HashMap());
    private DataChangeSupport<ModelProvider<M, D>> factoryChange = new DataChangeSupport();

    protected ModelFactory() {
        this.providersLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final M getModel(D dataSource) {
        Model model;
        DataSourceKey<D> key;
        Lock rlock;
        block10: {
            Reference<M> modelRef;
            block11: {
                M m;
                rlock = this.providersLock.readLock();
                rlock.lock();
                try {
                    D d = dataSource;
                    // MONITORENTER : d
                    key = new DataSourceKey<D>(dataSource);
                    modelRef = this.modelCache.get(key);
                    model = null;
                    if (modelRef == null) break block10;
                    if (modelRef != this.NULL_MODEL) break block11;
                    m = null;
                    // MONITOREXIT : d
                    rlock.unlock();
                }
                catch (Throwable throwable) {
                    rlock.unlock();
                    throw throwable;
                }
                return m;
            }
            model = (Model)modelRef.get();
            if (model != null) {
                Model model2 = model;
                // MONITOREXIT : d
                rlock.unlock();
                return (M)model2;
            }
        }
        for (ModelProvider modelProvider : this.providers) {
            model = modelProvider.createModelFor(dataSource);
            if (model == null) continue;
            this.modelCache.put(key, new SoftReference<Model>(model));
            break;
        }
        if (model == null) {
            this.modelCache.put(key, this.NULL_MODEL);
        }
        Model model3 = model;
        // MONITOREXIT : d
        rlock.unlock();
        return (M)model3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean registerProvider(ModelProvider<M, D> newProvider) {
        Lock wlock = this.providersLock.writeLock();
        wlock.lock();
        try {
            LOGGER.finer("Registering " + newProvider.getClass().getName());
            boolean added = this.providers.add(newProvider);
            if (added) {
                this.clearCache();
                this.factoryChange.fireChange(this.providers, Collections.singleton(newProvider), null);
            }
            boolean bl = added;
            return bl;
        }
        finally {
            wlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unregisterProvider(ModelProvider<M, D> oldProvider) {
        Lock wlock = this.providersLock.writeLock();
        wlock.lock();
        try {
            LOGGER.finer("Unregistering " + oldProvider.getClass().getName());
            boolean removed = this.providers.remove(oldProvider);
            if (removed) {
                this.clearCache();
                this.factoryChange.fireChange(this.providers, null, Collections.singleton(oldProvider));
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            wlock.unlock();
        }
    }

    public final void addFactoryChangeListener(DataChangeListener<ModelProvider<M, D>> listener) {
        this.factoryChange.addChangeListener(listener);
    }

    public final void removeFactoryChangeListener(DataChangeListener<ModelProvider<M, D>> listener) {
        this.factoryChange.removeChangeListener(listener);
    }

    public int priority() {
        return -1;
    }

    private void clearCache() {
        this.modelCache.clear();
    }

    private static class DataSourceKey<D extends DataSource> {
        Reference<D> weakReference;

        DataSourceKey(D ds) {
            this.weakReference = new WeakReference<D>(ds);
        }

        public int hashCode() {
            DataSource ds = (DataSource)this.weakReference.get();
            if (ds != null) {
                return ds.hashCode();
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof DataSourceKey) {
                DataSource ds = (DataSource)this.weakReference.get();
                DataSource otherDs = (DataSource)((DataSourceKey)obj).weakReference.get();
                return ds != null && ds == otherDs;
            }
            throw new IllegalArgumentException(obj.getClass().getName());
        }

        public String toString() {
            DataSource ds = (DataSource)this.weakReference.get();
            return "DataSourceKey for " + System.identityHashCode(this) + " for " + ds == null ? "NULL" : ds.toString();
        }
    }

    private class ModelProviderComparator
    implements Comparator<ModelProvider<M, D>> {
        private ModelProviderComparator() {
        }

        @Override
        public int compare(ModelProvider<M, D> provider1, ModelProvider<M, D> provider2) {
            int anotherVal;
            int thisVal = provider1.priority();
            if (thisVal < (anotherVal = provider2.priority())) {
                return 1;
            }
            if (thisVal > anotherVal) {
                return -1;
            }
            return ClassNameComparator.INSTANCE.compare(provider1, provider2);
        }
    }
}

