/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.BytePointer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.Pointer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.ByteIndexer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.Raw;

public class ByteRawIndexer
extends ByteIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected BytePointer pointer;
    final long base;
    final long size;

    public ByteRawIndexer(BytePointer pointer) {
        this(pointer, new long[]{pointer.limit() - pointer.position()}, ONE_STRIDE);
    }

    public ByteRawIndexer(BytePointer pointer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.pointer = pointer;
        this.base = pointer.address() + pointer.position();
        this.size = pointer.limit() - pointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    @Override
    public byte get(long i) {
        return RAW.getByte(this.base + ByteRawIndexer.checkIndex(i, this.size));
    }

    @Override
    public ByteIndexer get(long i, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.get(i * this.strides[0] + (long)n);
        }
        return this;
    }

    @Override
    public byte get(long i, long j) {
        return this.get(i * this.strides[0] + (long)((int)j));
    }

    @Override
    public ByteIndexer get(long i, long j, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.get(i * this.strides[0] + j * this.strides[1] + (long)n);
        }
        return this;
    }

    @Override
    public byte get(long i, long j, long k) {
        return this.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public byte get(long ... indices) {
        return this.get(this.index(indices));
    }

    @Override
    public ByteIndexer get(long[] indices, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.get(this.index(indices) + (long)n);
        }
        return this;
    }

    @Override
    public ByteIndexer put(long i, byte b) {
        RAW.putByte(this.base + ByteRawIndexer.checkIndex(i, this.size), b);
        return this;
    }

    @Override
    public ByteIndexer put(long i, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + (long)n, b[offset + n]);
        }
        return this;
    }

    @Override
    public ByteIndexer put(long i, long j, byte b) {
        this.put(i * this.strides[0] + j, b);
        return this;
    }

    @Override
    public ByteIndexer put(long i, long j, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + j * this.strides[1] + (long)n, b[offset + n]);
        }
        return this;
    }

    @Override
    public ByteIndexer put(long i, long j, long k, byte b) {
        this.put(i * this.strides[0] + j * this.strides[1] + k, b);
        return this;
    }

    @Override
    public ByteIndexer put(long[] indices, byte b) {
        this.put(this.index(indices), b);
        return this;
    }

    @Override
    public ByteIndexer put(long[] indices, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(this.index(indices) + (long)n, b[offset + n]);
        }
        return this;
    }

    @Override
    public short getShort(long i) {
        return RAW.getShort(this.base + ByteRawIndexer.checkIndex(i, this.size - 1L));
    }

    @Override
    public ByteIndexer putShort(long i, short s) {
        RAW.putShort(this.base + ByteRawIndexer.checkIndex(i, this.size - 1L), s);
        return this;
    }

    @Override
    public int getInt(long i) {
        return RAW.getInt(this.base + ByteRawIndexer.checkIndex(i, this.size - 3L));
    }

    @Override
    public ByteIndexer putInt(long i, int j) {
        RAW.putInt(this.base + ByteRawIndexer.checkIndex(i, this.size - 3L), j);
        return this;
    }

    @Override
    public long getLong(long i) {
        return RAW.getLong(this.base + ByteRawIndexer.checkIndex(i, this.size - 7L));
    }

    @Override
    public ByteIndexer putLong(long i, long j) {
        RAW.putLong(this.base + ByteRawIndexer.checkIndex(i, this.size - 7L), j);
        return this;
    }

    @Override
    public float getFloat(long i) {
        return RAW.getFloat(this.base + ByteRawIndexer.checkIndex(i, this.size - 3L));
    }

    @Override
    public ByteIndexer putFloat(long i, float f) {
        RAW.putFloat(this.base + ByteRawIndexer.checkIndex(i, this.size - 3L), f);
        return this;
    }

    @Override
    public double getDouble(long i) {
        return RAW.getDouble(this.base + ByteRawIndexer.checkIndex(i, this.size - 7L));
    }

    @Override
    public ByteIndexer putDouble(long i, double d) {
        RAW.putDouble(this.base + ByteRawIndexer.checkIndex(i, this.size - 7L), d);
        return this;
    }

    @Override
    public char getChar(long i) {
        return RAW.getChar(this.base + ByteRawIndexer.checkIndex(i, this.size - 1L));
    }

    @Override
    public ByteIndexer putChar(long i, char c) {
        RAW.putChar(this.base + ByteRawIndexer.checkIndex(i, this.size - 1L), c);
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

