/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.CodeWriter;
import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.transform.FixWarningsVisitor;
import com.oracle.truffle.dsl.processor.java.transform.GenerateOverrideVisitor;
import com.oracle.truffle.dsl.processor.model.Template;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

abstract class AbstractRegistrationProcessor
extends AbstractProcessor {
    private final Map<String, TypeElement> registrations = new HashMap<String, TypeElement>();
    private final List<TypeElement> legacyRegistrations = new ArrayList<TypeElement>();

    AbstractRegistrationProcessor() {
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ProcessorContext.enter(this.processingEnv);
        try {
            if (roundEnv.processingOver()) {
                this.generateServicesRegistration(this.registrations);
                this.generateLegacyRegistration(this.legacyRegistrations);
                this.registrations.clear();
                this.legacyRegistrations.clear();
                boolean bl = true;
                return bl;
            }
            String[] supportedAnnotations = this.getClass().getAnnotation(SupportedAnnotationTypes.class).value();
            TypeElement supportedAnnotation = this.processingEnv.getElementUtils().getTypeElement(supportedAnnotations[0]);
            if (supportedAnnotation == null) {
                throw new IllegalStateException("Cannot resolve " + supportedAnnotations[0]);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(supportedAnnotation)) {
                AnnotationMirror mirror = ElementUtils.findAnnotationMirror(element, supportedAnnotation.asType());
                if (mirror == null || element.getKind() != ElementKind.CLASS || !this.validateRegistration(element, mirror)) continue;
                TypeElement annotatedElement = (TypeElement)element;
                if (AbstractRegistrationProcessor.requiresLegacyRegistration(annotatedElement)) {
                    this.legacyRegistrations.add(annotatedElement);
                    continue;
                }
                this.registrations.put(this.generateProvider(annotatedElement), annotatedElement);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ProcessorContext.leave();
        }
    }

    abstract boolean validateRegistration(Element var1, AnnotationMirror var2);

    abstract DeclaredType getProviderClass();

    abstract Iterable<AnnotationMirror> getProviderAnnotations(TypeElement var1);

    abstract void implementMethod(TypeElement var1, CodeExecutableElement var2);

    abstract String getRegistrationFileName();

    abstract void storeRegistrations(Properties var1, Iterable<? extends TypeElement> var2);

    final void assertNoErrorExpected(Element e) {
        ExpectError.assertNoErrorExpected(this.processingEnv, e);
    }

    final void emitError(String msg, Element e) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    final void emitError(String msg, Element e, AnnotationMirror mirror, AnnotationValue value) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e, mirror, value);
    }

    final void emitWarning(String msg, Element e) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg, e);
    }

    final void emitWarning(String msg, Element e, AnnotationMirror mirror, AnnotationValue value) {
        if (ExpectError.isExpectedError(this.processingEnv, e, msg)) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg, e, mirror, value);
    }

    static AnnotationMirror copyAnnotations(AnnotationMirror mirror, Predicate<ExecutableElement> filter) {
        CodeAnnotationMirror res = new CodeAnnotationMirror(mirror.getAnnotationType());
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : mirror.getElementValues().entrySet()) {
            ExecutableElement executable = e.getKey();
            AnnotationValue value = e.getValue();
            if (!filter.test(executable)) continue;
            res.setElementValue(executable, value);
        }
        return res;
    }

    private static boolean requiresLegacyRegistration(TypeElement annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            Element annotationType = annotationMirror.getAnnotationType().asElement();
            if (!"GenerateLegacyRegistration".contentEquals(annotationType.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    private String generateProvider(TypeElement annotatedElement) {
        ProcessorContext context = ProcessorContext.getInstance();
        Template model = new Template(context, annotatedElement, null){};
        TypeElement providerElement = context.getTypeElement(this.getProviderClass());
        CodeTypeElement providerClass = GeneratorUtils.createClass(model, null, EnumSet.of(Modifier.PUBLIC), AbstractRegistrationProcessor.createProviderSimpleName(annotatedElement), null);
        providerClass.getImplements().add(providerElement.asType());
        for (Element element : ElementFilter.methodsIn(providerElement.getEnclosedElements())) {
            CodeExecutableElement implementedMethod = CodeExecutableElement.clone((ExecutableElement)element);
            implementedMethod.getModifiers().remove((Object)Modifier.ABSTRACT);
            this.implementMethod(annotatedElement, implementedMethod);
            providerClass.add(implementedMethod);
        }
        for (AnnotationMirror annotationMirror : this.getProviderAnnotations(annotatedElement)) {
            providerClass.addAnnotationMirror(annotationMirror);
        }
        DeclaredType overrideType = (DeclaredType)context.getType(Override.class);
        providerClass.accept(new GenerateOverrideVisitor(overrideType), null);
        providerClass.accept(new FixWarningsVisitor(annotatedElement, overrideType), null);
        providerClass.accept(new CodeWriter(context.getEnvironment(), annotatedElement), null);
        return providerClass.getQualifiedName().toString();
    }

    private static String createProviderSimpleName(TypeElement annotatedElement) {
        StringBuilder nameBuilder = new StringBuilder();
        List<Element> hierarchy = ElementUtils.getElementHierarchy(annotatedElement);
        ListIterator<Element> it = hierarchy.listIterator(hierarchy.size());
        while (it.hasPrevious()) {
            Element enc = it.previous();
            if (!enc.getKind().isClass() && !enc.getKind().isInterface()) continue;
            nameBuilder.append(enc.getSimpleName());
        }
        nameBuilder.append("Provider");
        return nameBuilder.toString();
    }

    private void generateServicesRegistration(Map<String, ? extends TypeElement> providerFqns) {
        ProcessorContext context = ProcessorContext.getInstance();
        ProcessingEnvironment env = context.getEnvironment();
        Elements elements = env.getElementUtils();
        Name providerBinName = elements.getBinaryName(context.getTypeElement(this.getProviderClass()));
        String filename = "META-INF/services/" + providerBinName;
        ArrayList<String> providerClassNames = new ArrayList<String>(providerFqns.size());
        for (String providerFqn : providerFqns.keySet()) {
            TypeElement te = ElementUtils.getTypeElement(env, providerFqn);
            providerClassNames.add(elements.getBinaryName(te).toString());
        }
        Collections.sort(providerClassNames);
        if (!providerClassNames.isEmpty()) {
            try {
                FileObject file = env.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filename, providerFqns.values().toArray(new Element[providerFqns.size()]));
                try (PrintWriter out = new PrintWriter(new OutputStreamWriter(file.openOutputStream(), "UTF-8"));){
                    for (String providerClassName : providerClassNames) {
                        out.println(providerClassName);
                    }
                }
            }
            catch (IOException e) {
                if (e instanceof FilerException && e.getMessage().startsWith("Source file already created")) {
                    return;
                }
                env.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), providerFqns.values().iterator().next());
            }
        }
    }

    private void generateLegacyRegistration(List<TypeElement> annotatedElements) {
        String filename = this.getRegistrationFileName();
        SortedProperties p = new SortedProperties();
        this.storeRegistrations(p, annotatedElements);
        if (!p.isEmpty()) {
            try {
                FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filename, annotatedElements.toArray(new Element[0]));
                try (OutputStream os = file.openOutputStream();){
                    p.store(os, "Generated by " + this.getClass().getName());
                }
            }
            catch (IOException e) {
                if (e instanceof FilerException && e.getMessage().startsWith("Source file already created")) {
                    return;
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), annotatedElements.get(0));
            }
        }
    }

    static class SortedProperties
    extends Properties {
        SortedProperties() {
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(new TreeSet<Object>(super.keySet()));
        }
    }
}

