/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.interop;

import com.oracle.truffle.dsl.processor.interop.ForeignAccessFactoryGenerator;
import com.oracle.truffle.dsl.processor.interop.MessageGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

final class GenericGenerator
extends MessageGenerator {
    private final String targetableExecuteNode;

    GenericGenerator(ProcessingEnvironment processingEnv, AnnotationMirror resolveAnnotation, AnnotationMirror messageResolutionAnnotation, TypeElement element, ForeignAccessFactoryGenerator containingForeignAccessFactory) {
        super(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
        String mName = this.messageName.substring(this.messageName.lastIndexOf(46) + 1);
        this.targetableExecuteNode = new StringBuilder(mName).replace(0, 1, mName.substring(0, 1).toUpperCase()).append("Node").insert(0, "Targetable").toString();
    }

    @Override
    int getParameterCount() {
        List<? extends VariableElement> parameters = this.getAccessMethods().get(0).getParameters();
        int parameterCount = parameters.size();
        if (parameters.size() >= 1) {
            --parameterCount;
        }
        return parameterCount;
    }

    @Override
    String getTargetableNodeName() {
        return this.targetableExecuteNode;
    }

    @Override
    void appendRootNode(Writer w) throws IOException {
        int i;
        w.append(this.indent).append("    private static final class ").append(this.rootNodeName).append(" extends RootNode {\n");
        w.append(this.indent).append("        protected ").append(this.rootNodeName).append("() {\n");
        w.append(this.indent).append("            super(null);\n");
        w.append(this.indent).append("        }\n");
        w.append("\n");
        w.append(this.indent).append("        @Child private ").append(this.clazzName).append(" node = ").append(this.getGeneratedDSLNodeQualifiedName()).append(".create();");
        w.append("\n");
        this.appendGetName(w);
        w.append(this.indent).append("        @Override\n");
        w.append(this.indent).append("        public Object execute(VirtualFrame frame) {\n");
        w.append(this.indent).append("            Object receiver = com.oracle.truffle.api.interop.ForeignAccess.getReceiver(frame);\n");
        boolean listGenerated = false;
        for (i = 0; i < this.getParameterCount() - 1; ++i) {
            if (!listGenerated) {
                w.append(this.indent).append("            Object[] arguments = frame.getArguments();\n");
                listGenerated = true;
            }
            w.append(this.indent).append("            Object arg").append(String.valueOf(i)).append(" = arguments[").append(String.valueOf(i + 1)).append("];\n");
        }
        w.append(this.indent).append("            try {\n");
        w.append(this.indent).append("                return node.executeWithTarget(frame, receiver");
        for (i = 0; i < this.getParameterCount() - 1; ++i) {
            String index = String.valueOf(i);
            w.append(", ").append("arg").append(index);
        }
        w.append(");\n");
        w.append(this.indent).append("            } catch (UnsupportedSpecializationException e) {\n");
        this.appendHandleUnsupportedTypeException(w);
        w.append(this.indent).append("            }\n");
        w.append(this.indent).append("        }\n");
        w.append("\n");
        w.append(this.indent).append("    }\n");
    }
}

