/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.model;

import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.GeneratedElement;
import com.oracle.truffle.dsl.processor.java.transform.AbstractCodeWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public abstract class CodeElement<E extends Element>
implements Element,
GeneratedElement {
    private final Set<Modifier> modifiers;
    private List<AnnotationMirror> annotations;
    private List<E> enclosedElements;
    private Element enclosingElement;
    private Element generatorElement;
    private AnnotationMirror generatorAnnotationMirror;

    public CodeElement(Set<Modifier> modifiers) {
        this.modifiers = new LinkedHashSet<Modifier>(modifiers);
    }

    @Override
    public void setGeneratorAnnotationMirror(AnnotationMirror mirror) {
        this.generatorAnnotationMirror = mirror;
    }

    @Override
    public void setGeneratorElement(Element element) {
        this.generatorElement = element;
    }

    @Override
    public AnnotationMirror getGeneratorAnnotationMirror() {
        return this.generatorAnnotationMirror;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            CodeElement other = (CodeElement)obj;
            return Objects.equals(this.modifiers, other.modifiers) && Objects.equals(this.annotations, other.annotations) && Objects.equals(this.enclosedElements, other.enclosedElements);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.modifiers, this.annotations, this.enclosedElements);
    }

    @Override
    public Element getGeneratorElement() {
        return this.generatorElement;
    }

    public <T extends E> void addAll(Collection<? extends T> elements) {
        for (Element t : elements) {
            this.add(t);
        }
    }

    public <T extends E> T add(T element) {
        if (element == null) {
            throw new NullPointerException();
        }
        this.getEnclosedElements().add(element);
        return element;
    }

    public <T extends E> T addOptional(T element) {
        if (element != null) {
            this.add(element);
        }
        return element;
    }

    public void remove(E element) {
        this.getEnclosedElements().remove(element);
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public List<E> getEnclosedElements() {
        if (this.enclosedElements == null) {
            this.enclosedElements = this.parentableList(this, new ArrayList());
        }
        return this.enclosedElements;
    }

    public List<AnnotationMirror> getAnnotationMirrors() {
        if (this.annotations == null) {
            this.annotations = this.parentableList(this, new ArrayList());
        }
        return this.annotations;
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        throw new UnsupportedOperationException();
    }

    public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        throw new UnsupportedOperationException();
    }

    public void addAnnotationMirror(AnnotationMirror annotationMirror) {
        this.getAnnotationMirrors().add(annotationMirror);
    }

    public void setEnclosingElement(Element parent) {
        this.enclosingElement = parent;
    }

    @Override
    public Element getEnclosingElement() {
        return this.enclosingElement;
    }

    public TypeElement getEnclosingClass() {
        Element p;
        for (p = this.enclosingElement; p != null && !p.getKind().isClass() && !p.getKind().isInterface(); p = p.getEnclosingElement()) {
        }
        return (TypeElement)p;
    }

    <T> List<T> parentableList(Element parent, List<T> list) {
        return new ParentableList<T>(parent, list);
    }

    public String toString() {
        StringBuilderCodeWriter codeWriter = new StringBuilderCodeWriter();
        this.accept(codeWriter, null);
        return codeWriter.getString();
    }

    private static class ParentableList<T>
    implements List<T> {
        private final Element parent;
        private final List<T> delegate;

        ParentableList(Element parent, List<T> delegate) {
            this.parent = parent;
            this.delegate = delegate;
        }

        private void addImpl(T element) {
            if (element != null && element instanceof CodeElement) {
                ((CodeElement)element).setEnclosingElement(this.parent);
            }
        }

        private static void removeImpl(Object element) {
            if (element instanceof CodeElement) {
                ((CodeElement)element).setEnclosingElement(null);
            }
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <E> E[] toArray(E[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public boolean add(T e) {
            this.addImpl(e);
            return this.delegate.add(e);
        }

        @Override
        public boolean remove(Object o) {
            boolean removed = this.delegate.remove(o);
            if (removed) {
                ParentableList.removeImpl(o);
            }
            return removed;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            if (c != null) {
                for (T t : c) {
                    this.addImpl(t);
                }
            }
            return this.delegate.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            if (c != null) {
                for (T t : c) {
                    this.addImpl(t);
                }
            }
            return this.delegate.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (c != null) {
                for (Object t : c) {
                    ParentableList.removeImpl(t);
                }
            }
            return this.delegate.removeAll(c);
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not supported by parentable list");
        }

        @Override
        public void clear() {
            for (T e : this) {
                ParentableList.removeImpl(e);
            }
            this.delegate.clear();
        }

        @Override
        public T get(int index) {
            return this.delegate.get(index);
        }

        @Override
        public T set(int index, T element) {
            ParentableList.removeImpl(this.delegate.get(index));
            this.addImpl(element);
            return this.delegate.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            this.addImpl(element);
            this.delegate.add(index, element);
        }

        @Override
        public T remove(int index) {
            T element = this.delegate.remove(index);
            ParentableList.removeImpl(element);
            return element;
        }

        @Override
        public int indexOf(Object o) {
            return this.delegate.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.delegate.lastIndexOf(o);
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.delegate.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return this.delegate.listIterator(index);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return new ParentableList<T>(this.parent, this.delegate.subList(fromIndex, toIndex));
        }
    }

    private static class StringBuilderCodeWriter
    extends AbstractCodeWriter {
        StringBuilderCodeWriter() {
            this.writer = new CharArrayWriter();
        }

        @Override
        protected Writer createWriter(CodeTypeElement clazz) throws IOException {
            return this.writer;
        }

        public String getString() {
            return new String(((CharArrayWriter)this.writer).toCharArray()).trim();
        }
    }
}

